/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.common.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.eas.base.log.LogException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LogItemDataPlugin {
    private static Logger logger = Logger.getLogger(LogItemDataPlugin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String ITEM_ALIAS = "FAlias";
    private static final String ITEM_DESCRIPTION = "FDescription";
    private static final String ITEM_GROUP = "FGroup";

    public String execute(String metasPath) throws Exception {
        Context ctx = this.createVirtualConext(metasPath);
        StringBuffer script = new StringBuffer();
        script.append("DELETE FROM T_LOG_LogItem;").append(SEPARATOR);
        LogInfo logInfo = this.getLogInfo(ctx);
        script.append(this.getLogItemScript(ctx, logInfo));
        return script.toString();
    }

    private Context createVirtualConext(String metasPath) {
        Context context = new Context(null, "eas", null, new Locale("L2"));
        context.put((Object)"METADATAPATH", (Object)metasPath);
        return context;
    }

    private LogInfo getLogInfo(Context ctx) throws BOSException {
        MetaDataLoaderFactory.setClientMetaDataPath((String)((String)ctx.get((Object)"METADATAPATH")));
        LogInfo log = MetaDataLoaderFactory.getMetaDataLoader(null).getLog();
        if (log == null) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.NOTGETLOGMETADATA)));
        }
        return log;
    }

    private LogItemCollection removeDumplicatedItems(LogItemCollection itemCol) {
        LogItemCollection itemCollection = new LogItemCollection();
        HashMap<String, String> tempitemidMap = new HashMap<String, String>();
        HashMap<String, String> tempFnameMap = new HashMap<String, String>();
        for (int i = 0; i < itemCol.size(); ++i) {
            if (tempitemidMap.containsKey(itemCol.get(i).getInnerID().toString()) || tempFnameMap.containsKey(itemCol.get(i).getName())) continue;
            itemCollection.add(itemCol.get(i));
            tempitemidMap.put(itemCol.get(i).getInnerID().toString(), "");
            tempFnameMap.put(itemCol.get(i).getName(), "");
        }
        tempitemidMap = null;
        tempFnameMap = null;
        return itemCollection;
    }

    private String getLogItemScript(Context ctx, LogInfo logInfo) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        LanguageCollection langCol = this.getLanguages(ctx);
        LanguageInfo defaultLang = this.getDefaultLanguage(ctx);
        Locale defaultLocale = new Locale(defaultLang.getPostfix(), "");
        LogItemCollection itemCol = logInfo.getLogItems();
        LogItemCollection noDumplicateItem = this.removeDumplicatedItems(itemCol);
        LogItemInfo item = null;
        for (int i = 0; i < noDumplicateItem.size(); ++i) {
            item = noDumplicateItem.get(i);
            item.setDefaultLocale(defaultLocale);
            buffer.append(this.getInsertSQL(item, langCol));
        }
        return buffer.toString();
    }

    private String getInsertSQL(LogItemInfo item, LanguageCollection langCol) throws BOSException {
        String postfix;
        LanguageInfo langInfo;
        int i;
        this.validateLogItem(item);
        StringBuffer sql = new StringBuffer().append("INSERT INTO T_LOG_LogItem(FLogItemID, FName, FType, FLevel, ");
        int n = langCol.size();
        for (i = 0; i < n; ++i) {
            langInfo = langCol.get(i);
            postfix = langInfo.getPostfix();
            String itemAlias = "FAlias_" + postfix;
            sql.append(itemAlias);
            sql.append(", ");
            String itemDesc = "FDescription_" + postfix;
            sql.append(itemDesc);
            sql.append(", ");
            String itemGroup = "FGroup_" + postfix;
            sql.append(itemGroup);
            if (i == n - 1) continue;
            sql.append(", ");
        }
        sql.append(" ) VALUES (");
        sql.append("'").append(item.getInnerID()).append("', ");
        sql.append("N'").append(item.getName()).append("', ");
        sql.append(item.getType()).append(", ");
        sql.append(item.getLevel()).append(", ");
        n = langCol.size();
        for (i = 0; i < n; ++i) {
            langInfo = langCol.get(i);
            postfix = langInfo.getPostfix();
            Locale locale = new Locale(postfix, "");
            String alias = item.getAlias(locale);
            sql.append(alias == null ? null : "N'" + alias + "'").append(", ");
            String desc = item.getDescription(locale);
            sql.append(desc == null ? null : "N'" + desc + "'").append(", ");
            String group = item.getGroup(locale);
            sql.append(group == null ? null : "N'" + group + "'");
            if (i == n - 1) continue;
            sql.append(", ");
        }
        sql.append(");").append(SEPARATOR);
        return sql.toString();
    }

    private LanguageCollection getLanguages(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo solutionInfo = ctrl.getValue();
        LanguageCollection langs = solutionInfo.getLanguages();
        return langs;
    }

    private LanguageInfo getDefaultLanguage(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo solutionInfo = ctrl.getValue();
        return solutionInfo.getDefaultLanguage();
    }

    private void validateLogItem(LogItemInfo logItem) throws BOSException {
        if (logItem == null) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.LOGITEMISNULL)));
        }
        if (logItem.getInnerID() == null) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.LOGITEMINNERIDISNULL)));
        }
        if (logItem.getName() == null) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.LOGITEMNAMEISNULL)));
        }
        this.validateType(logItem.getName(), logItem.getType());
        this.validateLevel(logItem.getName(), logItem.getLevel());
    }

    private void validateType(String logItemName, int type) throws BOSException {
        if (type != 1 && type != 2 && type != 4 && type != 512) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.LOGITEMTYPEISERROR, new Object[]{logItemName})));
        }
    }

    private void validateLevel(String logItemName, int level) throws BOSException {
        if (level != 64 && level != 256 && level != 128) {
            throw new BOSException((Throwable)((Object)new LogException(LogException.LOGITEMLEVELISERROR, new Object[]{logItemName})));
        }
    }
}

