/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.CounterSignComparator1;
import com.kingdee.eas.base.multiapprove.CounterSignComparator2;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveHstCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveHstInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class MultiapproveUtils {
    private static final Logger logger = CoreUIObject.getLogger(MultiapproveUtils.class);

    public static boolean checkNextPerson(String assignmentId) throws WfException, Exception {
        if (assignmentId == null || assignmentId.length() == 0) {
            return false;
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        String ActInstId = service.getAssignmentById(assignmentId).getActInstId();
        return service.enableNextPerson(ActInstId);
    }

    public static List convertToPersonIdList(List personList) {
        ArrayList<String> result = new ArrayList<String>();
        if (personList == null || personList.size() <= 0) {
            return result;
        }
        for (PersonInfo personInfo : personList) {
            if (personInfo == null || personInfo.getId() == null) continue;
            result.add(personInfo.getId().toString());
        }
        return result;
    }

    public static String getResString(String resName) {
        if (StringUtils.isEmpty((String)resName)) {
            throw new IllegalArgumentException();
        }
        return EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)resName);
    }

    public static String getResString(String resName, Locale locale) {
        if (StringUtils.isEmpty((String)resName)) {
            throw new IllegalArgumentException();
        }
        return EASCommonResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)resName, (Locale)locale);
    }

    public static String getReferenceHumanTypeName(ReferenceHumanType referenceHumanType) {
        if (ReferenceHumanType.ACTIVITY_PERFORMER.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_ACTIVITY_PERFORMER");
        }
        if (ReferenceHumanType.EMPLOYEE.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_EMPLOYEE");
        }
        if (ReferenceHumanType.POSITION.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_POSITION");
        }
        if (ReferenceHumanType.PROCESS_INITIATOR.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_PROCESS_INITIATOR");
        }
        if (ReferenceHumanType.PROCESS_VARIABLE.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_PROCESS_VARIABLE");
        }
        if (ReferenceHumanType.ORGNIZATION.equals((Object)referenceHumanType)) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static String getRelationTypeName(RelationType relationType) {
        if (RelationType.SELF.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_SELF");
        }
        if (RelationType.SUPERVISOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_SUPERVISOR");
        }
        if (RelationType.FELLOW.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_FELLOW");
        }
        if (RelationType.SUBORDINATOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_SUBORDINATOR");
        }
        if (RelationType.FELLOWBESIDESSELF.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_FELLOWBESIDESSELF");
        }
        if (RelationType.INDIRECTSUPERVISOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_INDIRECTSUPERVISOR");
        }
        if (RelationType.INDIRECTALLSUPERVISOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("INDIRECTALLSUPERVISOR");
        }
        if (RelationType.PRIMARY_POSITION_INDIRECT_SUPERVISOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PRIMARY_POSITION_INDIRECT_SUPERVISOR");
        }
        if (RelationType.SAME_JOB_GRADE.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("PARTICIPANT_RELATION_SAMEJOBGRAND");
        }
        if (RelationType.PRIMARY_POSITION_SUPERVISOR.equals((Object)relationType)) {
            return MultiapproveUtils.getResString("zhuyaozhiweizhijieshangjie");
        }
        if (RelationType.SAMELEVEL_ALLPOSITION.equals((Object)relationType)) {
            return EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"168_MultiapproveUtils");
        }
        if (RelationType.SAMELEVEL_OTHERPOSITION.equals((Object)relationType)) {
            return EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"169_MultiapproveUtils");
        }
        throw new UnsupportedOperationException();
    }

    public static PositionInfo getPositionInfo(String positionId) throws BOSException, EASBizException {
        return MultiapproveUtils.getPositionInfo(positionId, null);
    }

    public static boolean isMustDesignateNextPerformer(String procDefHashValue) throws BOSException {
        boolean mustDesignateDirectActivityPerformer = false;
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessDef procDef = service.getProcessDefByDefineHashValue(procDefHashValue);
        ExtendedAttributeCollection eac = procDef.getExtendedAttributes();
        if (eac != null && eac.get("mustDesignateDirectActivityPerformer") != null) {
            mustDesignateDirectActivityPerformer = "true".equals(eac.get("mustDesignateDirectActivityPerformer").getValue());
        }
        return mustDesignateDirectActivityPerformer;
    }

    public static PersonInfo getPersonInfo(String personId, Context ctx) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            throw new IllegalArgumentException();
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)personId));
        IPerson person = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
        return person.getPersonInfo((IObjectPK)pk);
    }

    public static PositionInfo getPositionInfo(String positionId, Context ctx) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)positionId)) {
            throw new IllegalArgumentException();
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)positionId));
        IPosition position = ctx == null ? PositionFactory.getRemoteInstance() : PositionFactory.getLocalInstance((Context)ctx);
        return position.getPositionInfo((IObjectPK)pk);
    }

    public static UserInfo getUserInfo(String userId) throws BOSException, EASBizException {
        return MultiapproveUtils.getUserInfo(userId, null);
    }

    public static UserInfo getUserInfo(String userId, Context ctx) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId)) {
            throw new IllegalArgumentException();
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)userId));
        IUser user = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance((Context)ctx);
        return user.getUserInfo((IObjectPK)pk);
    }

    public static String getParticipantOrgName(ParticipantDef prtcpntDef) throws BOSException, EASBizException {
        return MultiapproveUtils.getParticipantOrgName(prtcpntDef, null);
    }

    public static String getParticipantOrgName(ParticipantDef prtcpntDef, Context ctx) throws BOSException, EASBizException {
        if (prtcpntDef == null) {
            throw new IllegalArgumentException();
        }
        String fullOrgUnitName = "";
        String prfrmDtfldId = prtcpntDef.getPerformDatafieldId();
        if (prfrmDtfldId != null && prfrmDtfldId.length() > 0) {
            fullOrgUnitName = prtcpntDef.getName();
        } else {
            String fullOrgUnitId = prtcpntDef.getParticipantValue();
            if (fullOrgUnitId != null && fullOrgUnitId.length() > 0) {
                fullOrgUnitName = MultiapproveUtils.getFullOrgUnitInfo(fullOrgUnitId, ctx).getName();
            }
        }
        return fullOrgUnitName;
    }

    public static FullOrgUnitInfo getFullOrgUnitInfo(String fullOrgUnitId) throws BOSException, EASBizException {
        return MultiapproveUtils.getFullOrgUnitInfo(fullOrgUnitId, null);
    }

    public static FullOrgUnitInfo getFullOrgUnitInfo(String fullOrgUnitId, Context ctx) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fullOrgUnitId)) {
            throw new IllegalArgumentException();
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)fullOrgUnitId));
        IFullOrgUnit fullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)pk);
        return fullOrgUnitInfo;
    }

    public static MultiApproveCollection toMultiApproveCollection(MultiApproveHstCollection multiApproveHstCollection) {
        MultiApproveCollection result = new MultiApproveCollection();
        if (multiApproveHstCollection == null || multiApproveHstCollection.size() <= 0) {
            return result;
        }
        Iterator iterator = multiApproveHstCollection.iterator();
        while (iterator.hasNext()) {
            MultiApproveHstInfo multiApproveHstInfo = (MultiApproveHstInfo)iterator.next();
            result.add(multiApproveHstInfo.toMultiApproveInfo());
        }
        return result;
    }

    public static Object[][] getCountersignResult(Context context, String billID, Set assignmentIDList) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billID));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignment", (Object)assignmentIDList, CompareType.INCLUDE));
        IMultiApprove iMultiApprove = MultiApproveFactory.getLocalInstance(context);
        MultiApproveCollection collection = iMultiApprove.getMultiApproveCollection(entityViewInfo);
        Object[][] countersignResult = new Object[collection.size()][2];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            MultiApproveInfo multiApproveInfo = collection.get(i);
            countersignResult[i][0] = multiApproveInfo.getAssignment();
            countersignResult[i][1] = multiApproveInfo.getIsPass().equals((Object)ApproveResult.PASS);
        }
        return countersignResult;
    }

    public static boolean multiApproveInfoExists(Context context, Set assigmentIDs) throws BOSException {
        if (assigmentIDs.isEmpty()) {
            return false;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("assignment", (Object)assigmentIDs, CompareType.INCLUDE));
        IMultiApprove iMultiApprove = MultiApproveFactory.getLocalInstance(context);
        try {
            return iMultiApprove.exists(filterInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getMultiApproveID(Context context, String assigmentID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("assignment", (Object)assigmentID));
        IMultiApprove iMultiApprove = MultiApproveFactory.getLocalInstance(context);
        MultiApproveCollection collection = iMultiApprove.getMultiApproveCollection(entityViewInfo);
        if (collection.size() > 0) {
            ArrayList<MultiApproveInfo> retVal = new ArrayList<MultiApproveInfo>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                retVal.add(collection.get(i));
            }
            Collections.sort(retVal, new Comparator(){

                public int compare(Object o1, Object o2) {
                    MultiApproveInfo approveInfo1 = (MultiApproveInfo)o1;
                    MultiApproveInfo approveInfo2 = (MultiApproveInfo)o2;
                    return approveInfo1.getCreateTime().compareTo(approveInfo2.getCreateTime());
                }
            });
            return ((MultiApproveInfo)retVal.get(collection.size() - 1)).getId().toString();
        }
        throw new IllegalArgumentException("can not found multiapprove record. assigmentID: " + assigmentID);
    }

    public static TreeMap counterSignSortByGroup(ArrayList list) {
        Collections.sort(list, new CounterSignComparator1());
        TreeMap<String, ArrayList> map = new TreeMap<String, ArrayList>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer buffer = null;
        ArrayList groupList = null;
        String listkey = "";
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            buffer = new StringBuffer();
            buffer.append((String)item.get("FCOUNTERSIGNINITIATOR")).append("@");
            buffer.append(format.format(item.get("FCREATEDTIME")));
            listkey = buffer.toString();
            if (!map.containsKey(listkey)) {
                groupList = new ArrayList();
                groupList.add(item);
                map.put(listkey, groupList);
                continue;
            }
            groupList = (ArrayList)map.get(listkey);
            groupList.add(item);
        }
        return map;
    }

    public static ArrayList filterCounterSign(ArrayList list, Locale locale) {
        HashMap<String, Map> EmployeeMap = new HashMap<String, Map>();
        ArrayList<Map> newList = new ArrayList<Map>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < list.size(); ++i) {
            String approveResult;
            Map item = (Map)list.get(i);
            String employeeId = (String)item.get("FPERSONEMPID");
            String userId = (String)item.get("FCOUNTERSIGNINITIATOR");
            String initTime = sdf.format(item.get("FCREATEDTIME"));
            String tempStr = employeeId + userId + initTime;
            String opinion = item.get("FOPINION") != null ? (String)item.get("FOPINION") : "";
            item.put("FOPINION", opinion);
            String assignOpinion = item.get("FASSIGNOPINION") != null ? (String)item.get("FASSIGNOPINION") : "";
            item.put("FASSIGNOPINION", assignOpinion);
            if (!EmployeeMap.containsKey(tempStr)) {
                newList.add(item);
                EmployeeMap.put(tempStr, item);
                continue;
            }
            String string = approveResult = item.get("FISPASS") != null ? ((BizEnumValueDTO)item.get("FISPASS")).getAlias(locale) : "";
            if (StringUtils.isEmpty((String)approveResult)) continue;
            newList.remove(EmployeeMap.get(tempStr));
            EmployeeMap.put(tempStr, item);
            newList.add(item);
        }
        Collections.sort(newList, new CounterSignComparator2());
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeCounterSignQuery(String procInstId, boolean history, Locale locale) throws BOSException {
        if (StringUtils.isEmpty((String)procInstId)) {
            return null;
        }
        String localStr = locale.getDisplayName();
        IRowSet rowSet = null;
        String sql = "";
        sql = history ? "select sign.*,approveHst.FISPASS,approveHst.FOPINION_" + localStr + " AS FOPINION,approveHst.FCREATETIME AS FAPPROVETIME from (select counterSign.FASSIGNID,counterSign.FCOUNTERSIGNINITIATOR,counterSign.FINITIATORNAME_" + localStr + " AS FINITIATORNAME,  assignHst.FACTDEFNAME_" + localStr + " AS FACTDEFNAME,counterSign.FASSIGNOPINION_" + localStr + " AS FASSIGNOPINION,counterSign.FCREATEDTIME, assignHst.FPERSONEMPID,assignHst.FPERSONEMPNAME_" + localStr + " AS FPERSONEMPNAME from T_WFR_CounterSignHst counterSign  inner join t_wfr_assignHst assignHst on counterSign.FASSIGNID = assignHst.FASSIGNID and assignHst.FPROCINSTID='" + procInstId + "') sign  left join t_bas_multiapproveHst approveHst on sign.fassignid= approveHst.fassignmentid" : "select sign.*,approve.FISPASS,approve.FOPINION_" + localStr + " AS FOPINION,approve.FCREATETIME as FAPPROVETIME from (select counterSign1.FASSIGNID,counterSign1.FCOUNTERSIGNINITIATOR,counterSign1.FINITIATORNAME_" + localStr + " AS FINITIATORNAME, assign.FACTDEFNAME_" + localStr + " AS FACTDEFNAME,counterSign1.FASSIGNOPINION_" + localStr + " AS FASSIGNOPINION,counterSign1.FCREATEDTIME,assign.FPERSONEMPID,assign.FPERSONEMPNAME_" + localStr + " AS FPERSONEMPNAME from T_WFR_CounterSign counterSign1 inner join t_wfr_assign assign on counterSign1.FASSIGNID = assign.FASSIGNID and assign.FPROCINSTID='" + procInstId + "' union select counterSign2.FASSIGNID,counterSign2.FCOUNTERSIGNINITIATOR, counterSign2.FINITIATORNAME_" + localStr + " AS FINITIATORNAME, assignDetail.FACTDEFNAME_" + localStr + " AS FACTDEFNAME, counterSign2.FASSIGNOPINION_" + localStr + " AS FASSIGNOPINION,counterSign2.FCREATEDTIME, assignDetail.FPERSONEMPID, assignDetail.FPERSONEMPNAME_" + localStr + " AS FPERSONEMPNAME from T_WFR_CounterSign counterSign2  inner join t_wfr_assignDetail assignDetail on counterSign2.FASSIGNID = assignDetail.FASSIGNID and assignDetail.FPROCINSTID='" + procInstId + "' ) sign left join t_bas_multiapprove  approve on  sign.fassignid= approve.fassignmentid and approve.FSTATUS=1";
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getRemoteInstance((String)sql);
        rowSet = sqlExecutor.executeSQL();
        try {
            String className = "ApproveResult";
            String packageName = "com.kingdee.eas.base.multiapprove";
            BizEnumInfo approveResultEnum = null;
            try {
                approveResultEnum = MetaDataLoader.getEnum(null, (IMetaDataPK)MetaDataPK.create((String)packageName, (String)className));
            }
            catch (Exception be) {
                approveResultEnum = null;
                logger.error((Object)("getBizEnum(" + packageName + "." + className + ") occur error:"), (Throwable)be);
            }
            if (approveResultEnum != null) {
                while (rowSet.next()) {
                    String obj = (String)rowSet.getObject("FISPASS");
                    if (obj == null) continue;
                    BizEnumValueInfo obj2 = QueryHelper.getAliasFromEnumValue((BizEnumInfo)approveResultEnum, (String)obj);
                    rowSet.updateObject("FISPASS", (Object)obj2);
                }
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                rowSet.beforeFirst();
            }
            catch (Throwable e) {
                logger.error((Object)"executeCounterSignQuery", e);
            }
        }
        return rowSet;
    }
}

