/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.eas.base.multiapprove.MultiapproveUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ParticipantUtils {
    private static final Logger logger = CoreUIObject.getLogger(ParticipantUtils.class);
    public static final String DF_DP_PREFIX = "DP_";

    public static String createDesignatePerformerKey(String fromActivityInstId, String toActivityDefId) {
        if (StringUtils.isEmpty((String)fromActivityInstId)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)toActivityDefId)) {
            throw new IllegalArgumentException();
        }
        String key = DF_DP_PREFIX + toActivityDefId + "_" + fromActivityInstId;
        return key;
    }

    public static String createDesignatePerformerKey(String fromActivityInstId, ManpowerActivityDef activityDef) {
        return ParticipantUtils.createDesignatePerformerKey(fromActivityInstId, activityDef.getID());
    }

    public static String getParticipantName(ParticipantDef prtcpntDef, ProcessDef processDef, Locale locale) throws Exception {
        return ParticipantUtils.getParticipantName(prtcpntDef, processDef, locale, null);
    }

    public static String getParticipantName(ParticipantDef prtcpntDef, ProcessDef processDef, Locale locale, Context ctx) throws Exception {
        try {
            return ParticipantUtils.innerGet(prtcpntDef, processDef, locale, ctx);
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"170_ParticipantUtils"), (Throwable)e);
            return "error";
        }
    }

    private static String innerGet(ParticipantDef prtcpntDef, ProcessDef processDef, Locale locale, Context ctx) throws BOSException, EASBizException, Exception, WfException {
        if (prtcpntDef == null) {
            String msg = "\"prtcpntDef\" is null!";
            throw new IllegalArgumentException(msg);
        }
        String result = "";
        ParticipantType participantType = prtcpntDef.getParticipantType();
        if (ParticipantType.ALL.equals((Object)participantType)) {
            result = MultiapproveUtils.getResString("PARTICIPANT_ALL", locale);
        } else if (ParticipantType.HUMAN.equals((Object)participantType)) {
            result = MultiapproveUtils.getResString("PARTICIPANT_HUMAN", locale) + "-" + prtcpntDef.getName();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_ALLMEMBER", locale));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef, ctx);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_MEMBER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_MEMBER", locale));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef, ctx);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_PERMISSION_OWNER", locale));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef, ctx);
            buffer.append(orgName);
            result = buffer.toString();
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL.equals((Object)participantType)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGANIZATIONAL_UNIT_PRINCIPAL", locale));
            buffer.append("-");
            String orgName = MultiapproveUtils.getParticipantOrgName(prtcpntDef, ctx);
            buffer.append(orgName);
            result = buffer.toString();
        } else {
            if (ParticipantType.PERMISSION_OWNER.equals((Object)participantType)) {
                throw new UnsupportedOperationException();
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_JOB", locale));
                buffer.append("-" + prtcpntDef.getOrgName());
                buffer.append("-" + prtcpntDef.getName());
                result = buffer.toString();
            } else if (ParticipantType.POSITION.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_POSITION", locale));
                buffer.append("-" + prtcpntDef.getOrgID());
                String positionId = prtcpntDef.getParticipantValue();
                PositionInfo position = MultiapproveUtils.getPositionInfo(positionId, ctx);
                FullOrgUnitInfo info = MultiapproveUtils.getFullOrgUnitInfo(position.getAdminOrgUnit().getId().toString(), ctx);
                while (info.getParent() != null) {
                    info = MultiapproveUtils.getFullOrgUnitInfo(info.getParent().getId().toString(), ctx);
                    buffer.append("-" + info.getName());
                }
                String positionName = MultiapproveUtils.getPositionInfo(positionId, ctx).getName();
                buffer.append("-" + positionName);
                result = buffer.toString();
            } else if (ParticipantType.PROCESS_RESPONSIBILITY.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("PARTICIPANT_PROCESS_RESPONSIBILITY", locale);
            } else if (ParticipantType.RELATION.equals((Object)participantType)) {
                ReferenceHumanType referenceHumanType = prtcpntDef.getReferenceHumanType();
                String referenceHumanTypeName = MultiapproveUtils.getReferenceHumanTypeName(referenceHumanType);
                RelationType relationType = prtcpntDef.getRelationType();
                String relationTypeName = MultiapproveUtils.getRelationTypeName(relationType);
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_RELATION", locale));
                buffer.append("-" + referenceHumanTypeName);
                buffer.append("-" + relationTypeName);
                buffer.append("-" + ParticipantUtils.getRelationParticipantName(prtcpntDef, processDef, locale, ctx));
                result = buffer.toString();
            } else if (ParticipantType.GROUP.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_GROUP", locale));
                buffer.append("-" + prtcpntDef.getName());
                result = buffer.toString();
            } else if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_ORGSCOPE", locale));
                buffer.append("-" + prtcpntDef.getName());
                result = buffer.toString();
            } else if (ParticipantType.RESOURCE.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("resource", locale) + prtcpntDef.getName();
            } else if (ParticipantType.RESOURCE_SET.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("resourcelist", locale) + prtcpntDef.getName();
            } else if (ParticipantType.ROLE.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("role", locale) + prtcpntDef.getName();
            } else if (ParticipantType.SYSTEM.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("administrator ", locale) + prtcpntDef.getName();
            } else if (ParticipantType.USER.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("user", locale) + prtcpntDef.getName();
            } else if (ParticipantType.VARIANT.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("PARTICIPANT_VARIANT", locale));
                String dataFieldId = prtcpntDef.getPerformDatafieldId();
                String dataFieldName = processDef.getDataFieldDef(dataFieldId).getName();
                buffer.append("-" + dataFieldName);
                result = buffer.toString();
            } else if (ParticipantType.PROCESS_EXECUTOR.equals((Object)participantType)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(MultiapproveUtils.getResString("processExecutor", locale));
                String type = prtcpntDef.getProcessExecutorType();
                buffer.append("-" + ("executed".equals(type) ? MultiapproveUtils.getResString("implemented", locale) : MultiapproveUtils.getResString("assigned", locale)));
                result = buffer.toString();
            } else if (ParticipantType.WFROLE.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("PARTICIPANT_WFROLE", locale) + "-" + prtcpntDef.getName();
            } else if (ParticipantType.WFROLE_GROUP.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("PARTICIPANT_WFROLEGROUP", locale) + "-" + prtcpntDef.getName();
            } else if (ParticipantType.WFFunction.equals((Object)participantType)) {
                result = MultiapproveUtils.getResString("PARTICIPANT_WFFUNCTION", locale) + "-" + prtcpntDef.getName();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public static String getRelationParticipantName(ParticipantDef participantDef, ProcessDef processDef, Locale locale) throws Exception {
        return ParticipantUtils.getRelationParticipantName(participantDef, processDef, locale, null);
    }

    public static String getRelationParticipantName(ParticipantDef participantDef, ProcessDef processDef, Locale locale, Context ctx) throws Exception {
        if (participantDef == null) {
            throw new IllegalArgumentException();
        }
        ReferenceHumanType referenceHumanType = participantDef.getReferenceHumanType();
        if (ReferenceHumanType.ACTIVITY_PERFORMER.equals((Object)referenceHumanType)) {
            String activityDefId = participantDef.getReferenceHumanId();
            ActivityDef activityDef = processDef.getActivityDef(activityDefId);
            if (activityDef == null) {
                return EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"171_ParticipantUtils") + activityDefId + EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MULTIAPPROVEAutoGenerateResource", (String)"172_ParticipantUtils");
            }
            String activityDefName = activityDef.getName(locale);
            return activityDefName;
        }
        if (ReferenceHumanType.EMPLOYEE.equals((Object)referenceHumanType)) {
            String personId = participantDef.getReferenceHumanId();
            return MultiapproveUtils.getPersonInfo(personId, ctx).getName();
        }
        if (ReferenceHumanType.POSITION.equals((Object)referenceHumanType)) {
            String positionId = participantDef.getReferenceHumanId();
            return MultiapproveUtils.getPositionInfo(positionId, ctx).getName();
        }
        if (ReferenceHumanType.PROCESS_INITIATOR.equals((Object)referenceHumanType)) {
            return MultiapproveUtils.getResString("processPromoters", locale);
        }
        if (ReferenceHumanType.PROCESS_VARIABLE.equals((Object)referenceHumanType)) {
            String dataFieldId = participantDef.getReferenceHumanId();
            return processDef.getDataFieldDef(dataFieldId).getName();
        }
        if (ReferenceHumanType.ORGNIZATION.equals((Object)referenceHumanType)) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static String getParticipantOrgId(ParticipantDef prtcpntDef) throws EASBizException, BOSException {
        if (prtcpntDef == null) {
            String msg = "\"prtcpntDef\" is null!";
            throw new IllegalArgumentException(msg);
        }
        ParticipantType participantType = prtcpntDef.getParticipantType();
        if (ParticipantType.ALL.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.HUMAN.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER.equals((Object)participantType)) {
            return prtcpntDef.getParticipantValue();
        }
        if (ParticipantType.ORGANIZATIONAL_UNIT_MEMBER.equals((Object)participantType)) {
            return prtcpntDef.getParticipantValue();
        }
        if (ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER.equals((Object)participantType)) {
            return prtcpntDef.getParticipantValue();
        }
        if (ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL.equals((Object)participantType)) {
            return prtcpntDef.getParticipantValue();
        }
        if (ParticipantType.PERMISSION_OWNER.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.POSITION.equals((Object)participantType)) {
            String positionId = prtcpntDef.getParticipantValue();
            PositionInfo position = MultiapproveUtils.getPositionInfo(positionId);
            return position.getAdminOrgUnit().getId().toString();
        }
        if (ParticipantType.PROCESS_RESPONSIBILITY.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.RELATION.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.GROUP.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.RESOURCE.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.RESOURCE_SET.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.ROLE.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.SYSTEM.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.USER.equals((Object)participantType)) {
            return null;
        }
        if (ParticipantType.VARIANT.equals((Object)participantType)) {
            return null;
        }
        return null;
    }
}

