/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.AbstractComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.IComMenuFunction;
import com.kingdee.eas.base.myeas.app.AbstractComMenuFunctionControllerBean;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.IMenuCache;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ComMenuFunctionControllerBean
extends AbstractComMenuFunctionControllerBean {
    private static final Logger logger = Logger.getLogger(ComMenuFunctionControllerBean.class);

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        super._update(ctx, pk, value);
        MenuCacheFactory.getLocalInstance((Context)ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) {
        try {
            super._delete(ctx, pk);
            MenuCacheFactory.getLocalInstance((Context)ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        MenuCacheFactory.getLocalInstance((Context)ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
        ComMenuFunctionInfo info = (ComMenuFunctionInfo)ComMenuFunctionFactory.getLocalInstance(ctx).getValue(oql);
        String parentId = null;
        if (info != null) {
            parentId = info.getParent().getId().toString();
        }
        IObjectPK[] pks = super._delete(ctx, oql);
        this._removeDirWhenOneChild(ctx, parentId);
        return pks;
    }

    @Override
    protected void _removeDirWhenOneChild(Context ctx, String parentId) throws BOSException, EASBizException {
        int count = MyComFunctionFacadeFactory.getLocalInstance((Context)ctx).getChildCount(parentId);
        if (count <= 1) {
            ComMenuFunctionCollection coll = MyComFunctionFacadeFactory.getLocalInstance((Context)ctx).getComFunction(parentId);
            ComMenuFunctionInfo root = MyComFunctionFacadeFactory.getLocalInstance((Context)ctx).getFunctionRoot();
            if (coll != null && coll.size() == 1) {
                ComMenuFunctionInfo tmpInfo = coll.get(0);
                AbstractComMenuFunctionInfo parentInfo = null;
                try {
                    IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getLocalInstance(ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("order");
                    parentInfo = iComMenuFunction.getComMenuFunctionInfo((IObjectPK)new ObjectUuidPK(parentId), sic);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (parentInfo == null) {
                    return;
                }
                tmpInfo.setOrder(parentInfo.getOrder());
                tmpInfo.setParent(root);
                tmpInfo.setLevel(root.getLevel() + 1);
                tmpInfo.setLongNumber(root.getNumber() + "!" + tmpInfo.getNumber());
                try {
                    ComMenuFunctionFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmpInfo.getId()), (CoreBaseInfo)tmpInfo);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (!StringUtils.equals((String)root.getId().toString(), (String)parentId)) {
                MyComFunctionFacadeFactory.getLocalInstance((Context)ctx).deleteFunction("fid = '" + parentId + "'");
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MenuCacheFactory.getLocalInstance((Context)ctx).updateComMenuCacheByUserId(StringUtils.cnulls((Object)ctx.getCaller()));
        return super._addnew(ctx, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return false;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getCollByUser(Context ctx, String userId) throws BOSException, EASBizException {
        ComMenuFunctionCollection comFunColl = null;
        MainMenuItemCollection menuFunColl = new MainMenuItemCollection();
        IComMenuFunction iCom = ComMenuFunctionFactory.getLocalInstance(ctx);
        IMainMenuItem iMenuItem = MainMenuItemFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("user", (Object)userId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        comFunColl = iCom.getComMenuFunctionCollection(viewInfo);
        if (comFunColl != null) {
            int size = comFunColl.size();
            MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
            ComMenuFunctionInfo comFunInfo = null;
            Object pk = null;
            for (int i = 0; i < size; ++i) {
                comFunInfo = comFunColl.get(i);
                menuFunColl.add(menuItemInfo);
            }
        }
        return menuFunColl;
    }

    @Override
    protected void _batchUpdate(Context ctx, IObjectCollection functionColl) throws BOSException, EASBizException {
        if (functionColl == null) {
            return;
        }
        for (ComMenuFunctionInfo data : functionColl) {
            ObjectUuidPK pk = new ObjectUuidPK(data.getId());
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)data);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItemUser = new FilterItemInfo("user", (Object)ctx.getCaller().toString());
        filter.getFilterItems().add(filterItemUser);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        logger.error((Object)("_checkNumberDup : " + filter.toSql()));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            String name = dataBaseInfo.getName();
            name = name + EASCommonResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource", (String)"INCOMMFUN", (Locale)ctx.getLocale());
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private Map<String, Integer> getUserMaxOrderMap(Context ctx, Set<String> userIdSet) throws BOSException {
        String sql = "select fuserid,max(forder) maxOrder from t_bas_comfunction group by fuserid having fuserid in (" + ToolUtils.aryToStr(userIdSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        try {
            String userId = null;
            int maxOrder = 0;
            while (rs.next()) {
                userId = rs.getString("fuserid");
                maxOrder = rs.getInt("maxOrder");
                ret.put(userId, maxOrder);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Set<String> getUserIdSet(Set userSet) {
        Iterator itr = userSet.iterator();
        HashSet<String> ret = new HashSet<String>();
        while (itr.hasNext()) {
            ret.add(StringUtils.cnulls((Object)((UserInfo)itr.next()).getId()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _addBatchByUserAndMenu(Context ctx, Set userSet, Set menuIdSet) throws BOSException {
        block11: {
            PreparedStatement st;
            Connection con;
            block10: {
                if (userSet == null || userSet.size() == 0 || menuIdSet == null || menuIdSet.size() == 0) {
                    return;
                }
                Map<String, ComMenuFunctionInfo> userIdRootMap = this.getUserIdAndRootComFunctionMap(ctx, userSet);
                Set<MainMenuItemInfo> menuInfoSet = this.getMenuSetById(ctx, menuIdSet);
                Set<String> userIdSet = this.getUserIdSet(userSet);
                Map<String, Integer> userMaxOrderMap = this.getUserMaxOrderMap(ctx, userIdSet);
                String currentUserId = ctx.getCaller().toString();
                Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
                String ctrlUnitId = null;
                ctrlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
                con = null;
                st = null;
                TableManager tm = null;
                String tableName = null;
                try {
                    tm = TableManager.getTableManager((Context)ctx);
                    tableName = tm.getTableName("roleComFunction");
                    String createSql = "create table " + tableName + " ( FID VARCHAR(44),FUserID VARCHAR(44),FMenuFunctionID VARCHAR(44),FNumber NVARCHAR(80),FName_L2 NVARCHAR(80),FIsLeaf INT ,FLongNumber NVARCHAR(200),FLevel INT,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FDir INT,FOrder INT,FControlUnitID VARCHAR(44),FPAGETYPE varchar(80),FParentID VARCHAR(44))";
                    tm.createTable(createSql);
                    String sql = "insert into " + tableName + " (FID,FUSERID,FMENUFUNCTIONID,FNUMBER,FNAME_L2,FISLEAF,FLONGNUMBER,FLEVEL,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FDIR,FORDER,FCONTROLUNITID,FPAGETYPE,FParentID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    con = this.getConnection(ctx);
                    st = con.prepareStatement(sql);
                    Iterator<MainMenuItemInfo> menuItr = menuInfoSet.iterator();
                    MainMenuItemInfo menu = null;
                    UserInfo user2 = null;
                    String userId = null;
                    ComMenuFunctionInfo rootComFun = null;
                    while (menuItr.hasNext()) {
                        menu = menuItr.next();
                        for (UserInfo user2 : userSet) {
                            userId = user2.getId().toString();
                            rootComFun = userIdRootMap.get(userId);
                            String number = menu.getNumber();
                            BOSUuid id = BOSUuid.create((String)"B75723F0");
                            st.setString(1, id.toString());
                            st.setString(2, user2.getId().toString());
                            st.setString(3, menu.getId().toString());
                            st.setString(4, number);
                            st.setString(5, menu.getName());
                            st.setInt(6, 1);
                            st.setString(7, rootComFun.getNumber() + "!" + number);
                            st.setInt(8, 2);
                            st.setString(9, currentUserId);
                            st.setTimestamp(10, now);
                            st.setString(11, currentUserId);
                            st.setTimestamp(12, now);
                            st.setInt(13, 0);
                            Integer maxOrderObj = userMaxOrderMap.get(userId);
                            int maxOrder = 0;
                            if (maxOrderObj != null) {
                                maxOrder = maxOrderObj;
                            }
                            userMaxOrderMap.put(userId, ++maxOrder);
                            st.setInt(14, maxOrder);
                            st.setString(15, ctrlUnitId);
                            st.setString(16, "EXTERNAL_LINK_G");
                            st.setString(17, rootComFun.getId().toString());
                            st.addBatch();
                        }
                    }
                    st.executeBatch();
                    String insertSql = "insert into T_BAS_ComFunction (FID,FUSERID,FMENUFUNCTIONID,FNUMBER,FNAME_L2,FISLEAF,FLONGNUMBER,FLEVEL,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FDIR,FORDER,FCONTROLUNITID,FPAGETYPE,FParentID)select FID,FUSERID,FMENUFUNCTIONID,FNUMBER,FNAME_L2,FISLEAF,FLONGNUMBER,FLEVEL,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FDIR,FORDER,FCONTROLUNITID,FPAGETYPE,FParentID from " + tableName + " where not exists (select 1 from T_BAS_ComFunction where FUserID = " + tableName + ".FUserID and FMENUFUNCTIONID = " + tableName + ".FMENUFUNCTIONID)";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                    this.clearComFunCache(ctx, userSet);
                    if (tm == null || tableName == null) break block10;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    break block11;
                }
                finally {
                    if (tm != null && tableName != null) {
                        tm.releaseTable(tableName);
                    }
                    SQLUtils.cleanup(st, con);
                }
                tm.releaseTable(tableName);
            }
            SQLUtils.cleanup((Statement)st, (Connection)con);
        }
    }

    private void clearComFunCache(Context ctx, Set userSet) throws BOSException {
        IMenuCache iMenuCache = MenuCacheFactory.getLocalInstance((Context)ctx);
        HashSet<String> userIdSet = new HashSet<String>();
        for (UserInfo user : userSet) {
            userIdSet.add(user.getId().toString());
        }
        try {
            iMenuCache.updateComMenuCacheByUserIds(userIdSet);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Set<MainMenuItemInfo> getMenuSetById(Context ctx, Set menuIdSet) throws BOSException {
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        String sql = "select fid menuid,fnumber menuNum,fname_l2 menuName from t_pm_mainmenuitem where fid in (" + ToolUtils.aryToStr((Collection)menuIdSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            MainMenuItemInfo info = null;
            while (rs.next()) {
                info = new MainMenuItemInfo();
                info.setId(BOSUuid.read((String)rs.getString("menuid")));
                info.setNumber(rs.getString("menuNum"));
                info.setName(rs.getString("menuName"));
                ret.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Map<String, ComMenuFunctionInfo> getUserIdAndRootComFunctionMap(Context ctx, Set<UserInfo> userInfoSet) throws BOSException {
        HashMap<String, ComMenuFunctionInfo> ret = new HashMap<String, ComMenuFunctionInfo>();
        ArrayList<String> userIdList = new ArrayList<String>();
        Iterator<UserInfo> userInfoItr = userInfoSet.iterator();
        HashMap<String, UserInfo> userIdWithoutRootMap = new HashMap<String, UserInfo>();
        while (userInfoItr.hasNext()) {
            UserInfo userInfo = userInfoItr.next();
            userIdList.add(userInfo.getId().toString());
            userIdWithoutRootMap.put(userInfo.getId().toString(), userInfo);
        }
        String sql = "select fid,fnumber,fuserid from T_BAS_ComFunction where fparentid is null and fuserid in (" + ToolUtils.aryToStr(userIdList) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String userId = rs.getString("fuserid");
                String id = rs.getString("fid");
                String number = rs.getString("fnumber");
                ComMenuFunctionInfo root = new ComMenuFunctionInfo();
                root.setId(BOSUuid.read((String)id));
                root.setNumber(number);
                userIdWithoutRootMap.remove(userId);
                ret.put(userId, root);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (userIdWithoutRootMap.size() > 0) {
            Map<String, ComMenuFunctionInfo> newUserRootMap = this.getNewUserRootMap(ctx, userIdWithoutRootMap.values());
            ret.putAll(newUserRootMap);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ComMenuFunctionInfo> getNewUserRootMap(Context ctx, Collection<UserInfo> userInfoCol) throws BOSException {
        HashMap<String, ComMenuFunctionInfo> ret = new HashMap<String, ComMenuFunctionInfo>();
        String currentUserId = ctx.getCaller().toString();
        Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
        String ctrlUnitId = null;
        ctrlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
        String sql = "insert into T_BAS_ComFunction (FID,FUSERID,FMENUFUNCTIONID,FNUMBER,FNAME_L2,FISLEAF,FLONGNUMBER,FLEVEL,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FDIR,FORDER,FCONTROLUNITID,FPAGETYPE) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = this.getConnection(ctx);
            st = con.prepareStatement(sql);
            Iterator<UserInfo> userInfoItr = userInfoCol.iterator();
            ComMenuFunctionInfo rootData = null;
            while (userInfoItr.hasNext()) {
                UserInfo user = userInfoItr.next();
                rootData = new ComMenuFunctionInfo();
                rootData.setUser(user);
                String number = "root" + user.getNumber();
                rootData.setNumber(number);
                rootData.setLongNumber(number);
                BOSUuid id = BOSUuid.create((String)"B75723F0");
                rootData.setId(id);
                ret.put(user.getId().toString(), rootData);
                st.setString(1, id.toString());
                st.setString(2, user.getId().toString());
                st.setString(3, BOSUuid.create((String)"FD37DC9F").toString());
                st.setString(4, number);
                st.setString(5, "virtual root");
                st.setInt(6, 0);
                st.setString(7, number);
                st.setInt(8, 1);
                st.setString(9, currentUserId);
                st.setTimestamp(10, now);
                st.setString(11, currentUserId);
                st.setTimestamp(12, now);
                st.setInt(13, 1);
                st.setInt(14, 0);
                st.setString(15, ctrlUnitId);
                st.setString(16, "EXTERNAL_LINK_G");
                st.addBatch();
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)st, (Connection)con);
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
        return ret;
    }
}

