/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.myeas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.myeas.LoginTypeEnum;
import com.kingdee.eas.base.myeas.OverdueReminderLogInfo;
import com.kingdee.eas.base.myeas.TipsTypeEnum;
import com.kingdee.eas.base.myeas.app.AbstractOverdueReminderLogControllerBean;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class OverdueReminderLogControllerBean
extends AbstractOverdueReminderLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.myeas.app.OverdueReminderLogControllerBean");
    private static String ISNEEDSHOW = "isNeedShow";
    private static String NOT_REMINDER_SEVEN = "not_reminder_seven";
    private static String NOT_REMINDER_THIRTY = "not_reminder_thirty";
    private static final long SERVICE_VALIDDATE_RANGE_START = 30L;
    private static final long SERVICE_VALIDDATE_RANGE_ONE = 14L;
    private static final long SERVICE_VALIDDATE_RANGE_TWO = 7L;
    private static final long SERVICE_VALIDDATE_RANGE_THREE = -7L;

    @Override
    protected String _getServiceOverdueReminder(Context ctx, LoginTypeEnum loginType) throws BOSException {
        try {
            long OverdueTimeInMillis = this.getOverdueTimeInMillis(ctx, TipsTypeEnum.SERVICE);
            long CurrentTimeInMillis = this.getCurrentTimeInMillis();
            long serviceValidDays = this.millisConvertDays(OverdueTimeInMillis - CurrentTimeInMillis);
            if (serviceValidDays > 30L) {
                return this.bulidResultString();
            }
            Timestamp notNeedReminderTimeInMillis = this.getNotNeedReminderTimeInMillis(ctx, "SERVICE");
            if (notNeedReminderTimeInMillis != null && CurrentTimeInMillis < notNeedReminderTimeInMillis.getTime()) {
                return this.bulidResultString();
            }
            boolean isAdmin = "administrator".equalsIgnoreCase(ctx.getUserName());
            if (serviceValidDays < -7L && !isAdmin) {
                return this.bulidResultString();
            }
            Timestamp lastClosedTime = this.getReminderByUserID(ctx, "SERVICE");
            if (lastClosedTime == null) {
                if (serviceValidDays > 0L) {
                    return this.bulidResultString(serviceValidDays);
                }
                if (serviceValidDays < -7L) {
                    return this.bulidResultString(serviceValidDays, NOT_REMINDER_THIRTY);
                }
                if (isAdmin) {
                    return this.bulidResultString(serviceValidDays);
                }
                return this.bulidResultString(serviceValidDays, NOT_REMINDER_SEVEN);
            }
            long lastClosedTimeInMillis = lastClosedTime.getTime();
            boolean isClosedTips = false;
            if (serviceValidDays <= 0L) {
                isClosedTips = this.isInRangeOfDate(lastClosedTimeInMillis, OverdueTimeInMillis - this.daysConvertMillis(serviceValidDays + 1L), CurrentTimeInMillis);
                if (isClosedTips) {
                    return this.bulidResultString();
                }
                if (serviceValidDays < -7L) {
                    return this.bulidResultString(0L, NOT_REMINDER_THIRTY);
                }
                if (isAdmin) {
                    return this.bulidResultString(0L);
                }
                return this.bulidResultString(0L, NOT_REMINDER_SEVEN);
            }
            isClosedTips = serviceValidDays <= 7L ? this.isInRangeOfDate(lastClosedTimeInMillis, OverdueTimeInMillis - this.daysConvertMillis(serviceValidDays + 1L), CurrentTimeInMillis).booleanValue() : (serviceValidDays > 14L ? this.isInRangeOfDate(lastClosedTimeInMillis, OverdueTimeInMillis - this.daysConvertMillis(31L), CurrentTimeInMillis) : this.isInRangeOfDate(lastClosedTimeInMillis, OverdueTimeInMillis - this.daysConvertMillis(15L), CurrentTimeInMillis)).booleanValue();
            if (isClosedTips) {
                return this.bulidResultString();
            }
            return this.bulidResultString(serviceValidDays);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void _addnew(Context ctx, TipsTypeEnum tipsType, LoginTypeEnum loginType, boolean isNotReminder) throws BOSException {
        OverdueReminderLogInfo reminderEntity = new OverdueReminderLogInfo();
        try {
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (user == null) {
                return;
            }
            String clientHostIP = ctx.getClientHostIP();
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            reminderEntity.setCreator(user);
            reminderEntity.setCurrentIP(clientHostIP);
            reminderEntity.setServerName(hostAddress);
            reminderEntity.setTipsType(tipsType);
            reminderEntity.setLoginType(loginType);
            if (isNotReminder) {
                IObjectPK userPK = ctx.getCaller();
                boolean isAdmin = Administrator.isSuperAdmin((IObjectPK)userPK);
                long NotReminderTimeInMills = isAdmin ? this.getCurrentTimeInMillis() + this.daysConvertMillis(30L) : this.getCurrentTimeInMillis() + this.daysConvertMillis(7L);
                reminderEntity.setNotNeedReminderTime(new Timestamp(NotReminderTimeInMills));
            }
            super.addnew(ctx, reminderEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getCurrentTimeInMillis() {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        return c2.getTimeInMillis();
    }

    private long getOverdueTimeInMillis(Context ctx, TipsTypeEnum tipsType) {
        long OverdueTimeInMillis = 0L;
        try {
            if (TipsTypeEnum.SERVICE.equals((Object)tipsType)) {
                Calendar c1 = Calendar.getInstance();
                ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                c1.setTime(iLicenseSrvAgent.getLicenseBaseInfo().getServiceDate());
                OverdueTimeInMillis = c1.getTimeInMillis();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return OverdueTimeInMillis;
    }

    private Timestamp getNotNeedReminderTimeInMillis(Context ctx, String tipsType) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userID = user.getId().toString();
        if (StringUtils.isEmpty((String)userID)) {
            return null;
        }
        String sql = "select * from T_MY_OverdueReminderLog where FNotNeedReminderTime in (SELECT max(FNotNeedReminderTime) FROM T_MY_OverdueReminderLog) and FTipsType =? and FcreatorID=?";
        Object[] params = new Object[]{tipsType, userID};
        Timestamp notReminderTime = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                notReminderTime = rs.getTimestamp("FNotNeedReminderTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notReminderTime;
    }

    private Timestamp getReminderByUserID(Context ctx, String tipsType) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userID = user.getId().toString();
        if (StringUtils.isEmpty((String)userID)) {
            return null;
        }
        String sql = "select * from T_MY_OverdueReminderLog where FCreateTime in (SELECT max(FCreateTime) FROM T_MY_OverdueReminderLog where FTipsType =? and FcreatorID=?)";
        Object[] params = new Object[]{tipsType, userID};
        Timestamp createTime = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                createTime = rs.getTimestamp("FCreateTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return createTime;
    }

    private Boolean isInRangeOfDate(long value, long min, long max) {
        if (value >= min && value <= max) {
            return true;
        }
        return false;
    }

    private long daysConvertMillis(long days) {
        return days * 1000L * 60L * 60L * 24L;
    }

    private long millisConvertDays(long millis) {
        int dayMills = 86400000;
        if (millis > 0L && millis < (long)dayMills) {
            return 1L;
        }
        return millis / 86400000L;
    }

    private String bulidResultString(long validDays) {
        if (validDays < 0L) {
            validDays = 0L;
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)ISNEEDSHOW, (Object)true);
        resultObj.put((Object)"validDays", (Object)validDays);
        resultObj.put((Object)"tipsType", (Object)"SERVICE");
        return resultObj.toString();
    }

    private String bulidResultString(long validDays, String notReminderStr) {
        if (validDays < 0L) {
            validDays = 0L;
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)ISNEEDSHOW, (Object)true);
        resultObj.put((Object)"validDays", (Object)validDays);
        resultObj.put((Object)"tipsType", (Object)"SERVICE");
        resultObj.put((Object)"notReminderStr", (Object)notReminderStr);
        return resultObj.toString();
    }

    private String bulidResultString() {
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)ISNEEDSHOW, (Object)false);
        return resultObj.toString();
    }
}

