/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.netctrl.ContextJudgement;
import com.kingdee.eas.base.netctrl.DataLockParameter;
import com.kingdee.eas.base.netctrl.IJudgement;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.netctrl.UuidJudgement;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MutexService {
    private static boolean saveLockDescription = Boolean.parseBoolean(System.getProperty("com.kingdee.eas.base.netctrl.app.MutexService.saveLockDescription", "false"));
    private static Logger logger = Logger.getLogger(MutexService.class);
    private static MutexService mutexService = new MutexService();
    private static Map mutexList = Collections.synchronizedMap(new HashMap());
    private static Map objLockList = Collections.synchronizedMap(new HashMap());

    private MutexService() {
    }

    public static MutexService getInstance() {
        return mutexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMutex(Context ctx, MutexParameter mutexParameter) {
        logger.info((Object)(" mutexParameter = " + mutexParameter));
        Map map = mutexList;
        synchronized (map) {
            Collection values = mutexList.values();
            logger.info((Object)("mutexParameter.getMutexName() = " + mutexParameter.getMutexName() + " mutexList.size = " + mutexList.size()));
            MutexParameter currentLock2 = null;
            for (MutexParameter currentLock2 : values) {
                logger.info((Object)("currentLock =  " + currentLock2));
                if (!StringUtils.equals((String)(currentLock2.getMutexName().trim() + currentLock2.getAIX()), (String)(mutexParameter.getMutexName().trim() + ctx.getAIS()))) continue;
                if (currentLock2.getOrgUnitID() == null) {
                    if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                        return false;
                    }
                    if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                    return false;
                }
                if (mutexParameter.getOrgUnitID() != null) {
                    if (!StringUtils.equals((String)currentLock2.getOrgUnitID().toString().trim(), (String)StringUtils.cnulls((Object)mutexParameter.getOrgUnitID()).toString().trim())) continue;
                    if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                        return false;
                    }
                    if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                    return false;
                }
                if (mutexParameter.getOrgUnitID() != null) continue;
                if (mutexParameter.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                    return false;
                }
                if (currentLock2.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) continue;
                return false;
            }
            mutexParameter.setCreateTime(new Date());
            mutexParameter.setAIX(ctx.getAIS());
            mutexParameter.setSessionID(this.getSessionIDFromContext(ctx));
            mutexList.put(Uuid.create().toString().trim(), mutexParameter.clone());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMutex2(Context ctx, MutexParameter mutexParameter) {
        logger.info((Object)(" mutexParameter = " + mutexParameter));
        Map map = mutexList;
        synchronized (map) {
            Collection values = mutexList.values();
            logger.info((Object)("mutexParameter.getMutexName() = " + mutexParameter.getMutexName() + " mutexList.size = " + mutexList.size()));
            MutexParameter currentLock2 = null;
            for (MutexParameter currentLock2 : values) {
                logger.info((Object)("currentLock =  " + currentLock2));
                if (!StringUtils.equals((String)currentLock2.getMutexName().trim(), (String)mutexParameter.getMutexName().trim()) || mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) continue;
                return false;
            }
            mutexParameter.setCreateTime(new Date());
            mutexParameter.setSessionID(this.getSessionIDFromContext(ctx));
            mutexList.put(Uuid.create().toString().trim(), mutexParameter.clone());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutexParameter requestMutex3(Context ctx, MutexParameter mutexParameter) {
        logger.info((Object)(" mutexParameter = " + mutexParameter));
        Map map = mutexList;
        synchronized (map) {
            Collection values = mutexList.values();
            logger.info((Object)("mutexParameter.getMutexName() = " + mutexParameter.getMutexName() + " mutexList.size = " + mutexList.size()));
            MutexParameter currentLock2 = null;
            for (MutexParameter currentLock2 : values) {
                logger.info((Object)("currentLock =  " + currentLock2));
                if (!StringUtils.equals((String)(currentLock2.getMutexName().trim() + currentLock2.getAIX()), (String)(mutexParameter.getMutexName().trim() + ctx.getAIS()))) continue;
                if (currentLock2.getOrgUnitID() == null) {
                    if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                        return currentLock2;
                    }
                    if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                    return currentLock2;
                }
                if (mutexParameter.getOrgUnitID() != null) {
                    if (!StringUtils.equals((String)currentLock2.getOrgUnitID().toString().trim(), (String)StringUtils.cnulls((Object)mutexParameter.getOrgUnitID()).toString().trim())) continue;
                    if (currentLock2.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                        return currentLock2;
                    }
                    if (mutexParameter.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) break;
                    return currentLock2;
                }
                if (mutexParameter.getOrgUnitID() != null) continue;
                if (mutexParameter.getMutexLockType() == MutexLockType.EXCLUSIVE_LOCK) {
                    return currentLock2;
                }
                if (currentLock2.getMutexLockType() != MutexLockType.EXCLUSIVE_LOCK) continue;
                return currentLock2;
            }
            mutexParameter.setCreateTime(new Date());
            mutexParameter.setAIX(ctx.getAIS());
            mutexParameter.setSessionID(this.getSessionIDFromContext(ctx));
            mutexList.put(Uuid.create().toString().trim(), mutexParameter.clone());
            return null;
        }
    }

    private String getSessionIDFromContext(Context ctx) {
        return ctx.getContextID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMutex(Context ctx, Uuid requestId) {
        Map map = mutexList;
        synchronized (map) {
            if (requestId != null && mutexList != null) {
                Iterator iter = mutexList.entrySet().iterator();
                String key = null;
                MutexParameter value = null;
                Map.Entry entry = null;
                Vector<String> keys = new Vector<String>();
                while (iter.hasNext()) {
                    entry = iter.next();
                    key = (String)entry.getKey();
                    value = (MutexParameter)entry.getValue();
                    if (!StringUtils.equals((String)value.getRequestId().toString(), (String)requestId.toString())) continue;
                    keys.add(key);
                }
                for (int i = 0; i < keys.size(); ++i) {
                    mutexList.remove((String)keys.get(i));
                }
            }
        }
    }

    public Map getMutexList(Context ctx) {
        HashMap viewMap = new HashMap();
        viewMap.putAll(mutexList);
        return viewMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMutex(Context ctx) {
        Map map = mutexList;
        synchronized (map) {
            if (mutexList != null) {
                mutexList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delMutex(Context ctx, String id) {
        Map map = mutexList;
        synchronized (map) {
            if (!StringUtils.cnulls((String)id).equals("") && mutexList != null) {
                mutexList.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getObjIDForUpdateList(Context ctx) {
        Map map = objLockList;
        synchronized (map) {
            HashMap viewMap = new HashMap();
            viewMap.putAll(objLockList);
            return viewMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delObjIDForUpdate(Context ctx, String id) {
        Map map = objLockList;
        synchronized (map) {
            if (id != null && objLockList.containsKey(id)) {
                objLockList.remove(id);
            }
        }
    }

    public boolean requestObjIDForUpdate(Context ctx, String id) {
        return this.requestObjIDForUpdate(ctx, id, true);
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, boolean isBatchRequest) {
        return this.requestObjIDForUpdate(ctx, id, isBatchRequest, null);
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, boolean isBatchRequst, String objectDescription) {
        DataLockParameter dataLockParameter = new DataLockParameter(id, isBatchRequst);
        dataLockParameter.setObjectDescription(objectDescription);
        dataLockParameter.setCtx(ctx);
        ObjectUpdateLock exist = this.innerRequestObjIDForUpdate(ctx, dataLockParameter, new ContextJudgement());
        return exist == null;
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, String userId) {
        return this.requestObjIDForUpdate(ctx, id, userId, ctx.getAIS(), null);
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName) {
        return this.requestObjIDForUpdate(ctx, id, userId, ctx.getAIS(), null);
    }

    public ObjectUpdateLock requestObjIDForUpdate2(Context ctx, String id, String userId, String dcName) {
        return this.requestObjIDForUpdate2(ctx, id, userId, dcName, null);
    }

    public ObjectUpdateLock requestObjIDForUpdate2(Context ctx, String id, String userId, String dcName, String objectDescription) {
        DataLockParameter dataLockParameter = new DataLockParameter(id, userId, dcName, null);
        dataLockParameter.setObjectDescription(objectDescription);
        dataLockParameter.setCtx(ctx);
        return this.innerRequestObjIDForUpdate(ctx, dataLockParameter, new ContextJudgement());
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName, String objectDescription) {
        DataLockParameter dataLockParameter = new DataLockParameter(id, userId, dcName, objectDescription);
        dataLockParameter.setCtx(ctx);
        ObjectUpdateLock exist = this.innerRequestObjIDForUpdate(ctx, dataLockParameter, new ContextJudgement());
        return exist == null;
    }

    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, Uuid uuid) {
        return this.requestObjIDForUpdateWithUuid(ctx, id, userId, uuid, null);
    }

    public boolean requestObjIDForUpdateWithUuid(Context ctx, String id, String userId, Uuid uuid, String objectDescription) {
        DataLockParameter dataLockParameter = new DataLockParameter(id, userId, uuid);
        dataLockParameter.setObjectDescription(objectDescription);
        dataLockParameter.setCtx(ctx);
        ObjectUpdateLock exist = this.innerRequestObjIDForUpdate(ctx, dataLockParameter, new UuidJudgement());
        return exist == null;
    }

    public boolean requestBizObjIDForUpdate(Context ctx, String id) {
        return this.requestBizObjIDForUpdate(ctx, id, null);
    }

    public boolean requestBizObjIDForUpdate(Context ctx, String id, String objectDescription) {
        DataLockParameter dataLockParameter = new DataLockParameter(id);
        dataLockParameter.setObjectDescription(objectDescription);
        dataLockParameter.setCtx(ctx);
        ObjectUpdateLock exist = this.innerRequestObjIDForUpdate(ctx, dataLockParameter, new ContextJudgement());
        return exist == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObjIDForUpdate(Context ctx, String id) {
        id = id + ctx.getAIS();
        logger.warn((Object)("========== releaseObjIDForUpdate: " + id));
        Map map = objLockList;
        synchronized (map) {
            if (objLockList.containsKey(id)) {
                logger.warn((Object)("========== exits: " + id));
                ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(id);
                if (lock.getContextID().trim().equals(ctx.getContextID().trim())) {
                    logger.warn((Object)("========== removeObjIDForUpdate: " + id));
                    objLockList.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObjIDForUpdate(Context ctx, String id, Uuid uuid) {
        id = id + ctx.getAIS();
        logger.warn((Object)("========== releaseObjIDForUpdate(uuid): " + id + " " + uuid));
        Map map = objLockList;
        synchronized (map) {
            if (objLockList.containsKey(id)) {
                if (uuid == null) {
                    objLockList.remove(id);
                } else {
                    ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(id);
                    if (lock.getUuid() == null) {
                        return;
                    }
                    if (lock.getUuid().toString().equals(uuid.toString())) {
                        objLockList.remove(id);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllObjId(Context ctx) {
        Map map = objLockList;
        synchronized (map) {
            if (objLockList != null) {
                objLockList.clear();
            }
        }
    }

    public static MutexService getInstanceOfObjId() {
        return mutexService;
    }

    public ObjectUpdateLock getObjectUpdateLock(Context ctx, String id) {
        String key = id + ctx.getAIS();
        if (objLockList.containsKey(key)) {
            ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
            return lock;
        }
        return null;
    }

    public void releaseAllFuncMutexAndObjLocks(String sessionID) {
        this.innerReleaseAllFuncMutexAndObjLocks(sessionID, true);
    }

    public void releaseAllFuncMutexAndObjLocksWhenRemoveSession(Context ctx, String sessionID) {
        this.innerReleaseAllFuncMutexAndObjLocks(sessionID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchReleaseObjIDForUpdate(Context ctx, List idList) {
        Map map = objLockList;
        synchronized (map) {
            for (String id : idList) {
                this.releaseObjIDForUpdate(ctx, id);
            }
        }
    }

    public Map batchRequestObjIDForUpdate(Context ctx, List idList) {
        return this.batchRequestObjIDForUpdate(ctx, idList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map batchRequestObjIDForUpdate(Context ctx, List idList, String description) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        Map map = objLockList;
        synchronized (map) {
            for (String id : idList) {
                boolean success = this.requestObjIDForUpdate(ctx, id, null, null, description);
                result.put(id, success);
            }
        }
        return result;
    }

    public Map batchRequestBizObjIDForUpdate(Context ctx, List idList) {
        return this.batchRequestBizObjIDForUpdate(ctx, idList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map batchRequestBizObjIDForUpdate(Context ctx, List idList, String objectDescription) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        Map map = objLockList;
        synchronized (map) {
            for (String id : idList) {
                boolean success = this.requestBizObjIDForUpdate(ctx, id, objectDescription);
                result.put(id, success);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerReleaseAllFuncMutexAndObjLocks(String sessionID, boolean releaseAll) {
        int i;
        Vector<String> keys;
        Map.Entry entry;
        Cloneable value;
        String key;
        Iterator iter;
        Map map = mutexList;
        synchronized (map) {
            if (sessionID != null && mutexList != null) {
                iter = mutexList.entrySet().iterator();
                key = null;
                value = null;
                entry = null;
                keys = new Vector<String>();
                while (iter.hasNext()) {
                    entry = iter.next();
                    key = (String)entry.getKey();
                    value = (MutexParameter)entry.getValue();
                    long delayTime = new Date().getTime() - ((MutexParameter)value).getCreateTime().getTime();
                    boolean shouldRemove = releaseAll || ((MutexParameter)value).isReleaseWhenClearSession();
                    if (!shouldRemove || !StringUtils.equals((String)((MutexParameter)value).getSessionID(), (String)sessionID) && delayTime <= 36000000L) continue;
                    keys.add(key);
                }
                for (i = 0; i < keys.size(); ++i) {
                    mutexList.remove((String)keys.get(i));
                }
            }
        }
        map = objLockList;
        synchronized (map) {
            if (sessionID != null && objLockList != null) {
                iter = objLockList.entrySet().iterator();
                key = null;
                value = null;
                entry = null;
                keys = new Vector();
                while (iter.hasNext()) {
                    entry = iter.next();
                    key = (String)entry.getKey();
                    value = (ObjectUpdateLock)entry.getValue();
                    boolean shouldRemove = releaseAll || ((ObjectUpdateLock)value).isReleaseWhenClearSession();
                    if (!shouldRemove || !StringUtils.equals((String)((ObjectUpdateLock)value).getContextID(), (String)sessionID)) continue;
                    keys.add(key);
                }
                for (i = 0; i < keys.size(); ++i) {
                    objLockList.remove((String)keys.get(i));
                }
            }
        }
    }

    public boolean requestObjIDForUpdate(Context ctx, DataLockParameter dataLockParameter, IJudgement iJudgement) {
        if (dataLockParameter.getCtx() == null) {
            dataLockParameter.setCtx(ctx);
        }
        ObjectUpdateLock exist = this.innerRequestObjIDForUpdate(ctx, dataLockParameter, iJudgement == null ? new UuidJudgement() : iJudgement);
        return exist == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectUpdateLock innerRequestObjIDForUpdate(Context ctx, DataLockParameter dataLockParameter, IJudgement iJudgement) {
        if (!saveLockDescription) {
            dataLockParameter.setObjectDescription("");
        }
        String id = dataLockParameter.getId();
        boolean isBatchRequst = dataLockParameter.isBatchRequest();
        String key = id + ctx.getAIS();
        logger.warn((Object)("========== requestObjIDForUpdate: " + key));
        Map map = objLockList;
        synchronized (map) {
            if (objLockList.containsKey(key)) {
                ObjectUpdateLock lock = (ObjectUpdateLock)objLockList.get(key);
                boolean isSameClient = iJudgement.isSameClinet(dataLockParameter, lock);
                if (!isSameClient) {
                    logger.info((Object)String.format("Lock is already obtained by other clients: dataLockParameter.contextId=%s, dataLockParameter.userName=%s, client.id=%s, client.userName=%s", dataLockParameter.getContextID(), dataLockParameter.getUserId(), lock.getContextID(), lock.getUserName()));
                }
                if (isSameClient) {
                    return null;
                }
                logger.info((Object)String.format("Lock is already obtained by other clients: dataLockParameter.contextId=%s, dataLockParameter.userName=%s, client.id=%s, client.userName=%s", dataLockParameter.getContextID(), dataLockParameter.getUserId(), lock.getContextID(), lock.getUserName()));
                return lock;
            }
            ObjectUpdateLock objLock = new ObjectUpdateLock(dataLockParameter);
            if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
                objLock.setOrgUnitID(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            }
            objLockList.put(key, objLock);
        }
        return null;
    }
}

