/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;

public class OrgRangeHelper {
    public static void saveOrgRangeIncludeSubOrgToBoth(Context ctx, OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrg) throws BOSException, EASBizException {
        IOrgRange iOrgRange = null;
        IOrgRangeIncludeSubOrg iOrgRangeIncludeSubOrg = null;
        if (ctx == null) {
            iOrgRange = OrgRangeFactory.getRemoteInstance();
            iOrgRangeIncludeSubOrg = OrgRangeIncludeSubOrgFactory.getRemoteInstance();
        } else {
            iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
            iOrgRangeIncludeSubOrg = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        }
        OrgRangeInfo orgRange = OrgRangeHelper.orgRangeCast(orgRangeIncludeSubOrg);
        FilterInfo orgRangeFilter = new FilterInfo();
        orgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)orgRange.getUser().getId()));
        orgRangeFilter.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgRange.getOrg().getId()));
        orgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)orgRange.getType().getValue()));
        if (!iOrgRange.exists(orgRangeFilter)) {
            iOrgRange.addnew(orgRange);
        }
        FilterInfo orgRangeIncludeFilter = new FilterInfo();
        orgRangeIncludeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)orgRangeIncludeSubOrg.getUser().getId()));
        orgRangeIncludeFilter.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgRangeIncludeSubOrg.getOrg().getId()));
        orgRangeIncludeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)orgRangeIncludeSubOrg.getType().getValue()));
        orgRangeIncludeFilter.getFilterItems().add(new FilterItemInfo("isIncludeSubOrg", (Object)orgRangeIncludeSubOrg.isIsIncludeSubOrg()));
        if (!iOrgRangeIncludeSubOrg.exists(orgRangeIncludeFilter)) {
            iOrgRangeIncludeSubOrg.addnew(orgRangeIncludeSubOrg);
        }
    }

    public static OrgRangeInfo orgRangeCast(OrgRangeIncludeSubOrgInfo orgRange) {
        OrgRangeInfo oInfo = new OrgRangeInfo();
        oInfo.setOrg(orgRange.getOrg());
        oInfo.setUser(orgRange.getUser());
        oInfo.setType(orgRange.getType());
        return oInfo;
    }

    public static AdminOrgUnitCollection getAllAdminOrgUnit(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        IPerson iPerson = null;
        IAdminOrgUnit adminOrgUnit = null;
        if (ctx == null) {
            iPerson = PersonFactory.getRemoteInstance();
            adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
        } else {
            iPerson = PersonFactory.getLocalInstance((Context)ctx);
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        PositionCollection positionCol = iPerson.getPositions(personId);
        if (positionCol == null || positionCol.isEmpty()) {
            return adminCol;
        }
        for (int i = 0; i < positionCol.size(); ++i) {
            PositionInfo positionInfo = positionCol.get(i);
            if (positionInfo.isIsRespPosition()) {
                AdminOrgUnitInfo adminInfo = positionInfo.getAdminOrgUnit();
                adminCol.addCollection(OrgRangeHelper.getSubAdminOrg(ctx, adminInfo));
                continue;
            }
            AdminOrgUnitInfo info = positionInfo.getAdminOrgUnit();
            if (info == null) continue;
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(info.getId().toString()));
            adminCol.add(adminOrgUnitInfo);
        }
        return adminCol;
    }

    private static AdminOrgUnitCollection getSubAdminOrg(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        if (adminInfo == null) {
            return new AdminOrgUnitCollection();
        }
        IAdminOrgUnit iAdminOrgUnit = null;
        iAdminOrgUnit = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)adminInfo.getDisplayName())) {
            adminInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminInfo.getId().toString()));
        }
        String oql = "select id where displayName like '" + adminInfo.getDisplayName() + "%' order by displayName";
        return iAdminOrgUnit.getAdminOrgUnitCollection(oql);
    }

    public static String getOrgRangeFilterSql(String userId, OrgRangeType type) {
        return "(select FOrgId from t_pm_orgrange where fuserid='" + userId + "' and ftype=" + type.getValue() + ")";
    }

    public static void updateAdminOrgRange(Context ctx, String userId) throws BOSException {
        String findSubOrg = "select admin1.flongnumber longnumber from T_PM_OrgRangeIncludeSubOrg subOrg inner join t_org_admin admin1 on subOrg.forgid = admin1.fid where subOrg.ftype=20 and subOrg.FISINCLUDESUBORG =1 and fuserid= ? order by longnumber asc";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)findSubOrg, (Object[])new Object[]{userId});
        TreeSet<String> longNumberSet = new TreeSet<String>();
        try {
            while (rowset.next()) {
                String longnumber = rowset.getString("longnumber");
                if (OrgRangeHelper.hasLongNumberOrParentInMap(longNumberSet, longnumber = longnumber + "!")) continue;
                longNumberSet.add(longnumber);
                String sql = "delete from T_PM_OrgRangeIncludeSubOrg orgRange1 where exists(select 1 from T_PM_OrgRangeIncludeSubOrg orgRange inner join t_org_admin a on a.fid=orgRange.forgid where  orgRange1.fid=orgRange.fid and orgRange.ftype=?  and a.flongnumber like ? and orgRange.fuserid= ?)  and fuserid =?  and ftype =?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{20, longnumber + "%", userId, userId, 20});
                String insertOrgRangeSql = "insert into t_pm_orgrange(fid,ftype,fuserid,forgid) select newbosid('FD3DC16D'),?,?,fid from t_org_admin a where flongnumber like ? and not exists(select 1 from t_pm_orgRange o where o.forgid = a.fid and o.fuserid = ? and o.ftype=?)";
                DbUtil.execute((Context)ctx, (String)insertOrgRangeSql, (Object[])new Object[]{20, userId, longnumber + "%", userId, 20});
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            throw new BOSException((Throwable)throwables);
        }
    }

    private static boolean hasLongNumberOrParentInMap(Set<String> longNumberSet, String longnumber) {
        for (String hisLongNumber : longNumberSet) {
            if (!longnumber.startsWith(hisLongNumber)) continue;
            return true;
        }
        return false;
    }
}

