/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermDebugParam;
import com.kingdee.eas.base.permission.PermDebugResult;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.ThreadLocalCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermDebugHelper {
    private static final String PERM_DEBUG = "perm_debug";
    private static final String IS_DEBUG = "is_debug";
    private static final String DEBUG_LOG = "debug_log";
    private static final Logger logger = Logger.getLogger(PermDebugHelper.class);

    public static String getPermLog() {
        String debug_log = "";
        Map permLogMap = ThreadLocalCache.getRegion((String)PERM_DEBUG);
        if (permLogMap != null && !permLogMap.isEmpty()) {
            debug_log = (String)permLogMap.get(DEBUG_LOG);
        }
        return StringUtils.cnulls((String)debug_log);
    }

    public static void putPermLog(String permLog) {
        if (!PermDebugHelper.isDebug()) {
            return;
        }
        Map logInfoMap = ThreadLocalCache.getRegion((String)PERM_DEBUG);
        String existPermLog = PermDebugHelper.getPermLog();
        StringBuffer joinLog = new StringBuffer().append(existPermLog).append("\n\n").append(permLog);
        logInfoMap.put(DEBUG_LOG, joinLog.toString());
    }

    public static void remove() {
        ThreadLocalCache.detroyRegion((String)PERM_DEBUG);
    }

    public static boolean isDebug() {
        Map logInfoMap = ThreadLocalCache.getRegion((String)PERM_DEBUG);
        if (logInfoMap != null && !logInfoMap.isEmpty() && logInfoMap.containsKey(IS_DEBUG)) {
            return Boolean.valueOf((String)logInfoMap.get(IS_DEBUG));
        }
        return false;
    }

    public static void setDebug() {
        HashMap<String, String> logInfoMap = ThreadLocalCache.getRegion((String)PERM_DEBUG);
        if (logInfoMap == null) {
            logInfoMap = new HashMap<String, String>();
        }
        logInfoMap.put(IS_DEBUG, "true");
    }

    public static void logInfo(String log) {
    }

    public static PermDebugResult getPermDebugResult(Context ctx, PermDebugParam param) throws BOSException, EASBizException {
        PermDebugHelper.setDebug();
        PermDebugResult result = new PermDebugResult();
        ObjectStringPK userPK = new ObjectStringPK(param.getUserPK());
        ObjectStringPK orgPK = null;
        if (param.getOrgPK() != null) {
            orgPK = new ObjectStringPK(param.getOrgPK());
        }
        if ("function_permission".equals(param.getDebugPermType())) {
            FunctionPermissionService functionPermissionService = new FunctionPermissionService(ctx);
            String permItemName = param.getPermItemName();
            boolean hasPerm = functionPermissionService.hasPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName, true);
            String log = PermDebugHelper.getPermLog();
            result.setLog("has permission:" + hasPerm + "\n" + log);
            return result;
        }
        if ("data_permission".equals(param.getDebugPermType())) {
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance(ctx);
            boolean isEnableDataperm = provider.isEnableDataPermission();
            DataPermissionService dataPermissionService = new DataPermissionService(ctx);
            String permItemName = param.getPermItemName();
            String rule = dataPermissionService.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
            String log = PermDebugHelper.getPermLog();
            StringBuffer logResult = new StringBuffer().append("param isEnableDataPermssion value:").append(isEnableDataperm).append("\n").append("rule is:").append(rule).append("\n").append("log is:").append(log);
            result.setLog(logResult.toString());
        } else if ("field_permission".equals(param.getDebugPermType())) {
            if (!StringUtils.isEmpty((String)param.getQuery())) {
                result = PermDebugHelper.getQueryFieldPermissionLog(ctx, (IObjectPK)userPK, (IObjectPK)orgPK, param.getQuery());
            } else if (!StringUtils.isEmpty((String)param.getEntity())) {
                result = PermDebugHelper.getEntityFieldPermissionLog(ctx, (IObjectPK)userPK, (IObjectPK)orgPK, param.getEntity());
            }
        } else if ("queryForPermitem".equals(param.getDebugPermType()) || "UIForPermitem".equals(param.getDebugPermType()) || "entityForPermitem".equals(param.getDebugPermType())) {
            result = PermDebugHelper.getPermitemByObject(ctx, param);
        }
        PermDebugHelper.remove();
        return result;
    }

    private static PermDebugResult getQueryFieldPermissionLog(Context ctx, IObjectPK userPK, IObjectPK orgPK, String query) throws BOSException, EASBizException {
        PermDebugResult result = new PermDebugResult();
        IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
        FieldPermission fieldPermission = iPermission.getQueryFieldPermission((IMetaDataPK)new MetaDataPK(query), userPK, orgPK);
        String log = PermDebugHelper.getPermLog();
        StringBuffer logResult = new StringBuffer().append("query fieldPermission result:").append(fieldPermission).append("\n\n").append("log is:").append(log);
        result.setLog(logResult.toString());
        return result;
    }

    private static PermDebugResult getEntityFieldPermissionLog(Context ctx, IObjectPK userPK, IObjectPK orgPK, String entity) throws BOSException, EASBizException {
        PermDebugResult result = new PermDebugResult();
        IPermission iPermission = PermissionFactory.getLocalInstance(ctx);
        IMetaDataLoader iMDLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityObjectInfo = iMDLoader.getEntity((IMetaDataPK)new MetaDataPK(entity));
        FieldPermission fieldPermission = iPermission.getFieldPermission(entityObjectInfo.getType(), userPK, orgPK);
        String log = PermDebugHelper.getPermLog();
        StringBuffer logResult = new StringBuffer().append("entity fieldPermission result:").append(fieldPermission).append("\n\n").append("log is:").append(log);
        result.setLog(logResult.toString());
        return result;
    }

    private static PermDebugResult getPermitemByObject(Context ctx, PermDebugParam param) throws BOSException, EASBizException {
        PermDebugResult result = new PermDebugResult();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] binds = null;
        if ("queryForPermitem".equals(param.getDebugPermType())) {
            binds = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, param.getBizObjectMetaPK());
        } else if ("UIForPermitem".equals(param.getDebugPermType())) {
            binds = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, param.getBizObjectMetaPK(), param.getBizPropertyMetaPK());
        } else if ("entityForPermitem".equals(param.getDebugPermType())) {
            binds = binder.getServiceBindings(MetaDataTypeList.ENTITY, param.getBoType(), param.getBizPropertyMetaPK());
        }
        StringBuffer permNames = new StringBuffer();
        for (int i = 0; i < binds.length; ++i) {
            if (binds[i].getType() != 0) continue;
            permNames.append(binds[i].getName()).append(",");
        }
        result.setLog(permNames.toString());
        return result;
    }
}

