/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.eas.base.permission.AbstractUserType;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserType;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UserTypeFactory {
    static HashMap typeMap = new HashMap();
    static String DEFAULT = "default";
    private static Logger logger = Logger.getLogger(UserTypeFactory.class);

    public static AbstractUserType getUserType(UserType type) throws UserException {
        String className = typeMap.get((Object)type).toString();
        AbstractUserType userType = null;
        try {
            userType = (AbstractUserType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserException(UserException.USER_TYPE_NOT_EXIST, e);
        }
        return userType;
    }

    public static AbstractUserType getDefaultUserType() {
        String className = typeMap.get(DEFAULT).toString();
        AbstractUserType userType = null;
        try {
            userType = (AbstractUserType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return userType;
    }

    static {
        typeMap.put(UserType.CUSTOMER, "com.kingdee.eas.basedata.master.cssp.CustomerUserType");
        typeMap.put(UserType.SUPPLIER, "com.kingdee.eas.basedata.master.cssp.SupplierUserType");
        typeMap.put(UserType.PERSON, "com.kingdee.eas.basedata.person.PersonUserType");
        typeMap.put(DEFAULT, "com.kingdee.eas.base.permission.DefaultUserType");
    }
}

