/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.app.AbstractAdminOrgUnitUserFacadeControllerBean;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class AdminOrgUnitUserFacadeControllerBean
extends AbstractAdminOrgUnitUserFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AdminOrgUnitUserFacadeControllerBean");

    @Override
    protected String _getUserByAdminOrg(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String orgId = (String)solutionMap.get("orgId");
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String sorter = (String)solutionMap.get("sorter");
        String sorterType = (String)solutionMap.get("sorterType");
        String user = (String)solutionMap.get("user");
        Object returnSQL = solutionMap.get("returnSQL");
        IQueryExecutor queryExcu = this.getQueryExecutor(ctx, orgId, sorter, sorterType, user);
        if (returnSQL != null && Boolean.valueOf(returnSQL.toString()).booleanValue()) {
            return queryExcu.getSQL();
        }
        IRowSet rowSet = queryExcu.executeQuery(Integer.parseInt(startIndex), Integer.parseInt(rowCount));
        int totalCount = queryExcu.getRowCount();
        ArrayList userList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("personId", rowSet.getString("person.id"));
                map.put("adminOrgUnitId", rowSet.getString("adminOrgUnit.id"));
                map.put("adminOrgUnitName", rowSet.getString("adminOrgUnit.name"));
                map.put("type", rowSet.getInt("type"));
                map.put("email", rowSet.getString("person.email"));
                userList.add(map);
            }
            logger.error((Object)("******_getUserByAdminOrg******userList.size=" + userList.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", userList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    IQueryExecutor getQueryExecutor(Context ctx, String orgId, String sorter, String sorterType, String user) {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.AdminOrgUnitUserQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(this.buildViewInfo(ctx, orgId, sorter, sorterType, user));
        return queryExcu;
    }

    EntityViewInfo buildViewInfo(Context ctx, String currentOrgId, String sorter, String sorterType, String user) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sic = new SorterItemCollection();
        viewInfo.setSorter(sic);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SelectorItemInfo name = new SelectorItemInfo("name");
        viewInfo.getSelector().add(name);
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("type"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.email"));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)currentOrgId));
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrgId));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        boolean isAdmin = false;
        if (adminOrgUnitInfo != null) {
            String longNumber = adminOrgUnitInfo.getLongNumber();
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            isAdmin = true;
        }
        if (!StringUtils.isEmpty((String)user)) {
            user = user.toLowerCase();
            String filterStr = "lower(number) like '%" + user + "%' or lower(name) like '%" + user + "%' or lower(adminOrgUnit.name) like '%" + user + "%'";
            try {
                FilterInfo userFilterInfo = new FilterInfo(filterStr);
                viewInfo.getFilter().mergeFilter(userFilterInfo, "AND");
            }
            catch (ParserException e) {
                logger.error((Object)("********filterStr********" + filterStr));
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (isAdmin) {
                filter.setMaskString("(#0 or #1) and (#2 or #3 or #4)");
            } else {
                filter.setMaskString("#0 and (#1 or #2 or #3)");
            }
        } else if (isAdmin) {
            filter.setMaskString("(#0 or #1)");
        }
        SorterItemInfo sorterInfo = new SorterItemInfo(sorter);
        sorterInfo.setSortType("desc".equalsIgnoreCase(sorterType) ? SortType.DESCEND : SortType.ASCEND);
        sic.getSorter().add(sorterInfo);
        return viewInfo;
    }

    @Override
    protected String _getMultiUserByAdminOrg(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        return "";
    }
}

