/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AboutAuthenSchemeInfoNode;
import com.kingdee.eas.base.permission.app.AbstractAuthenSchemeRuleControllerBean;
import com.kingdee.eas.base.permission.app.PollAndCheckInfoCallable;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AuthenSchemeRuleControllerBean
extends AbstractAuthenSchemeRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenSchemeRuleControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private int MAX_RECORD_COUNT = 8000;

    @Override
    protected List _checkAndSetRule(Context ctx, String authenSchemeId, Map orgRuleMap) throws BOSException {
        List resultList = this.checkRule(ctx, authenSchemeId, orgRuleMap);
        if ("fail".equals(resultList.get(0))) {
            return resultList;
        }
        this.setRule(ctx, authenSchemeId, orgRuleMap);
        return resultList;
    }

    private void setRule(Context ctx, String authenSchemeId, Map orgRuleMap) throws BOSException {
        Connection con = null;
        Statement statement = null;
        ResultSet ruleResultSet = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer queryRuleSql = new StringBuffer();
            queryRuleSql.append("select asrule.forgid orgid, asrule.fisrule isrule ").append("from t_pm_authenschemerule as asrule ").append("where asrule.fauthenschemeid = '").append(authenSchemeId).append("'");
            ruleResultSet = statement.executeQuery(queryRuleSql.toString());
            HashSet<String> needUpdateSet = new HashSet<String>();
            HashSet needInsertSet = new HashSet();
            HashSet<String> noChangeSet = new HashSet<String>();
            Set keySet = orgRuleMap.keySet();
            needInsertSet.addAll(keySet);
            String orgId = null;
            boolean isRule = false;
            boolean changeRule = false;
            while (ruleResultSet.next()) {
                orgId = ruleResultSet.getString("orgid");
                isRule = ruleResultSet.getBoolean("isrule");
                if (!keySet.contains(orgId)) continue;
                changeRule = (Boolean)orgRuleMap.get(orgId);
                if (isRule == changeRule) {
                    noChangeSet.add(orgId);
                    continue;
                }
                needUpdateSet.add(orgId);
            }
            needInsertSet.removeAll(needUpdateSet);
            needInsertSet.removeAll(noChangeSet);
            this.insertRule(con, needInsertSet, authenSchemeId, orgRuleMap);
            this.updateRule(con, needUpdateSet, authenSchemeId, orgRuleMap);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ruleResultSet, (Statement)statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)ruleResultSet, (Statement)statement, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRule(Connection con, Set needInsertSet, String authenSchemeId, Map orgRuleMap) throws SQLException {
        PreparedStatement statement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_authenschemerule(fid, fisrule, forgid, fauthenschemeid) ").append("values(?, ?, ?, ?)");
            statement = con.prepareStatement(insertSql.toString());
            int count = 0;
            String recordId = null;
            for (Object needInsertIdObj : needInsertSet) {
                recordId = BOSUuid.create((String)"8AB4F626").toString();
                statement.setString(1, recordId);
                statement.setObject(2, orgRuleMap.get(needInsertIdObj));
                statement.setObject(3, needInsertIdObj);
                statement.setString(4, authenSchemeId);
                statement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRule(Connection con, Set needUpdateSet, String authenSchemeId, Map orgRuleMap) throws SQLException {
        PreparedStatement statement = null;
        try {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pm_authenschemerule set fisrule = ? ").append("where forgid = ? and fauthenschemeid = ? ");
            statement = con.prepareStatement(updateSql.toString());
            int count = 0;
            for (Object needUpdateIdObj : needUpdateSet) {
                statement.setObject(1, orgRuleMap.get(needUpdateIdObj));
                statement.setObject(2, needUpdateIdObj);
                statement.setString(3, authenSchemeId);
                statement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement);
    }

    private List checkRule(Context ctx, String authenSchemeId, Map orgRuleMap) throws BOSException {
        ArrayList<String> checkResult = new ArrayList<String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select asrule.fauthenschemeid authenschemeid, asrule.forgid orgid, asrule.fisrule isrule, ").append("scheme.fname_l2 schemename, ").append("org.fname_l2 orgname ").append("from t_pm_authenschemerule as asrule ").append("inner join t_pm_authenschemeperm as aspermOut on asrule.fauthenschemeid = aspermOut.fauthenschemeid ").append("inner join t_pm_authenscheme as scheme on scheme.fid = asrule.fauthenschemeid ").append("inner join t_org_baseunit as org on org.fid = asrule.forgid ").append("where aspermOut.fpermitemid in (").append("select aspermIn.fpermitemid ").append("from t_pm_authenschemeperm as aspermIn ").append("where aspermIn.fauthenschemeid = ? ").append(") ").append("and asrule.fauthenschemeid <> ?");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenSchemeId, authenSchemeId});
            Set orgKeySet = orgRuleMap.keySet();
            String orgId = null;
            Object otherAuthenSchemeId = null;
            String orgName = null;
            String otherAuthenSchemeName = null;
            boolean isRule = false;
            while (rowSet.next()) {
                orgId = rowSet.getString("orgid");
                isRule = rowSet.getBoolean("isrule");
                authenSchemeId = rowSet.getString("authenschemeid");
                orgName = rowSet.getString("orgname");
                otherAuthenSchemeName = rowSet.getString("schemename");
                if (!orgKeySet.contains(orgId) || isRule == (Boolean)orgRuleMap.get(orgId)) continue;
                checkResult.add("fail");
                checkResult.add(otherAuthenSchemeName);
                checkResult.add(orgName);
                return checkResult;
            }
            checkResult.add("success");
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return checkResult;
    }

    @Override
    protected Map _getRule(Context ctx, String authenSchemeId, Set orgIdSet) throws BOSException {
        HashMap<String, Boolean> orgRuleMap = new HashMap<String, Boolean>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select asrule.forgid orgid, asrule.fisrule isrule ").append("from t_pm_authenschemerule as asrule ").append("where asrule.fauthenschemeid = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenSchemeId});
            String orgId = null;
            boolean isRule = false;
            while (rowSet.next()) {
                orgId = rowSet.getString("orgid");
                isRule = rowSet.getBoolean("isrule");
                if (!orgIdSet.contains(orgId)) continue;
                orgRuleMap.put(orgId, isRule);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return orgRuleMap;
    }

    @Override
    protected Object[] _checkAllRuleClash(Context ctx) throws BOSException {
        Connection conn = null;
        ExecutorService threadPool = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            threadPool = Executors.newFixedThreadPool(3);
            List permissionRuleClashResult = this.checkPermissionRuleClash(conn, threadPool);
            List roleRuleClashResult = this.checkRoleRuleClash(conn, threadPool);
            Object[] objectArray = new Object[]{permissionRuleClashResult, roleRuleClashResult};
            return objectArray;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (threadPool != null) {
                threadPool.shutdown();
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List checkRoleRuleClash(Connection conn, ExecutorService threadPool) throws BOSException {
        ArrayList arrayList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList result = new ArrayList();
        PollAndCheckInfoCallable[] pollArray = null;
        try {
            void var24_32;
            StringBuffer checkSql = new StringBuffer();
            checkSql.append("select asrole.froleid roleid, org.fid orgid, scheme.fid schemeid, asrule.fisrule isrule, ").append("scheme.fname_l2 schemename, org.fname_l2 orgname, easrole.fname_l2 rolename ").append("from t_pm_authenschemerule asrule ").append("inner join t_pm_authenschemerole asrole on asrule.fauthenschemeid = asrole.fauthenschemeid ").append("inner join t_pm_authenscheme scheme on scheme.fid = asrule.fauthenschemeid ").append("left join t_org_baseunit org on org.fid = asrule.forgid ").append("left join t_pm_role easrole on easrole.fid = asrole.froleid ").append("order by roleid, orgid");
            preparedStatement = conn.prepareStatement(checkSql.toString());
            resultSet = preparedStatement.executeQuery();
            LinkedBlockingQueue<Object[]> queue = new LinkedBlockingQueue<Object[]>();
            pollArray = new PollAndCheckInfoCallable[]{new PollAndCheckInfoCallable(queue), new PollAndCheckInfoCallable(queue), new PollAndCheckInfoCallable(queue)};
            ArrayList<Future<List<Object[]>>> pollFutureList = new ArrayList<Future<List<Object[]>>>();
            for (PollAndCheckInfoCallable pollCallable : pollArray) {
                pollFutureList.add(threadPool.submit(pollCallable));
            }
            String roleId = null;
            String orgId = null;
            String schemeId = null;
            boolean isRule = false;
            String schemeName = null;
            String orgName = null;
            String roleName = null;
            String lastRoleId = null;
            String lastRoleName = null;
            ArrayList<AboutAuthenSchemeInfoNode> lastList = null;
            Object[] needCheckInfoArray = null;
            AboutAuthenSchemeInfoNode aboutAuthenSchemeInfoNode = null;
            while (resultSet.next()) {
                roleId = resultSet.getString("roleid");
                orgId = resultSet.getString("orgid");
                schemeId = resultSet.getString("schemeid");
                isRule = resultSet.getBoolean("isrule");
                schemeName = resultSet.getString("schemename");
                orgName = resultSet.getString("orgname");
                roleName = resultSet.getString("rolename");
                if (StringUtils.isEmpty((String)roleName)) continue;
                aboutAuthenSchemeInfoNode = new AboutAuthenSchemeInfoNode(null, roleId, orgId, schemeId, isRule, schemeName, orgName);
                if (lastRoleId != null && !lastRoleId.equals(roleId)) {
                    needCheckInfoArray = new Object[]{lastRoleName, lastList};
                    queue.offer(needCheckInfoArray);
                    lastList = null;
                }
                if (lastList == null) {
                    lastList = new ArrayList<AboutAuthenSchemeInfoNode>();
                }
                lastList.add(aboutAuthenSchemeInfoNode);
                lastRoleId = roleId;
                lastRoleName = roleName;
            }
            if (lastList != null && !lastList.isEmpty()) {
                needCheckInfoArray = new Object[]{lastRoleName, lastList};
                queue.offer(needCheckInfoArray);
                lastList = null;
            }
            PollAndCheckInfoCallable[] pollAndCheckInfoCallableArray = pollArray;
            int n = pollAndCheckInfoCallableArray.length;
            boolean bl = false;
            while (var24_32 < n) {
                PollAndCheckInfoCallable pollCallable = pollAndCheckInfoCallableArray[var24_32];
                pollCallable.setStop(true);
                ++var24_32;
            }
            List subResult = null;
            for (Future future : pollFutureList) {
                subResult = (List)future.get();
                if (subResult == null || subResult.isEmpty()) continue;
                result.addAll(subResult);
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
                catch (InterruptedException e2) {
                    logger.error((Object)e2);
                    throw new BOSException((Throwable)e2);
                }
                catch (ExecutionException e3) {
                    logger.error((Object)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement);
                if (pollArray != null) {
                    for (void var32_43 : pollArray) {
                        var32_43.setStop(true);
                    }
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
        if (pollArray != null) {
            for (PollAndCheckInfoCallable pollCallable : pollArray) {
                pollCallable.setStop(true);
            }
        }
        return arrayList;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List checkPermissionRuleClash(Connection conn, ExecutorService threadPool) throws BOSException {
        ArrayList arrayList;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList result = new ArrayList();
        PollAndCheckInfoCallable[] pollArray = null;
        try {
            void var24_32;
            StringBuffer checkSql = new StringBuffer();
            checkSql.append("select asperm.fpermitemid permitemid, org.fid orgid, scheme.fid schemeid, asrule.fisrule isrule, ").append("scheme.fname_l2 schemename, org.fname_l2 orgname, permitem.falias_l2 permname ").append("from t_pm_authenschemerule asrule ").append("inner join t_pm_authenschemeperm asperm on asrule.fauthenschemeid = asperm.fauthenschemeid ").append("inner join t_pm_authenscheme scheme on scheme.fid = asrule.fauthenschemeid ").append("left join t_org_baseunit org on org.fid = asrule.forgid ").append("left join t_pm_permitem permitem on permitem.fid = asperm.fpermitemid ").append("order by permitemid, orgid");
            preparedStatement = conn.prepareStatement(checkSql.toString());
            resultSet = preparedStatement.executeQuery();
            LinkedBlockingQueue<Object[]> queue = new LinkedBlockingQueue<Object[]>();
            pollArray = new PollAndCheckInfoCallable[]{new PollAndCheckInfoCallable(queue), new PollAndCheckInfoCallable(queue), new PollAndCheckInfoCallable(queue)};
            ArrayList<Future<List<Object[]>>> pollFutureList = new ArrayList<Future<List<Object[]>>>();
            for (PollAndCheckInfoCallable pollCallable : pollArray) {
                pollFutureList.add(threadPool.submit(pollCallable));
            }
            String permItemId = null;
            String orgId = null;
            String schemeId = null;
            boolean isRule = false;
            String schemeName = null;
            String orgName = null;
            String permName = null;
            String lastPermItemId = null;
            String lastPermName = null;
            ArrayList<AboutAuthenSchemeInfoNode> lastList = null;
            Object[] needCheckInfoArray = null;
            AboutAuthenSchemeInfoNode aboutAuthenSchemeInfoNode = null;
            while (resultSet.next()) {
                permItemId = resultSet.getString("permitemid");
                orgId = resultSet.getString("orgid");
                schemeId = resultSet.getString("schemeid");
                isRule = resultSet.getBoolean("isrule");
                schemeName = resultSet.getString("schemename");
                orgName = resultSet.getString("orgname");
                permName = resultSet.getString("permname");
                if (StringUtils.isEmpty((String)permName)) {
                    if (!"e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM".equals(permItemId)) continue;
                    permName = "\u65b0\u589e\u7528\u6237\u65f6\u751f\u6210\u8ba4\u8bc1\u4efb\u52a1";
                }
                aboutAuthenSchemeInfoNode = new AboutAuthenSchemeInfoNode(permItemId, null, orgId, schemeId, isRule, schemeName, orgName);
                if (lastPermItemId != null && !lastPermItemId.equals(permItemId)) {
                    needCheckInfoArray = new Object[]{lastPermName, lastList};
                    queue.offer(needCheckInfoArray);
                    lastList = null;
                }
                if (lastList == null) {
                    lastList = new ArrayList<AboutAuthenSchemeInfoNode>();
                }
                lastList.add(aboutAuthenSchemeInfoNode);
                lastPermItemId = permItemId;
                lastPermName = permName;
            }
            if (lastList != null && !lastList.isEmpty()) {
                needCheckInfoArray = new Object[]{lastPermName, lastList};
                queue.offer(needCheckInfoArray);
                lastList = null;
            }
            PollAndCheckInfoCallable[] pollAndCheckInfoCallableArray = pollArray;
            int n = pollAndCheckInfoCallableArray.length;
            boolean bl = false;
            while (var24_32 < n) {
                PollAndCheckInfoCallable pollCallable = pollAndCheckInfoCallableArray[var24_32];
                pollCallable.setStop(true);
                ++var24_32;
            }
            List subResult = null;
            for (Future future : pollFutureList) {
                subResult = (List)future.get();
                if (subResult == null || subResult.isEmpty()) continue;
                result.addAll(subResult);
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
                catch (InterruptedException e2) {
                    logger.error((Object)e2);
                    throw new BOSException((Throwable)e2);
                }
                catch (ExecutionException e3) {
                    logger.error((Object)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement);
                if (pollArray != null) {
                    for (void var32_43 : pollArray) {
                        var32_43.setStop(true);
                    }
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
        if (pollArray != null) {
            for (PollAndCheckInfoCallable pollCallable : pollArray) {
                pollCallable.setStop(true);
            }
        }
        return arrayList;
    }
}

