/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.CaOrgRangeInfo;
import com.kingdee.eas.base.permission.CaOrgRangeParam;
import com.kingdee.eas.base.permission.IDSecondAuthenNotifyUserFactory;
import com.kingdee.eas.base.permission.IDSecondAuthenNotifyUserInfo;
import com.kingdee.eas.base.permission.IDSecondAuthorizeCollection;
import com.kingdee.eas.base.permission.IDSecondAuthorizeInfo;
import com.kingdee.eas.base.permission.IIDSecondAuthenNotifyUser;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractIDSecondAuthorizeControllerBean;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeControllerBean
extends AbstractIDSecondAuthorizeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.IDSecondAuthorizeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String CACHE_PERM_ITEM = "permission.permItem";
    static final int FETCH_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveAuthorizeResult(Context ctx, IDSecondAuthorizeCollection[] results) throws BOSException, EASBizException {
        assert (results != null);
        if (this.canIgnore(results)) {
            return;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer sql = null;
            sql = new StringBuffer();
            IDSecondAuthorizeCollection allAddRPs = results[0];
            if (allAddRPs.size() > 0) {
                sql.append("INSERT INTO T_PM_IDSecondAuthorize (FID, FAuthorizeType, FPermItem ) VALUES (?, ? , ? )");
                statement = connection.prepareStatement(sql.toString());
                this.addAuthorizeBatch(statement, allAddRPs);
                statement.executeBatch();
            }
            sql = new StringBuffer();
            IDSecondAuthorizeCollection allDelRPs = results[1];
            if (allDelRPs.size() > 0) {
                sql.append("DELETE FROM T_PM_IDSecondAuthorize WHERE FPermItem = ? ");
                statement = connection.prepareStatement(sql.toString());
                this.delAuthorizeBatch(statement, allDelRPs);
                statement.executeBatch();
            }
            sql = new StringBuffer();
            IDSecondAuthorizeCollection updateRPs = results[2];
            if (updateRPs.size() > 0) {
                sql.append("UPDATE T_PM_IDSecondAuthorize SET FAuthorizeType = ? WHERE FPermItem = ? ");
                statement = connection.prepareStatement(sql.toString());
                ArrayList notifyMsgList = new ArrayList();
                this.updateAuthorizeBatch(ctx, statement, updateRPs, notifyMsgList);
                statement.executeBatch();
                this.sendNotifyMsg(ctx, notifyMsgList);
            }
            String key = CacheUtil.getCacheKey(new Object[]{"permission.secondauthorize"});
            CustomCacheService cacheService = new CustomCacheService(CACHE_PERM_ITEM);
            cacheService.remove(key);
            SQLUtils.cleanup((Statement)statement, (Connection)connection);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)connection);
        }
    }

    private void sendNotifyMsg(Context ctx, List notifyMsgList) throws EASBizException, BOSException {
        HashMap paramMap = ParamManager.getParamHashMap((Context)ctx, (String[])new String[]{"EASMsgNotifyEnable", "EmailNotifyEnable", "SMSNotifyEnable"}, null);
        boolean easMsgNotifyEnable = Boolean.valueOf((String)paramMap.get("EASMsgNotifyEnable"));
        boolean emailNotifyEnable = Boolean.valueOf((String)paramMap.get("EmailNotifyEnable"));
        boolean mobileSMSNotifyEnable = Boolean.valueOf((String)paramMap.get("SMSNotifyEnable"));
        IIDSecondAuthenNotifyUser idSecondAuthenNotifyUser = IDSecondAuthenNotifyUserFactory.getLocalInstance(ctx);
        CoreBaseCollection userColl = idSecondAuthenNotifyUser.getCollection();
        String title = EASResource.getString((String)RESOURCE, (String)"secondeAuthenNotifyTitile");
        if (easMsgNotifyEnable) {
            IBMCMessage ibmcMessage = BMCMessageFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection newColl = new CoreBaseCollection();
            for (int i = 0; i < notifyMsgList.size(); ++i) {
                BMCMessageInfo messageInfo = new BMCMessageInfo();
                messageInfo.setBizPackage(IDSecondAuthenNotifyUserInfo.class.getPackage().getName());
                messageInfo.setBizType(MsgBizType.ONLINE);
                messageInfo.setStatus(MsgStatus.UNREADED);
                messageInfo.setType(MsgType.NOTICE);
                messageInfo.setPriority(MsgPriority.HIGH);
                messageInfo.setOrgID("11111111-1111-1111-1111-111111111111CCE7AED4");
                messageInfo.setOrgType(OrgType.NONE);
                messageInfo.setSender("SYSTEM");
                messageInfo.setTitle(title);
                messageInfo.setBody((String)notifyMsgList.get(i));
                for (int ui = 0; ui < userColl.size(); ++ui) {
                    BMCMessageInfo messageInfo4user = (BMCMessageInfo)messageInfo.clone();
                    IDSecondAuthenNotifyUserInfo notifyUserInfo = (IDSecondAuthenNotifyUserInfo)userColl.get(ui);
                    if (notifyUserInfo.getUser() == null) {
                        logger.info((Object)"sendNotifyMsg receiver, notifyUserInfo.getUser() return null.");
                    }
                    logger.info((Object)("sendNotifyMsg receiver id:" + notifyUserInfo.getUser().getId().toString()));
                    messageInfo4user.setReceiver(notifyUserInfo.getUser().getId().toString());
                    newColl.add((CoreBaseInfo)messageInfo4user);
                }
            }
            ibmcMessage.addnew(newColl);
        }
        if (emailNotifyEnable || mobileSMSNotifyEnable) {
            for (int i = 0; i < notifyMsgList.size(); ++i) {
                String msgBody = (String)notifyMsgList.get(i);
                for (int ui = 0; ui < userColl.size(); ++ui) {
                    IDSecondAuthenNotifyUserInfo notifyUserInfo = (IDSecondAuthenNotifyUserInfo)userColl.get(ui);
                    IUser iUser = UserFactory.getLocalInstance(ctx);
                    UserInfo userInfo = iUser.getUserByID((IObjectPK)new ObjectUuidPK(notifyUserInfo.getUser().getId()));
                    PersonInfo personInfo = userInfo.getPerson();
                    if (personInfo == null) {
                        logger.warn((Object)("Second authentication notify warn: person is null, user id=" + notifyUserInfo.getUser().getId().toString()));
                        continue;
                    }
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId()));
                    if (emailNotifyEnable) {
                        if (!StringUtil.isEmpty((String)personInfo.getEmail())) {
                            MsgUtil.msgSend((Context)ctx, (String)title, (int)20, (boolean)false, (String)msgBody, (String)personInfo.getId().toString(), (int)2, null, null, null);
                        } else {
                            logger.warn((Object)("Second authentication notify warn: person's email is null, personId=" + personInfo.getId().toString()));
                        }
                    }
                    if (!mobileSMSNotifyEnable) continue;
                    if (!StringUtil.isEmpty((String)personInfo.getCell())) {
                        MsgUtil.msgSend((Context)ctx, (String)msgBody, (int)20, (boolean)false, (String)msgBody, (String)personInfo.getId().toString(), (int)1, null, null, null);
                        continue;
                    }
                    logger.warn((Object)("Second authentication notify warn: person's cellphone is null, personId=" + personInfo.getId().toString()));
                }
            }
        }
    }

    private void addAuthorizeBatch(PreparedStatement preparedStatement, IDSecondAuthorizeCollection collection) throws SQLException {
        BOSObjectType objectType = this.getBOSType();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IDSecondAuthorizeInfo info = collection.get(i);
            BOSUuid id = BOSUuid.create((BOSObjectType)objectType);
            preparedStatement.setString(1, id.toString());
            preparedStatement.setInt(2, 10);
            preparedStatement.setString(3, info.getPermItem().getId().toString());
            preparedStatement.addBatch();
        }
    }

    private void updateAuthorizeBatch(Context ctx, PreparedStatement preparedStatement, IDSecondAuthorizeCollection collection, List notifyMsgList) throws SQLException, BOSException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            int oldAuthorizeType;
            AuthorizeTypeEnum oldType;
            String ksql = "SELECT  top 1 s.FAuthorizeType FROM T_PM_IDSecondAuthorize s WHERE FPermItem = ? ";
            IDSecondAuthorizeInfo info = collection.get(i);
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)ksql, (Object[])new Object[]{info.getPermItem().getId().toString()});
            if (result.next() && (oldType = AuthorizeTypeEnum.getEnum(oldAuthorizeType = result.getInt("FAuthorizeType"))) != info.getAuthorizeType()) {
                String oldDescription = null;
                oldDescription = AuthorizeTypeEnum.noAuthor == oldType ? PermissionCommonUtil.getAuthorizeDiscription(oldType) : oldType.getAlias();
                String newDescription = null;
                newDescription = AuthorizeTypeEnum.noAuthor == info.getAuthorizeType() ? info.getAuthorizeType().getAlias() : PermissionCommonUtil.getAuthorizeDiscription(info.getAuthorizeType());
                String content = EASResource.getString((String)RESOURCE, (String)"secondeAuthenNotifyContent");
                content = content.replaceFirst("\\{0\\}", info.get("menuNamePath") + info.getPermItem().getAlias());
                content = content.replaceFirst("\\{1\\}", oldDescription);
                content = content.replaceFirst("\\{2\\}", newDescription);
                notifyMsgList.add(content);
            }
            preparedStatement.setInt(1, info.getAuthorizeType().getValue());
            preparedStatement.setString(2, info.getPermItem().getId().toString());
            preparedStatement.addBatch();
        }
    }

    private void delAuthorizeBatch(PreparedStatement preparedStatement, IDSecondAuthorizeCollection collection) throws SQLException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IDSecondAuthorizeInfo info = collection.get(i);
            preparedStatement.setString(1, info.getPermItem().getId().toString());
            preparedStatement.addBatch();
        }
    }

    private boolean canIgnore(IDSecondAuthorizeCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IObjectCollection _getPermItemCollection(Context ctx) throws BOSException {
        PermItemCollection perms = new PermItemCollection();
        String sql = "SELECT permItem.* FROM  T_PM_PermItem permItem,T_PM_IDSecondAuthorize secondAuthorize WHERE permItem.Fid = secondAuthorize.FPermItem";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
        try {
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                perms.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return perms;
    }

    @Override
    protected Map _getAuthorizeMap(Context ctx) throws BOSException {
        String sql = "SELECT FPermItem,FAuthorizeType FROM  T_PM_IDSecondAuthorize ";
        HashMap<String, AuthorizeTypeEnum> result = new HashMap<String, AuthorizeTypeEnum>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String permID = rowSet.getString("FPermItem");
                int authType = rowSet.getInt("FAuthorizeType");
                result.put(permID, AuthorizeTypeEnum.getEnum(authType));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected AuthorizeTypeEnum _getAuthorizeType(Context ctx, String permItemName) throws BOSException, EASBizException {
        AuthorizeTypeEnum result = AuthorizeTypeEnum.noAuthor;
        if (permItemName == null || permItemName.trim().length() == 0) {
            return result;
        }
        BOSObjectType tBOSObjectType = BOSObjectType.create((String)permItemName);
        if (MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntityObjectPK(tBOSObjectType) != null) {
            logger.error((Object)"permItem is BOSTYPE");
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT authorize.FAuthorizeType FROM  T_PM_IDSecondAuthorize authorize,T_PM_PermItem permItem ").append(" WHERE permItem.FName = ").append("'" + permItemName + "'").append(" AND authorize.FPermItem = permItem.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                result = AuthorizeTypeEnum.getEnum(rowSet.getInt("FAuthorizeType"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            result = AuthorizeTypeEnum.noAuthor;
        }
        return result;
    }

    @Override
    protected AuthorizeTypeEnum _getAuthorizeType(Context ctx, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        AuthorizeTypeEnum result = AuthorizeTypeEnum.noAuthor;
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null) {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                AuthorizeTypeEnum tmpType = this._getAuthorizeType(ctx, permItemName);
                if (!(tmpType.equals((Object)result) || tmpType.equals((Object)AuthorizeTypeEnum.noAuthor) || result.equals((Object)AuthorizeTypeEnum.noAuthor))) {
                    result = AuthorizeTypeEnum.dynAndUsb;
                    break;
                }
                result = tmpType;
            }
        }
        return result;
    }

    @Override
    protected Map _getAuthorizeMap4Web(Context ctx) throws BOSException {
        String sql = "select ca.FAuthorizeType FAuthorizeType, perm.fnumber FPermItem from T_PM_IDSecondAuthorize ca, t_pm_permitem perm where ca.fpermitem=perm.fid ";
        HashMap<String, AuthorizeTypeEnum> result = new HashMap<String, AuthorizeTypeEnum>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                String permID = rowSet.getString("FPermItem");
                int authType = rowSet.getInt("FAuthorizeType");
                result.put(permID, AuthorizeTypeEnum.getEnum(authType));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected Set _getOrgIdByPermItemId(Context ctx, String permItemID) throws BOSException {
        String sql = "select tpc.forgid from T_PM_CaOrgRange tpc where FPermItem='" + permItemID + "'";
        HashSet<String> ret = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                ret.add(rowSet.getString("FOrgId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return ret;
    }

    @Override
    protected void _saveOrgRange(Context ctx, CaOrgRangeParam caOrgRangeParam) throws BOSException, EASBizException {
        LogProxy logProxy = new LogProxy();
        Collection deletedOrgs = caOrgRangeParam.getDeletedOrgIds();
        Collection addedOrgs = caOrgRangeParam.getAddedOrgIds();
        CaOrgRangeInfo changedOrgRange = caOrgRangeParam.getChangedCaOrgRangeInfo();
        boolean isDeleteAll = caOrgRangeParam.isDeleteAll();
        IObjectPK permItemPK = caOrgRangeParam.getPermItemPK();
        OrgRangeType orgRangeType = caOrgRangeParam.getOrgRangeType();
        if (isDeleteAll) {
            this.deleteAllByPermItem(ctx, permItemPK);
        }
        if (deletedOrgs != null && deletedOrgs.size() > 0) {
            this.deleteCaOrgRanges(ctx, permItemPK, orgRangeType, deletedOrgs);
        }
        if (addedOrgs != null && addedOrgs.size() > 0) {
            if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)orgRangeType)) {
                addedOrgs = this.getNotIncludedOrgIds(ctx, permItemPK, addedOrgs);
            }
            this.saveAddOrgs(ctx, permItemPK, orgRangeType, addedOrgs);
        }
        if (changedOrgRange != null) {
            this.handleChangeIncludeSubOrg(ctx, changedOrgRange);
        }
        logProxy.end();
    }

    private void deleteAllByPermItem(Context ctx, IObjectPK permItemPK) throws BOSException, EASBizException {
        String caOrgRangeDelete = "delete from t_pm_caorgrange where fpermItem='" + permItemPK.toString() + "'";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)caOrgRangeDelete);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteAllByPermItem error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteCaOrgRanges(Context ctx, IObjectPK permItemPK, OrgRangeType orgRangeType, Collection deletedOrgs) throws BOSException, EASBizException {
        String sql = "delete from t_pm_caorgrange where fpermItem='" + permItemPK.toString() + "' and forgid in (" + ToolUtils.aryToStr(deletedOrgs) + ")";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"deleteOrgRangeIncludeSubOrgs error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private Collection getNotIncludedOrgIds(Context ctx, IObjectPK permItemPK, Collection orgIds) throws BOSException, EASBizException {
        List includeSubOrgLongNumber = this.getIncludeSubOrgAdminLongNumber(ctx, permItemPK, null);
        for (int i = 0; i < includeSubOrgLongNumber.size(); ++i) {
            Collection includedOrgIds = this.getIncludedOrgIds(ctx, includeSubOrgLongNumber.get(i).toString(), orgIds);
            orgIds.removeAll(includedOrgIds);
        }
        return orgIds;
    }

    private Collection getIncludedOrgIds(Context ctx, String longNumber, Collection orgIds) throws BOSException, EASBizException {
        ArrayList<String> includedOrgIds = new ArrayList<String>();
        if (orgIds == null || orgIds.size() < 1) {
            return includedOrgIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_admin where flongnumber like ? and fid in (");
        Iterator itr = orgIds.iterator();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(longNumber + "!%");
        while (itr.hasNext()) {
            paramList.add(itr.next().toString());
            sql.append("?");
            if (!itr.hasNext()) continue;
            sql.append(",");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                includedOrgIds.add(rs.getString("fid"));
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return includedOrgIds;
    }

    private List getIncludeSubOrgAdminLongNumber(Context ctx, IObjectPK permItemPK, Collection orgIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FLongNumber from t_pm_orgrange a join t_org_admin b ").append(" on a.forgid=b.fid where a.fpermItem=? and fisIncludeSubOrg=1");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(StringUtils.cnulls((Object)permItemPK));
        if (orgIds != null && orgIds.size() > 0) {
            sql.append("and a.forgid in (");
            Iterator itr = orgIds.iterator();
            while (itr.hasNext()) {
                paramList.add(itr.next().toString());
                sql.append("?");
                if (!itr.hasNext()) continue;
                sql.append(",");
            }
            sql.append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> ret = new ArrayList<String>();
        try {
            while (rs.next()) {
                ret.add(rs.getString("FLongNumber"));
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return ret;
    }

    private void saveAddOrgs(Context ctx, IObjectPK permItemPK, OrgRangeType orgRangeType, Collection addedOrgs) throws BOSException {
        TableManager tm = null;
        String tableName = null;
        try {
            tm = TableManager.getTableManager((Context)ctx);
            tableName = tm.getTableName("orgRangeAdd");
            String createSql = "create table " + tableName + " (fpermItem varchar(44),forgid varchar(44),ftype int)";
            tm.createTable(createSql);
            this.insertIntoTempTable(ctx, permItemPK, addedOrgs, orgRangeType, tableName);
            this.addCaOrgRangeBatch(ctx, permItemPK, orgRangeType, addedOrgs, tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tm != null && tableName != null) {
                tm.releaseTable(tableName);
            }
        }
    }

    private void insertIntoTempTable(Context ctx, IObjectPK permItemPK, Collection addedOrgs, OrgRangeType orgRangeType, String tableName) throws BOSException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement state = null;
        try {
            String insertSql = "insert into " + tableName + "( fpermItem,forgid,ftype) values(?,?,?)";
            state = conn.prepareStatement(insertSql);
            Iterator orgItr = addedOrgs.iterator();
            int i = 0;
            while (orgItr.hasNext()) {
                state.setString(1, permItemPK.toString());
                state.setString(2, orgItr.next().toString());
                state.setObject(3, orgRangeType.getValue());
                state.addBatch();
                if (i % 2000 == 0) {
                    state.executeBatch();
                }
                ++i;
            }
            state.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private void addCaOrgRangeBatch(Context ctx, IObjectPK permItemPK, OrgRangeType orgRangeType, Collection addedOrgs, String tmpTableName) throws BOSException, EASBizException {
        try {
            String bosType = new CaOrgRangeInfo().getBOSType().toString();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO T_PM_CaOrgRange (FID, FpermItem, FOrgID, FType,FIsIncludeSubOrg) ").append("select newbosid('").append(bosType).append("'),fpermItem,forgid,ftype,0 from ").append(tmpTableName).append(" tmp where not exists ").append("(select 1 from T_PM_CaOrgRange where fpermItem=tmp.fpermItem and forgid=tmp.forgid and ftype=tmp.ftype)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"addOrgRangeBatch error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void handleChangeIncludeSubOrg(Context ctx, CaOrgRangeInfo changedOrgRange) throws BOSException, EASBizException {
        this.updateIsIncludeSubOrg(ctx, changedOrgRange);
        ObjectUuidPK permItemPK = new ObjectUuidPK(changedOrgRange.getPermitem().getId());
        if (changedOrgRange.isIsIncludeSubOrg()) {
            this.deleteSubOrgFromOrgRange(ctx, (IObjectPK)permItemPK, changedOrgRange.getOrg().getLongNumber());
            this.addSubOrgToOrgRange(ctx, changedOrgRange);
        } else {
            this.deleteSubOrgFromOrgRange(ctx, (IObjectPK)permItemPK, changedOrgRange.getOrg().getLongNumber());
        }
    }

    private void updateIsIncludeSubOrg(Context ctx, CaOrgRangeInfo changedOrgRange) throws BOSException, EASBizException {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("isIncludeSubOrg"));
        this.innerUpdatePartial(ctx, (IObjectValue)changedOrgRange, selectorCol);
    }

    private void deleteSubOrgFromOrgRange(Context ctx, IObjectPK permItemPK, String longNumber) throws BOSException, EASBizException {
        String sql = "delete from t_pm_caorgrange where fpermItem=? and FType = 20 and forgid in (select fid from t_org_admin where FLongNumber like ? )";
        Object[] params = new Object[]{permItemPK.toString(), longNumber + "!%"};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void addSubOrgToOrgRange(Context ctx, CaOrgRangeInfo changedOrgRange) throws BOSException, EASBizException {
        String insertSql = "insert into t_pm_caorgrange(fid,FPermItem,forgid,ftype,FIsIncludeSubOrg) select newbosid('413196EB'),'" + changedOrgRange.getPermitem().getId().toString() + "',fid from t_org_admin where flongnumber like '" + changedOrgRange.getOrg().getLongNumber() + "!%'" + changedOrgRange.getType().getValue() + "FIsIncludeSubOrg='" + changedOrgRange.isIsIncludeSubOrg() + "'";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)insertSql);
        }
        catch (SQLException e) {
            logger.error((Object)"addSubOrgToOrgRange error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected Set _getCaOrgRangeByPermItemName(Context ctx, String permItemName) throws BOSException {
        HashSet<String> ret = new HashSet<String>();
        if (permItemName == null || permItemName.trim().length() == 0) {
            return ret;
        }
        StringBuffer sql = new StringBuffer("SELECT caorgrange.forgid FROM T_PM_PERMITEM permitem ,T_PM_CaOrgRange caorgrange ").append("WHERE permitem.fname = '").append(permItemName).append("' AND permitem.fid = caorgrange.fpermitem");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                ret.add(rowSet.getString("FOrgId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return ret;
    }

    @Override
    protected Set _getCaOrgRangeByActionPK(Context ctx, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException {
        Set ret = new HashSet();
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK);
        if (bind != null && bind[0].getType() == 0 && !StringUtils.isEmpty((String)bind[0].getName())) {
            String permItemName = bind[0].getName();
            ret = this._getCaOrgRangeByPermItemName(ctx, permItemName);
        }
        return ret;
    }

    @Override
    protected Set _getCaOrgRangeByBosType(Context ctx, String bosType) throws BOSException {
        HashSet<String> ret = new HashSet<String>();
        if (bosType == null || bosType.trim().length() == 0) {
            return ret;
        }
        StringBuffer sql = new StringBuffer("SELECT DISTINCT caorgrange.forgid FROM T_PM_PERMITEM permitem ,T_PM_CaOrgRange caorgrange,T_PM_IDSecondAuthorize idsecondAuthorize ").append("WHERE permitem.fobjectType = '").append(bosType).append("' AND permitem.fid = caorgrange.fpermitem AND permitem.fid = idsecondAuthorize.FPermItem AND idsecondAuthorize.Fauthorizetype like '2_'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                ret.add(rowSet.getString("FOrgId"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return ret;
    }

    @Override
    protected Collection _getOrgControlUnit(Context ctx, Collection orgCol) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String orgColl = ToolUtils.aryToStr(orgCol);
        sql.append("select fcontrolunitid from t_org_baseunit where fid in (").append(orgColl).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> numberList = new ArrayList<String>();
        try {
            while (rs.next()) {
                numberList.add(rs.getString("fcontrolunitid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return numberList;
    }

    @Override
    protected boolean _getCaOrgRangeCheck(Context ctx, String id, String permItem) throws BOSException {
        logger.info((Object)("CaOrgRangeCheck-permItem:" + permItem + ",id:" + id));
        BOSObjectType bosTypeCurrent = BOSUuid.read((String)id).getType();
        String table = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosTypeCurrent).getTable().getName();
        String sqlforid = "select top 1 tfs.FCOMPANYID from " + table + " tfs where tfs.fid=? ORDER BY tfs.FCreateTime desc";
        IRowSet resultforid = DbUtil.executeQuery((Context)ctx, (String)sqlforid, (Object[])new Object[]{id.toString()});
        if (resultforid.size() < 1) {
            logger.error((Object)"CasPaymentBill id is null");
            throw new BOSException("CasPaymentBill id is null");
        }
        String companyId = null;
        try {
            if (resultforid.next()) {
                companyId = resultforid.getString("FCOMPANYID");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)("checkOrg get FCOMPANYID error:" + e1.getMessage()));
            throw new BOSException("CasPaymentBill id is null");
        }
        logger.info((Object)("CasPaymentBill id:" + companyId));
        Set set = this._getCaOrgRangeByPermItemName(ctx, permItem);
        logger.info((Object)("CaOrgRangeCheck-companyId:" + set.toString()));
        if (set.isEmpty()) {
            return true;
        }
        return set.contains(companyId);
    }

    @Override
    protected IObjectCollection _getPermItemTreeCollection(Context ctx) throws BOSException {
        PermItemCollection perms = new PermItemCollection();
        String sql = "SELECT permItem.* FROM  T_PM_PermItem permItem,T_PM_IDSecondAuthorize secondAuthorize WHERE permItem.Fid = secondAuthorize.FPermItem";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> parentIds = new HashSet<String>();
        try {
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(MultiLangHelper.getFieldName("FAlias", ctx.getLocale())));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    parentIds.add(parentID);
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                perms.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (!parentIds.isEmpty()) {
            perms.clear();
            this.fetchParent(ctx, parentIds, perms);
        }
        ArrayList newItems = new ArrayList();
        newItems.addAll(Arrays.asList((Object[])perms.toArray()));
        Collections.sort(newItems, (Comparator)new Comparator<PermItemInfo>(){

            @Override
            public int compare(PermItemInfo o1, PermItemInfo o2) {
                return o1.getLongNumber().toString().compareTo(o2.getLongNumber().toString());
            }
        });
        perms.clear();
        for (int i = 0; i < newItems.size(); ++i) {
            perms.add((PermItemInfo)newItems.get(i));
        }
        return perms;
    }

    private void fetchParent(Context ctx, Set<String> parentIds, PermItemCollection permItems) {
        try {
            if (parentIds.size() > 1024) {
                ArrayList<String> limitedParents = new ArrayList<String>(parentIds);
                int extra = limitedParents.size() % 1024;
                int round = 0;
                round = extra == 0 ? limitedParents.size() / 1024 : limitedParents.size() / 1024 + 1;
                for (int roundIndex = 0; roundIndex < round; ++roundIndex) {
                    parentIds.clear();
                    int fetchSize = 1024;
                    if (roundIndex == round - 1) {
                        fetchSize = limitedParents.size() - 1024 * roundIndex;
                    }
                    for (int i = 0; i < fetchSize; ++i) {
                        parentIds.add((String)limitedParents.get(i + 1024 * roundIndex));
                    }
                    this.fetchParent(ctx, parentIds, permItems);
                }
                return;
            }
            Object params = null;
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuilder sql = new StringBuilder(300);
            sql.append("SELECT FID, FNAME," + aliasField + ", FLongNumber, FOrgRelation, FObjectType, FIsApplyToF7, FIsLeaf, FParentID \n");
            sql.append("FROM T_PM_PermItem\n");
            sql.append("WHERE FISLEAF = 0 AND ( FTYPE = ? OR FTYPE = ? ) AND FID IN (" + IDSecondAuthorizeControllerBean.questMarkerPlaceHolder(parentIds.size()) + ") \n");
            sql.append("ORDER BY FLONGNUMBER ASC\n");
            LinkedList<Object> newParams = new LinkedList<Object>();
            newParams.addAll(parentIds);
            newParams.add(0, 30);
            newParams.add(1, 20);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])newParams.toArray());
            parentIds.clear();
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    parentIds.add(parentID);
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                permItems.add(info);
            }
            if (!parentIds.isEmpty()) {
                this.fetchParent(ctx, parentIds, permItems);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static String questMarkerPlaceHolder(int size) {
        StringBuilder holders = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            holders.append("?,");
        }
        return holders.toString().substring(0, holders.length() - 1);
    }
}

