/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractPermItemControllerBean;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.helper.SynchUserHelper;
import com.kingdee.eas.base.permission.app.util.FilterHelper;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.cluster.FileClusterFactory;
import com.kingdee.eas.common.app.cluster.IFileCluster;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermItemControllerBean
extends AbstractPermItemControllerBean {
    private static Logger logger = Logger.getLogger(PermItemControllerBean.class);
    private static final String CONFIG_PATH = UserCustomSubSystem.SUBSYSTEM_EAS_PATH + File.separator + "easconfig";
    private static final String ORG_RELATION = "orgRelation";
    private static final String ENABLE_DATA_PERMISSION = "enableDataPermission";
    private static final String ORG_TYPE = "OrgType";
    private static final String PERM_ITEM_TYPE = "permItemType";

    @Override
    protected IObjectCollection _getBranches(Context ctx) throws BOSException, EASBizException {
        PermItemCollection permItems = (PermItemCollection)this.getPermItems(ctx, false);
        if (permItems.size() == 0) {
            throw new PermItemException(PermItemException.ITEMS_NOT_EXIST);
        }
        return permItems;
    }

    @Override
    protected IObjectCollection _getAllLeaves(Context ctx) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentUserInfo((Context)ctx).isBizAdmin()) {
            return this.getPermItems4BizAdmin(ctx, true);
        }
        return this.getPermItems(ctx, true);
    }

    @Override
    protected IObjectCollection _getLeaves(Context ctx, IObjectPK orgPK) throws BOSException, EASBizException {
        PermItemCollection result = new PermItemCollection();
        try {
            StringBuffer sql = new StringBuffer(300);
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            String orgRelationFilter = FilterHelper.getOrgRelationFilter(ctx, orgPK, "FOrgRelation");
            sql.append("SELECT FID, FName, ").append(aliasField).append(", ").append(" FLongNumber, FOrgRelation, FObjectType, FIsApplyToF7, FIsLeaf, FParentID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND ( FType = ").append(20).append(" OR FType = ").append(30).append(" ) ");
            sql.append(orgRelationFilter);
            sql.append(" ORDER BY FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    private IObjectCollection getPermItems4BizAdmin(Context ctx, boolean isLeaf) throws BOSException, EASBizException {
        PermItemCollection result = new PermItemCollection();
        try {
            Object[] params = null;
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer(300);
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userid = currentUserInfo.getId().toString();
            sql.append(" SELECT pm.FID, pm." + aliasField + ", pm.FName, pm.FLongNumber, pm.FOrgRelation, pm.FObjectType,").append(" pm.FIsApplyToF7, pm.FIsLeaf, pm.FParentID FROM T_PM_PermItem pm").append(" where  pm.FIsLeaf=?  and ").append(" exists  ( ").append(" SELECT 1 from T_PM_USERORGPERM uop  where uop.fpermitemid=pm.fid and uop.fowner=? and uop.fpermtype= ?").append(" union all ").append(" SELECT 1 FROM T_PM_ROLEPERM rop inner join T_PM_UserRoleOrg uro on uro.froleid=rop.froleid").append(" where rop.fpermitemid=pm.fid  and uro.fuserid=? and rop.fpermtype=? )");
            params = new Object[]{new Integer(isLeaf ? 1 : 0), userid, 30, userid, 30};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    private IObjectCollection getCurrentPermissionItems4Customization(Context ctx) throws BOSException, EASBizException {
        PermissionItemCollection result = new PermissionItemCollection();
        try {
            StringBuffer sql = new StringBuffer(300);
            sql.append("SELECT FID, FName, ");
            sql.append(" FAlias_l1,FAlias_l2,FAlias_l3, ");
            sql.append(" FLongNumber, FOrgRelation,FType, FObjectType, FIsApplyToF7, FIsLeaf, FOperationType,FDescription_l1,FDescription_l2,FDescription_l3,FParentID FROM T_PM_PermItem ");
            sql.append(" where fisleaf=1 ");
            sql.append(" ORDER BY FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                PermissionItemInfo info = new PermissionItemInfo();
                info.setInnerID(rowSet.getString("FID"));
                info.setName(rowSet.getString("FName"));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString("FAlias_l1"), Locale.ENGLISH);
                info.setAlias(rowSet.getString("FAlias_l2"), Locale.SIMPLIFIED_CHINESE);
                info.setAlias(rowSet.getString("FAlias_l3"), Locale.TRADITIONAL_CHINESE);
                String longNumber = rowSet.getString("FLongNumber");
                longNumber = longNumber.replace('!', '.').replaceAll("\\d{6}", "");
                info.setGroup(longNumber.substring(0, longNumber.lastIndexOf(46)));
                EntityObjectRefInfo eom = new EntityObjectRefInfo();
                eom.setEnitityType(rowSet.getString("FObjectType"));
                info.setEntityObjectMetadataRef(eom);
                info.setDescription(rowSet.getString("FDescription_l1"), Locale.ENGLISH);
                info.setDescription(rowSet.getString("FDescription_l2"), Locale.ENGLISH);
                info.setDescription(rowSet.getString("FDescription_l3"), Locale.ENGLISH);
                info.setExtendedProperty(PERM_ITEM_TYPE, rowSet.getString("FType"));
                info.setExtendedProperty(ORG_RELATION, OrgType.getEnum((int)rowSet.getInt("FOrgRelation")).getName());
                info.setExtendedProperty(ENABLE_DATA_PERMISSION, String.valueOf(rowSet.getInt("FIsApplyToF7") == 1));
                info.setType(rowSet.getString("FOperationType"));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    private IObjectCollection getPermItems(Context ctx, boolean isLeaf) throws BOSException, EASBizException {
        PermItemCollection result = new PermItemCollection();
        try {
            Object[] params = null;
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer(300);
            sql.append("SELECT FID, FName, ").append(aliasField).append(", ").append(" FLongNumber, FOrgRelation, FObjectType, FIsApplyToF7, FIsLeaf, FParentID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = ? ").append(" AND ( FType = ").append(20).append(" OR FType = ").append(30).append(" ) ").append(" ORDER BY FLongNumber ASC");
            params = new Object[]{new Integer(isLeaf ? 1 : 0)};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                info.setObjectType(rowSet.getString("FObjectType"));
                info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    @Override
    protected void _syncPermItems(Context ctx) throws BOSException, EASBizException {
        SynchUserHelper synchUserHelper = null;
        try {
            synchUserHelper = new SynchUserHelper(ctx);
            synchUserHelper.syncPermItems();
        }
        finally {
            if (synchUserHelper != null) {
                synchUserHelper.release();
            }
        }
    }

    @Override
    protected boolean _hasIncorrectPermItems(Context ctx) throws BOSException, EASBizException {
        return StringUtils.isEmpty((String)this._getPermItemError(ctx));
    }

    @Override
    protected PermissionItemInfo _getPermissionItemInfo(Context ctx, String permItemName) throws BOSException {
        if (StringUtils.isEmpty((String)permItemName)) {
            return null;
        }
        String sqlStr = "select *  where name ='" + permItemName + "'";
        PermItemCollection permItemCol = this.getPermItemCollection(ctx, sqlStr);
        if (permItemCol == null || permItemCol.isEmpty()) {
            return null;
        }
        PermissionItemInfo permissioinItemInfo = new PermissionItemInfo();
        permissioinItemInfo.setName(permItemCol.get(0).getName());
        permissioinItemInfo.setAlias(permItemCol.get(0).getAlias());
        return permissioinItemInfo;
    }

    @Override
    protected Map _getDepPermItems(Context ctx, IObjectPK[] permItemPKs) throws BOSException, EASBizException {
        assert (permItemPKs != null && permItemPKs.length > 0);
        HashMap<String, PermItemCollection> dependencyPemItems = new HashMap<String, PermItemCollection>();
        int length = permItemPKs.length;
        if (length > 0) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" SELECT PermDependency.FID, PermDependency.FDependencyID, PermItem.FOrgRelation, PermItem.FType FROM T_PM_PermDependency PermDependency ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = PermDependency.FDependencyID ");
            buffer.append(" WHERE PermDependency.FID IN (");
            for (int i = 0; i < length; ++i) {
                if (i == length - 1) {
                    buffer.append(" '").append(permItemPKs[i].toString()).append("' ) ");
                    continue;
                }
                buffer.append(" '").append(permItemPKs[i].toString()).append("' , ");
            }
            buffer.append(" ORDER BY PermDependency.FID ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                while (rowSet.next()) {
                    PermItemCollection permItems;
                    PermItemInfo permItemInfo = new PermItemInfo();
                    String ID = rowSet.getString("FID");
                    String dependencyID = rowSet.getString("FDependencyID");
                    int orgRelateion = rowSet.getInt("FOrgRelation");
                    PermItemType permItemType = PermItemType.getEnum(rowSet.getInt("FType"));
                    if (permItemType.equals((Object)PermItemType.SYSTEM_ADMIN_FUNCTION) || permItemType.equals((Object)PermItemType.BIZ_ADMIN_FUNCTION)) continue;
                    permItemInfo.setId(BOSUuid.read((String)dependencyID));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)orgRelateion));
                    permItemInfo.setType(permItemType);
                    if (dependencyPemItems.containsKey(ID)) {
                        permItems = (PermItemCollection)((Object)dependencyPemItems.get(ID));
                        permItems.add(permItemInfo);
                        continue;
                    }
                    permItems = new PermItemCollection();
                    permItems.add(permItemInfo);
                    dependencyPemItems.put(ID, permItems);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new EASBizException(PermItemException.GET_PERMITEM_FAIL, (Throwable)e);
            }
        }
        return dependencyPemItems;
    }

    @Override
    protected Map _getBeenDepPermItems(Context ctx, IObjectPK[] permItemPKs) throws BOSException, EASBizException {
        assert (permItemPKs != null && permItemPKs.length > 0);
        HashMap<String, PermItemCollection> beenDependencyPemItems = new HashMap<String, PermItemCollection>();
        int length = permItemPKs.length;
        if (length > 0) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" SELECT PermDependency.FID, PermDependency.FDependencyID, PermItem.FOrgRelation, PermItem.FType FROM T_PM_PermDependency PermDependency ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = PermDependency.FID ");
            buffer.append(" WHERE PermDependency.FDependencyID IN (");
            for (int i = 0; i < length; ++i) {
                if (i == length - 1) {
                    buffer.append(" '").append(permItemPKs[i].toString()).append("' ) ");
                    continue;
                }
                buffer.append(" '").append(permItemPKs[i].toString()).append("' , ");
            }
            buffer.append(" ORDER BY PermDependency.FDependencyID ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                while (rowSet.next()) {
                    PermItemCollection permItems;
                    PermItemInfo permItemInfo = new PermItemInfo();
                    String ID = rowSet.getString("FID");
                    String dependencyID = rowSet.getString("FDependencyID");
                    int orgRelateion = rowSet.getInt("FOrgRelation");
                    PermItemType permItemType = PermItemType.getEnum(rowSet.getInt("FType"));
                    if (permItemType.equals((Object)PermItemType.SYSTEM_ADMIN_FUNCTION) || permItemType.equals((Object)PermItemType.BIZ_ADMIN_FUNCTION)) continue;
                    permItemInfo.setId(BOSUuid.read((String)ID));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)orgRelateion));
                    permItemInfo.setType(permItemType);
                    if (beenDependencyPemItems.containsKey(dependencyID)) {
                        permItems = (PermItemCollection)((Object)beenDependencyPemItems.get(dependencyID));
                        permItems.add(permItemInfo);
                        continue;
                    }
                    permItems = new PermItemCollection();
                    permItems.add(permItemInfo);
                    beenDependencyPemItems.put(dependencyID, permItems);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new EASBizException(PermItemException.GET_PERMITEM_FAIL, (Throwable)e);
            }
        }
        return beenDependencyPemItems;
    }

    @Override
    protected ConfigurationInfo _getClsPermItem(Context ctx) throws BOSException {
        ConfigurationLoader loader = ConfigurationLoader.getInstance();
        return loader.getConfigurationInfo();
    }

    @Override
    protected IObjectCollection _getAllPermissionByOrgType(Context ctx, Collection orgType, Collection permItemTypeCol) throws BOSException, EASBizException {
        String orgTypeStr = "";
        if (orgType != null && !orgType.isEmpty()) {
            orgTypeStr = " and orgRelation in (" + ToolUtils.aryToStr(orgType, true) + ")";
        }
        String permItemTypeStr = "";
        if (permItemTypeCol != null && !permItemTypeCol.isEmpty()) {
            permItemTypeStr = " and type in (" + ToolUtils.aryToStr(permItemTypeCol, true) + ")";
        }
        String oqlStrContent = "isLeaf = 1" + orgTypeStr + permItemTypeStr;
        String selector = this.getSimplePermSelector().toString();
        String oqlStr = "select  " + selector + " ";
        oqlStr = oqlStr + " where " + oqlStrContent + " order by longnumber asc";
        return this.getPermItemCollection(ctx, oqlStr);
    }

    @Override
    protected boolean _haveThisNumber(Context ctx, String permItemNumber) throws BOSException, EASBizException {
        return PermBizHelper.haveThisNumber(ctx, "t_pm_permitem", permItemNumber);
    }

    @Override
    protected IObjectValue _getPermItemInfoByNumber(Context ctx, String permItemNumber) throws BOSException, EASBizException {
        String oql = "select * where number ='" + permItemNumber + "'";
        return this._getValue(ctx, oql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void _saveCustomPermItem(Context ctx, PermissionInfo userCustomPermItem) throws BOSException, EASBizException {
        if (userCustomPermItem != null) {
            userCustomPermItem.setName("allCustom");
            MutilLangeToolForParam.muti2Obj((String)"allCustom", (IObjectValue)userCustomPermItem, (String)"alias");
        }
        boolean isEnablePermSubsytemFile = PermissionCommonUtil.isPermSubsystemFileEnabled(ctx);
        SynchUserHelper synchUserHelper = null;
        try {
            synchUserHelper = new SynchUserHelper(ctx);
            synchUserHelper.synAnyPermitems(userCustomPermItem, isEnablePermSubsytemFile);
        }
        finally {
            if (synchUserHelper != null) {
                synchUserHelper.release();
            }
        }
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster((Context)ctx);
        try {
            iFileCluster.savePermMdbView(ctx, MetaDataTypeList.PERMISSION, (AbstractMetaDataValue)userCustomPermItem);
        }
        catch (DataAccessException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PermissionInfo _getAllPermissionInfo(Context ctx) throws BOSException, EASBizException {
        boolean isEnablePermSubsytemFile = PermissionCommonUtil.isPermSubsystemFileEnabled(ctx);
        if (isEnablePermSubsytemFile) {
            SynchUserHelper helper = null;
            try {
                helper = new SynchUserHelper(ctx);
                PermissionInfo permissionInfo = helper.getPermissionInfoFromFile();
                return permissionInfo;
            }
            finally {
                if (helper != null) {
                    helper.release();
                }
            }
        }
        PermissionInfo allPermission = new PermissionInfo();
        PermissionItemCollection pc = (PermissionItemCollection)this.getCurrentPermissionItems4Customization(ctx);
        allPermission.getPermissionItems().addObjectCollection((IObjectCollection)pc);
        return allPermission;
    }

    @Override
    protected void _deleteCustomPerm(Context ctx) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster((Context)ctx);
        iFileCluster.delPermFile();
    }

    @Override
    protected boolean _existCustomerFile(Context ctx) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster((Context)ctx);
        return iFileCluster.havePermFile();
    }

    @Override
    protected PermissionInfo _getAllStandardPermissionInfo(Context ctx) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getPermission();
    }

    private SelectorItemCollection getSimplePermSelector() {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("isleaf"));
        selectorCol.add(new SelectorItemInfo("number"));
        selectorCol.add(new SelectorItemInfo("parent"));
        selectorCol.add(new SelectorItemInfo("orgrelation"));
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("type"));
        selectorCol.add(new SelectorItemInfo("alias"));
        selectorCol.add(new SelectorItemInfo("operationtype"));
        selectorCol.add(new SelectorItemInfo("longnumber"));
        selectorCol.add(new SelectorItemInfo("enabledatapermission"));
        selectorCol.add(new SelectorItemInfo("objecttype"));
        return selectorCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getPermItemError(Context ctx) throws BOSException, EASBizException {
        SynchUserHelper helper = null;
        try {
            helper = new SynchUserHelper(ctx);
            String string = helper.getPermItemError();
            return string;
        }
        finally {
            if (helper != null) {
                helper.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _deleteRedundantUserPerm(Context ctx) throws BOSException, EASBizException {
        SynchUserHelper helper = null;
        try {
            helper = new SynchUserHelper(ctx);
            helper.deleteRedundantPerm();
            boolean bl = true;
            return bl;
        }
        finally {
            if (helper != null) {
                helper.release();
            }
        }
    }

    @Override
    protected PermItemCollection _getSonBranches(Context ctx, IObjectPK permPK) throws BOSException, EASBizException {
        PermItemCollection result = new PermItemCollection();
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer(300);
            sql.append("SELECT FID, FName, ").append(aliasField).append(", ").append(" FLongNumber, FParentID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 0 and FParentID ");
            if (permPK == null) {
                sql.append(" is null");
            } else {
                sql.append(" = ? ");
            }
            sql.append(" AND ( FType = ").append(20).append(" OR FType = ").append(30).append(" ) ").append(" ORDER BY FLongNumber ASC");
            IRowSet rowSet = null;
            if (permPK == null) {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            } else {
                Object[] params = new Object[]{permPK.toString()};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            }
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setName(rowSet.getString("FName"));
                info.setAlias(rowSet.getString(aliasField));
                info.setLongNumber(rowSet.getString("FLongNumber"));
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    info.setParent(parent);
                }
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    @Override
    protected PermItemCollection _getPermObjectType(Context ctx, boolean enableDataPermission) throws BOSException, EASBizException {
        PermItemCollection result = new PermItemCollection();
        try {
            StringBuffer sql = new StringBuffer(300);
            sql.append("SELECT DISTINCT FObjectType FROM T_PM_PermItem WHERE FObjectType IS NOT NULL ");
            if (enableDataPermission) {
                sql.append(" AND FIsApplyToF7 = 1");
            } else {
                sql.append(" AND (FIsApplyToF7 = 0 OR FIsApplyToF7 IS NULL)");
            }
            sql.append(" ORDER BY FObjectType ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                PermItemInfo info = new PermItemInfo();
                info.setObjectType(rowSet.getString("FObjectType"));
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        return result;
    }

    @Override
    protected PermItemCollection _getAllParentPermWithLeaves(Context ctx, PermItemCollection leavePerms) throws BOSException, EASBizException {
        PermItemCollection resultPermItemCol = new PermItemCollection();
        ArrayList<String> resultPermItemList = new ArrayList<String>();
        ArrayList<String> permIDList = new ArrayList<String>();
        for (int i = 0; i < leavePerms.size(); ++i) {
            PermItemInfo permItemInfo = leavePerms.get(i);
            permIDList.add("'" + permItemInfo.getId().toString() + "'");
        }
        try {
            while (permIDList.size() != 0) {
                String idList = Arrays.toString(permIDList.toArray());
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("Select FParentID From T_PM_PermItem Where FID in (" + idList.substring(1, idList.length() - 1) + ") "));
                permIDList.clear();
                while (rowSet.next()) {
                    String parentItemId = rowSet.getString(1);
                    if (resultPermItemList.contains(parentItemId)) continue;
                    resultPermItemList.add("'" + parentItemId + "'");
                    permIDList.add("'" + parentItemId + "'");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)("selectSql failed" + e.getMessage()));
        }
        String allIdList = Arrays.toString(resultPermItemList.toArray());
        CoreBaseCollection permCol = this.getCollection(ctx, "where id in (" + allIdList.substring(1, allIdList.length() - 1) + " )");
        for (int i = 0; i < permCol.size(); ++i) {
            PermItemInfo permItemInfo = (PermItemInfo)permCol.get(i);
            resultPermItemCol.add(permItemInfo);
        }
        resultPermItemCol.addCollection(leavePerms);
        return resultPermItemCol;
    }

    @Override
    protected PermItemCollection _getAllLeavePermsWithParent(Context ctx, PermItemInfo parentPerm) throws BOSException, EASBizException {
        PermItemCollection resultPermItemCol = new PermItemCollection();
        CoreBaseCollection permCol = this.getCollection(ctx, "where isLeaf = 1 and longNumber like '" + parentPerm.getLongNumber() + "%'");
        for (int i = 0; i < permCol.size(); ++i) {
            PermItemInfo permItemInfo = (PermItemInfo)permCol.get(i);
            resultPermItemCol.add(permItemInfo);
        }
        return resultPermItemCol;
    }

    private void checkNumberDup(Context ctx, PermItemInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)model.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (model.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{model.getNumber()});
        }
    }

    private void checkNameDup(Context ctx, PermItemInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)model.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (model.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{model.getName()});
        }
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PermItemInfo info = (PermItemInfo)model;
        this.checkNumberDup(ctx, info);
        return super._save(ctx, model);
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        super._deleteBatchData(ctx, pkArray);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return super._delete(ctx, filter);
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        return super._delete(ctx, oql);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._isReferenced(ctx, pk);
        String oql = "where parent.id='" + pk + "' and isUserDefined=1";
        if (this._exists(ctx, oql)) {
            throw new PermItemException(PermItemException.CANNOT_DELETE_ERROR);
        }
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        try {
            super._isReferenced(ctx, pk, cn);
            String oql = "where parent.id='" + pk + "' and isUserDefined=1";
            if (this._exists(ctx, oql)) {
                throw new PermItemException(PermItemException.CANNOT_DELETE_ERROR);
            }
        }
        catch (Exception e) {
            throw new ObjectReferedException(null, e.getMessage());
        }
    }
}

