/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.app.helper.UserRolePermHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RolePermDataTransmission
extends AbstractDataTransmission {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger((String)RolePermDataTransmission.class.getName());

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RolePermFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"eccor error!", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null || hsData.isEmpty()) {
            throw new IllegalArgumentException("hsData is null");
        }
        String roleNumber = (String)((DataToken)hsData.get((Object)"FRoleNumber")).data;
        String roleName = (String)((DataToken)hsData.get((Object)"FRoleName")).data;
        String permitemNumber = (String)((DataToken)hsData.get((Object)"FPermItemNumber")).data;
        String permitemAlias = (String)((DataToken)hsData.get((Object)"FPermItemAlias")).data;
        String permItemType = (String)((DataToken)hsData.get((Object)"FPermType")).data;
        String ruleStructure = (String)((DataToken)hsData.get((Object)"FRuleStructure")).data;
        String ruleExpr = (String)((DataToken)hsData.get((Object)"FRuleExpr")).data;
        try {
            if (StringUtils.isEmpty((String)roleNumber)) {
                String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new RoleInfo().getBOSType()).getAlias();
                Object[] params = new Object[]{objectName, roleNumber};
                String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"numberNotFound", (Locale)ctx.getLocale()), params);
                throw new TaskExternalException(msg);
            }
            IRole iRole = RoleFactory.getLocalInstance(ctx);
            boolean hasNumber = iRole.haveThisNumber(roleNumber);
            RoleInfo roleInfo = null;
            if (hasNumber) {
                roleInfo = iRole.getRoleInfoByNumber(roleNumber);
            } else {
                roleInfo = new RoleInfo();
                roleInfo.setNumber(roleNumber);
                if (StringUtils.isEmpty((String)roleName)) {
                    MutilLangeToolForParam.muti2Obj((String)roleNumber, (IObjectValue)roleInfo, (String)"name", (Context)ctx);
                } else {
                    MutilLangeToolForParam.muti2Obj((String)roleName, (IObjectValue)roleInfo, (String)"name", (Context)ctx);
                }
                IObjectPK rolePK = iRole.addnew((CoreBaseInfo)roleInfo);
                roleInfo.setId(BOSUuid.read((String)rolePK.toString()));
            }
            PermItemInfo permItemInfo = PermBizHelper.findPermItemInfoByNumber(ctx, permitemNumber);
            if (StringUtils.isEmpty((String)permItemType)) {
                String msg = EASCommonResource.getString((String)RESOURCE, (String)"permitemtype_cannot_be_null", (Locale)ctx.getLocale());
                throw new TaskExternalException(msg);
            }
            PermType permType = PermBizHelper.findPermType(permItemType);
            if (PermType.AUTHORIZATION == permType) {
                String msg = EASCommonResource.getString((String)RESOURCE, (String)"rolePermNotSupoortAuthor", (Locale)ctx.getLocale());
                throw new TaskExternalException(msg);
            }
            IRolePerm iRolePerm = RolePermFactory.getLocalInstance(ctx);
            String roleId = roleInfo.getId().toString();
            RolePermCollection rolePermCol = iRolePerm.findRolePermInfo(roleId, permItemInfo.getId().toString(), permType);
            RolePermInfo rolePermInfo = new RolePermInfo();
            boolean isAddRolePerm = true;
            if (!rolePermCol.isEmpty()) {
                isAddRolePerm = false;
                if (this.isSltImportUpdate()) {
                    rolePermInfo.setId(rolePermCol.get(0).getId());
                } else {
                    Object[] param = new Object[]{roleNumber, permitemNumber, permitemAlias, permType.getAlias()};
                    String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"permAlreadyExist", (Locale)ctx.getLocale()), param);
                    throw new TaskExternalException(msg);
                }
            }
            rolePermInfo.setRole(roleInfo);
            rolePermInfo.setPermItem(permItemInfo);
            rolePermInfo.setPermType(permType);
            String importRule = ParamManager.getParamValue((Context)ctx, null, (String)"PERM_IMPORT_RULE");
            if (!StringUtils.isEmpty((String)importRule) && importRule.trim().equalsIgnoreCase("true")) {
                rolePermInfo.setRuleStructure(StringUtils.cnulls((String)ruleStructure));
                rolePermInfo.setRuleExpr(StringUtils.cnulls((String)ruleExpr));
            }
            if (isAddRolePerm && hasNumber) {
                RolePermCollection addrc = new RolePermCollection();
                addrc.add(rolePermInfo);
                try {
                    GroupLicenseUseInfoUtil.changeRolePermitem(ctx, roleInfo, addrc, new RolePermCollection());
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage());
                }
            }
            return rolePermInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"easException :", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"easException :", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String roleId = rs.getString("role.id");
            IRole iRole = RoleFactory.getLocalInstance(ctx);
            RoleInfo roleInfo = iRole.getRoleInfo((IObjectPK)new ObjectStringPK(roleId));
            result.put("FRoleNumber", roleInfo.getNumber());
            result.put("FRoleName", roleInfo.getName());
            String permItemId = rs.getString("permitem.id");
            IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
            PermItemInfo permItemInfo = iPermItem.getPermItemInfo((IObjectPK)new ObjectStringPK(permItemId));
            result.put("FPermItemNumber", permItemInfo.getNumber());
            result.put("FPermItemAlias", permItemInfo.getAlias());
            String permType = rs.getString("permType");
            result.put("FPermType", permType);
            String ruleStructure = rs.getString("ruleStructure");
            result.put("FRuleStructure", StringUtils.cnulls((String)ruleStructure));
            String ruleExpr = rs.getString("ruleExpr");
            result.put("FRuleExpr", StringUtils.cnulls((String)ruleExpr));
            UserRolePermHelper helper = new UserRolePermHelper();
            helper.exportLongNumberLevel(ctx, rs, result);
        }
        catch (SQLException e) {
            logger.error((Object)"eccor!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"eccor!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)"eccor1!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.RolePermQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }
}

