/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IOwnerExceptPermitem;
import com.kingdee.eas.base.permission.ISpecialDirectorPermitem;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OtherOwnerCollection;
import com.kingdee.eas.base.permission.OwnerExceptPermitemCollection;
import com.kingdee.eas.base.permission.OwnerExceptPermitemFactory;
import com.kingdee.eas.base.permission.OwnerExceptPermitemInfo;
import com.kingdee.eas.base.permission.SpecialDataPermCollection;
import com.kingdee.eas.base.permission.SpecialDataPermEntryCollection;
import com.kingdee.eas.base.permission.SpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.SpecialDataPermFactory;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDataPermissionException;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemCollection;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermitemInfo;
import com.kingdee.eas.base.permission.app.AbstractSpecialDataPermControllerBean;
import com.kingdee.eas.base.permission.app.SpecialDataPermServerHelper;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.config.FileReloadHelper;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SpecialDataPermControllerBean
extends AbstractSpecialDataPermControllerBean {
    private static Logger logger = Logger.getLogger(SpecialDataPermControllerBean.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected void _save(Context ctx, SpecialDataPermCollection perms) throws BOSException, EASBizException {
        if (perms != null && perms.size() > 0) {
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"SPECIAL_DATA_PERMISSION"), (BOSObjectType)perms.get(0).getBOSType(), null, (String)this.getLogDetailString(ctx, perms), (String)"bs_permission_specialDataPerm_maintain");
            int size = perms.size();
            for (int i = 0; i < size; ++i) {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(perms.get(i).getId()), (CoreBaseInfo)perms.get(i));
            }
            this.saveDirectorEntries(ctx, perms);
            this.saveOwnerExceptEntries(ctx, perms);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            CacheUtil.clearRuleCache();
        }
    }

    private String getLogDetailString(Context ctx, SpecialDataPermCollection perms) throws EASBizException, BOSException {
        String value;
        StringBuilder logDetail = new StringBuilder();
        HashSet<String> setOwnerBosTypeSet = new HashSet<String>();
        HashSet<String> unSetDirectorBosTypeSet = new HashSet<String>();
        HashSet<String> unSetOwnerBosTypeSet = new HashSet<String>();
        HashSet<String> setDirectorBosTypeSet = new HashSet<String>();
        HashSet<String> setOwnerExceptBosTypeSet = new HashSet<String>();
        int size = perms.size();
        for (int i = 0; i < size; ++i) {
            SpecialDataPermInfo newValue = perms.get(i);
            SpecialDataPermInfo oldValue = this.getSpecialDataPermInfo(ctx, (IObjectPK)new ObjectUuidPK(newValue.getId()));
            if (oldValue == null) {
                if (newValue.isEnableCreatorPerm()) {
                    setOwnerBosTypeSet.add(newValue.getBizObject());
                }
                if (newValue.isEnableDirectorPerm()) {
                    setDirectorBosTypeSet.add(newValue.getBizObject());
                }
                if (!StringUtils.isEmpty((String)newValue.getOtherOwner())) continue;
                setOwnerExceptBosTypeSet.add(newValue.getOtherOwner());
                continue;
            }
            if (oldValue.isEnableCreatorPerm() != newValue.isEnableCreatorPerm()) {
                if (newValue.isEnableCreatorPerm()) {
                    setOwnerBosTypeSet.add(newValue.getBizObject());
                } else {
                    unSetOwnerBosTypeSet.add(newValue.getBizObject());
                }
            }
            if (oldValue.isEnableDirectorPerm() != newValue.isEnableDirectorPerm()) {
                if (newValue.isEnableDirectorPerm()) {
                    setDirectorBosTypeSet.add(newValue.getBizObject());
                } else {
                    unSetDirectorBosTypeSet.add(newValue.getBizObject());
                }
            }
            if (this.isSameOtherOwner(newValue.getOtherOwners(), oldValue.getOtherOwners())) continue;
            setOwnerExceptBosTypeSet.add(newValue.getBizObject());
        }
        String cuName = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(perms.get(0).getCU().getId())).getName();
        logDetail.append(EASResource.getString((String)RESOURCE, (String)"ON_CTRLUNIT")).append(cuName).append(" ):\n");
        if (setOwnerBosTypeSet.size() > 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"BILL1"));
            Iterator iterator = setOwnerBosTypeSet.iterator();
            while (iterator.hasNext()) {
                value = (String)iterator.next();
                logDetail.append(value).append(iterator.hasNext() ? "," : "");
            }
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"ENABLE_OWNER_PERM") + ");\n");
        }
        if (unSetOwnerBosTypeSet.size() > 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"BILL1"));
            Iterator iterator = unSetOwnerBosTypeSet.iterator();
            while (iterator.hasNext()) {
                value = (String)iterator.next();
                logDetail.append(value).append(iterator.hasNext() ? "," : "");
            }
            logDetail.append(")" + EASResource.getString((String)RESOURCE, (String)"CANCER_OWNER_PERM") + ";\n");
        }
        if (setDirectorBosTypeSet.size() > 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"BILL1"));
            Iterator iterator = setDirectorBosTypeSet.iterator();
            while (iterator.hasNext()) {
                value = (String)iterator.next();
                logDetail.append(value).append(iterator.hasNext() ? "," : "");
            }
            logDetail.append(")" + EASResource.getString((String)RESOURCE, (String)"ENABLE_MANAGE_PERM") + ";\n");
        }
        if (unSetDirectorBosTypeSet.size() > 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"BILL1"));
            Iterator iterator = unSetDirectorBosTypeSet.iterator();
            while (iterator.hasNext()) {
                value = (String)iterator.next();
                logDetail.append(value).append(iterator.hasNext() ? "," : "");
            }
            logDetail.append(")" + EASResource.getString((String)RESOURCE, (String)"CANCEL_MANAGE_PERM") + ";\n");
        }
        if (setOwnerExceptBosTypeSet.size() > 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"BILL1"));
            Iterator iterator = setOwnerExceptBosTypeSet.iterator();
            while (iterator.hasNext()) {
                value = (String)iterator.next();
                logDetail.append(value).append(iterator.hasNext() ? "," : "");
            }
            logDetail.append(")" + EASResource.getString((String)RESOURCE, (String)"SET_OTHER_OWNER") + ";\n");
        }
        if (setOwnerBosTypeSet.size() == 0 && unSetOwnerBosTypeSet.size() == 0 && setDirectorBosTypeSet.size() == 0 && unSetDirectorBosTypeSet.size() == 0 && setOwnerExceptBosTypeSet.size() == 0) {
            logDetail.append(EASResource.getString((String)RESOURCE, (String)"NO_UPDATE"));
        }
        return logDetail.toString();
    }

    private boolean isSameOtherOwner(OtherOwnerCollection newValue, OtherOwnerCollection oldValue) {
        int i;
        if (newValue.size() == 0 && oldValue.size() == 0) {
            return true;
        }
        if (newValue.size() != oldValue.size()) {
            return false;
        }
        HashSet<String> oldIdSet = new HashSet<String>();
        for (i = 0; i < oldValue.size(); ++i) {
            oldIdSet.add(oldValue.get(i).getPropertyName());
        }
        for (i = 0; i < newValue.size(); ++i) {
            String id = newValue.get(i).getPropertyName();
            if (oldIdSet.contains(id)) continue;
            return false;
        }
        return true;
    }

    private void saveDirectorEntries(Context ctx, SpecialDataPermCollection perms) throws BOSException, EASBizException {
        ISpecialDirectorPermitem iSpecialDirectorPermitem = SpecialDirectorPermitemFactory.getLocalInstance(ctx);
        for (int i = 0; i < perms.size(); ++i) {
            SpecialDataPermInfo specialDataPermInfo = perms.get(i);
            SpecialDirectorPermitemCollection directorPermCol = specialDataPermInfo.getSpecialDirectorPermitemCol();
            for (int j = 0; j < directorPermCol.size(); ++j) {
                SpecialDirectorPermitemInfo directorInfo = directorPermCol.get(j);
                directorInfo.setCU(specialDataPermInfo.getCU());
                directorInfo.setObjType(specialDataPermInfo.getBizObjectType());
                if (directorInfo.getId() == null) {
                    iSpecialDirectorPermitem.addnew(directorInfo);
                    continue;
                }
                iSpecialDirectorPermitem.update((IObjectPK)new ObjectUuidPK(directorInfo.getId()), directorInfo);
            }
        }
    }

    private void saveOwnerExceptEntries(Context ctx, SpecialDataPermCollection perms) throws BOSException, EASBizException {
        IOwnerExceptPermitem iOwnerExceptPermitem = OwnerExceptPermitemFactory.getLocalInstance(ctx);
        for (int i = 0; i < perms.size(); ++i) {
            SpecialDataPermInfo specialDataPermInfo = perms.get(i);
            OwnerExceptPermitemCollection ownerExceptPermCol = specialDataPermInfo.getOwnerExceptPermitemCol();
            for (int j = 0; j < ownerExceptPermCol.size(); ++j) {
                OwnerExceptPermitemInfo ownerExceptInfo = ownerExceptPermCol.get(j);
                ownerExceptInfo.setCU(specialDataPermInfo.getCU());
                ownerExceptInfo.setObjType(specialDataPermInfo.getBizObjectType());
                if (ownerExceptInfo.getId() == null) {
                    iOwnerExceptPermitem.addnew(ownerExceptInfo);
                    continue;
                }
                iOwnerExceptPermitem.update((IObjectPK)new ObjectUuidPK(ownerExceptInfo.getId()), ownerExceptInfo);
            }
        }
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.BASICSYSTEM;
    }

    private SpecialDataPermCollection getSpecialDataPermColByCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        String oql = "select bizObjectType,enableCreatorPerm,enableDirectorPerm,otherOwner,entries.permItem.id,entries.permType,entries.logicTag,CU.id where (enableDirectorPerm=1 or otherOwner is not null or enableCreatorPerm= 1) and CU.id = '" + cuPK.toString() + "'";
        return this.getSpecialDataPermCollection(ctx, oql);
    }

    private Map getSpecialDataPermMap(Context ctx, SpecialDataPermCollection col) throws BOSException, EASBizException {
        HashMap<String, SpecialDataPermInfo> ret = new HashMap<String, SpecialDataPermInfo>();
        if (col == null || col.size() < 1) {
            return ret;
        }
        for (int i = 0; i < col.size(); ++i) {
            SpecialDataPermInfo data = col.get(i);
            String key = data.getCU().getId().toString() + data.getBizObjectType();
            ret.put(key, data);
        }
        return ret;
    }

    private Map getSpecialDataPermEntryMap(Context ctx, SpecialDataPermCollection col) throws BOSException, EASBizException {
        HashMap<String, SpecialDataPermEntryInfo> ret = new HashMap<String, SpecialDataPermEntryInfo>();
        if (col == null || col.size() < 1) {
            return ret;
        }
        for (int i = 0; i < col.size(); ++i) {
            SpecialDataPermInfo data = col.get(i);
            SpecialDataPermEntryCollection entryCol = data.getEntries();
            for (int j = 0; j < entryCol.size(); ++j) {
                SpecialDataPermEntryInfo entryInfo = entryCol.get(j);
                String key = data.getCU().getId().toString() + data.getBizObjectType() + entryInfo.getPermItem().getId();
                ret.put(key, entryInfo);
            }
        }
        return ret;
    }

    private boolean existCUSpecialDataPerm(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuPK.toString()));
        return this.exists(ctx, filterInfo);
    }

    private File getTimeFile() {
        String timeFileName = "specialpermlastloadtime.txt";
        String timeFilePath = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append(timeFileName).toString();
        return new File(timeFilePath);
    }

    public boolean isConfigFileChanged() throws BOSException, EASBizException {
        boolean ret = false;
        FileReloadHelper helper = new FileReloadHelper(this.getTimeFile());
        File[] configFiles = ConfigurationLoader.getConfiguationFile();
        for (int i = 0; i < configFiles.length; ++i) {
            if (!helper.isConfigFileChanged(configFiles[i])) continue;
            helper.writeNewTime(false);
            return true;
        }
        return ret;
    }

    private List getAllCUOfSpecialDataPerm(Context ctx) throws BOSException, EASBizException {
        String sql = "select distinct FControlUnitID from t_pm_specialdataperm";
        ArrayList<String> ret = new ArrayList<String>();
        Connection con = this.getConnection(ctx);
        PreparedStatement state = null;
        ResultSet rs = null;
        try {
            state = con.prepareStatement(sql);
            rs = state.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString("FControlUnitID"));
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return ret;
    }

    @Override
    protected void _initData(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        if (this.isConfigFileChanged()) {
            List cuList = this.getAllCUOfSpecialDataPerm(ctx);
            for (int i = 0; i < cuList.size(); ++i) {
                this.initDataByCU(ctx, (IObjectPK)new ObjectStringPK(cuList.get(i).toString()));
            }
            this.updateSpecialDataPermIDOfOtherOwner(ctx);
        }
        if (!this.existCUSpecialDataPerm(ctx, cuPK)) {
            this.initDataByCU(ctx, cuPK);
        }
        SpecialDataPermServerHelper.upgradeSpecialDirector(ctx);
        SpecialDataPermServerHelper.upgradeOwnerPermExcept(ctx);
    }

    private void initDatabyAppToMultiOrg(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        if (this.isConfigFileChanged()) {
            List cuList = this.getAllCUOfSpecialDataPerm(ctx);
            for (int i = 0; i < cuList.size(); ++i) {
                this.initDataByCU(ctx, (IObjectPK)new ObjectStringPK(cuList.get(i).toString()));
            }
            this.updateSpecialDataPermIDOfOtherOwner(ctx);
        }
        if (!this.existCUSpecialDataPerm(ctx, cuPK)) {
            this.initDataByCU(ctx, cuPK);
        }
    }

    private void initDataByCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        Collection collection = ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialEntityTypes();
        collection = this.getAvailableBosTypeCollection(ctx, collection);
        SpecialDataPermCollection oldSpecialCol = this.getSpecialDataPermColByCU(ctx, cuPK);
        Map oldSpecialMap = this.getSpecialDataPermMap(ctx, oldSpecialCol);
        Map oldSpecialEntryMap = this.getSpecialDataPermEntryMap(ctx, oldSpecialCol);
        this.deleteSpecialDataPermEntryByCU(ctx, cuPK);
        this.deleteSpecialDataPermByCU(ctx, cuPK);
        if (collection.size() > 0) {
            Map typePermItemMap = SpecialDataPermServerHelper.getObjectTypeAndPermItemMap(ctx, collection);
            Map mapSpecialDataPerm = this.insertSpecialDataPerm(ctx, cuPK, collection, oldSpecialMap);
            this.insertSpecialDataPermEntry(ctx, cuPK, mapSpecialDataPerm, typePermItemMap, oldSpecialEntryMap);
        }
    }

    private Collection getAvailableBosTypeCollection(Context ctx, Collection allCol) {
        Iterator bosTypeItr = allCol.iterator();
        HashSet<String> ret = new HashSet<String>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        while (bosTypeItr.hasNext()) {
            String objectType = bosTypeItr.next().toString();
            try {
                loader.getEntity(BOSObjectType.create((String)objectType));
                ret.add(objectType);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return ret;
    }

    private void deleteSpecialDataPermByCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        String sql = "delete from t_pm_specialDataPerm where FControlUnitID='" + cuPK.toString() + "'";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"delete special data perm fail");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void deleteSpecialDataPermEntryByCU(Context ctx, IObjectPK cuPK) throws BOSException, EASBizException {
        String sql = "delete from t_pm_specialDataPermEntry where FSpecialDataPermID in (select fid from t_pm_specialDataPerm where FControlUnitID = '" + cuPK.toString() + "')";
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"delete special data perm fail");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private Map insertSpecialDataPerm(Context ctx, IObjectPK ctrlUnitPK, Collection entityCol, Map oldSpecialMap) throws BOSException, EASBizException {
        Map mapSpecialDataPerm = new HashMap();
        if (entityCol.size() > 0) {
            Connection con = null;
            PreparedStatement ps = null;
            try {
                int i;
                StringBuffer sql = new StringBuffer();
                Locale[] locales = MultiLangHelper.getDefinedLocales(ctx);
                sql.append("INSERT INTO T_PM_SpecialDataPerm (FID, FBizObject, FBizObjectType, ").append(" FIsEnableCreatorPerm, FIsEnableDirectorPerm, FControlUnitID, ");
                for (i = 0; i < locales.length; ++i) {
                    sql.append(MultiLangHelper.getFieldName("FOtherOwner", locales[i])).append(",");
                }
                sql.append(" FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime) VALUES (? , ? , ? , ? , ? , ? , ");
                for (i = 0; i < locales.length; ++i) {
                    sql.append("?,");
                }
                sql.append("? ,? , ?, ?) ");
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql.toString());
                mapSpecialDataPerm = this.addSpecialDataPermBatch(ctx, ctrlUnitPK, entityCol, oldSpecialMap, ps);
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new SpecialDataPermissionException(SpecialDataPermissionException.INIT_DATA_FAIL, e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
        return mapSpecialDataPerm;
    }

    private void insertSpecialDataPermEntry(Context ctx, IObjectPK ctrlUnitPK, Map mapSpecialDataPerm, Map typePermItemMap, Map oldSpecialEntryMap) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO T_PM_SpecialDataPermEntry (FID, FSeq, FSpecialDataPermID,").append(" FPermItemID, FPermType,FLogicTag  ) VALUES (? , ? , ? , ? , ? , ? ) ");
            ps = con.prepareStatement(sql.toString());
            this.addSpecialDataPermEntryBatch(ctrlUnitPK, mapSpecialDataPerm, typePermItemMap, oldSpecialEntryMap, ps);
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new SpecialDataPermissionException(SpecialDataPermissionException.INIT_DATA_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private void addSpecialDataPermEntryBatch(IObjectPK cuID, Map mapSpecialDataPerm, Map allPermItems, Map oldSpecialEntryMap, PreparedStatement ps) throws SQLException {
        BOSObjectType specialDataPermEntryType = new SpecialDataPermEntryInfo().getBOSType();
        Set setSpecialDataPerm = mapSpecialDataPerm.keySet();
        for (String objectType : setSpecialDataPerm) {
            if (!allPermItems.containsKey(objectType)) continue;
            Set setPermItem = (Set)allPermItems.get(objectType);
            Iterator itePermItem = setPermItem.iterator();
            int index = 1;
            while (itePermItem.hasNext()) {
                String permItemID = (String)itePermItem.next();
                String ID = BOSUuid.create((BOSObjectType)specialDataPermEntryType).toString();
                ps.setString(1, ID);
                ps.setInt(2, index);
                ps.setString(3, (String)mapSpecialDataPerm.get(objectType));
                ps.setString(4, permItemID);
                int specialPermType = 0;
                String specialPermLogicTag = "DF";
                SpecialDataPermEntryInfo entry = (SpecialDataPermEntryInfo)oldSpecialEntryMap.get(cuID.toString() + objectType + permItemID);
                if (entry != null) {
                    specialPermType = entry.getPermType().getValue();
                    specialPermLogicTag = entry.getLogicTag().getValue();
                }
                ps.setInt(5, specialPermType);
                ps.setString(6, specialPermLogicTag);
                ps.addBatch();
                ++index;
            }
        }
    }

    private Map addSpecialDataPermBatch(Context ctx, IObjectPK ctrlUnitPK, Collection specialEntities, Map oldSpecialMap, PreparedStatement ps) throws SQLException {
        HashMap<String, String> mapSpecialDataPerm = new HashMap<String, String>();
        BOSObjectType specialDataPermissionType = new SpecialDataPermInfo().getBOSType();
        Date date = new Date(System.currentTimeMillis());
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        Locale[] locales = MultiLangHelper.getDefinedLocales(ctx);
        Iterator iterator = specialEntities.iterator();
        while (iterator.hasNext()) {
            String ID = BOSUuid.create((BOSObjectType)specialDataPermissionType).toString();
            String objectType = (String)iterator.next();
            ps.setString(1, ID);
            ps.setString(2, loader.getEntity(BOSObjectType.create((String)objectType)).getAlias());
            ps.setString(3, objectType);
            SpecialDataPermInfo oldSpecialInfo = (SpecialDataPermInfo)oldSpecialMap.get(ctrlUnitPK.toString() + objectType);
            int enableCreatorPerm = 0;
            int enableDirectorPerm = 0;
            if (oldSpecialInfo != null) {
                enableCreatorPerm = oldSpecialInfo.isEnableCreatorPerm() ? 1 : 0;
                enableDirectorPerm = oldSpecialInfo.isEnableDirectorPerm() ? 1 : 0;
            }
            ps.setInt(4, enableCreatorPerm);
            ps.setInt(5, enableDirectorPerm);
            ps.setString(6, ctrlUnitPK.toString());
            for (int i = 0; i < locales.length; ++i) {
                String otherOwner = null;
                if (oldSpecialInfo != null) {
                    otherOwner = oldSpecialInfo.getOtherOwner(locales[i]);
                }
                ps.setString(7 + i, otherOwner);
            }
            int localeLength = locales.length;
            ps.setString(7 + localeLength, "00000000-0000-0000-0000-00000000000013B7DE7F");
            ps.setDate(8 + localeLength, date);
            ps.setString(9 + localeLength, "00000000-0000-0000-0000-00000000000013B7DE7F");
            ps.setDate(10 + localeLength, date);
            mapSpecialDataPerm.put(objectType, ID);
            ps.addBatch();
        }
        return mapSpecialDataPerm;
    }

    private void updateSpecialDataPermIDOfOtherOwner(Context ctx) throws BOSException, EASBizException {
        String sql = "update t_pm_otherowner set fspecialdatapermid = (select fid from t_pm_specialdataperm where fcontrolunitid=t_pm_otherowner.fcontrolunitid and fbizobjecttype=t_pm_otherowner.fobjecttype)";
        Connection conn = this.getConnection(ctx);
        try {
            SQLUtils.execute((Connection)conn, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"updateSpecialDataPermIDOfOtherOwner error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected SpecialDataPermInfo _getSpecialDataPermDetailInfo(Context ctx, IObjectPK specialDataPermID) throws BOSException, EASBizException {
        SpecialDataPermInfo info = null;
        StringBuffer oql = new StringBuffer();
        oql.append(" SELECT *, entries.*, entries.permItem.*,otherOwners.* WHERE id = '").append(specialDataPermID).append("' ");
        info = this.getSpecialDataPermInfo(ctx, oql.toString());
        info.setSpecialDirectorPermitemCol(this.getSpecialDirectorPermitemCol(ctx, info));
        info.setOwnerExceptPermitemCol(this.getOwnerExceptPermitemCol(ctx, info));
        return info;
    }

    private SpecialDirectorPermitemCollection getSpecialDirectorPermitemCol(Context ctx, SpecialDataPermInfo specialDataPermInfo) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,CU.id,objType,permItem.*,permType where cu.id='").append(specialDataPermInfo.getCU().getId().toString()).append("' and objType='").append(specialDataPermInfo.getBizObjectType()).append("'");
        ISpecialDirectorPermitem iSpecialDirectorPermitem = SpecialDirectorPermitemFactory.getLocalInstance(ctx);
        return iSpecialDirectorPermitem.getSpecialDirectorPermitemCollection(oql.toString());
    }

    private OwnerExceptPermitemCollection getOwnerExceptPermitemCol(Context ctx, SpecialDataPermInfo specialDataPermInfo) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,CU.id,objType,permItem.*,permType where cu.id='").append(specialDataPermInfo.getCU().getId().toString()).append("' and objType='").append(specialDataPermInfo.getBizObjectType()).append("'");
        IOwnerExceptPermitem iOwnerExceptPermitem = OwnerExceptPermitemFactory.getLocalInstance(ctx);
        return iOwnerExceptPermitem.getOwnerExceptPermitemCollection(oql.toString());
    }

    @Override
    protected void _appToMultiOrg(Context ctx, List orgList, SpecialDataPermCollection perms) throws BOSException, EASBizException {
        int modNumber = 0;
        String cuId = perms.get(0).getCU().getId().toString();
        orgList.remove(cuId);
        String orgIds = ToolUtils.aryToStr(orgList);
        Connection conn = this.getConnection(ctx);
        String otherowner_l1 = "";
        String otherowner_l2 = "";
        String otherowner_l3 = "";
        Statement stat = null;
        if (perms == null || perms.size() <= 0 || orgList == null || orgList.size() <= 0) {
            return;
        }
        long c1 = System.currentTimeMillis();
        for (int i = 0; i < orgList.size(); ++i) {
            this.initDatabyAppToMultiOrg(ctx, (IObjectPK)new ObjectUuidPK(orgList.get(i).toString()));
        }
        SpecialDataPermServerHelper.upgradeSpecialDirector(ctx);
        SpecialDataPermServerHelper.upgradeOwnerPermExcept(ctx);
        long c2 = System.currentTimeMillis() - c1;
        logger.error((Object)("hp2014 _initData =" + c2 + "ms"));
        System.out.println("hp2014 _initData =" + c2 + "ms");
        try {
            int j;
            int i;
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"ADDNEW_OWNER_EXCEPTION"), (BOSObjectType)new BOSObjectType("F2B4E25F"), null, (String)this.getLogDetail(ctx, orgList, cuId), (String)"bs_permission_specialDataPerm_mutiOrg");
            stat = conn.createStatement();
            c1 = System.currentTimeMillis();
            int size = perms.size();
            for (i = 0; i < size; ++i) {
                int isEnableCreatorPerm = perms.get(i).isEnableCreatorPerm() ? 1 : 0;
                int isEnableDirectorPerm = perms.get(i).isEnableDirectorPerm() ? 1 : 0;
                Locale[] locales = MultiLangHelper.getDefinedLocales(ctx);
                otherowner_l1 = StringUtils.isEmpty((String)perms.get(i).getOtherOwner(locales[0])) ? "" : perms.get(i).getOtherOwner(locales[0]);
                otherowner_l2 = StringUtils.isEmpty((String)perms.get(i).getOtherOwner(locales[1])) ? "" : perms.get(i).getOtherOwner(locales[1]);
                otherowner_l3 = StringUtils.isEmpty((String)perms.get(i).getOtherOwner(locales[2])) ? "" : perms.get(i).getOtherOwner(locales[2]);
                String bizObjectType = perms.get(i).getBizObjectType();
                String specialDataPermId = perms.get(i).getId().toString();
                String updateDataPermSql = "update T_PM_SpecialDataPerm set FIsEnableCreatorPerm = '" + isEnableCreatorPerm + "',FIsEnableDirectorPerm='" + isEnableDirectorPerm + "'  ,fotherowner_l1 ='" + otherowner_l1 + "', fotherowner_l2 ='" + otherowner_l2 + "', fotherowner_l3 ='" + otherowner_l3 + "'";
                updateDataPermSql = updateDataPermSql + " where fcontrolunitid in (" + orgIds + ") and fbizobjecttype = '" + bizObjectType + "'";
                stat.addBatch(updateDataPermSql);
                if (++modNumber % 1000 == 0) {
                    stat.executeBatch();
                }
                for (int k = 0; k < orgList.size(); ++k) {
                    String insertSpecialDatapermId = SpecialDataPermFactory.getLocalInstance(ctx).getSpecialDataPermInfo("select id where bizObjectType ='" + perms.get(i).getBizObjectType() + "' and CU ='" + orgList.get(k) + "'").getId().toString();
                    if (StringUtils.isEmpty((String)insertSpecialDatapermId)) continue;
                    String delSql = "delete from T_PM_OtherOwner where FSPECIALDATAPERMID='" + insertSpecialDatapermId + "'";
                    stat.addBatch(delSql);
                    if (++modNumber % 1000 == 0) {
                        stat.executeBatch();
                    }
                    String insertOtherOwner = "insert into T_PM_OtherOwner(FID,FPROPERTYNAME,FPROPERTYALIAS_L1,FPROPERTYALIAS_L2,FPROPERTYALIAS_L3,FSPECIALDATAPERMID,FISOTHEROWNER,FOBJECTTYPE,FCONTROLUNITID)  select newbosid('3DA88937'),FPROPERTYNAME,FPROPERTYALIAS_L1,FPROPERTYALIAS_L2,FPROPERTYALIAS_L3,'" + insertSpecialDatapermId + "',FISOTHEROWNER,FOBJECTTYPE,'" + orgList.get(k) + "'  from T_PM_OtherOwner where fcontrolunitid='" + cuId + "'  and fspecialdatapermid='" + specialDataPermId + "'";
                    stat.addBatch(insertOtherOwner);
                    if (++modNumber % 1000 != 0) continue;
                    stat.executeBatch();
                }
            }
            c2 = System.currentTimeMillis() - c1;
            logger.error((Object)("hp2014 insert OtherOwner =" + c2 + "ms"));
            System.out.println("hp2014 insert OtherOwner =" + c2 + "ms");
            c1 = System.currentTimeMillis();
            for (i = 0; i < perms.size(); ++i) {
                SpecialDataPermInfo specialDataPermInfo = perms.get(i);
                SpecialDataPermEntryCollection entryCol = specialDataPermInfo.getEntries();
                for (j = 0; j < entryCol.size(); ++j) {
                    SpecialDataPermEntryInfo entryInfo = entryCol.get(j);
                    String updateDataPermEntrySql = "update T_PM_SpecialDataPermentry set FPermType = '" + entryInfo.getPermType().getValue() + "',FLogicTag ='" + entryInfo.getLogicTag().getValue() + "' where fpermitemid='" + entryInfo.getPermItem().getId().toString() + "'  and FSpecialDataPermID in(select fid from T_PM_SpecialDataPerm where fcontrolunitid in (" + orgIds + "))";
                    stat.addBatch(updateDataPermEntrySql);
                    if (++modNumber % 1000 != 0) continue;
                    stat.executeBatch();
                }
            }
            c2 = System.currentTimeMillis() - c1;
            logger.error((Object)("hp2014 update T_PM_SpecialDataPermentry  =" + c2 + "ms"));
            System.out.println("hp2014 update T_PM_SpecialDataPermentry  =" + c2 + "ms");
            c1 = System.currentTimeMillis();
            for (i = 0; i < perms.size(); ++i) {
                SpecialDataPermInfo specialDataPermInfo = perms.get(i);
                SpecialDirectorPermitemCollection directorPermCol = specialDataPermInfo.getSpecialDirectorPermitemCol();
                for (j = 0; j < directorPermCol.size(); ++j) {
                    SpecialDirectorPermitemInfo directorInfo = directorPermCol.get(j);
                    directorInfo.setCU(specialDataPermInfo.getCU());
                    directorInfo.setObjType(specialDataPermInfo.getBizObjectType());
                    String updateDirectorPermSql = "update T_PM_SpecialDirectorPermitem set FPermType = '" + directorInfo.getPermType().getValue() + "' where fcontrolunitid in (" + orgIds + ") and fpermitemid='" + directorInfo.getPermItem().getId().toString() + "' and fobjtype ='" + directorInfo.getObjType() + "'";
                    stat.addBatch(updateDirectorPermSql);
                    if (++modNumber % 1000 != 0) continue;
                    stat.executeBatch();
                }
            }
            c2 = System.currentTimeMillis() - c1;
            logger.error((Object)("hp2014 update T_PM_SpecialDirectorPermitem  =" + c2 + "ms"));
            System.out.println("hp2014 update T_PM_SpecialDirectorPermitem  =" + c2 + "ms");
            c1 = System.currentTimeMillis();
            for (i = 0; i < perms.size(); ++i) {
                SpecialDataPermInfo specialDataPermInfo = perms.get(i);
                OwnerExceptPermitemCollection ownerExceptPermCol = specialDataPermInfo.getOwnerExceptPermitemCol();
                for (j = 0; j < ownerExceptPermCol.size(); ++j) {
                    OwnerExceptPermitemInfo ownerExceptInfo = ownerExceptPermCol.get(j);
                    ownerExceptInfo.setCU(specialDataPermInfo.getCU());
                    ownerExceptInfo.setObjType(specialDataPermInfo.getBizObjectType());
                    String updateOwnerExceptPermSql = "update T_PM_OwnerExceptPermitem set FPermType = '" + ownerExceptInfo.getPermType().getValue() + "' where fcontrolunitid in (" + orgIds + ") and fpermitemid='" + ownerExceptInfo.getPermItem().getId().toString() + "' and fobjtype ='" + ownerExceptInfo.getObjType() + "'";
                    stat.addBatch(updateOwnerExceptPermSql);
                    if (++modNumber % 1000 != 0) continue;
                    stat.executeBatch();
                }
            }
            c2 = System.currentTimeMillis() - c1;
            logger.error((Object)("hp2014 update T_PM_SpecialDirectorPermitem  =" + c2 + "ms"));
            System.out.println("hp2014 update T_PM_SpecialDirectorPermitem  =" + c2 + "ms");
            stat.executeBatch();
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
        CacheUtil.clearRuleCache();
    }

    private String getLogDetail(Context ctx, List orgList, String cuId) {
        StringBuilder sb = new StringBuilder();
        try {
            FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select name where id = '" + cuId + "'");
            sb.append(EASResource.getString((String)RESOURCE, (String)"CTRLUNIT")).append(orgUnitInfo.getName()).append(")" + EASResource.getString((String)RESOURCE, (String)"SPECIAL_PERM_APPLY_TO_MULORG") + ":(");
            FullOrgUnitCollection orgUnitColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name where id in (" + ToolUtils.aryToStr(orgList) + ")");
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                sb.append(orgUnitColl.get(i).getName());
                sb.append(i == orgUnitColl.size() - 1 ? " " : ",");
            }
            sb.append(")");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sb.toString();
    }
}

