/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.AssignTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.AuthenRecordInfo;
import com.kingdee.eas.base.permission.AuthenStatusEnum;
import com.kingdee.eas.base.permission.GrantUserRoleOrgChangeFactory;
import com.kingdee.eas.base.permission.GrantUserRoleOrgChangeInfo;
import com.kingdee.eas.base.permission.OprtTypeEnum;
import com.kingdee.eas.base.permission.PermChangeRecordInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgChangeFactory;
import com.kingdee.eas.base.permission.UserRoleOrgChangeInfo;
import com.kingdee.eas.base.permission.app.AbstractBaseAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserAssignRoleAuthenRecordAuthen
extends AbstractBaseAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserAssignRoleAuthenRecordAuthenImpl");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private int MAX_RECORD_COUNT = 8000;
    private final String ROLE_TO_USER_MAP = "role2UserMap";
    private final String ROLE_TO_RULE = "role2Rule";
    private Context ctx;

    @Override
    protected String getDescription() {
        return EASResource.getString((String)RESOURCE, (String)"AUTHEN_CREATE_TASK");
    }

    public UserAssignRoleAuthenRecordAuthen(Context ctx) {
        this.ctx = ctx;
    }

    public List<String> createAuthen(Context ctx, OprtTypeEnum oprtType, UserInfo userInfo, String orgID, UserInfo currentUser, List roleIds) throws BOSException, EASBizException {
        ArrayList<String> opRoleIds = new ArrayList<String>();
        opRoleIds.addAll(roleIds);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Map role2UserSetMap = this.getNeedAuthenRole2UserSetMap(conn, opRoleIds, orgID);
            if (role2UserSetMap.isEmpty()) {
                ArrayList<String> arrayList = opRoleIds;
                return arrayList;
            }
            opRoleIds.removeAll(role2UserSetMap.keySet());
            this.dealNeedAuthenRoles(ctx, conn, oprtType, role2UserSetMap, userInfo, currentUser, orgID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return opRoleIds;
    }

    private Map getNeedAuthenRole2UserSetMap(Connection conn, List roleIds, String orgId) throws BOSException {
        HashMap hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("SELECT asu.FUSERID userid ,rp.froleid roleid FROM  t_pm_authenschemeorguser asu inner join t_pm_authenschemeperm aspm ").append(" on asu.fauthenschemeid = aspm.fauthenschemeid inner join t_pm_roleperm rp on aspm.fpermitemid = rp.fpermitemid ").append(" where rp.froleid in(" + ToolUtils.aryToStr(roleIds) + ") and asu.forgid =? group by asu.FUSERID,rp.froleid");
            preparedStatement = conn.prepareStatement(querySql.toString());
            preparedStatement.setString(1, orgId);
            resultSet = preparedStatement.executeQuery();
            HashMap role2UserMap = new HashMap();
            while (resultSet.next()) {
                String roleId = resultSet.getString("roleid");
                String userId = resultSet.getString("userid");
                HashSet<String> userIdSet = (HashSet<String>)role2UserMap.get(roleId);
                if (userIdSet != null) {
                    if (userIdSet.contains(userId)) continue;
                    userIdSet.add(userId);
                    continue;
                }
                userIdSet = new HashSet<String>();
                userIdSet.add(userId);
                role2UserMap.put(roleId, userIdSet);
            }
            hashMap = role2UserMap;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
        return hashMap;
    }

    private void dealNeedAuthenRoles(Context ctx, Connection conn, OprtTypeEnum operateType, Map role2UserSetMap, UserInfo userInfo, UserInfo currentUser, String orgID) throws BOSException, EASBizException {
        Set<String> roleIds = role2UserSetMap.keySet();
        String permChangeId = this.createPermChangeRecord(ctx, currentUser, operateType, userInfo);
        String changeTable = "T_PM_UserRoleOrgchange";
        if (operateType.equals((Object)OprtTypeEnum.AssignRoleToUser)) {
            this.createNormalChangeRecord(ctx, permChangeId, userInfo, orgID, roleIds);
        } else {
            this.createGrantChangeRecord(ctx, permChangeId, userInfo, orgID, roleIds);
            changeTable = "T_PM_GrantUserRoleOrgChange";
        }
        HashSet<String> allUserIdSet = new HashSet<String>();
        for (String roleId : roleIds) {
            Set userIdSet = (Set)role2UserSetMap.get(roleId);
            if (userIdSet == null) continue;
            allUserIdSet.addAll(userIdSet);
        }
        this.createAuthenRecord(ctx, permChangeId, allUserIdSet, orgID);
        this.insertAuthenSnapViewInfo(conn, changeTable, permChangeId, orgID);
        AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, allUserIdSet);
    }

    private void createNormalChangeRecord(Context ctx, String permChangeId, UserInfo userInfo, String orgId, Set<String> rolesId) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (String roleId : rolesId) {
            UserRoleOrgChangeInfo changeInfo = new UserRoleOrgChangeInfo();
            PermChangeRecordInfo permChangeInfoId = new PermChangeRecordInfo();
            permChangeInfoId.setId(BOSUuid.read((String)permChangeId));
            changeInfo.setPermChange(permChangeInfoId);
            changeInfo.setUser(userInfo);
            changeInfo.setAssignType(AssignTypeEnum.AddNew);
            RoleInfo roleInfoId = new RoleInfo();
            roleInfoId.setId(BOSUuid.read((String)roleId));
            changeInfo.setRole(roleInfoId);
            FullOrgUnitInfo orgInfoId = new FullOrgUnitInfo();
            orgInfoId.setId(BOSUuid.read((String)orgId));
            changeInfo.setOrg(orgInfoId);
            changeInfo.setAuthenStatus(AuthenStatusEnum.UnAuthen);
            colls.add((CoreBaseInfo)changeInfo);
        }
        UserRoleOrgChangeFactory.getLocalInstance(ctx).addnewBatchData(colls);
    }

    private void createGrantChangeRecord(Context ctx, String permChangeId, UserInfo userInfo, String orgId, Set<String> rolesId) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (String roleId : rolesId) {
            GrantUserRoleOrgChangeInfo changeInfo = new GrantUserRoleOrgChangeInfo();
            PermChangeRecordInfo permChangeInfoId = new PermChangeRecordInfo();
            permChangeInfoId.setId(BOSUuid.read((String)permChangeId));
            changeInfo.setPermChange(permChangeInfoId);
            changeInfo.setUser(userInfo);
            changeInfo.setAssignType(AssignTypeEnum.AddNew);
            RoleInfo roleInfoId = new RoleInfo();
            roleInfoId.setId(BOSUuid.read((String)roleId));
            changeInfo.setRole(roleInfoId);
            FullOrgUnitInfo orgInfoId = new FullOrgUnitInfo();
            orgInfoId.setId(BOSUuid.read((String)orgId));
            changeInfo.setOrg(orgInfoId);
            changeInfo.setAuthenStatus(AuthenStatusEnum.UnAuthen);
            colls.add((CoreBaseInfo)changeInfo);
        }
        GrantUserRoleOrgChangeFactory.getLocalInstance(ctx).addnewBatchData(colls);
    }

    private void createAuthenRecord(Context ctx, String permChangeId, Set<String> userIds, String orgId) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (String userId : userIds) {
            AuthenRecordInfo info = new AuthenRecordInfo();
            PermChangeRecordInfo permChangeInfoId = new PermChangeRecordInfo();
            permChangeInfoId.setId(BOSUuid.read((String)permChangeId));
            info.setPermChange(permChangeInfoId);
            info.setAuthenStatus(AuthenStatusEnum.UnAuthen);
            UserInfo UserInfoId = new UserInfo();
            UserInfoId.setId(BOSUuid.read((String)userId));
            info.setAuthentor(UserInfoId);
            FullOrgUnitInfo Cu = (FullOrgUnitInfo)ContextUtils.getContextFromSession().get((Object)"CurOU");
            info.setCu(Cu);
            colls.add((CoreBaseInfo)info);
        }
        AuthenRecordFactory.getLocalInstance(ctx).addnewBatchData(colls);
    }

    private void insertAuthenSnapViewInfo(Connection con, String changeTableName, String permChangeId, String targetOrgId) throws BOSException {
        PreparedStatement insertStatement = null;
        try {
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_authenschemesnapview(fid, froleid, fuserid, fpermitemid, fpermchangerecordid, fisrule) ").append(" select newbosid('38B94EC5'),t.froleid ,t.fauthentorid ,fpermitemid,'" + permChangeId + "',t.fisrule  from (").append("select distinct roc.FROLEID as froleid,rp.fpermitemid as fpermitemid,asou.FUSERID as fauthentorid,authenrule.FISRULE as fisrule").append(" from ").append(changeTableName).append(" roc  inner join T_PM_RolePerm rp  on roc.FROLEID = rp.FROLEID").append(" inner join t_pm_authenschemeperm as schemeperm  on rp.fpermitemid = schemeperm.fpermitemid").append(" inner join t_pm_authenschemeorguser as asou  on schemeperm.fauthenschemeid = asou.fauthenschemeid and roc.FORGID = asou.FORGID").append(" inner join t_pm_authenschemerule as authenrule on asou.fauthenschemeid = authenrule.fauthenschemeid and  asou.forgid = authenrule.forgid").append(" where roc.FPERMCHANGEID =? and roc.FORGID =? )  t");
            insertStatement = con.prepareStatement(insertSql.toString());
            insertStatement.setString(1, permChangeId);
            insertStatement.setString(2, targetOrgId);
            insertStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertStatement);
    }

    @Override
    protected ResultSet queryNeedAuthenResultSet(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer queryAllCanAuthenRoleInfo = new StringBuffer();
            queryAllCanAuthenRoleInfo.append("select change.froleid roleid,snapview.fpermitemid fpermitemid,snapview.fisrule isrule, ").append("snapview.fuserid userid ").append("from t_pm_userroleorgchange as change ").append("inner join t_pm_authenschemesnapview as snapview on change.fpermchangeid = snapview.fpermchangerecordid and change.froleid = snapview.froleid ").append("inner join t_pm_authenrecord as record on record.fpermchangeid = change.fpermchangeid and record.fauthentorid = snapview.fuserid ").append("where change.fauthenstatus = ? and ").append("record.fauthenstatus = ? and ").append("snapview.fpermchangerecordid = ? order by roleid,fpermitemid");
            queryStatement = conn.prepareStatement(queryAllCanAuthenRoleInfo.toString());
            queryStatement.setString(1, "10");
            queryStatement.setString(2, "10");
            queryStatement.setString(3, permChangeId);
            resultSet = queryStatement.executeQuery();
            return resultSet;
        }
        catch (Exception e) {
            SQLUtils.cleanup(resultSet, queryStatement);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map getInformation(ResultSet resultSet) throws BOSException {
        try {
            HashMap<String, HashSet<String>> role2UserMap = new HashMap<String, HashSet<String>>();
            HashMap<String, Boolean> role2Rule = new HashMap<String, Boolean>();
            while (resultSet.next()) {
                String roleId = resultSet.getString("roleid");
                String fpermitemid = resultSet.getString("fpermitemid");
                boolean rule = resultSet.getBoolean("isrule");
                String userId = resultSet.getString("userid");
                HashSet<String> userIdSet = (HashSet<String>)role2UserMap.get(roleId + "," + fpermitemid);
                if (userIdSet == null) {
                    userIdSet = new HashSet<String>();
                    role2UserMap.put(roleId + "," + fpermitemid, userIdSet);
                }
                userIdSet.add(userId);
                role2Rule.put(roleId + "," + fpermitemid, rule);
            }
            HashMap<String, HashMap<String, Serializable>> information = new HashMap<String, HashMap<String, Serializable>>();
            information.put("role2UserMap", role2UserMap);
            information.put("role2Rule", role2Rule);
            return information;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Set getPassSet(Map information, String currentUserId) {
        Map role2UserMap = (Map)information.get("role2UserMap");
        Map role2Rule = (Map)information.get("role2Rule");
        Set roleKeySet = role2UserMap.keySet();
        HashSet<String> roleIdSet = new HashSet<String>();
        String curRole = "";
        boolean rolePermIsAllPass = true;
        for (Object roleIdObj : roleKeySet) {
            String rolePerm = (String)roleIdObj;
            String[] rolePermA = rolePerm.split(",");
            String roleId = rolePermA[0];
            if (!curRole.equals(roleId)) {
                if (rolePermIsAllPass && curRole != "") {
                    roleIdSet.add(curRole);
                }
                rolePermIsAllPass = true;
                curRole = roleId;
            }
            boolean rule = (Boolean)role2Rule.get(roleIdObj);
            Set userIdSet = (Set)role2UserMap.get(roleIdObj);
            if (!userIdSet.contains(currentUserId)) {
                rolePermIsAllPass = false;
                continue;
            }
            if (!rule || userIdSet.size() == 1) continue;
            rolePermIsAllPass = false;
        }
        if (rolePermIsAllPass && curRole != "") {
            roleIdSet.add(curRole);
        }
        return roleIdSet;
    }

    @Override
    protected void updatePassData(Connection conn, Set passSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        PreparedStatement insertStatement = null;
        PreparedStatement updateStatement = null;
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select change.fuserid, change.forgid, change.froleid ").append("from t_pm_userroleorgchange as change ").append("where change.fpermchangeid = ? and ").append("not exists (").append("select 1 ").append("from t_pm_userroleorg uro ").append("where uro.fuserid = change.fuserid and ").append("uro.forgid = change.forgid and ").append("uro.froleid = change.froleid").append(")  ");
            queryStatement = conn.prepareStatement(querySql.toString());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_userroleorg(fuserid, forgid, froleid)values(?,?,?) ");
            insertStatement = conn.prepareStatement(insertSql.toString());
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_pm_userroleorgchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("froleid = ?");
            updateStatement = conn.prepareStatement(updateSql.toString());
            int count = 0;
            queryStatement.setString(1, permChangeId);
            ResultSet rs = queryStatement.executeQuery();
            while (rs.next()) {
                String fuserid = rs.getString("fuserid");
                String forgid = rs.getString("forgid");
                String froleid = rs.getString("froleid");
                if (passSet.contains(froleid)) {
                    insertStatement.setString(1, fuserid);
                    insertStatement.setString(2, forgid);
                    insertStatement.setString(3, froleid);
                    insertStatement.addBatch();
                    ArrayList<String> roleids = new ArrayList<String>();
                    roleids.add(froleid);
                    try {
                        GroupLicenseUseInfoUtil.assignRoles(this.ctx, fuserid, roleids);
                    }
                    catch (EASBizException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                updateStatement.setString(1, "20");
                updateStatement.setString(2, permChangeId);
                updateStatement.setString(3, froleid);
                updateStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                insertStatement.executeBatch();
                insertStatement.clearBatch();
                updateStatement.executeBatch();
                updateStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                insertStatement.executeBatch();
                insertStatement.clearBatch();
                updateStatement.executeBatch();
                updateStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertStatement);
                SQLUtils.cleanup(updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertStatement);
        SQLUtils.cleanup((Statement)updateStatement);
    }

    @Override
    protected Set getNoPassSet(Map information, String currentUserId) {
        Map role2UserMap = (Map)information.get("role2UserMap");
        Map role2Rule = (Map)information.get("role2Rule");
        Set roleKeySet = role2UserMap.keySet();
        HashSet roleIdSet = new HashSet();
        Set userIdSet = null;
        boolean rule = false;
        for (Object roleIdObj : roleKeySet) {
            userIdSet = (Set)role2UserMap.get(roleIdObj);
            if (!userIdSet.contains(currentUserId)) continue;
            roleIdSet.add(roleIdObj);
        }
        return roleIdSet;
    }

    @Override
    protected void updateNoPassData(Connection conn, Set noPassSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_userroleorgchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("froleid = ?");
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            int count = 0;
            for (Object roleIdObj : noPassSet) {
                updateAuthenStatusStatement.setString(1, "30");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, roleIdObj);
                updateAuthenStatusStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }
}

