/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AbstractUserInfo;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AdvancedPermissionServiceFactory;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.ErpUserStatus;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IOrgRangeSolution;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgCollection;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionLogHelper;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCertifyRecordInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserGroupGFacadeFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLockTypeEnum;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.UserUpdateParam;
import com.kingdee.eas.base.permission.app.AbstractUserControllerBean;
import com.kingdee.eas.base.permission.app.UserControllerHelper;
import com.kingdee.eas.base.permission.app.agentuser.PersonHelper;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.permission.app.util.UserLogUtil;
import com.kingdee.eas.base.permission.app.util.interior.permgroup.UserPermChangeListener;
import com.kingdee.eas.base.permission.ldap.LdapProxy;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.MyEntityInfo;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.base.permission.util.SMSValidataUserManagerUtil;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.base.permission.util.cloud.activiation.UserNoActiviationHelper;
import com.kingdee.eas.base.permission.util.cloud.kbc.CloudLicenseUtil;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.KickoutFacadeFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPositionAdmin;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.IPositionRole;
import com.kingdee.eas.basedata.org.PositionAdminCollection;
import com.kingdee.eas.basedata.org.PositionAdminFactory;
import com.kingdee.eas.basedata.org.PositionAdminInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.PositionRoleCollection;
import com.kingdee.eas.basedata.org.PositionRoleFactory;
import com.kingdee.eas.basedata.org.PositionRoleInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class UserControllerBean
extends AbstractUserControllerBean {
    private static Logger logger = Logger.getLogger(UserControllerBean.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String personCanReferenceManyUser = null;

    @Override
    protected UserInfo _getUserByID(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
        return this.getUserInfo(ctx, objectPK);
    }

    private String getSQLForForbid(String id, boolean forbidden) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("UPDATE T_PM_User SET FForbidden = ").append(forbidden ? 1 : 0);
        sbSQL.append(" ,flastupdatetime={ts'").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append("'}");
        sbSQL.append(" WHERE FID = '").append(id).append("'");
        return sbSQL.toString();
    }

    @Override
    protected void _forbidUsers(Context ctx, IObjectPK[] users, boolean forbidden) throws BOSException, EASBizException {
        this._getPermItemsByUser(ctx, "");
        Connection conn = null;
        Statement statement = null;
        ArrayList<String> usersId = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (int i = 0; i < users.length; ++i) {
                statement.addBatch(this.getSQLForForbid(users[i].toString(), forbidden));
                usersId.add(users[i].toString());
            }
            statement.executeBatch();
            GroupLicenseUseInfoUtil.forbidUsers(ctx, usersId, forbidden);
            if (forbidden) {
                this.deleteUserSession(ctx, users);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new UserException(UserException.USER_SAVE_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PermItemCollection _getPermItemsByUser(Context ctx, String userPK) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        PermItemCollection permItemCol = null;
        sql.append("select fpermitemid from t_pm_userorgperm uop where fowner = '").append(userPK).append("' union all select rm.fpermitemid fpermitemid from t_pm_roleperm rm where exists(select 1 from t_pm_userroleorg urg where  rm.froleid = urg.froleid  and urg.fuserid = '").append(userPK).append("')");
        HashSet<String> permItemSet = new HashSet<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                permItemSet.add(rs.getString("fpermitemid"));
            }
            permItemCol = PermItemFactory.getLocalInstance(ctx).getPermItemCollection("where id in(" + ToolUtils.aryToStr(permItemSet) + ")");
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("=============_getPermItemsByUser=============" + e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return permItemCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updatePass(Context ctx, IObjectPK userPK, String oldPW, String newPW) throws BOSException, EASBizException {
        Object[] params = new Object[]{ctx.getUserName()};
        String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"changePassword", (java.util.Locale)ctx.getLocale()), params);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"UserControllerBean_updatePass()", (BOSObjectType)this.getBOSType(), null, (String)msg, (String)"bs_permission_change_psssword");
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("security.*"));
        ORMCacheUtil.getInstance().removeInfosByBosType(ctx, new BOSObjectType("13B7DE7F"));
        UserInfo userInfo = this.getUserInfo(ctx, userPK, sc);
        oldPW = PermissionUtil.decrypt(userInfo.getNumber(), oldPW);
        newPW = PermissionUtil.decrypt(userInfo.getNumber(), newPW);
        SecurityValidator.checkUserUpdatePw(userPK.toString(), newPW);
        Boolean isMatch = null;
        try {
            int goneMinutes;
            int lockedMinutes = userInfo.getSecurity().getLockUpdatePwTime();
            if (userInfo.isIsLocked() && userInfo.getErrUpdatePwLastTime() != null && lockedMinutes > (goneMinutes = (int)((System.currentTimeMillis() - userInfo.getErrUpdatePwLastTime().getTime()) / 60000L))) {
                if (UserLockTypeEnum.UPDATE_PASSWORD.equals((Object)userInfo.getLockType())) {
                    throw new UserException(UserException.USER_IS_LOCKED_BY_UPDATEPW, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
                }
                throw new UserException(UserException.USER_IS_LOCKED, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
            }
            if (userInfo.getSecurity() == null) {
                throw new UserException(UserException.USER_NOT_SECURITY);
            }
            boolean canChangePW = userInfo.getSecurity().isPasswordCanChg();
            boolean selfChangePW = userInfo.getSecurity().isExpiredPassCanChg();
            boolean isPassExpired = PermissionCommonUtil.isPassExpired(userInfo);
            boolean isAdmin = Administrator.isCUAdmin(ctx, ctx.getCaller());
            if (!canChangePW) {
                throw new SecurityException(SecurityException.PASSWORD_CAN_NOT_CHANGE);
            }
            if (!isAdmin && !selfChangePW && isPassExpired) {
                throw new SecurityException(SecurityException.PASSWORD_CAN_NOT_CHANGE);
            }
            isMatch = PermissionUtil.matchPassword(userInfo, oldPW);
            if (!isMatch.booleanValue()) {
                throw new UserException(UserException.OLD_PASSWORD_ERROR);
            }
            userInfo.setPassword(newPW);
            SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
            securityValidator.validate();
            if (StringUtils.isEmpty((String)userInfo.getPassword())) {
                userInfo.setPassword(null);
            } else {
                PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
                userInfo.setPassword(PermissionUtil.encrypt(userPK.toString(), newPW, passwordType));
                userInfo.setPasswordType(passwordType);
            }
            userInfo.setPWEffectiveDate(new Date());
            userInfo.setChangedPW(true);
            this.checkPwSameBefore(userInfo);
            if (userInfo.isIsLocked()) {
                userInfo.setIsLocked(false);
                userInfo.setErrUpdatePwCount(0);
                userInfo.setLockType(UserLockTypeEnum.NONE);
                userInfo.setLockedTime(null);
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"USER_UPDATE_PWD", (java.util.Locale)ctx.getLocale()), (BOSObjectType)userInfo.getBOSType(), null, (String)this.getUpdatePasswordLogDetail(ctx, userInfo), (String)"bs_permission_user_update_password");
            super._update(ctx, userPK, (IObjectValue)userInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            LdapProxy ldapProxy = new LdapProxy(ctx);
            ldapProxy.submit(userPK.toString(), newPW);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            this.kickOutUserAfterChangePW(ctx, userInfo);
        }
        catch (Throwable throwable) {
            try {
                if (!userInfo.isIsLocked()) {
                    UserFactory.getLocalInstance(ctx).checkLockUserWhenUpdatePw(userInfo, isMatch);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (!userInfo.isIsLocked()) {
                UserFactory.getLocalInstance(ctx).checkLockUserWhenUpdatePw(userInfo, isMatch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUpdatePasswordLogDetail(Context ctx, UserInfo userInfo) {
        String userNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
        return PermissionLogHelper.getLogInstanceDetail("logUpdatePassword", new Object[]{userNumber, userInfo.getNumber()});
    }

    @Override
    protected void _checkLockUserWhenUpdatePw(Context ctx, UserInfo userInfo, Boolean isMatch) throws BOSException, EASBizException {
        String userIdStr = userInfo.getId().toString();
        if (isMatch == null || isMatch.booleanValue() || "00000000-0000-0000-0000-00000000000013B7DE7F".equals(userIdStr)) {
            return;
        }
        if (userInfo.getSecurity().isNeedUpdatePwLocked()) {
            String sql = null;
            if (userInfo.getSecurity().getLockUpdatePwCount() <= userInfo.getErrUpdatePwCount() + 1) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String datetime = formatter.format(new Date());
                Object[] params = new Object[]{datetime, datetime, userIdStr};
                sql = "UPDATE T_PM_User SET FErrUpdatePwLastTime=to_date(?),FLockedTime=to_date(?),FIsLocked=1,FErrUpdatePwCount=FErrUpdatePwCount + 1,FLockType = 2 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                ArrayList<String> userIds = new ArrayList<String>(1);
                userIds.add(userIdStr);
                UserLogUtil.log(ctx, userIds, 2);
            } else {
                Object[] params = new Object[]{userIdStr};
                sql = "UPDATE T_PM_User SET FErrUpdatePwCount = FErrUpdatePwCount + 1 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
        }
    }

    private void checkPwSameBefore(UserInfo userInfo) throws UserException {
        SecurityInfo securityInfo = userInfo.getSecurity();
        if (securityInfo == null) {
            return;
        }
        if (securityInfo != null && securityInfo.isEnableRepeatPw()) {
            String userPassword = userInfo.getPassword();
            if (userPassword == null) {
                userPassword = "";
            }
            if (this.isSameBeforePw(securityInfo.getRepeatTimes(), userInfo.getPwdHisStr(), userPassword)) {
                throw new UserException(UserException.PW_SAME_BEFORE, new Object[]{securityInfo.getRepeatTimes()});
            }
            this.savePwHis(userInfo, securityInfo.getRepeatTimes(), securityInfo.isEnableRepeatPw(), userPassword);
        }
    }

    private void savePwHis(UserInfo userInfo, int time, boolean enableRepeat, String newPwd) {
        if (!enableRepeat) {
            userInfo.setPwdHisStr("");
        }
        if (StringUtils.isEmpty((String)userInfo.getPwdHisStr())) {
            userInfo.setPwdHisStr(newPwd);
        }
        String hisPwdStr = newPwd + "," + userInfo.getPwdHisStr();
        String[] hisPwdAry = StringUtils.split((String)hisPwdStr, (String)",");
        userInfo.setPwdHisStr(ToolUtils.aryToStr(hisPwdAry, time));
    }

    private boolean isSameBeforePw(int time, String hisPwStr, String nowPw) {
        if (time < 1) {
            return false;
        }
        if (StringUtils.isEmpty((String)hisPwStr)) {
            return false;
        }
        String[] pwStr = StringUtils.split((String)hisPwStr, (String)",");
        if (time > pwStr.length) {
            if (hisPwStr.indexOf(nowPw) != -1) {
                return true;
            }
        } else {
            for (int i = 0; i < time; ++i) {
                if (!pwStr[i].equals(nowPw)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void _lockUsers(Context ctx, IObjectPK[] userPKs, boolean lock) throws BOSException, EASBizException {
        Statement statement;
        Connection conn;
        block6: {
            conn = null;
            statement = null;
            ArrayList<String> usersId = new ArrayList<String>();
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.createStatement();
                for (int i = 0; i < userPKs.length; ++i) {
                    statement.addBatch(this.getSQLForLock(userPKs[i].toString(), lock));
                    usersId.add(userPKs[i].toString());
                }
                statement.executeBatch();
                if (lock) {
                    UserLogUtil.log(ctx, usersId, 2);
                    break block6;
                }
                UserLogUtil.log(ctx, usersId, 3);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new UserException(UserException.USER_SAVE_FAIL, e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private String getSQLForLock(String id, boolean lock) {
        StringBuffer sbSQL = new StringBuffer();
        if (lock) {
            sbSQL.append("UPDATE T_PM_User SET FIsLocked =").append(lock ? 1 : 0).append(" WHERE FID = '").append(id).append("'");
        } else {
            sbSQL.append("UPDATE T_PM_User SET FIsLocked =").append(lock ? 1 : 0).append(" , FLockedTime = NULL, FErrCount = 0 , FErrUpdatePwLastTime = NULL, FErrUpdatePwCount = 0 WHERE FID = '").append(id).append("'");
        }
        return sbSQL.toString();
    }

    @Override
    protected void _update(Context ctx, IObjectPK userPK, IObjectValue model, boolean isUpdatePW, boolean isUpdateOrgRange) throws BOSException, EASBizException {
        UserUpdateParam param = new UserUpdateParam();
        param.setUpdateOrgRange(isUpdateOrgRange);
        param.setUpdatePW(isUpdatePW);
        this._update(ctx, userPK, model, param);
    }

    @Override
    protected void _update(Context ctx, IObjectPK userPK, IObjectValue model, boolean isUpdatePW) throws BOSException, EASBizException {
        this._update(ctx, userPK, model, isUpdatePW, false);
    }

    private void handleCuSwitch(Context ctx, UserInfo userInfo, boolean isDeleteOldPerm, String oldCuId) throws BOSException, EASBizException {
        OrgRangeParam orgRangeParam;
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ArrayList<String> oldCuIdCol = new ArrayList<String>();
        oldCuIdCol.add(oldCuId);
        ArrayList<String> defaultOrgIdCol = new ArrayList<String>();
        defaultOrgIdCol.add(userInfo.getDefOrgUnit().getId().toString());
        if (isDeleteOldPerm) {
            orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, oldCuIdCol, null, null);
            iOrgRange.saveOrgRange(orgRangeParam);
            this.deleteRelativePermAndRole(ctx, (IObjectPK)userPK, ToolUtils.aryToStr(oldCuIdCol));
        }
        orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, defaultOrgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
    }

    private void handleTypeSwitch(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        this.deleteAllAdminOrgRange(ctx, userInfo);
    }

    private void addAdminOrgRangeForPerson(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        List removedSubOrgFidList;
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PositionCollection positionCol = iPerson.getPositions(userInfo.getPerson().getId());
        if (positionCol == null || positionCol.isEmpty()) {
            return;
        }
        ArrayList<String> orgLongNumberList = new ArrayList<String>();
        ArrayList<String> orgFidList = new ArrayList<String>();
        for (int i = 0; i < positionCol.size(); ++i) {
            PositionInfo positionInfo = positionCol.get(i);
            AdminOrgUnitInfo adminInfo = positionInfo.getAdminOrgUnit();
            if (positionInfo.isIsRespPosition() && adminInfo != null) {
                if (StringUtils.isEmpty((String)adminInfo.getLongNumber())) {
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    adminInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminInfo.getId().toString()));
                }
                orgLongNumberList.add(adminInfo.getLongNumber());
                continue;
            }
            if (adminInfo == null) continue;
            orgFidList.add(adminInfo.getId().toString());
        }
        this.removeSuborgLongnumber(orgLongNumberList);
        StringBuffer longnumberLikeSql = new StringBuffer();
        StringBuffer longnumberEqualSql = new StringBuffer();
        StringBuffer fidInSql = new StringBuffer();
        if (orgLongNumberList != null && orgLongNumberList.size() > 0) {
            for (int i = 0; i < orgLongNumberList.size(); ++i) {
                longnumberLikeSql.append(" OR FLONGNUMBER LIKE '").append(orgLongNumberList.get(i)).append("!%' ");
                longnumberEqualSql.append(" OR FLONGNUMBER ='").append(orgLongNumberList.get(i)).append("' ");
            }
        }
        if ((removedSubOrgFidList = this.getRemovedSuborgFidList(ctx, orgLongNumberList, orgFidList)) != null && removedSubOrgFidList.size() > 0) {
            fidInSql.append(" OR FID IN (");
            fidInSql.append(ToolUtils.aryToStr(removedSubOrgFidList)).append(")");
        }
        LogProxy logProxy = new LogProxy();
        String conditionSql = "WHERE 1=0 " + longnumberLikeSql.toString() + longnumberEqualSql.toString() + fidInSql.toString();
        Thread logAndInsertThread = new Thread(new LogThread(ctx, logProxy, (IObjectPK)userPK, conditionSql));
        logAndInsertThread.start();
        this.insertOrgRange(ctx, userPK.toString(), conditionSql.toString());
        this.insertOrgRangeIncludesuborg(ctx, userPK.toString(), longnumberEqualSql.toString(), fidInSql.toString());
        logProxy.end();
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection pmc = iPositionMember.getPositionMemberCollection("where person.id = '" + userInfo.getPerson().getId().toString() + "'");
        for (int i = 0; i < pmc.size(); ++i) {
            this.addUserOrgRange(ctx, pmc.get(i), userInfo);
        }
    }

    private void addUserOrgRange(Context ctx, PositionMemberInfo info, UserInfo userInfo) throws EASBizException, BOSException {
        IPositionAdmin iPositionAdmin;
        PositionAdminCollection positionAdminCollection;
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(userInfo.getId().toString());
        IPositionRole iPositionRole = PositionRoleFactory.getLocalInstance((Context)ctx);
        String sqlString = "select id ,position.id ,position.number ,role.id ,role.number ,orgUnit.id ,orgUnit.number where position.id = '" + info.getPosition().getId().toString() + "' and deletedStatus = 1";
        PositionRoleCollection positionRoleCollection = iPositionRole.getPositionRoleCollection(sqlString);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance(ctx);
        if (positionRoleCollection.size() != 0) {
            for (int i = 0; i < positionRoleCollection.size(); ++i) {
                PositionRoleInfo positionRoleInfo = positionRoleCollection.get(i);
                BOSUuid orgId = positionRoleInfo.getOrgUnit().getId();
                BOSUuid roleId = positionRoleInfo.getRole().getId();
                ArrayList<String> addCuList = new ArrayList<String>();
                addCuList.add(orgId.toString());
                ArrayList<BOSUuid> roleList = new ArrayList<BOSUuid>();
                roleList.add(roleId);
                iOrgRange.addOrgRangeBatch(userIdList, addCuList, OrgRangeType.BIZ_ORG_TYPE);
                UserRoleOrgManagerFactory.getLocalInstance(ctx).batchSaveUsersRolePerm(userIdList, addCuList, roleList, null);
            }
        }
        if ((positionAdminCollection = (iPositionAdmin = PositionAdminFactory.getLocalInstance((Context)ctx)).getPositionAdminCollection(sqlString = "select id ,position.id ,position.number ,adminOrgUnit.id ,adminOrgUnit.number ,isIncludeSub where position.id = '" + info.getPosition().getId().toString() + "' and deletedStatus = 1")).size() != 0) {
            ArrayList<String> addAdminList = new ArrayList<String>();
            ArrayList<String> addAdminSubList = new ArrayList<String>();
            for (int i = 0; i < positionAdminCollection.size(); ++i) {
                PositionAdminInfo positionAdminInfo = positionAdminCollection.get(i);
                String orgIdString = positionAdminInfo.getAdminOrgUnit().getId().toString();
                if (positionAdminInfo.isIsIncludeSub()) {
                    if (addAdminSubList.contains(orgIdString)) continue;
                    addAdminSubList.add(orgIdString);
                    continue;
                }
                if (addAdminList.contains(orgIdString)) continue;
                addAdminList.add(orgIdString);
            }
            if (addAdminList.size() > 0) {
                iOrgRange.addOrgRangeBatch(userIdList, addAdminList, OrgRangeType.ADMIN_ORG_TYPE);
            }
            if (addAdminSubList.size() > 0) {
                OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).addAdminOrgRangeByPosition(userIdList, addAdminSubList, true);
            }
        }
    }

    private List getRemovedSuborgFidList(Context ctx, List orgLongNumberList, List orgFidList) throws BOSException, EASBizException {
        if (orgFidList == null || orgFidList.size() <= 0) {
            return null;
        }
        String orgFidStr = ToolUtils.aryToStr(orgFidList);
        AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select id,longnumber where id in(" + orgFidStr + ")");
        for (int i = 0; i < adminOrgColl.size(); ++i) {
            AdminOrgUnitInfo adminInfo = adminOrgColl.get(i);
            if (orgLongNumberList == null || orgLongNumberList.size() <= 0 || adminInfo.getLongNumber() == null) continue;
            for (int j = 0; j < orgLongNumberList.size(); ++j) {
                if (!orgLongNumberList.get(j).toString().equals(adminInfo.getLongNumber()) && !adminInfo.getLongNumber().startsWith(orgLongNumberList.get(j).toString() + "!")) continue;
                orgFidList.remove(adminInfo.getId().toString());
            }
        }
        return orgFidList;
    }

    private void removeSuborgLongnumber(List orgLongNumberList) {
        ArrayList beRemoveList = new ArrayList();
        block0: for (int i = 0; i < orgLongNumberList.size(); ++i) {
            for (int j = 0; j < orgLongNumberList.size(); ++j) {
                if (orgLongNumberList.get(i).equals(orgLongNumberList.get(j)) || !orgLongNumberList.get(i).toString().startsWith(orgLongNumberList.get(j).toString())) continue;
                beRemoveList.add(orgLongNumberList.get(i));
                continue block0;
            }
        }
        orgLongNumberList.removeAll(beRemoveList);
    }

    private void insertOrgRange(Context ctx, String userId, String conditionSql) throws BOSException {
        String sql = "INSERT INTO T_PM_OrgRange (FID, FUserID, FOrgID, FType)  SELECT NEWBOSID('FD3DC16D'),'" + userId + "',FID," + 20 + " FROM T_ORG_ADMIN " + conditionSql.toString();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void insertOrgRangeIncludesuborg(Context ctx, String userId, String longnumberEqualSql, String fidInSql) throws BOSException {
        String sql = "INSERT INTO T_PM_OrgRangeincludesuborg (FID, FUserID, FOrgID, FType, FIsIncludeSubOrg)  SELECT NEWBOSID('4DC3DADF'),'" + userId + "',FID," + 20 + ",1 FROM T_ORG_ADMIN WHERE 1=0 " + longnumberEqualSql;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "INSERT INTO T_PM_OrgRangeincludesuborg (FID, FUserID, FOrgID, FType, FIsIncludeSubOrg)  SELECT NEWBOSID('4DC3DADF'),'" + userId + "',FID," + 20 + ",0 FROM T_ORG_ADMIN admin1 WHERE (1=0 " + fidInSql + ") and NOT EXISTS (select 1 from T_PM_OrgRangeincludesuborg range  where range.ftype=" + 20 + " and range.FIsIncludeSubOrg =1 and  range.fuserid='" + userId + "' and range.forgid=admin1.fid)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void beginLog(Context ctx, LogProxy logProxy, IObjectPK userPK, String conditionSql) throws BOSException, EASBizException {
        java.util.Locale l = ContextUtils.getLocaleFromEnv();
        String methodName = EASCommonResource.getString((String)RESOURCE, (String)"OrgRangeDeal", (java.util.Locale)l);
        BOSObjectType bizObjType = new UserInfo().getBOSType();
        IObjectPK instancePK = userPK;
        StringBuffer detail = new StringBuffer();
        String add4Log = EASCommonResource.getString((String)RESOURCE, (String)"add4Log", (java.util.Locale)l);
        String user = EASCommonResource.getString((String)RESOURCE, (String)"user", (java.util.Locale)l);
        String orgRangeType = EASCommonResource.getString((String)RESOURCE, (String)"OrgRangeType", (java.util.Locale)l);
        UserInfo userInfo = CacheUtil.getCacheUserInfo(ctx, userPK.toString());
        String userNumber = userInfo.getNumber();
        detail.append(methodName + "\n");
        detail.append(user + ":" + userNumber + "\n");
        detail.append(orgRangeType + ":" + OrgRangeType.ADMIN_ORG_TYPE.getAlias() + "\n");
        detail.append(add4Log + ":\n");
        detail.append(ToolUtils.aryToStr(this.getOrgNumberByCondition(ctx, conditionSql))).append("\n");
        logProxy.beginLog(ctx, methodName, bizObjType, instancePK, detail.toString());
    }

    private Collection getOrgNumberByCondition(Context ctx, String conditionSql) throws BOSException, EASBizException {
        String sql = "select fnumber from t_org_baseunit " + conditionSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> numberList = new ArrayList<String>();
        try {
            while (rs.next()) {
                numberList.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return numberList;
    }

    private void deleteAllAdminOrgRange(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, null, null, null, true);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        iOrgRange.saveOrgRange(orgRangeParam);
    }

    private void handlePersonSwitch(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        this.deleteAllAdminOrgRange(ctx, userInfo);
        if (userInfo.getPerson() != null) {
            this.addAdminOrgRangeForPerson(ctx, userInfo);
        }
    }

    @Override
    protected void _updateAndDeleteOrgPermAndRole(Context ctx, IObjectPK pk, IObjectValue userInfo, boolean isUpdatePassword, String orgIds) throws BOSException, EASBizException {
        this._update(ctx, pk, userInfo, isUpdatePassword);
        this.deleteRelativePermAndRole(ctx, pk, orgIds);
    }

    private void deleteRelativePermAndRole(Context ctx, IObjectPK userPK, String orgIds) throws BOSException, EASBizException {
        List deleteSqlList = this.getDeleteSqlList(userPK, orgIds);
        List permitemIDs = AdvancedPermissionServiceFactory.getLocalInstance(ctx).getPermItemIDsByUserOrgs(userPK.toString(), orgIds);
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            for (int i = 0; i < deleteSqlList.size(); ++i) {
                SQLUtils.execute((Connection)con, (String)deleteSqlList.get(i).toString());
            }
        }
        catch (SQLException se) {
            logger.error((Object)se);
            throw new UserException(UserException.USER_CHANGE_FAIL);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        GroupLicenseUseInfoUtil.disAssignPermitems(ctx, userPK.toString(), permitemIDs);
    }

    @Override
    protected void _deleteRelativePermAndRole(Context ctx, IObjectPK userPK, Collection orgIdCol) throws BOSException, EASBizException {
        this.deleteRelativePermAndRole(ctx, userPK, ToolUtils.aryToStr(orgIdCol));
    }

    private List getDeleteSqlList(IObjectPK userPK, String orgIds) {
        ArrayList<String> deleteSqlList = new ArrayList<String>();
        StringBuffer permOql = new StringBuffer();
        permOql.append("delete from t_pm_userorgperm where fowner='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(permOql.toString());
        StringBuffer roleOql = new StringBuffer();
        roleOql.append("delete from t_pm_userroleorg where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(roleOql.toString());
        StringBuffer fieldOql = new StringBuffer();
        fieldOql.append("delete from T_PM_FIELDACCESS where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
        deleteSqlList.add(fieldOql.toString());
        List discreteTableList = this.getDiscreteTableList();
        for (int i = 0; i < discreteTableList.size(); ++i) {
            StringBuffer discreteOql = new StringBuffer();
            discreteOql.append("delete from ").append(discreteTableList.get(i).toString()).append(" where fuserid='").append(userPK.toString()).append("' and forgid in(").append(orgIds).append(")");
            deleteSqlList.add(discreteOql.toString());
        }
        return deleteSqlList;
    }

    private String getManagedOrgIds(UserInfo userInfo) {
        OrgRangeCollection orgRangeCol = userInfo.getOrgRange();
        if (orgRangeCol == null || orgRangeCol.size() == 0) {
            return "(' ')";
        }
        StringBuffer existOrgIds = new StringBuffer();
        existOrgIds.append("(' '");
        OrgRangeType rangeType = null;
        if (userInfo.getType() == UserType.SYSTEM) {
            rangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (userInfo.isBizAdmin()) {
            rangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        int length = orgRangeCol.size();
        for (int i = 0; i < length; ++i) {
            OrgRangeInfo orgRange = orgRangeCol.get(i);
            if (orgRange.getType() != rangeType) continue;
            existOrgIds.append(",'").append(orgRange.getOrg().getId().toString()).append("'");
        }
        existOrgIds.append(")");
        return existOrgIds.toString();
    }

    private void saveOrgRange(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = this.getConnection(ctx);
            for (int i = 0; i < OrgRangeType.getEnumList().size(); ++i) {
                int orgRangeType = ((OrgRangeType)((Object)OrgRangeType.getEnumList().get(i))).getValue();
                List existOrgIdList = this.getExistOrgIdList(ctx, userInfo, orgRangeType);
                String orgIds = ToolUtils.aryToStr(existOrgIdList);
                String deleteSql = "DELETE FROM T_PM_OrgRange WHERE FUserID = '" + userInfo.getId().toString() + "' and ftype=" + orgRangeType;
                if (existOrgIdList.size() > 0) {
                    deleteSql = deleteSql + " and forgid not in (" + orgIds + ")";
                }
                ps = cn.prepareStatement(deleteSql);
                ps.executeUpdate();
                ps = cn.prepareStatement("INSERT INTO T_PM_OrgRange (FID, FUserID, FOrgID, FType) VALUES (?, ?, ?, ? )");
                BOSObjectType objectType = new OrgRangeInfo().getBOSType();
                OrgRangeCollection orgRangeCol = userInfo.getOrgRange();
                int size = orgRangeCol.size();
                for (int j = 0; j < size; ++j) {
                    OrgRangeInfo orgRangeInfo = orgRangeCol.get(j);
                    if (orgRangeInfo.getType().getValue() != orgRangeType || existOrgIdList.contains(orgRangeInfo.getOrg().getId().toString())) continue;
                    ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                    ps.setString(2, userInfo.getId().toString());
                    ps.setString(3, orgRangeInfo.getOrg().getId().toString());
                    ps.setInt(4, orgRangeInfo.getType().getValue());
                    ps.addBatch();
                    if (j % 1000 != 0) continue;
                    ps.executeBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.USER_SAVE_FAIL, e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cn);
        }
    }

    private List getExistOrgIdList(Context ctx, UserInfo userInfo, int orgRangeType) throws BOSException, EASBizException {
        Connection cn = null;
        Statement ps = null;
        ArrayList<String> orgIdList = new ArrayList<String>();
        try {
            cn = this.getConnection(ctx);
            String orgIds = this.getOrgIds(userInfo.getOrgRange(), orgRangeType);
            String sql = "select distinct forgid from t_pm_orgrange where fuserid='" + userInfo.getId().toString() + "' and forgid in (" + orgIds + ") and ftype=" + orgRangeType;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                orgIdList.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.USER_SAVE_FAIL, e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cn);
        }
        return orgIdList;
    }

    private String getOrgIds(OrgRangeCollection orgRanges, final int orgRangeType) {
        List orgIdList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgRanges, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                OrgRangeInfo orgRange = (OrgRangeInfo)obj;
                if (orgRange.getType().getValue() == orgRangeType) {
                    return ((OrgRangeInfo)obj).getOrg().getId().toString();
                }
                return null;
            }
        });
        return ToolUtils.aryToStr(orgIdList);
    }

    private void saveOrgRangeIncludeSubOrg(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = this.getConnection(ctx);
            ps = cn.prepareStatement("DELETE FROM T_PM_OrgRangeIncludeSubOrg WHERE FUserID = ?");
            ps.setString(1, userInfo.getId().toString());
            ps.executeUpdate();
            ps = cn.prepareStatement("INSERT INTO T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType, FIsIncludeSubOrg) VALUES (?, ?, ?, ?, ?)");
            BOSObjectType objectType = new OrgRangeInfo().getBOSType();
            if (userInfo.getOrgRangeIncludeSubOrg() != null) {
                int size = userInfo.getOrgRangeIncludeSubOrg().size();
                for (int i = 0; i < size; ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                    ps.setString(2, userInfo.getId().toString());
                    ps.setString(3, userInfo.getOrgRangeIncludeSubOrg().get(i).getOrg().getId().toString());
                    ps.setInt(4, userInfo.getOrgRangeIncludeSubOrg().get(i).getType().getValue());
                    ps.setInt(5, userInfo.getOrgRangeIncludeSubOrg().get(i).isIsIncludeSubOrg() ? 1 : 0);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new UserException(UserException.USER_SAVE_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    protected void _delete(Context ctx, IObjectPK[] userPKs) throws BOSException, EASBizException {
        assert (userPKs != null);
        try {
            ArrayList<String> userIds = new ArrayList<String>();
            for (IObjectPK userPK : userPKs) {
                userIds.add(userPK.toString());
            }
            String logAction = EASCommonResource.getString((String)RESOURCE, (String)"deleteUser", (java.util.Locale)ContextUtils.getLocaleFromEnv());
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"DELETE_USER", (java.util.Locale)ctx.getLocale()), (BOSObjectType)new BOSObjectType("13B7DE7F"), null, (String)(logAction + ": " + this.getNamesByIds(ctx, userIds)), (String)"bs_permission_user_delete");
            String deleteSql = "UPDATE T_PM_User SET FIsDelete = 1 ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' ,flastupdatetime=now()  WHERE FID in (" + ToolUtils.aryToStr(userIds, true) + ")";
            DbUtil.execute((Context)ctx, (String)deleteSql);
            GroupLicenseUseInfoUtil.deleteUsers(ctx, userIds);
            this.deleteUserSession(ctx, userPKs);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.USER_DEL_FAIL, e);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = this._getUserByID(ctx, pk);
        super._delete(ctx, pk);
        GroupLicenseUseInfoUtil.deleteUser(ctx, userInfo);
        IObjectPK[] userPKs = new IObjectPK[]{pk};
        this.deleteUserSession(ctx, userPKs);
    }

    private void deleteUserSession(Context ctx, IObjectPK[] userPKs) {
        try {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < userPKs.length; ++i) {
                if (userPKs[i] == null) continue;
                idSet.add(userPKs[i].toString());
            }
            if (idSet.isEmpty()) {
                return;
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection selectorItemColl = new SelectorItemCollection();
            selectorItemColl.add("number");
            entityViewInfo.setSelector(selectorItemColl);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            UserCollection userColl = this.getUserCollection(ctx, entityViewInfo);
            IUserMonitor iUserMonitor = UserMonitorFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < userColl.size(); ++i) {
                UserInfo userInfo = userColl.get(i);
                List umRegistryInfoList = iUserMonitor.findUsers(ctx.getAIS(), userInfo.getNumber());
                for (int j = 0; j < umRegistryInfoList.size(); ++j) {
                    UMRegistryInfo umRegistryInfo = (UMRegistryInfo)umRegistryInfoList.get(j);
                    if (umRegistryInfo == null) continue;
                    iUserMonitor.deleteSessionAndUserMonitorInfo(umRegistryInfo.getId(), null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)model;
        ArrayList<String> roleList = new ArrayList<String>();
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            String personId = personInfo.getId().toString();
            if (UserInfoUtils.isLeader(ctx, personId)) {
                roleList.add("vqoC6sk6Svmijjatmt+tSBO2cyo=");
            }
            if (UserInfoUtils.isManager(ctx, personId)) {
                roleList.add("00000000-0000-0000-0000-00000000000013B6732A");
            }
        }
        return this._addnew(ctx, userInfo, roleList);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, UserInfo userInfo, List roleIdList) throws BOSException, EASBizException {
        this.sysnUserCell(userInfo);
        this.checkDateValidity(userInfo);
        System.out.println("def role log _addnew begin userInfo : " + userInfo.toString());
        System.out.println("def role log userInfo DefOrgUnit: " + userInfo.getDefOrgUnit());
        this.checkCellorMailDup(ctx, userInfo.getCell(), userInfo.getEmail(), null);
        String password = PermissionUtil.decrypt(userInfo.getNumber(), userInfo.getPassword());
        userInfo.setPassword(password);
        this.checkNumberDup(ctx, userInfo.getNumber(), null);
        this.checkSecurityByParam(ctx, userInfo);
        this.checkPersonDup(ctx, userInfo);
        BOSUuid userID = userInfo.getId();
        if (userID == null) {
            userID = BOSUuid.create((BOSObjectType)userInfo.getBOSType());
            userInfo.setId(userID);
        }
        this.setUserDefOrgUnit(ctx, userInfo);
        if (StringUtils.isEmpty((String)userInfo.getPassword())) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userID.toString(), userInfo.getPassword(), passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setPwdHisStr(userInfo.getPassword());
        this.dealAuthenRecordWithEnableAuthen(ctx, userInfo);
        IObjectPK userPK = super._addnew(ctx, (IObjectValue)userInfo);
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        this.addOrgRangeOfNewUser(ctx, userInfo);
        if (userInfo.getGroup() != null) {
            UserGroupGFacadeFactory.getLocalInstance(ctx).addNewSimple((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(userInfo.getGroup().getId()));
        }
        GroupLicenseUseInfoUtil.addUser(ctx, userInfo);
        this.correctOrgSolution(ctx, userInfo);
        if (userInfo.getType().equals((Object)UserType.PERSON)) {
            System.out.println("def role log is person : " + roleIdList.toString());
            this.addDefRoleOfNewUser(ctx, userInfo, roleIdList);
        }
        UserNoActiviationHelper.tryAutoAddNoActivedErpUser(ctx, userInfo.getNumber());
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userPK.toString(), password);
        return userPK;
    }

    private void dealAuthenRecordWhenNeedAuthen(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (!userInfo.isIsRegister()) {
            String insertSql = "INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus,FDescription,FCU) values(?,?,?,?,?,?) ";
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            paramsList = new ArrayList();
            String ctrlUnitId = userInfo.getCU().getId().toString();
            List<String> authentorList = this.getAuthentorByCtrlUnit(ctx, ctrlUnitId);
            if (authentorList == null || authentorList.isEmpty()) {
                throw new BOSException(EASCommonResource.getString((String)RESOURCE, (String)"addnew_user_fail_because_of_no_authentor", (java.util.Locale)ctx.getLocale()));
            }
            String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, "50", userInfo.getNumber(), userInfo.getName(), "user");
            for (String authentodId : authentorList) {
                Object[] params = new Object[]{authentodId, BOSUuid.create((String)"B0E636B6").toString(), permChangeId, "10", "", ctrlUnitId};
                paramsList.add(params);
                AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentodId);
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        }
    }

    private void dealAuthenRecordWithEnableAuthen(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (!userInfo.isIsRegister()) {
            if (userInfo.getCU() == null) {
                userInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            String insertSql = "insert into t_pm_authenrecord(fauthentorid, fid, fpermchangeid, fauthenstatus, fdescription, fcu) values(?, ?, ?, ?, ?, ?) ";
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            paramsList = new ArrayList();
            String ctrlUnitId = userInfo.getCU().getId().toString();
            List<String> authentorList = this.getAuthentorByCtrlUnit(ctx, ctrlUnitId);
            if (authentorList == null || authentorList.isEmpty()) {
                throw new BOSException(EASCommonResource.getString((String)RESOURCE, (String)"addnew_user_fail_because_of_no_authentor", (java.util.Locale)ctx.getLocale()));
            }
            String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserId, "50", userInfo.getNumber(), userInfo.getName(), "user");
            this.insertAuthenSnapViewInfo(ctx, permChangeId, ctrlUnitId);
            for (String authentodId : authentorList) {
                Object[] params = new Object[]{authentodId, BOSUuid.create((String)"B0E636B6").toString(), permChangeId, "10", "", ctrlUnitId};
                paramsList.add(params);
            }
            AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, new HashSet<String>(authentorList));
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        }
    }

    private void insertAuthenSnapViewInfo(Context ctx, String permChangeId, String ctrlUnitId) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into t_pm_authenschemesnapview(fid, froleid, fuserid, fpermitemid, fpermchangerecordid, fisrule)").append("select newbosid('38B94EC5'), '', asou.fuserid, schemeperm.fpermitemid, '").append(permChangeId).append("', authenrule.fisrule ").append("from t_pm_authenschemeperm as schemeperm ").append("inner join t_pm_authenschemeorguser as asou on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("inner join t_pm_authenschemerule as authenrule on authenrule.fauthenschemeid = asou.fauthenschemeid and authenrule.forgid = asou.forgid ").append("where asou.forgid = ? and ").append("schemeperm.fpermitemid = ?");
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{ctrlUnitId, "e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM"});
    }

    private List<String> getAuthentorByCtrlUnit(Context ctx, String ctrlUnit) throws BOSException {
        ArrayList<String> authentorList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct(asou.fuserid) ").append("from t_pm_authenschemeorguser as asou ").append("inner join t_pm_authenschemeperm as schemeperm on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("where asou.forgid = '").append(ctrlUnit).append("' ").append("and schemeperm.FPERMITEMID ='").append("e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM").append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                authentorList.add(rowSet.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return authentorList;
    }

    private void addDefRoleOfNewUser(Context ctx, UserInfo userInfo, List roleIdList) throws BOSException, EASBizException {
        RoleCollection roleCol = new RoleCollection();
        for (int iRole = 0; iRole < roleIdList.size(); ++iRole) {
            String pkId = (String)roleIdList.get(iRole);
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)pkId));
            roleCol.add(roleInfo);
        }
        roleCol.addCollection(this.getRoleByIsDefRole(ctx, true));
        System.out.println("def role log addDefRoleOfNewUser is roleCol : " + roleCol.toString());
        if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null) {
            UserRoleOrgManagerFactory.getLocalInstance(ctx).saveUserRoleOrgs((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), (IObjectPK)new ObjectStringPK(userInfo.getDefOrgUnit().getId().toString()), PermissionUtil.getPkIds(ToolUtils.tranColToList((IObjectCollection)roleCol)), false);
        }
    }

    private void checkPersonDup(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        UserCollection userCol = new UserCollection();
        userCol.add(userInfo);
        this.checkPersonDup(ctx, userCol);
    }

    private void checkPersonDup(Context ctx, UserCollection userCol) throws BOSException, EASBizException {
        if (userCol == null || userCol.size() < 1) {
            return;
        }
        List personUserList = this.getPersonUserList(userCol);
        if (personUserList.size() < 1) {
            return;
        }
        String paramValue = this.getPersonCanReferenceManyUserParamValue(ctx);
        if (!"false".equalsIgnoreCase(paramValue)) {
            return;
        }
        Map personIdUserNumberMap = this.getPersonIdUserNumberMap(ctx, personUserList);
        if (personIdUserNumberMap.size() > 0) {
            ArrayList<String> newUserNumbers = new ArrayList<String>();
            ArrayList<String> oldUserNumbers = new ArrayList<String>();
            int size = personUserList.size();
            for (int i = 0; i < size; ++i) {
                UserInfo newUserInfo = (UserInfo)personUserList.get(i);
                String personId = StringUtils.cnulls((Object)newUserInfo.getPerson().getId());
                if (!personIdUserNumberMap.containsKey(personId)) continue;
                String oldUserNumber = (String)personIdUserNumberMap.get(personId);
                newUserNumbers.add(newUserInfo.getNumber());
                oldUserNumbers.add(oldUserNumber);
            }
            throw new UserException(UserException.PERSON_REFERENCED, new Object[]{ToolUtils.aryToStr(newUserNumbers), ToolUtils.aryToStr(oldUserNumbers)});
        }
    }

    private List getPersonUserList(UserCollection userCol) {
        ArrayList<UserInfo> personUserList = new ArrayList<UserInfo>();
        int size = userCol.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userInfo = userCol.get(i);
            if (!UserType.PERSON.equals((Object)userInfo.getType()) || userInfo.getPerson() == null) continue;
            personUserList.add(userInfo);
        }
        return personUserList;
    }

    private String getPersonCanReferenceManyUserParamValue(Context ctx) throws BOSException, EASBizException {
        if (this.personCanReferenceManyUser == null) {
            String paramNumber = "PersonCanReferenceManyUser";
            this.personCanReferenceManyUser = ParamManager.getParamValue((Context)ctx, null, (String)paramNumber);
        }
        return this.personCanReferenceManyUser;
    }

    private Map getPersonIdUserNumberMap(Context ctx, List personUserList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fpersonid,fnumber from t_pm_user where fpersonid in (");
        int personUserListSize = personUserList.size();
        for (int i = 0; i < personUserListSize; ++i) {
            sql.append("?");
            if (i >= personUserListSize - 1) continue;
            sql.append(",");
        }
        sql.append(") and FIsDelete=0 ");
        Object[] params = new Object[personUserListSize];
        for (int i = 0; i < personUserListSize; ++i) {
            params[i] = StringUtils.cnulls((Object)((UserInfo)personUserList.get(i)).getPerson().getId());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        HashMap<String, String> personIdUserNumberMap = new HashMap<String, String>();
        try {
            if (rs.next()) {
                String userNumber = rs.getString("fnumber");
                String personId = rs.getString("fpersonid");
                personIdUserNumberMap.put(personId, userNumber);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personIdUserNumberMap;
    }

    private RoleCollection getRoleByIsDefRole(Context ctx, boolean isDefRole) throws BOSException {
        IRole iRole = RoleFactory.getLocalInstance(ctx);
        String oql = " WHERE isDefRole=" + (isDefRole ? 1 : 0);
        RoleCollection role = iRole.getRoleCollection(oql);
        return role;
    }

    private void setUserDefOrgUnit(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (userInfo.getDefOrgUnit() == null) {
            ObjectUuidPK orgUnitPK = new ObjectUuidPK(userInfo.getCU().getId());
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)orgUnitPK);
            userInfo.setDefOrgUnit(fullOrgUnitInfo);
        }
    }

    private void addOrgRangeOfNewUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        String orgId = userInfo.getCU().getId().toString();
        ArrayList<String> orgIdCol = new ArrayList<String>();
        orgIdCol.add(orgId);
        if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null && !orgId.equals(userInfo.getDefOrgUnit().getId().toString())) {
            orgIdCol.add(userInfo.getDefOrgUnit().getId().toString());
        }
        if (userInfo.getOrgRange() != null && !userInfo.getOrgRange().isEmpty()) {
            for (int i = 0; i < userInfo.getOrgRange().size(); ++i) {
                OrgRangeInfo orgRangeInfo = userInfo.getOrgRange().get(i);
                if (orgRangeInfo == null || !OrgRangeType.BIZ_ORG_TYPE.equals((Object)orgRangeInfo.getType()) || orgIdCol.contains(orgRangeInfo.getOrg().getId().toString())) continue;
                orgIdCol.add(orgRangeInfo.getOrg().getId().toString());
            }
        }
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, orgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
        if (userInfo.isBizAdmin()) {
            OrgRangeParam manageOrgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.MANAGE_ORG_TYPE, null, orgIdCol, null);
            iOrgRange.saveOrgRange(manageOrgRangeParam);
        }
        if (userInfo.getPerson() != null) {
            this.addAdminOrgRangeForPerson(ctx, userInfo);
        }
        this.addAdminOrgRange(ctx, userInfo, (IObjectPK)userPK);
    }

    private void addAdminOrgRange(Context ctx, UserInfo userInfo, IObjectPK userPK) throws SQLDataException, UserException {
        ArrayList<String> orgIdList = new ArrayList<String>();
        if (userInfo.getOrgRange() != null && !userInfo.getOrgRange().isEmpty()) {
            for (int i = 0; i < userInfo.getOrgRange().size(); ++i) {
                OrgRangeInfo orgRangeInfo = userInfo.getOrgRange().get(i);
                if (!orgRangeInfo.getType().equals((Object)OrgRangeType.ADMIN_ORG_TYPE)) continue;
                orgIdList.add(orgRangeInfo.getOrg().getId().toString());
            }
        }
        if (orgIdList.size() <= 0) {
            return;
        }
        Connection cn = null;
        PreparedStatement ps = null;
        TableManager tableManager = null;
        String tableName = null;
        try {
            tableManager = TableManager.getTableManager((Context)ctx);
            tableName = tableManager.getTableName("orgrange");
            String createTableSql = "create table " + tableName + " (FuserID VARCHAR(44),ForgID VARCHAR(44),Ftype int)";
            tableManager.createTable(createTableSql);
            String insertSql = "insert into " + tableName + " (fuserid,forgid,ftype) values(?,?,?)";
            cn = this.getConnection(ctx);
            ps = cn.prepareStatement(insertSql);
            for (int i = 0; i < orgIdList.size(); ++i) {
                ps.setString(1, userPK.toString());
                ps.setString(2, orgIdList.get(i).toString());
                ps.setInt(3, 20);
            }
            ps.executeBatch();
            String sql = " insert into t_pm_orgrange (FID, FUserID, FOrgID, FType) select newbosid('FD3DC16D'),fuserid,forgid,ftype from " + tableName + " tbl where not exists (select 1 from t_pm_orgrange org where org.fuserid=tbl.fuserid and org.forgid=tbl.forgid and org.ftype=tbl.ftype)";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = " insert into T_PM_OrgRangeIncludeSubOrg (FID, FUserID, FOrgID, FType,FIsIncludeSubOrg)  select newbosid('4DC3DADF'), FUserID, FOrgID, FType ,0 from " + tableName + " tbl inner join t_org_admin admin1 on tbl.forgid=admin1.fid where not exists (select 1 from   T_PM_OrgRangeIncludeSubOrg orgSub where orgSub.fuserid = tbl.fuserid and orgSub.forgid=tbl.forgid  and orgSub.ftype=tbl.ftype) and not exists(select 1 from T_ORG_ADMIN inneradmin inner join  T_PM_OrgRangeIncludeSubOrg innerSubOrg on inneradmin.fid = innerSubOrg.forgid where  innerSubOrg.FISINCLUDESUBORG =1 and innerSubOrg.fuserid = tbl.fuserid and   charindex(inneradmin.flongnumber||'!',admin1.flongnumber||'!') = 1)";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.USER_SAVE_FAIL, e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserException(UserException.USER_SAVE_FAIL, e);
        }
        finally {
            if (tableManager != null && tableManager != null) {
                tableManager.releaseTable(tableName);
            }
        }
    }

    private void correctOrgSolution(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ArrayList<String> orgList = new ArrayList<String>();
        if (userInfo.getOrgRange() != null) {
            int size = userInfo.getOrgRange().size();
            for (int i = 0; i < size; ++i) {
                OrgRangeInfo orgRangeInfo = userInfo.getOrgRange().get(i);
                orgList.add(orgRangeInfo.getOrg().getId().toString());
            }
        }
        if (!orgList.isEmpty()) {
            IOrgRangeSolution iOrgRangeSolution = OrgRangeSolutionFactory.getLocalInstance(ctx);
            ArrayList<String> userIdStrList = new ArrayList<String>();
            userIdStrList.add(userInfo.getId().toString());
            iOrgRangeSolution.correctOrgRange(userIdStrList, orgList);
        }
    }

    private void checkDateValidity(UserInfo userInfo) throws EASBizException {
        Date date = new Date();
        if (userInfo.getId() == null && DateTimeUtils.dayAfter((Date)date, (Date)userInfo.getEffectiveDate())) {
            logger.error((Object)("curDate is:" + date + " effectiveDate is:" + userInfo.getEffectiveDate()));
            throw new UserException(UserException.EFFECTIVE_DATE_BEFORE_CURRENT_DATE);
        }
        if (DateTimeUtils.dayAfter((Date)userInfo.getEffectiveDate(), (Date)userInfo.getPWEffectiveDate())) {
            logger.error((Object)(" getEffectiveDate is:" + userInfo.getEffectiveDate() + " getPWEffectiveDate is:" + userInfo.getPWEffectiveDate()));
            throw new UserException(UserException.PWEFFECTIVE_DATE_BEFORE_EFFECTIVE_DATE);
        }
    }

    private void checkNumberDup(Context ctx, String number, IObjectPK userPK) throws EASBizException, BOSException {
        try {
            IRowSet rowSet2;
            IRowSet rowSet;
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT FID FROM T_PM_User WHERE UPPER(FNumber) =  UPPER(N'").append(number).append("') ");
            if (userPK != null) {
                sql.append(" AND FID <> '").append(userPK.toString()).append("' ");
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                throw new UserException(UserException.NUMBER_REPEAT);
            }
            sql = new StringBuilder();
            sql.append(" SELECT FID,FNumber FROM T_PM_User WHERE UPPER(FLoginNumber)=UPPER(N'").append(number).append("') ");
            if (userPK != null) {
                sql.append(" AND FID <> '").append(userPK.toString()).append("' ");
            }
            if ((rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                throw new UserException(UserException.LOGINNUMBER_REPEAT, new Object[]{rowSet2.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
    }

    private void checkCellorMailDup(Context ctx, String cell, String mail, IObjectPK userPK) throws EASBizException, BOSException {
        String controlPolicy = "";
        try {
            controlPolicy = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getControlPolicy();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        if ("Subsystem".equalsIgnoreCase(controlPolicy)) {
            return;
        }
        try {
            int flag = 0;
            String user = null;
            if (cell != null && cell.trim().length() > 0) {
                IRowSet rowSet;
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT FID,FNUMBER FROM T_PM_User WHERE UPPER(FCell) =  UPPER(N'").append(cell).append("') and FISDELETE<>1");
                if (userPK != null) {
                    sql.append(" AND FID <> '").append(userPK.toString()).append("' ");
                }
                if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                    ++flag;
                    user = rowSet.getString("FNUMBER");
                }
            }
            String _user = null;
            if (mail != null && mail.trim().length() > 0) {
                IRowSet _rowSet;
                StringBuffer _sql = new StringBuffer();
                _sql.append(" SELECT FID,FNUMBER FROM T_PM_User WHERE UPPER(FEMail) = UPPER(N'").append(mail).append("') and FISDELETE<>1");
                if (userPK != null) {
                    _sql.append(" AND FID <> '").append(userPK.toString()).append("' ");
                }
                if ((_rowSet = DbUtil.executeQuery((Context)ctx, (String)_sql.toString())).next()) {
                    flag += 2;
                    _user = _rowSet.getString("FNUMBER");
                }
            }
            if (flag == 1) {
                throw new UserException(UserException.CELL_REPEAT, new Object[]{user});
            }
            if (flag == 2) {
                throw new UserException(UserException.EMAIL_REPEAT, new Object[]{_user});
            }
            if (flag == 3) {
                if (user.equals(_user)) {
                    throw new UserException(UserException.CELL_MAIL_REPEAT, new Object[]{user});
                }
                throw new UserException(UserException.CELL_MAIL_REPEAT_DIFFERENT_USER, new Object[]{user, _user});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
    }

    private void checkSecurity(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        if (userInfo.getSecurity() == null) {
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        ISecurity security = SecurityFactory.getLocalInstance(ctx);
        SecurityInfo securityInfo = security.getSecurityInfo((IObjectPK)new ObjectUuidPK(userInfo.getSecurity().getId()));
        userInfo.setSecurity(securityInfo);
        SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
        securityValidator.validate();
    }

    private void checkSecurityByParam(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        if (userInfo.getSecurity() == null) {
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        ISecurity security = SecurityFactory.getLocalInstance(ctx);
        SecurityInfo securityInfo = security.getSecurityInfo((IObjectPK)new ObjectUuidPK(userInfo.getSecurity().getId()));
        userInfo.setSecurity(securityInfo);
        SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
        String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"NewUsersIsCheckSecurity");
        if ("true".equals(paramValue)) {
            securityValidator.validate();
        }
    }

    @Override
    protected IObjectValue _getUser(Context ctx, String number) throws BOSException, EASBizException {
        UserInfo userInfo = null;
        try {
            Object[] params = new Object[]{number.toUpperCase()};
            String nameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
            String descriptionField = MultiLangHelper.getFieldName("FDescription", ctx.getLocale());
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT U.FID, U.FNumber, ").append(" U.").append(nameField).append(", ").append(" U.FIsLocked, U.FIsDelete, U.FForbidden, ").append(" U.FIsRegister, U.FGroupID, U.FPersonId, U.FSecurityID, U.FEffectiveDate, U.FInvalidationDate, ").append(" U.FDefaultLocale,U.FErrCount, U.FPWEffectiveDate, U.FLockedTime, U.FType, U.FDefOrgUnitID, ").append(" U.FControlUnitID, CtrlUnit.FNumber AS FCtrlUnitNumber, ").append(" CtrlUnit.").append(nameField).append(" AS FCtrlUnitName, ").append(" U.FIsBizAdmin, U.FIsChangedPW, ").append(" U.").append(descriptionField).append(", ").append(" Security.FNumber AS FSecurityNumber, ").append(" Security.").append(aliasField).append(" AS FSecurityAlias, ").append(" Security.FPasswordLength AS FPasswordLength, ").append(" Security.FPasswordForever AS FPasswordForever, Security.FNeedLocked AS FNeedLocked, ").append(" Security.FLockCount AS FLockCount, Security.FPasswordCanChg AS FPasswordCanChg, ").append(" Security.FPasswordCycle AS FPasswordCycle, Security.FForewarnDay AS FForewarnDay, ").append(" Security.FIsComplex AS FIsComplex, Security.FIsRequireChgPW AS FIsRequireChgPW, ").append(" BaseUnit.FNumber AS FDefOrgUnitNumber, ").append(" BaseUnit.").append(nameField).append(" AS FDefOrgUnitName, ").append(" Person.FNumber AS FPersonNumber, ").append(" Person.").append(nameField).append(" AS FPersonNane, ").append(" U.FCustomerID, ").append(" U.FSupplierID ").append(" FROM T_PM_User U ").append(" LEFT OUTER JOIN T_BD_Person Person ON Person.FID = U.FPersonId ").append(" LEFT OUTER JOIN T_PM_Security Security ON Security.FID = U.FSecurityID ").append(" LEFT OUTER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = U.FDefOrgUnitID ").append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = U.FControlUnitID ").append(" WHERE UPPER(U.FNumber) = ? AND FIsDelete = 0 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                String supplierID;
                String customerID;
                String ctrlUnitID;
                String securityID;
                String personID;
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField));
                userInfo.setType(UserType.getEnum(rowSet.getInt("FType")));
                userInfo.setIsLocked(rowSet.getInt("FIsLocked") == 1);
                userInfo.setIsDelete(rowSet.getInt("FIsDelete") == 1);
                userInfo.setIsForbidden(rowSet.getInt("FForbidden") == 1);
                userInfo.setIsRegister(rowSet.getInt("FIsRegister") == 1);
                userInfo.setBizAdmin(rowSet.getInt("FIsBizAdmin") == 1);
                userInfo.setChangedPW(rowSet.getInt("FIsChangedPW") == 1);
                userInfo.setDescription(rowSet.getString(descriptionField));
                String groupID = rowSet.getString("FGroupID");
                if (!StringUtils.isEmpty((String)groupID)) {
                    UserGroupInfo groupInfo = new UserGroupInfo();
                    groupInfo.setId(BOSUuid.read((String)groupID));
                    userInfo.setGroup(groupInfo);
                }
                if (!StringUtils.isEmpty((String)(personID = rowSet.getString("FPersonId")))) {
                    String personNumber = rowSet.getString("FPersonNumber");
                    String personName = rowSet.getString("FPersonNane");
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personID));
                    personInfo.setNumber(personNumber);
                    personInfo.setName(personName);
                    userInfo.setPerson(personInfo);
                }
                if (!StringUtils.isEmpty((String)(securityID = rowSet.getString("FSecurityID")))) {
                    SecurityInfo securityInfo = new SecurityInfo();
                    securityInfo.setNumber(rowSet.getString("FSecurityNumber"));
                    securityInfo.setAlias(rowSet.getString("FSecurityAlias"));
                    securityInfo.setPasswordLength(rowSet.getInt("FPasswordLength"));
                    securityInfo.setPasswordForever(rowSet.getInt("FPasswordForever") == 1);
                    securityInfo.setNeedLocked(rowSet.getInt("FNeedLocked") == 1);
                    securityInfo.setLockCount(rowSet.getInt("FLockCount"));
                    securityInfo.setPasswordCanChg(rowSet.getInt("FPasswordCanChg") == 1);
                    securityInfo.setPasswordCycle(rowSet.getInt("FPasswordCycle"));
                    securityInfo.setForewarnDay(rowSet.getInt("FForewarnDay"));
                    securityInfo.setComplex(rowSet.getInt("FIsComplex") == 1);
                    securityInfo.setRequireChgPW(rowSet.getInt("FIsRequireChgPW") == 1);
                    userInfo.setSecurity(securityInfo);
                }
                if (!StringUtils.isEmpty((String)(ctrlUnitID = rowSet.getString("FControlUnitID")))) {
                    String ctrlUnitNumber = rowSet.getString("FCtrlUnitNumber");
                    String ctrlUnitName = rowSet.getString("FCtrlUnitName");
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)ctrlUnitID));
                    ctrlUnitInfo.setNumber(ctrlUnitNumber);
                    ctrlUnitInfo.setName(ctrlUnitName);
                    userInfo.setCU(ctrlUnitInfo);
                }
                userInfo.setEffectiveDate(rowSet.getTimestamp("FEffectiveDate"));
                userInfo.setInvalidationDate(rowSet.getTimestamp("FInvalidationDate"));
                userInfo.setDefLocale(Locale.getEnum(rowSet.getString("FDefaultLocale")));
                userInfo.setErrCount(rowSet.getInt("FErrCount"));
                userInfo.setPWEffectiveDate(rowSet.getDate("FPWEffectiveDate"));
                userInfo.setLockedTime(rowSet.getTime("FLockedTime"));
                String defOrgUnitID = rowSet.getString("FDefOrgUnitID");
                if (!StringUtils.isEmpty((String)defOrgUnitID)) {
                    String defOrgUnitNumber = rowSet.getString("FDefOrgUnitNumber");
                    String defOrgUnitName = rowSet.getString("FDefOrgUnitName");
                    FullOrgUnitInfo defOrgUnit = new FullOrgUnitInfo();
                    defOrgUnit.setId(BOSUuid.read((String)defOrgUnitID));
                    defOrgUnit.setNumber(defOrgUnitNumber);
                    defOrgUnit.setName(defOrgUnitName);
                    userInfo.setDefOrgUnit(defOrgUnit);
                }
                if (!StringUtils.isEmpty((String)(customerID = rowSet.getString("FCustomerID")))) {
                    userInfo.setCustomerID(customerID);
                }
                if (!StringUtils.isEmpty((String)(supplierID = rowSet.getString("FSupplierID")))) {
                    userInfo.setSupplierID(supplierID);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
        return userInfo;
    }

    @Override
    protected boolean _checkOrgIsRelatedWithPerms(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        StringBuffer sql = new StringBuffer("SELECT 1 FROM T_PM_UserOrgPerm WHERE FOwner = ? AND FOrgID = ? ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_UserRoleOrg WHERE FUserID = ? AND FOrgID = ? ");
        String orgID = orgPK.toString();
        String userID = userPK.toString();
        Object[] params = new Object[]{userID, orgID, userID, orgID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
    }

    @Override
    protected boolean _checkOrgIsRelatedWithPerms(Context ctx, IObjectPK userPK, Collection orgIDlist) throws BOSException, EASBizException {
        assert (userPK != null && orgIDlist != null);
        try {
            String orgIDFilter = ToolUtils.aryToStr(orgIDlist);
            StringBuilder sql = new StringBuilder("select 1 from T_ORG_BaseUnit baseunit where fid in ( " + orgIDFilter + " ) and (").append(" exists (select 1 from T_PM_UserOrgPerm WHERE FOwner = ? and baseunit.fid = FOrgID)").append(" or exists  (select 1 from T_PM_UserRoleOrg WHERE FUserID = ? and baseunit.fid = FOrgID)");
            sql.append(this.getExistRelativedDiscretePermSql(userPK, "baseunit"));
            sql.append("or exists  (select 1 from T_PM_FIELDACCESS").append(" where fuserid='").append(userPK.toString()).append("' and baseunit.fid = FOrgID)");
            sql.append(" )");
            String userID = userPK.toString();
            Object[] params = new Object[]{userID, userID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            return rowSet.next();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private String getExistRelativedDiscretePermSql(IObjectPK userPK, String baseunit) {
        StringBuilder ret = new StringBuilder();
        List discreteTableList = this.getDiscreteTableList();
        for (int i = 0; i < discreteTableList.size(); ++i) {
            ret.append(" or exists (select 1 from ").append(discreteTableList.get(i).toString()).append(" where fuserid='").append(userPK.toString()).append("' and ").append(baseunit).append(".fid = FOrgID)");
        }
        return ret.toString();
    }

    private String getExistFieldAccessSql(IObjectPK userPK, String orgIdFilter) {
        StringBuffer ret = new StringBuffer();
        ret.append("select 1 from T_PM_FIELDACCESS").append(" where fuserid='").append(userPK.toString()).append("' and forgid in (").append(orgIdFilter).append(")");
        return ret.toString();
    }

    private List getDiscreteTableList() {
        ArrayList<String> list = new ArrayList<String>();
        Collection discreteTableList = ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().values();
        Iterator ite = discreteTableList.iterator();
        while (ite.hasNext()) {
            list.add(ite.next().toString());
        }
        return list;
    }

    @Override
    protected boolean _checkUserIsRelatedWithPerms(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        assert (userPK != null);
        StringBuffer sql = new StringBuffer(" SELECT 1 WHERE EXISTS( ").append(" SELECT 1 FROM T_PM_UserOrgPerm WHERE FOwner = ?").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_UserRoleOrg WHERE FUserID = ?").append(" ) ");
        String userID = userPK.toString();
        Object[] params = new Object[]{userID, userID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
    }

    @Override
    protected String _getDeletedUserID(Context ctx, String number) throws BOSException, EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_PM_User WHERE UPPER(FNumber) =  N'").append(number.toUpperCase()).append("' AND FIsDelete = 1 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                return rowSet.getString("FID");
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
    }

    @Override
    protected void _changeCtrlUnit(Context ctx, IObjectPK ctrlPK, IObjectPK userPK) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)ctrlPK)) || StringUtils.isEmpty((String)StringUtils.cnulls((Object)userPK))) {
            throw new IllegalArgumentException("userPK or ctrlPK is null");
        }
        if (this.getUserInfo(ctx, userPK) == null) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        if (ctrlUnit.getCtrlUnitInfo(ctrlPK) == null) {
            throw new UserException(UserException.USER_CHANGE_FAIL);
        }
        String updateSql = "UPDATE T_PM_USER SET FCONTROLUNITID = '" + ctrlPK.toString() + "' WHERE FID = '" + userPK.toString() + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo;
        if (pk != null && (userInfo = this._getUserByID(ctx, pk)) != null) {
            return StringUtils.cnulls((String)userInfo.getNumber()) + "  " + StringUtils.cnulls((String)userInfo.getName());
        }
        return "";
    }

    @Override
    protected void _createUserByPerson(Context ctx, IObjectPK personId) throws BOSException, EASBizException {
        if (personId == null) {
            throw new IllegalArgumentException(" personId is null");
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = iPerson.getPersonInfo(personId);
        if (personInfo == null) {
            return;
        }
        UserInfo userInfo = this.newUserInfo(ctx, personInfo);
        IObjectPK newUserPK = this._addnew(ctx, (IObjectValue)userInfo);
        userInfo.setId(BOSUuid.read((String)newUserPK.toString()));
        FullOrgUnitCollection fullOrgUnit = this.addUserOrgangeByPerson(ctx, newUserPK, personInfo);
        this.saveRoleInfo(ctx, userInfo, fullOrgUnit, "59V21QENEADgAABbwKgSkxO2cyo=");
    }

    private FullOrgUnitCollection addUserOrgangeByPerson(Context ctx, IObjectPK newUserPK, PersonInfo personInfo) throws BOSException, EASBizException {
        PersonHelper helper = new PersonHelper();
        return helper.addUserOrgRange(ctx, newUserPK, personInfo);
    }

    @Override
    protected void _updateLoginAuthorWay(Context ctx, List userIdList, LoginAuthorWayEnum loginAuthorWay) throws BOSException, EASBizException {
        if (userIdList == null || userIdList.isEmpty() || loginAuthorWay == null) {
            // empty if block
        }
        int loginAuthorWayInt = loginAuthorWay.getValue();
        if (userIdList != null && !userIdList.isEmpty()) {
            String sql = " update t_pm_user set floginAuthorWay = " + loginAuthorWayInt + " where fid in (" + ToolUtils.aryToStr(userIdList, true) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _callBackUser(Context ctx, List userIdList) throws BOSException, EASBizException {
        if (userIdList == null || userIdList.isEmpty()) {
            return;
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"RECYCLING_USER", (java.util.Locale)ctx.getLocale()), (BOSObjectType)new BOSObjectType("13B7DE7F"), null, (String)this.getNamesByIds(ctx, userIdList), (String)"bs_permission_user_callBackUser");
        String oql = "select number,type,person.id where id in (" + ToolUtils.aryToStr(userIdList) + ")";
        UserCollection userCol = this.getUserCollection(ctx, oql);
        this.checkPersonDup(ctx, userCol);
        String sql = "update t_pm_user set FIsDelete = 0 ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' ,flastupdatetime=now() where fid in (" + ToolUtils.aryToStr(userIdList, true) + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        GroupLicenseUseInfoUtil.callBackUsers(ctx, userIdList);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private String getNamesByIds(Context ctx, List userIdList) throws BOSException, EASBizException {
        String str = "";
        for (int i = 0; i < userIdList.size(); ++i) {
            IUser iuser = UserFactory.getLocalInstance(ctx);
            UserInfo info = iuser.getUserInfo((IObjectPK)new ObjectStringPK(userIdList.get(i).toString()));
            str = str + info.getName() + "(" + info.getNumber() + ")";
            if (i >= userIdList.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    @Override
    protected boolean _haveThisNumber(Context ctx, String roleNumber) throws BOSException, EASBizException {
        return PermBizHelper.haveThisNumber(ctx, "t_pm_user", roleNumber);
    }

    @Override
    protected IObjectValue _getUserInfoByNumber(Context ctx, String userNumber) throws BOSException, EASBizException {
        String id;
        block4: {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT fid,fnumber FROM T_PM_User where upper(fnumber)=upper(?)", (Object[])new Object[]{userNumber});
            id = "";
            try {
                while (rs.next()) {
                    id = rs.getString("fid");
                    String number = rs.getString("fnumber");
                    if (!userNumber.equals(number)) continue;
                    break;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                if (id != "") break block4;
                throw new BOSException((Throwable)e);
            }
        }
        if (id == "") {
            return null;
        }
        return this._getValue(ctx, "select * where id ='" + id + "'");
    }

    @Override
    protected IObjectCollection _notOrgRangeUseCol(Context ctx, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        try {
            String preFixStr = "_" + ctx.getLocale().toString();
            String oqlStr = "select *,t_org_baseUnit.fname" + preFixStr + " as CUName  from t_pm_user left join t_org_baseUnit on t_pm_user.FControlUnitId = t_org_baseUnit.fid  where t_pm_user.fid not in (select fuserid from t_pm_orgrange where ftype = " + orgRangeType.getValue() + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oqlStr);
            UserCollection userCol = new UserCollection();
            while (rowSet.next()) {
                String userId = rowSet.getString("Fid");
                String numberStr = rowSet.getString("FNumber");
                String nameStr = rowSet.getString("FName" + preFixStr);
                String cuIdStr = rowSet.getString("FControlUnitID");
                String cuName = rowSet.getString("CUName");
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)userId));
                userInfo.setName(nameStr);
                userInfo.setNumber(numberStr);
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)cuIdStr));
                ctrlUnitInfo.setName(cuName);
                userInfo.setCU(ctrlUnitInfo);
                userCol.add(userInfo);
            }
            return userCol;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _setUserLoginAuthWay(Context ctx, List userID, LoginAuthorWayEnum authWay) throws BOSException, EASBizException {
        if (userID == null || userID.size() == 0) {
            return;
        }
        switch (authWay.getValue()) {
            case 2: {
                UserControllerHelper.getHelper().handleDynCardUser(ctx, userID, authWay);
                break;
            }
            case 1: {
                UserControllerHelper.getHelper().handleUsbKeyUser(ctx, userID, authWay);
                break;
            }
            case 0: {
                UserControllerHelper.getHelper().handleNormalUser(ctx, userID, authWay);
            }
        }
        this._setRegisterResult(ctx, userID, false);
    }

    @Override
    protected void _setRegisterResult(Context ctx, List userIDList, boolean isCertified) throws BOSException, EASBizException {
        if (userIDList == null || userIDList.size() == 0) {
            return;
        }
        LogProxy logProxy = new LogProxy();
        this.logRegister(ctx, logProxy, userIDList, isCertified);
        UserControllerHelper.getHelper().setCertifyRegistration(ctx, userIDList, isCertified);
        if (isCertified) {
            this.addOrUpdateUserCertifyRecord(ctx, userIDList);
        }
        logProxy.end();
    }

    private void addOrUpdateUserCertifyRecord(Context ctx, Collection userIDCol) throws BOSException, EASBizException {
        ArrayList<String> userIDStrList = new ArrayList<String>();
        Iterator userIDItr = userIDCol.iterator();
        while (userIDItr.hasNext()) {
            userIDStrList.add(userIDItr.next().toString());
        }
        String sql = "select FUserID from t_pm_userCertifyRecord where fuserid in (" + ToolUtils.aryToStr(userIDStrList) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> existUserIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                existUserIdList.add(rs.getString("FUserID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String updateUserCertifyRecord = "update t_pm_userCertifyRecord set FCertifyTimes=FCertifyTimes+1 where fuserid in (" + ToolUtils.aryToStr(existUserIdList) + ")";
        DbUtil.execute((Context)ctx, (String)updateUserCertifyRecord);
        Collection newCertifyUserIDCol = CollectionUtils.subtract(userIDStrList, existUserIdList);
        String addSql = "insert into t_pm_userCertifyRecord(fid,fuserid,fcertifyTimes) values(?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        BOSObjectType objectType = new UserCertifyRecordInfo().getBOSType();
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(addSql);
            Iterator newCertifyUserItr = newCertifyUserIDCol.iterator();
            while (newCertifyUserItr.hasNext()) {
                ps.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
                ps.setString(2, newCertifyUserItr.next().toString());
                ps.setInt(3, 1);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private Collection getUserNumberListByIDList(Context ctx, Collection userIDCol) throws BOSException, EASBizException {
        String sql = "select fnumber from t_pm_user where fid in (" + ToolUtils.aryToStr(userIDCol) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> numberList = new ArrayList<String>();
        try {
            while (rs.next()) {
                numberList.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return numberList;
    }

    private void logRegister(Context ctx, LogProxy logProxy, List userIDList, boolean isCertified) throws BOSException, EASBizException {
        StringBuffer detail = new StringBuffer();
        java.util.Locale l = ContextUtils.getLocaleFromEnv();
        String authenUser = EASCommonResource.getString((String)RESOURCE, (String)"AuthenUser", (java.util.Locale)l);
        String authenResult = EASCommonResource.getString((String)RESOURCE, (String)"AuthenResult", (java.util.Locale)l);
        detail.append(authenUser + "\n");
        detail.append(ToolUtils.aryToStr(this.getUserNumberListByIDList(ctx, userIDList))).append("\n");
        detail.append(authenResult + ":" + isCertified);
        logProxy.beginLog(ctx, null, new UserInfo().getBOSType(), null, detail.toString());
    }

    @Override
    protected void _batchCreateUserByPerson(Context ctx, List personIDList) throws BOSException, EASBizException {
        this._batchCreateUserByPerson(ctx, personIDList, null);
    }

    @Override
    protected void _batchCreateUserByPerson(Context ctx, List personIDList, String password) throws BOSException, EASBizException {
        if (personIDList == null || personIDList.size() == 0) {
            return;
        }
        HashSet personSet = new HashSet();
        int size = personIDList.size();
        for (int iPersonId = 0; iPersonId < size; ++iPersonId) {
            personSet.add(personIDList.get(iPersonId));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        PersonCollection personCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
        int tmpIndex = 1;
        block3: for (int iPerson = 0; iPerson < personCol.size(); ++iPerson) {
            PersonInfo personInfo = personCol.get(iPerson);
            UserInfo userInfo = this.newUserInfo(ctx, personInfo);
            AdminOrgUnitInfo adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(personInfo.getId());
            userInfo.setCU(adminOrgUnitInfo.getCU());
            if (!StringUtils.isEmpty((String)password)) {
                userInfo.setPassword(password);
                this.initUserPassword(userInfo);
            }
            userInfo.setAgentUser(false);
            while (true) {
                try {
                    this._addnew(ctx, (IObjectValue)userInfo);
                    continue block3;
                }
                catch (UserException ex) {
                    if (ex.getSubCode().equalsIgnoreCase("006")) {
                        userInfo.setNumber(personInfo.getNumber() + "(" + tmpIndex++ + ")");
                        this.initUserPassword(userInfo);
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
    }

    private void initUserPassword(UserInfo userInfo) throws BOSException {
        try {
            if (StringUtils.isEmpty((String)userInfo.getPassword())) {
                userInfo.setPassword(CryptoTean.encrypt((String)userInfo.getNumber(), (String)userInfo.getNumber()));
            } else {
                userInfo.setPassword(CryptoTean.encrypt((String)userInfo.getNumber(), (String)userInfo.getPassword()));
            }
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("CryptException.encrypt() error!", (Throwable)e);
        }
    }

    private UserInfo newUserInfo(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        UserInfo userInfo = UserInfoHelper.createNewDefaultUserInfo();
        userInfo.setNumber(personInfo.getNumber());
        MutilLangeToolForParam.muti2Obj((IObjectValue)personInfo, (String)"name", (IObjectValue)userInfo, (String)"name", (Context)ctx);
        userInfo.setCU(personInfo.getCU());
        userInfo.setAgentUser(true);
        userInfo.setPerson(personInfo);
        userInfo.setCell(personInfo.getCell());
        userInfo.setEmail(personInfo.getEmail());
        this.initUserPassword(userInfo);
        String securityId = "00000000-0000-0000-0000-0000000000013EE2C673";
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setId(BOSUuid.read((String)securityId));
        userInfo.setSecurity(securityInfo);
        return userInfo;
    }

    @Override
    protected void _saveRoleInfo(Context ctx, UserInfo userInfo, FullOrgUnitCollection fullOrgUnit, String roleID) throws BOSException, EASBizException {
        RoleCollection roleCol = new RoleCollection();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)roleID));
        roleCol.add(roleInfo);
        this._saveRoleInfo(ctx, userInfo, fullOrgUnit, roleCol);
    }

    @Override
    protected void _saveRoleInfo(Context ctx, UserInfo userInfo, FullOrgUnitCollection fullOrgUnitCol, RoleCollection roleCol) throws BOSException, EASBizException {
        if (fullOrgUnitCol == null || fullOrgUnitCol.isEmpty() || roleCol == null || roleCol.isEmpty()) {
            return;
        }
        IUserRoleOrgManager iUserRole = UserRoleOrgManagerFactory.getLocalInstance(ctx);
        UserRoleOrgCollection userRoleCol = new UserRoleOrgCollection();
        int size = fullOrgUnitCol.size();
        for (int i = 0; i < size; ++i) {
            for (int iRole = 0; iRole < roleCol.size(); ++iRole) {
                UserRoleOrgInfo userRoleInfo = new UserRoleOrgInfo();
                userRoleInfo.setUser(userInfo);
                userRoleInfo.setOrg(fullOrgUnitCol.get(i));
                userRoleInfo.setRole(roleCol.get(iRole));
                userRoleCol.add(userRoleInfo);
            }
            iUserRole.saveUserRoleOrgs(userRoleCol, userInfo.getId().toString(), fullOrgUnitCol.get(i).getId().toString(), null);
        }
    }

    @Override
    protected boolean _matchPassword(Context ctx, String userNumber, String password) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)this._getUserInfoByNumber(ctx, userNumber);
        boolean ret = false;
        ret = StringUtils.isEmpty((String)password) ? StringUtils.isEmpty((String)userInfo.getPassword()) : password.equals(userInfo.getPassword());
        if (!ret) {
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
        return ret;
    }

    @Override
    protected String[][] _findUserByAD(Context ctx, String[][] orgs) throws BOSException, EASBizException {
        String[][] ret = new String[orgs.length][2];
        for (int i = 0; i < orgs.length; ++i) {
            ret[i] = this.findUserBy(ctx, orgs[i][0], orgs[i][1], orgs[i][2]);
        }
        return ret;
    }

    private String[] findUserBy(Context ctx, String adNumber, String name, String orgId) throws BOSException, EASBizException {
        String[] ret = new String[2];
        if (StringUtils.isEmpty((String)adNumber)) {
            ret[0] = "false";
            ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"AD_ACCOUNT_EMPTY", (java.util.Locale)ctx.getLocale());
            return ret;
        }
        if (StringUtils.isEmpty((String)name)) {
            ret[0] = "false";
            ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"REAL_NAME_EMPTY", (java.util.Locale)ctx.getLocale());
            return ret;
        }
        if (StringUtils.isEmpty((String)orgId)) {
            ret[0] = "false";
            ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"GROUP_INSIDE_EMPTY", (java.util.Locale)ctx.getLocale());
            return ret;
        }
        if (this.getOrgById(ctx, orgId) == null) {
            ret[0] = "false";
            ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"ORGID_EMPTY", (java.util.Locale)ctx.getLocale());
            return ret;
        }
        UserCollection userCol = this.getUserByAdNumber(ctx, adNumber);
        if (userCol.size() == 0) {
            UserCollection userColByName = this.getUserByName(ctx, name);
            if (userColByName.size() > 0) {
                UserInfo userInfo1 = userColByName.get(0);
                for (int i = 0; i < userColByName.size(); ++i) {
                    if (!adNumber.equals(userColByName.get(i).getNumber())) continue;
                    userInfo1 = userColByName.get(i);
                    break;
                }
                userInfo1.setAdNumber(adNumber);
                SelectorItemCollection selectorCol = new SelectorItemCollection();
                selectorCol.add(new SelectorItemInfo("adNumber"));
                this.updatePartial(ctx, (CoreBaseInfo)userInfo1, selectorCol);
                ret[0] = "true";
                ret[1] = userInfo1.getId().toString();
                return ret;
            }
            UserCollection userCollection = this.getUserCollection(ctx, "select fid where number='" + adNumber + "'");
            if (userCollection.size() > 0) {
                ret[0] = "false";
                ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"AD_ACCOUNT", (java.util.Locale)ctx.getLocale()) + adNumber + EASCommonResource.getString((String)RESOURCE, (String)"ACCOUNT_OCCUPIED", (java.util.Locale)ctx.getLocale());
            } else {
                UserInfo newUser = this.createUserByAd(ctx, adNumber, name, orgId);
                ret[0] = "true";
                ret[1] = newUser.getId().toString();
            }
        } else if (userCol.size() == 1) {
            UserInfo userInfo = userCol.get(0);
            if (!name.equals(userInfo.getName(new java.util.Locale("l2")))) {
                Connection conn = this.getConnection(ctx);
                try {
                    SQLUtils.execute((Connection)conn, (String)("update t_pm_user set fname_l2='" + name + "',fname_l3='" + name + "' where fid='" + userInfo.getId().toString() + "'"));
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
            ret[0] = "true";
            ret[1] = userInfo.getId().toString();
        } else if (userCol.size() > 1) {
            ret[0] = "false";
            ret[1] = EASCommonResource.getString((String)RESOURCE, (String)"EAS_HAS_REPETE_ADACCOUNT", (java.util.Locale)ctx.getLocale());
        }
        return ret;
    }

    private FullOrgUnitInfo getOrgById(Context ctx, String orgId) throws BOSException, EASBizException {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitInfo orgInfo = iOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            return orgInfo;
        }
        catch (BOSException ie) {
            logger.error((Object)"org id is invalid:", (Throwable)ie);
            return null;
        }
    }

    private UserCollection getUserByAdNumber(Context ctx, String adNumber) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        String sql = "select FName_l2,FID,FAdNumber from t_pm_user where FAdNumber = '" + adNumber + "'";
        UserCollection userCol = new UserCollection();
        try {
            Object user;
            con = this.getConnection(ctx);
            state = con.prepareStatement(sql);
            rs = state.executeQuery();
            while (rs.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("FID")));
                ((AbstractUserInfo)user).setName(rs.getString("FName_l2"), new java.util.Locale("l2"));
                ((AbstractUserInfo)user).setAdNumber(rs.getString("FAdNumber"));
                userCol.add((UserInfo)user);
            }
            user = userCol;
            return user;
        }
        catch (SQLException se) {
            logger.error((Object)"getUserByDescription error", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private UserCollection getUserByName(Context ctx, String name) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        String sql = "select FNumber,FName_l2,FID,FAdNumber from t_pm_user where fname_l2 = '" + name + "'";
        UserCollection userCol = new UserCollection();
        try {
            Object user;
            con = this.getConnection(ctx);
            state = con.prepareStatement(sql);
            rs = state.executeQuery();
            while (rs.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("FID")));
                ((AbstractUserInfo)user).setName(rs.getString("FName_l2"), new java.util.Locale("l2"));
                ((AbstractUserInfo)user).setNumber(rs.getString("FNumber"));
                ((AbstractUserInfo)user).setAdNumber(rs.getString("FAdNumber"));
                userCol.add((UserInfo)user);
            }
            user = userCol;
            return user;
        }
        catch (SQLException se) {
            logger.error((Object)"getUserByDescription error", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private SecurityInfo getFirstSecurity(Context ctx) throws BOSException, EASBizException {
        ISecurity iSecurity = SecurityFactory.getLocalInstance(ctx);
        SecurityCollection securityCol = iSecurity.getSecurityCollection();
        if (securityCol.size() > 0) {
            return securityCol.get(0);
        }
        return null;
    }

    private UserInfo createUserByAd(Context ctx, String adNumber, String name, String orgId) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        Calendar now = Calendar.getInstance();
        userInfo.setNumber(adNumber);
        userInfo.setName(name, new java.util.Locale("l2"));
        userInfo.setName(name, new java.util.Locale("l3"));
        userInfo.setType(UserType.OTHER);
        userInfo.setAdNumber(adNumber);
        userInfo.setSecurity(this.getFirstSecurity(ctx));
        userInfo.setIsForbidden(true);
        userInfo.setDefLocale(Locale.getEnum("L2"));
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
        userInfo.setCreator(creator);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)orgId));
        userInfo.setCU(cu);
        Timestamp effectiveDate = new Timestamp(now.getTimeInMillis());
        Timestamp pwEffectiveDate = new Timestamp(now.getTimeInMillis());
        userInfo.setEffectiveDate(effectiveDate);
        Timestamp invalidDate = null;
        try {
            invalidDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse("2099-12-31").getTime());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        userInfo.setInvalidationDate(invalidDate);
        userInfo.setPWEffectiveDate(pwEffectiveDate);
        userInfo.setIsRegister(true);
        FullOrgUnitInfo defOrg = new FullOrgUnitInfo();
        defOrg.setId(BOSUuid.read((String)orgId));
        OrgRangeInfo orgRange = new OrgRangeInfo();
        orgRange.setOrg(defOrg);
        orgRange.setType(OrgRangeType.BIZ_ORG_TYPE);
        userInfo.getOrgRange().add(orgRange);
        userInfo.setDefOrgUnit(defOrg);
        userInfo.setIsDelete(false);
        userInfo.setLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        try {
            userInfo.setPassword(CryptoTean.encrypt((String)userInfo.getNumber(), (String)"aaaa8888"));
        }
        catch (CryptException e) {
            logger.error((Object)"createUserByAd encrypt error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.addnew(ctx, (CoreBaseInfo)userInfo);
        return userInfo;
    }

    @Override
    protected IObjectValue _getPersonWithContact(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        String sql = "select a.femail,a.fmobile,a.fofficephone,a.fhomephone,a.fbackupemail from T_HR_PersonContactMethod a join t_bd_person b on a.fpersonid=b.fid where b.fid=?";
        PersonInfo ret = (PersonInfo)personInfo;
        String personId = ret.getId().toString();
        Object[] params = new Object[]{personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            if (rs.next()) {
                if (StringUtils.isEmpty((String)ret.getEmail())) {
                    ret.setEmail(rs.getString("femail"));
                }
                if (StringUtils.isEmpty((String)ret.getBackupEMail())) {
                    ret.setBackupEMail(rs.getString("fbackupemail"));
                }
                if (StringUtils.isEmpty((String)ret.getCell())) {
                    ret.setCell(rs.getString("fmobile"));
                }
                if (StringUtils.isEmpty((String)ret.getOfficePhone())) {
                    ret.setOfficePhone(rs.getString("fofficephone"));
                }
                if (StringUtils.isEmpty((String)ret.getHomePhone())) {
                    ret.setHomePhone(rs.getString("fhomephone"));
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        return ret;
    }

    @Override
    protected void _createWeiBoUser(Context ctx, String email, String personId) throws BOSException, EASBizException {
        try {
            WeiboBizUtil.adminCreateUnverifiedWeiboUser((Context)ctx, (String)email, (String)personId, (String)"4");
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK userPK, IObjectValue model, UserUpdateParam param) throws BOSException, EASBizException {
        BOSUuid userId;
        UserInfo userInfo = (UserInfo)model;
        this.sysnUserCell(userInfo);
        UserInfo oldUserInfo = this.getUserByID(ctx, userPK);
        if (!userInfo.getCU().getId().equals((Object)oldUserInfo.getCU().getId())) {
            this.handleCuSwitch(ctx, userInfo, param.isDeleteOldCuPerm(), oldUserInfo.getCU().getId().toString());
        }
        if (!oldUserInfo.isBizAdmin() && userInfo.isBizAdmin() && !UserType.SYSTEM.equals((Object)ContextUtil.getCurrentUserInfo((Context)ctx).getType())) {
            throw new UserException(UserException.CAN_NOT_MODIFY_BIZADMIN, new Object[]{oldUserInfo.getNumber()});
        }
        if (!userInfo.getType().equals((Object)oldUserInfo.getType())) {
            if (this._checkUserIsRelatedWithPerms(ctx, userPK)) {
                throw new UserException(UserException.CAN_NOT_MODIFY_TYPE_AND_NAME, new Object[]{oldUserInfo.getNumber()});
            }
        } else {
            boolean realNameChange = true;
            if (UserType.PERSON.equals((Object)userInfo.getType())) {
                if (oldUserInfo.getPerson() == null && oldUserInfo.getPerson() == null || oldUserInfo.getPerson() != null && userInfo.getPerson() != null && oldUserInfo.getPerson().getId().toString().equals(userInfo.getPerson().getId().toString())) {
                    realNameChange = false;
                }
            } else if (UserType.CUSTOMER.equals((Object)userInfo.getType())) {
                if (oldUserInfo.getCustomerID() == null && oldUserInfo.getCustomerID() == null || oldUserInfo.getCustomerID() != null && userInfo.getCustomerID() != null && oldUserInfo.getCustomerID().equals(userInfo.getCustomerID())) {
                    realNameChange = false;
                }
            } else if (UserType.SUPPLIER.equals((Object)userInfo.getType())) {
                if (oldUserInfo.getSupplierID() == null && oldUserInfo.getSupplierID() == null || oldUserInfo.getSupplierID() != null && userInfo.getSupplierID() != null && oldUserInfo.getSupplierID().equals(userInfo.getSupplierID())) {
                    realNameChange = false;
                }
            } else {
                java.util.Locale local = new java.util.Locale("L2");
                if (StringUtils.equals((String)oldUserInfo.getName(local), (String)userInfo.getName(local)) && StringUtils.equals((String)oldUserInfo.getName(local = new java.util.Locale("L3")), (String)userInfo.getName(local)) && StringUtils.equals((String)oldUserInfo.getName(local = new java.util.Locale("L1")), (String)userInfo.getName(local))) {
                    realNameChange = false;
                }
            }
            if (realNameChange && this._checkUserIsRelatedWithPerms(ctx, userPK)) {
                throw new UserException(UserException.CAN_NOT_MODIFY_TYPE_AND_NAME, new Object[]{oldUserInfo.getNumber()});
            }
        }
        if (!userInfo.getType().equals((Object)oldUserInfo.getType())) {
            this.handleTypeSwitch(ctx, userInfo);
        }
        if (!ToolUtils.equalObject(userInfo.getPerson(), oldUserInfo.getPerson())) {
            this.checkPersonDup(ctx, userInfo);
            this.handlePersonSwitch(ctx, userInfo);
        }
        this.checkDateValidity(userInfo);
        this.checkNumberDup(ctx, userInfo.getNumber(), userPK);
        this.updateComfunctionLongnumber(ctx, userPK, model, oldUserInfo);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        if (userInfo.isBizAdmin()) {
            String orgId = userInfo.getCU().getId().toString();
            ArrayList<String> orgIdCol = new ArrayList<String>();
            orgIdCol.add(orgId);
            OrgRangeParam manageOrgRangeParam = new OrgRangeParam(userPK, OrgRangeType.MANAGE_ORG_TYPE, null, orgIdCol, null);
            iOrgRange.saveOrgRange(manageOrgRangeParam);
        } else if ((UserType.PERSON.equals((Object)userInfo.getType()) || UserType.OTHER.equals((Object)userInfo.getType())) && (userId = userInfo.getId()) != null) {
            IOrgRange iorgrange0 = OrgRangeFactory.getLocalInstance(ctx);
            iorgrange0.delete("where user.id = '" + userId.toString() + "' and type=" + 30);
            iOrgRange.delete("where user.id = '" + userId.toString() + "' and type=" + 30);
        }
        this.checkCellorMailDup(ctx, userInfo.getCell(), userInfo.getEmail(), userPK);
        LogProxy logProxy = new LogProxy();
        String userIdStr = userPK.toString();
        IObjectPK logPk = null;
        if (param.isUpdatePW()) {
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(userIdStr);
            Object[] params = new Object[]{ctx.getUserName(), userInfo.getName()};
            String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"setPassword", (java.util.Locale)ctx.getLocale()), params);
            logPk = LogUtil.beginLog((Context)ctx, (String)"UserControllerBean_update()", (BOSObjectType)this.getBOSType(), null, (String)msg, (String)"bs_permission_change_psssword");
            String password = PermissionUtil.decrypt(userInfo.getNumber(), userInfo.getPassword());
            userInfo.setPassword(password);
            SecurityValidator.checkUserUpdatePw(userIdStr, password);
            this.checkSecurity(ctx, userInfo);
            if (StringUtils.isEmpty((String)userInfo.getPassword())) {
                userInfo.setPassword(null);
            } else {
                PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
                userInfo.setPassword(PermissionUtil.encrypt(userIdStr, userInfo.getPassword(), passwordType));
                userInfo.setPasswordType(passwordType);
            }
            userInfo.setPWEffectiveDate(new Date());
            userInfo.setChangedPW(true);
            this.checkPwSameBefore(userInfo);
            LdapProxy ldapProxy = new LdapProxy(ctx);
            ldapProxy.submit(userIdStr, password);
            logProxy.beginLog(ctx, MyEntityInfo.getMethodAlias(ctx, (CoreBaseInfo)userInfo, "updatePass"), userInfo.getBOSType(), null, userInfo.getNumber());
        } else {
            userInfo.remove("password");
            userInfo.remove("passwordtype");
        }
        GroupLicenseUseInfoUtil.changeUserInfo(ctx, userInfo, oldUserInfo);
        SMSValidataUserManagerUtil.checkCanUpdate(ctx, userInfo);
        super._update(ctx, userPK, (IObjectValue)userInfo);
        CloudLicenseUtil.refreshUserSyncStatus(ctx, userPK);
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userIdStr);
        logProxy.end();
        if (param.isUpdateOrgRange()) {
            if (userInfo.containsKey("orgRange")) {
                this.saveOrgRange(ctx, userInfo);
            }
            if (userInfo.containsKey("orgRangeIncludeSubOrg")) {
                this.saveOrgRangeIncludeSubOrg(ctx, userInfo);
            }
        }
        CacheUtil.updateCacheOfUserInfo(ctx, userPK.toString());
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK(userPK);
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
        if (param.isUpdatePW()) {
            this.kickOutUserAfterChangePW(ctx, userInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
    }

    private void addOrgRangeOfNewUserForCloud(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        String orgId = userInfo.getCU().getId().toString();
        ArrayList<String> orgIdCol = new ArrayList<String>();
        orgIdCol.add(orgId);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, orgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
        if (userInfo.getPerson() != null) {
            this.addAdminOrgRangeForPersonForCloud(ctx, userInfo);
        }
    }

    private void addAdminOrgRangeForPersonForCloud(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        List removedSubOrgFidList;
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PositionCollection positionCol = iPerson.getPositions(userInfo.getPerson().getId());
        if (positionCol == null || positionCol.isEmpty()) {
            return;
        }
        ArrayList<String> orgLongNumberList = new ArrayList<String>();
        ArrayList<String> orgFidList = new ArrayList<String>();
        for (int i = 0; i < positionCol.size(); ++i) {
            PositionInfo positionInfo = positionCol.get(i);
            AdminOrgUnitInfo adminInfo = positionInfo.getAdminOrgUnit();
            if (positionInfo.isIsRespPosition() && adminInfo != null) {
                if (StringUtils.isEmpty((String)adminInfo.getLongNumber())) {
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    adminInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminInfo.getId().toString()));
                }
                orgLongNumberList.add(adminInfo.getLongNumber());
                continue;
            }
            if (adminInfo == null) continue;
            orgFidList.add(adminInfo.getId().toString());
        }
        this.removeSuborgLongnumber(orgLongNumberList);
        StringBuffer longnumberLikeSql = new StringBuffer();
        StringBuffer longnumberEqualSql = new StringBuffer();
        StringBuffer fidInSql = new StringBuffer();
        if (orgLongNumberList != null && orgLongNumberList.size() > 0) {
            for (int i = 0; i < orgLongNumberList.size(); ++i) {
                longnumberLikeSql.append(" OR FLONGNUMBER LIKE '").append(orgLongNumberList.get(i)).append("!%' ");
                longnumberEqualSql.append(" OR FLONGNUMBER ='").append(orgLongNumberList.get(i)).append("' ");
            }
        }
        if ((removedSubOrgFidList = this.getRemovedSuborgFidList(ctx, orgLongNumberList, orgFidList)) != null && removedSubOrgFidList.size() > 0) {
            fidInSql.append(" OR FID IN (");
            fidInSql.append(ToolUtils.aryToStr(removedSubOrgFidList)).append(")");
        }
        LogProxy logProxy = new LogProxy();
        String conditionSql = "WHERE 1=0 " + longnumberLikeSql.toString() + longnumberEqualSql.toString() + fidInSql.toString();
        try {
            this.beginLog(ctx, logProxy, (IObjectPK)userPK, conditionSql);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.insertOrgRange(ctx, userPK.toString(), conditionSql.toString());
        this.insertOrgRangeIncludesuborg(ctx, userPK.toString(), longnumberEqualSql.toString(), fidInSql.toString());
        try {
            logProxy.end();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void _addNewForCloud(Context ctx, IObjectValue model, boolean isPersonToManyUser, IObjectCollection roleCol) throws BOSException, EASBizException {
        boolean result;
        UserInfo userInfo = (UserInfo)model;
        RoleCollection roleCollection = (RoleCollection)roleCol;
        boolean isPersonType = UserType.PERSON.equals((Object)userInfo.getType());
        if (!isPersonToManyUser && isPersonType && (result = this.exists(ctx, "where person='" + userInfo.getPerson().getId().toString() + "' and isDelete=0"))) {
            logger.error((Object)("exist personUser*** " + userInfo.getPerson().getId() + " ***userNumber!=" + userInfo.getNumber()));
            return;
        }
        IObjectPK userPK = super._addnew(ctx, (IObjectValue)userInfo);
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        this.addOrgRangeOfNewUserForCloud(ctx, userInfo);
        if (isPersonType) {
            FullOrgUnitCollection fullOrgUnit = new FullOrgUnitCollection();
            fullOrgUnit.add(userInfo.getDefOrgUnit());
            this._saveRoleInfo(ctx, userInfo, fullOrgUnit, roleCollection);
        }
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userPK.toString(), null);
        try {
            if (userInfo.getPerson() == null) {
                return;
            }
            UserFactory.getLocalInstance(ctx).createWeiBoUser(userInfo.getEmail(), userInfo.getPerson().getId().toString());
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    protected void _createEmpUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        this.checkDateValidity(userInfo);
        String password = PermissionUtil.decrypt(userInfo.getNumber(), userInfo.getPassword());
        userInfo.setPassword(password);
        this.checkNumberDup(ctx, userInfo.getNumber(), null);
        this.checkSecurity(ctx, userInfo);
        this.checkPersonDup(ctx, userInfo);
        BOSUuid userID = BOSUuid.create((BOSObjectType)userInfo.getBOSType());
        userInfo.setId(userID);
        this.setUserDefOrgUnit(ctx, userInfo);
        if (StringUtils.isEmpty((String)password)) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userID.toString(), password, passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setPwdHisStr(userInfo.getPassword());
        userInfo.setChangedPW(false);
        IObjectPK userPK = super._addnew(ctx, (IObjectValue)userInfo);
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userPK.toString(), password);
    }

    protected void _updatePass(Context ctx, IObjectPK userPK, String newPW) throws BOSException, EASBizException {
        if (ctx.getCaller() == null) {
            ctx.setCaller(userPK);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("security.*"));
        UserInfo userInfo = this.getUserInfo(ctx, userPK, sc);
        newPW = PermissionUtil.decrypt(userInfo.getNumber(), newPW);
        if (userInfo.getSecurity() == null) {
            throw new UserException(UserException.USER_NOT_SECURITY);
        }
        userInfo.setPassword(newPW);
        SecurityValidator securityValidator = new SecurityValidator(ctx, userInfo);
        securityValidator.validate();
        if (StringUtils.isEmpty((String)userInfo.getPassword())) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userPK.toString(), newPW, passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setPWEffectiveDate(new Date());
        userInfo.setChangedPW(true);
        this.checkPwSameBefore(userInfo);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"USER_UPDATE_PWD", (java.util.Locale)ctx.getLocale()), (BOSObjectType)userInfo.getBOSType(), null, (String)this.getUpdatePasswordLogDetail(ctx, userInfo), (String)"bs_permission_user_update_password");
        super._update(ctx, userPK, (IObjectValue)userInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userPK.toString(), newPW);
        this.kickOutUserAfterChangePW(ctx, userInfo);
    }

    protected void _register(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (userInfo == null) {
            return;
        }
        UserInfo oldUser = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)userInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)new Integer(1)));
        viewInfo.setFilter(filter);
        UserCollection uColl = this.getUserCollection(ctx, viewInfo);
        if (uColl != null && uColl.size() > 0) {
            oldUser = uColl.get(0);
        }
        if (oldUser != null) {
            userInfo.setId(oldUser.getId());
            String sbSQL = "DELETE FROM T_PM_UserRoleOrg WHERE FUserID =?";
            DbUtil.execute((Context)ctx, (String)sbSQL, (Object[])new Object[]{oldUser.getId().toString()});
            sbSQL = "DELETE FROM T_PM_UserOrgPerm WHERE FOwner = ?";
            DbUtil.execute((Context)ctx, (String)sbSQL, (Object[])new Object[]{oldUser.getId().toString()});
            sbSQL = "DELETE FROM T_PM_OrgRange WHERE FUserID = ?";
            DbUtil.execute((Context)ctx, (String)sbSQL, (Object[])new Object[]{oldUser.getId().toString()});
            sbSQL = "DELETE FROM T_PM_User WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sbSQL, (Object[])new Object[]{oldUser.getId().toString()});
        }
        userInfo.setChangedPW(false);
        userInfo.setIsDelete(false);
        this.checkDateValidity(userInfo);
        String password = PermissionUtil.decrypt(userInfo.getNumber(), userInfo.getPassword());
        userInfo.setPassword(password);
        this.checkNumberDup(ctx, userInfo.getNumber(), null);
        this.checkSecurity(ctx, userInfo);
        this.checkPersonDup(ctx, userInfo);
        BOSUuid userID = BOSUuid.create((BOSObjectType)userInfo.getBOSType());
        userInfo.setId(userID);
        this.setUserDefOrgUnit(ctx, userInfo);
        if (StringUtils.isEmpty((String)userInfo.getPassword())) {
            userInfo.setPassword(null);
        } else {
            PasswordType passwordType = PermissionUtils.getPasswordType(ctx);
            userInfo.setPassword(PermissionUtil.encrypt(userID.toString(), userInfo.getPassword(), passwordType));
            userInfo.setPasswordType(passwordType);
        }
        userInfo.setPwdHisStr(userInfo.getPassword());
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userID));
        IObjectPK userPK = super._addnew(ctx, (IObjectValue)userInfo);
    }

    protected void _activate(Context ctx, String userId) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        UserInfo userInfo = this.getUserInfo(ctx, (IObjectPK)userPK);
        userInfo.setChangedPW(true);
        String sql = "UPDATE T_PM_User SET FIsActivate=1,FIsChangedPW=1 where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        ctx.setCaller((IObjectPK)userPK);
        ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
        ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo.getCU());
        String cuOrgId = userInfo.getCU().getId().toString();
        String defaultOrgId = userInfo.getDefOrgUnit().getId().toString();
        HashSet<String> orgIdCol = new HashSet<String>();
        orgIdCol.add(cuOrgId);
        orgIdCol.add(defaultOrgId);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, orgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add("YW3xsAEJEADgAAcrwKgTBxO2cyo=");
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            String personId = personInfo.getId().toString();
            if (UserInfoUtils.isLeader(ctx, personId)) {
                roleList.add("vqoC6sk6Svmijjatmt+tSBO2cyo=");
            }
            if (UserInfoUtils.isManager(ctx, personId)) {
                roleList.add("00000000-0000-0000-0000-00000000000013B6732A");
            }
        }
        this.addDefRoleOfNewUser(ctx, userInfo, roleList);
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(userId);
    }

    protected IObjectPK _synchAddNew(Context ctx, UserInfo userInfo, String password) throws BOSException, EASBizException {
        IObjectPK pk = this._addnew(ctx, (IObjectValue)userInfo);
        String sql = "UPDATE T_PM_User SET FPassWord=? where FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{password, pk.toString()});
        LdapProxy ldapProxy = new LdapProxy(ctx);
        ldapProxy.submit(pk.toString(), password);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _remove(Context ctx, List userPKs) throws BOSException, EASBizException {
        boolean bl;
        String deleteOrgSql = "delete from t_pm_orgrange where fuserid in( " + ToolUtils.aryToStr(userPKs) + " )";
        String deleteOrgInSql = "delete from t_pm_orgrangeincludesuborg where fuserid in( " + ToolUtils.aryToStr(userPKs) + " )";
        String deletePermSql = "delete from t_pm_userorgperm where fowner in( " + ToolUtils.aryToStr(userPKs) + " )";
        String deleteRolePermSql = "delete from t_pm_userroleorg where fuserid in( " + ToolUtils.aryToStr(userPKs) + " )";
        String deleteSql = "delete from t_pm_user where fid in( " + ToolUtils.aryToStr(userPKs) + " )";
        Connection conn = null;
        Statement stat = null;
        try {
            conn = this.getConnection(ctx);
            stat = conn.createStatement();
            stat.addBatch(deleteOrgSql);
            stat.addBatch(deleteOrgInSql);
            stat.addBatch(deletePermSql);
            stat.addBatch(deleteRolePermSql);
            stat.addBatch(deleteSql);
            stat.executeBatch();
            CacheUtil.clearBizCache(BOSObjectType.create((String)"13B7DE7F"));
            bl = true;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(stat, (Connection)conn);
                throw throwable;
            }
            SQLUtil.cleanup((Statement)stat, (Connection)conn);
            return bl2;
        }
        SQLUtil.cleanup((Statement)stat, (Connection)conn);
        return bl;
    }

    @Override
    protected String _getSSOURL(Context ctx, String pageURL, String userName) throws BOSException, EASBizException {
        String serverURL = "";
        String dbType = ctx.get((Object)"dbType").toString();
        int dbValue = 0;
        if ("Oracle".equalsIgnoreCase(dbType)) {
            dbValue = 2;
        }
        if ("MS SQL Server".equalsIgnoreCase(dbType)) {
            dbValue = 0;
        }
        if ("DB2 UDB".equalsIgnoreCase(dbType)) {
            dbValue = 1;
        }
        if (StringUtils.isEmpty((String)pageURL)) {
            serverURL = "http://127.0.0.1:6888/easportal";
            pageURL = "";
        } else {
            String[] url = pageURL.split(";");
            serverURL = url[0];
            pageURL = url[1];
        }
        String password = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
        String partUrl = "username=administrator&password=" + password + "&isNotCheckRelogin=true&dbType=" + dbValue + "&dataCenter=" + ctx.getAIS() + "&locale=" + ctx.getLocale().toString() + "&redirectTo=";
        try {
            pageURL = serverURL + "/portal/index2sso.jsp?" + partUrl + URLEncoder.encode(pageURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UnsupportedEncodingException-----------------" + e));
        }
        return pageURL;
    }

    private void updateComfunctionLongnumber(Context ctx, IObjectPK userPK, IObjectValue model, UserInfo oldUserInfo) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)model;
        String oldUserNumber = oldUserInfo.getNumber();
        String newUserNumber = userInfo.getNumber();
        if (newUserNumber != null && newUserNumber.equals(oldUserNumber)) {
            return;
        }
        ArrayList<String> param = new ArrayList<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String getfcOldLongnumberSql = "select fid,fnumber,flongnumber,fisleaf from t_bas_comfunction where fuserid = '" + userPK + "'";
        String updateFcNumberSql = "update t_bas_comfunction set fnumber = ?, flongnumber = ? where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getfcOldLongnumberSql);
        if (rs.size() == 0) {
            return;
        }
        try {
            while (rs.next()) {
                String fcOldNumber = null;
                String fcOldLongnumber = null;
                Object fcNewNumber = null;
                String fcNewLongNumber = null;
                String fcOldRootUser = null;
                String fcid = rs.getString("fid");
                String fcIsLeaf = rs.getString("fisleaf");
                fcOldNumber = rs.getString("fnumber");
                fcOldLongnumber = rs.getString("flongnumber");
                if (fcOldLongnumber == null || fcOldLongnumber == null || fcOldLongnumber.indexOf("!") <= -1 && !"0".equals(fcIsLeaf) || fcOldLongnumber.indexOf("root" + oldUserNumber) != 0) continue;
                if (fcOldLongnumber.indexOf("!") > -1) {
                    fcOldRootUser = fcOldLongnumber.substring(0, fcOldLongnumber.indexOf("!"));
                    fcNewLongNumber = fcOldLongnumber.substring(fcOldLongnumber.indexOf("!"));
                    fcNewLongNumber = "root" + newUserNumber + fcNewLongNumber;
                } else {
                    fcNewLongNumber = fcOldLongnumber.indexOf("root" + oldUserNumber) == 0 && "0".equals(fcIsLeaf) ? "root" + newUserNumber : fcOldLongnumber;
                }
                param = new ArrayList();
                if (fcOldNumber != null && fcOldNumber.indexOf("root" + oldUserNumber) != -1) {
                    param.add("root" + newUserNumber);
                } else {
                    param.add(fcOldNumber);
                }
                param.add(fcNewLongNumber);
                param.add(fcid);
                params.add(param.toArray());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateFcNumberSql, params);
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.checkCellorMailDup(ctx, ((UserInfo)model).getCell(), ((UserInfo)model).getEmail(), pk);
        super.update(ctx, pk, model);
    }

    @Override
    protected Map _userInfoCheck(Context ctx, IObjectValue userInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean flag = true;
        String msg = "";
        result.put("flag", flag);
        result.put("msg", msg);
        String controlPolicy = "";
        try {
            controlPolicy = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getControlPolicy();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        if ("Subsystem".equalsIgnoreCase(controlPolicy)) {
            return result;
        }
        try {
            Object resultInfo = null;
            UserInfo user = (UserInfo)userInfo;
            int index = 0;
            String userNumber = null;
            String userName = null;
            String cell = user.getCell();
            String nameField = MultiLangHelper.getFieldName("FName", ctx.getLocale());
            if (cell != null && cell.trim().length() > 0) {
                IRowSet rowSet;
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT top 1 FID,FNUMBER," + nameField + " FROM T_PM_User WHERE UPPER(FCell) =  UPPER(N'").append(cell).append("') and FISDELETE<>1");
                if (user.getId() != null) {
                    sql.append(" AND FID <> '").append(user.getId().toString()).append("' ");
                }
                if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
                    ++index;
                    userNumber = rowSet.getString("FNUMBER");
                    userName = rowSet.getString(nameField);
                    flag = false;
                }
            }
            String _userNumber = null;
            String _userName = null;
            String mail = user.getEmail();
            if (mail != null && mail.trim().length() > 0) {
                IRowSet _rowSet;
                StringBuffer _sql = new StringBuffer();
                _sql.append(" SELECT top 1 FID,FNUMBER," + nameField + " FROM T_PM_User WHERE UPPER(FEMail) = UPPER(N'").append(mail).append("') and FISDELETE<>1");
                if (user.getId() != null) {
                    _sql.append(" AND FID <> '").append(user.getId().toString()).append("' ");
                }
                if ((_rowSet = DbUtil.executeQuery((Context)ctx, (String)_sql.toString())).next()) {
                    index += 2;
                    _userNumber = _rowSet.getString("FNUMBER");
                    _userName = _rowSet.getString(nameField);
                    flag = false;
                }
            }
            java.util.Locale l = ContextUtils.getLocaleFromEnv();
            if (index == 1) {
                msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PhoneExists", (java.util.Locale)l), user.getNumber(), userNumber, user.getCell());
            }
            if (index == 2) {
                msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"EmailExists", (java.util.Locale)l), _userNumber, user.getEmail());
            } else if (index == 3) {
                msg = userNumber.equals(_userNumber) ? MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PhoneAndEmailExists", (java.util.Locale)l), userNumber, userName, userNumber, userName) : MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"PhoneAndEmailExists", (java.util.Locale)l), userNumber, userName, _userNumber, _userName);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL, e);
        }
        result.put("flag", flag);
        result.put("msg", msg);
        return result;
    }

    @Override
    protected void _updateByPro(Context ctx, IObjectPK pk, String pro, Object value) throws BOSException, EASBizException {
        String fieldName = ("F" + pro).toUpperCase();
        DbUtil.execute((Context)ctx, (String)("update t_pm_user set " + fieldName + " = ? where fid = ?"), (Object[])new Object[]{value, pk.toString()});
    }

    @Override
    protected void _refreshUserActivedStatus(Context ctx) throws BOSException, EASBizException {
        try {
            if (!LicenseSrvAgentFactory.getLocalInstance((Context)ctx).isRegister()) {
                return;
            }
            ICloudRegistSrv iCloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            IUser iuser = UserFactory.getLocalInstance(ctx);
            boolean isBySubscriptionRegOnline = ControlPolicy.isBySubscriptionRegOnline((Context)ctx);
            UserCollection userColl = new UserCollection();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            userColl = !isBySubscriptionRegOnline ? iuser.getUserCollection("select id,number,erpUserStatus where isDelete = 0") : iuser.getUserCollection("select id,number,cell,email,erpUserStatus where isDelete = 0");
            for (int i = 0; i < userColl.size(); ++i) {
                UserInfo userInfo = userColl.get(i);
                ErpUserStatus oldStatus = userInfo.getErpUserStatus();
                ErpUserStatusEnum status = null;
                status = !isBySubscriptionRegOnline ? iCloudRegistSrv.getErpUserIsActived(userInfo.getNumber()) : iCloudRegistSrv.getErpUserIsActived(userInfo.getNumber(), userInfo.getCell(), userInfo.getEmail());
                if (ErpUserStatusEnum.SUCCESSED.equals((Object)status) && !ErpUserStatus.SUCCESSED.equals((Object)oldStatus)) {
                    paramsList.add(new Object[]{3, userInfo.getId().toString()});
                    continue;
                }
                if (ErpUserStatusEnum.SUCCESSED.equals((Object)status) || ErpUserStatus.NOT_ACTIVATED.equals((Object)oldStatus)) continue;
                paramsList.add(new Object[]{1, userInfo.getId().toString()});
            }
            DbUtil.executeBatch((Context)ctx, (String)"update t_pm_user set fErpUserStatus= ? where fid= ?", paramsList);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        try {
            CloudLicenseUtil.refreshUserSyncStatus(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected DataBaseInfo _getGlobalRoaming(Context ctx, String areaCode) throws BOSException, EASBizException {
        DataBaseInfo result = null;
        try {
            CoreBaseInfo coreBaseInfo;
            Class<?> utilCls = Class.forName("com.kingdee.eas.basedata.assistant.app.GlobalRoamingControllerBean");
            Object util = utilCls.newInstance();
            Class[] paramType = new Class[]{Context.class, String.class};
            Method staticFunc1 = utilCls.getMethod("getCollection", Context.class, String.class);
            Object[] paramValue = new Object[]{ctx, "where areaCode='" + areaCode + "'"};
            Object retValue = staticFunc1.invoke(util, paramValue);
            if (retValue != null && retValue instanceof CoreBaseCollection && (coreBaseInfo = ((CoreBaseCollection)retValue).get(0)) != null && coreBaseInfo instanceof DataBaseInfo) {
                result = (DataBaseInfo)coreBaseInfo;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void sysnUserCell(UserInfo user) {
        String global = user.getGlobalRoaming();
        String ncell = user.getNCell();
        String cell = user.getCell();
        if (!StringUtils.isEmpty((String)ncell)) {
            if (StringUtils.isEmpty((String)global)) {
                global = "+86";
            }
            if ("+86".equals(global)) {
                user.setCell(ncell);
            } else {
                user.setCell(global + "-" + ncell);
            }
        } else if (!StringUtils.isEmpty((String)cell)) {
            String[] globalMap = ToolUtils.getGLObalMapCell(cell);
            user.setGlobalRoaming(globalMap[0]);
            user.setNCell(globalMap[1]);
        } else {
            user.setGlobalRoaming(null);
        }
    }

    @Override
    protected boolean _checkGlobalRomingIsUse(Context ctx, String globalRoming) throws BOSException, EASBizException {
        return this.exists(ctx, "select top 1 where globalRoaming = '" + globalRoming + "'");
    }

    @Override
    protected void _updateUserGlobalRomaing(Context ctx, String oldGlobalRomaing, String newGlobalRomaing) throws BOSException, EASBizException {
        if (oldGlobalRomaing.equals(newGlobalRomaing)) {
            return;
        }
        UserCollection userColl = this.getUserCollection(ctx, "select id ,ncell where globalRoaming='" + oldGlobalRomaing + "'");
        Connection conn = null;
        PreparedStatement preStmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement("update T_PM_USER set FGLObalRoaming=?, FCELL=? where fid = ?");
            for (int i = 0; i < userColl.size(); ++i) {
                UserInfo userInfo = userColl.get(i);
                String id = userInfo.getId().toString();
                String ncell = userInfo.getNCell();
                if (StringUtils.isEmpty((String)ncell)) continue;
                preStmt.setString(1, newGlobalRomaing);
                if ("+86".equals(newGlobalRomaing)) {
                    preStmt.setString(2, ncell);
                } else {
                    preStmt.setString(2, newGlobalRomaing + "-" + ncell);
                }
                preStmt.setString(3, id);
                preStmt.addBatch();
            }
            preStmt.executeBatch();
            preStmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)model;
        this.sysnUserCell(user);
        super._update(ctx, pk, (IObjectValue)user);
    }

    @Override
    protected void _resetUserInfo(Context ctx, IObjectPK userId) throws BOSException, EASBizException {
        UserInfo userInfo = super.getUserByID(ctx, userId);
        if (userInfo == null) {
            return;
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"USER_ASSIGN_PERM", (java.util.Locale)ctx.getLocale()), (BOSObjectType)this.getBOSType(), (IObjectPK)userId, (String)("resert user : " + userInfo.getNumber()));
        UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, userId.toString(), EASCommonResource.getString((String)RESOURCE, (String)"RESET_USER", (java.util.Locale)ctx.getLocale()));
        userPermChangeListener.before();
        OrgRangeIncludeSubOrgCollection subOrg = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).getOrgRangeIncludeSubOrgCollection("select * where user.id = '" + userId.toString() + "'");
        if (subOrg != null && !subOrg.isEmpty()) {
            FullOrgUnitCollection fullOrgUnitCollection = new FullOrgUnitCollection();
            for (int i = 0; i < subOrg.size(); ++i) {
                if (subOrg.get(i).getOrg() == null || fullOrgUnitCollection.contains(subOrg.get(i).getOrg())) continue;
                fullOrgUnitCollection.add(subOrg.get(i).getOrg());
            }
            String currUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            UserOrgPermFacadeFactory.getLocalInstance(ctx).saveUserOrgPerms((IObjectPK)new ObjectUuidPK(currUserId), userId, fullOrgUnitCollection, new UserOrgPermCollection[]{new UserOrgPermCollection(), new UserOrgPermCollection(), new UserOrgPermCollection()}, false);
            OrgRangeParam orgRangeParam = new OrgRangeParam();
            orgRangeParam.setDeleteAll(true);
            orgRangeParam.setUserPK(userId);
            orgRangeParam.setOrgRangeType(OrgRangeType.BIZ_ORG_TYPE);
            OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).saveOrgRange(orgRangeParam);
            orgRangeParam.setOrgRangeType(OrgRangeType.MANAGE_ORG_TYPE);
            OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).saveOrgRange(orgRangeParam);
            orgRangeParam.setOrgRangeType(OrgRangeType.ADMIN_ORG_TYPE);
            OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).saveOrgRange(orgRangeParam);
            orgRangeParam.setOrgRangeType(OrgRangeType.UNION_ORG_TYPE);
            OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).saveOrgRange(orgRangeParam);
        }
        Connection conn = null;
        PreparedStatement deleteRoleStatement = null;
        PreparedStatement deleteGrantRoleStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            deleteRoleStatement = conn.prepareStatement("delete from T_PM_UserRoleOrg where FUSERID = ?");
            deleteRoleStatement.setString(1, userId.toString());
            deleteRoleStatement.execute();
            deleteGrantRoleStatement = conn.prepareStatement("delete from T_PM_GrantUserRoleOrg where FUSERID = ?");
            deleteGrantRoleStatement.setString(1, userId.toString());
            deleteGrantRoleStatement.execute();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(deleteGrantRoleStatement);
                SQLUtils.cleanup((Statement)deleteRoleStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)deleteGrantRoleStatement);
        SQLUtils.cleanup((Statement)deleteRoleStatement, (Connection)conn);
        this.setUserDefOrgUnit(ctx, userInfo);
        ArrayList<String> roleList = new ArrayList<String>();
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo != null) {
            String personId = personInfo.getId().toString();
            if (UserInfoUtils.isLeader(ctx, personId)) {
                roleList.add("vqoC6sk6Svmijjatmt+tSBO2cyo=");
            }
            if (UserInfoUtils.isManager(ctx, personId)) {
                roleList.add("00000000-0000-0000-0000-00000000000013B6732A");
            }
        }
        this.addOrgRangeOfNewUser(ctx, userInfo);
        this.correctOrgSolution(ctx, userInfo);
        if (userInfo.getType().equals((Object)UserType.PERSON)) {
            this.addDefRoleOfNewUser(ctx, userInfo, roleList);
        }
        userPermChangeListener.after();
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _updateLoginNumber(Context ctx, String loginNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)loginNumber)) {
            throw new UserException(UserException.LOGINNUMBER_NOTNULL);
        }
        if (loginNumber.equalsIgnoreCase(ctx.getUserName())) {
            throw new UserException(UserException.LOGINNUMBER_CANNOT_EQUAL_NUMBER);
        }
        this.checkNumberDup(ctx, loginNumber, ctx.getCaller());
        DbUtil.execute((Context)ctx, (String)"update t_pm_user set FLoginNumber=? where fid =?", (Object[])new Object[]{loginNumber, ctx.getCaller().toString()});
    }

    private void kickOutUserAfterChangePW(Context ctx, UserInfo userinfo) throws EASBizException, BOSException {
        IUserMonitor iUserMonitor = UserMonitorFactory.getLocalInstance((Context)ctx);
        List userList = iUserMonitor.findUsers(ctx.getAIS(), userinfo.getNumber());
        userList = this.filter(userList, userinfo.getId().toString());
        try {
            for (Object user : userList) {
                UMRegistryInfo info = (UMRegistryInfo)user;
                String sessionID = info.getId();
                if (StringUtils.isEmpty((String)ctx.getContextID()) || ctx.getContextID().equals(sessionID)) continue;
                KickoutFacadeFactory.getLocalInstance((Context)ctx).kickoutUser(info.getUserName());
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            }
            logger.info((Object)"kickOutUsersAfterChangePasswordSuccess");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("kickOutUserAfterChangePW" + e));
        }
    }

    private List filter(List users, String userId) {
        if (userId == null || users == null) {
            return users;
        }
        ArrayList<UMRegistryInfo> result = new ArrayList<UMRegistryInfo>();
        for (UMRegistryInfo user : users) {
            if (user.getId().equals(userId)) continue;
            result.add(user);
        }
        return result;
    }

    private class LogThread
    implements Runnable {
        private LogProxy logProxy;
        private Context ctx;
        private IObjectPK userPK;
        private String conditionSql;

        public LogThread(Context ctx, LogProxy logProxy, IObjectPK userPK, String conditionSql) {
            this.logProxy = logProxy;
            this.ctx = ctx;
            this.userPK = userPK;
            this.conditionSql = conditionSql;
        }

        @Override
        public void run() {
            try {
                UserControllerBean.this.beginLog(this.ctx, this.logProxy, this.userPK, this.conditionSql);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }
}

