/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermMutexExLockType;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermException;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.AbstractUserOrgPermControllerBean;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.helper.UserRolePermHelper;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.FilterHelper;
import com.kingdee.eas.base.permission.app.util.PermMutexExLockManger;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class UserOrgPermControllerBean
extends AbstractUserOrgPermControllerBean {
    private static Logger logger = Logger.getLogger(UserOrgPermControllerBean.class);
    private int count = 0;

    @Override
    protected void _saveUserOrgPerms(Context ctx, UserOrgPermCollection[] results) throws BOSException, EASBizException {
        assert (results != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        if (this.canIgnore(results)) {
            return;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(ctx);
            IObjectPK orgPK = this.getOrgPK(results);
            IObjectPK userPK = this.getUserPK(results);
            UserOrgPermCollection allUOPs = this.getUOPs(ctx, userPK, orgPK);
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("getUOPs  " + (endTime - beginTime)));
                beginTime = lowTimer.msValue();
            }
            Set existUOPKeys = this.createUOPSet(allUOPs);
            Set addUOPKeys = this.createUOPSet(results[0]);
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("createUOPSet  " + (endTime - beginTime)));
            }
            StringBuffer sql = null;
            beginTime = lowTimer.msValue();
            endTime = lowTimer.msValue();
            sql = new StringBuffer();
            UserOrgPermCollection delUOPs = results[1];
            UserOrgPermCollection allDelUOPs = this.getAllDelUOPs(ctx, delUOPs, existUOPKeys, addUOPKeys);
            if (allDelUOPs.size() > 0) {
                sql.append("DELETE FROM T_PM_UserOrgPerm WHERE FID = ? ");
                statement = connection.prepareStatement(sql.toString());
                this.delUOPBatch(statement, allDelUOPs);
                statement.executeBatch();
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("delUOPBatch  " + (endTime - beginTime)));
                }
            }
            beginTime = lowTimer.msValue();
            endTime = lowTimer.msValue();
            sql = new StringBuffer();
            UserOrgPermCollection addUOPs = results[0];
            UserOrgPermCollection allAddUOPs = this.getAllAddUOPs(ctx, addUOPs, existUOPKeys, addUOPKeys);
            if (allAddUOPs.size() > 0) {
                sql.append("INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, ").append("  FRuleStructure, FRuleExpr, FCtrlUnitID) VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )");
                statement = connection.prepareStatement(sql.toString());
                this.addUOPBatch(statement, allAddUOPs);
                statement.executeBatch();
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("addUOPBatch  " + (endTime - beginTime)));
                }
            }
            beginTime = lowTimer.msValue();
            endTime = lowTimer.msValue();
            sql = new StringBuffer();
            UserOrgPermCollection updateUOPs = results[2];
            if (updateUOPs.size() > 0) {
                sql.append("UPDATE T_PM_UserOrgPerm SET FRuleStructure = ?, FRuleExpr = ? WHERE FID = ? ");
                statement = connection.prepareStatement(sql.toString());
                this.updateUOPBatch(statement, updateUOPs);
                statement.executeBatch();
                if (logger.isDebugEnabled()) {
                    endTime = lowTimer.msValue();
                    logger.debug((Object)("updateUOPBatch  " + (endTime - beginTime)));
                }
            }
            this.cleanPermissionCache(userPK);
            this.handleCallBack(ctx, userPK);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new UserOrgPermException(UserOrgPermException.ACCREDIT_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    private void handleCallBack(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        try {
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK(userPK);
            helper.exceChange(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"handleCallBack when saving user orgnization permissions:", (Throwable)e);
        }
    }

    private void cleanPermissionCache(IObjectPK userPK) {
    }

    private UserOrgPermCollection getUOPs(Context context, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        UserOrgPermCollection uops = new UserOrgPermCollection();
        String sql = "SELECT FPermItemID, FPermType FROM T_PM_UserOrgPerm WHERE FOwner = ? AND ( FOrgID = ? OR FOrgID = '11111111-1111-1111-1111-111111111111CCE7AED4' ) ";
        Object[] params = new Object[]{userPK.toString(), orgPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])params);
        UserOrgPermInfo userOrgPermInfo = null;
        try {
            while (rowSet.next()) {
                userOrgPermInfo = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                userOrgPermInfo.setPermItem(permItemInfo);
                userOrgPermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                uops.add(userOrgPermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserOrgPermException(UserOrgPermException.GET_USERORGPERM_FAIL, e);
        }
        return uops;
    }

    private boolean canIgnore(UserOrgPermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return false;
        }
        return true;
    }

    private IObjectPK getOrgPK(UserOrgPermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i] == null || results[i].size() <= 0) continue;
            return new ObjectUuidPK(results[i].get(0).getOrg().getId());
        }
        throw new IllegalArgumentException("result is error");
    }

    private IObjectPK getUserPK(UserOrgPermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i] == null || results[i].size() <= 0) continue;
            return new ObjectUuidPK(results[i].get(0).getOwner().getId());
        }
        throw new IllegalArgumentException("result is error");
    }

    private UserOrgPermCollection getAllAddUOPs(Context context, UserOrgPermCollection addUOPs, Set existUOPKeys, Set addUOPKeys) throws BOSException, EASBizException {
        UserOrgPermInfo info;
        int i;
        UserOrgPermCollection result = new UserOrgPermCollection();
        UserOrgPermCollection uops = (UserOrgPermCollection)((Object)addUOPs.clone());
        CtrlUnitInfo sysCU = new CtrlUnitInfo();
        sysCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        int size = uops.size();
        for (i = 0; i < size; ++i) {
            info = uops.get(i);
            if (!info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) continue;
            info.setOrg(sysCU.castToFullOrgUnitInfo());
            info.setCtrlUnit(sysCU);
        }
        size = addUOPs.size();
        for (i = 0; i < size; ++i) {
            PermItemInfo beenDepPerm;
            PermItemCollection beenDepPerms;
            UserOrgPermInfo newUOP;
            String key;
            int j;
            int size1;
            info = addUOPs.get(i);
            if (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL)) {
                PermItemInfo depPerm;
                PermItemCollection depPerms = PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
                if (depPerms == null) continue;
                if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                    size1 = depPerms.size();
                    for (j = 0; j < size1; ++j) {
                        depPerm = depPerms.get(j);
                        if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                        newUOP = (UserOrgPermInfo)info.clone();
                        newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                        newUOP.setCtrlUnit(sysCU);
                        newUOP.setPermItem(depPerm);
                        newUOP.setRuleStructure(null);
                        newUOP.setRuleExpr(null);
                        uops.add(newUOP);
                        addUOPKeys.add(key);
                    }
                    continue;
                }
                size1 = depPerms.size();
                for (j = 0; j < size1; ++j) {
                    depPerm = depPerms.get(j);
                    if (depPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation())) {
                        key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType());
                        if (existUOPKeys.contains(key) || addUOPKeys.contains(key)) continue;
                        newUOP = (UserOrgPermInfo)info.clone();
                        newUOP.setPermItem(depPerm);
                        newUOP.setRuleStructure(null);
                        newUOP.setRuleExpr(null);
                        uops.add(newUOP);
                        addUOPKeys.add(key);
                        continue;
                    }
                    if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                    newUOP = (UserOrgPermInfo)info.clone();
                    newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                    newUOP.setCtrlUnit(sysCU);
                    newUOP.setPermItem(depPerm);
                    newUOP.setRuleStructure(null);
                    newUOP.setRuleExpr(null);
                    uops.add(newUOP);
                    addUOPKeys.add(key);
                }
                continue;
            }
            if (!info.getPermType().equals((Object)PermType.FORBIDDEN) || (beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()))) == null) continue;
            if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                size1 = beenDepPerms.size();
                for (j = 0; j < size1; ++j) {
                    beenDepPerm = beenDepPerms.get(j);
                    if (!beenDepPerm.getOrgRelation().equals((Object)OrgType.NONE) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                    newUOP = (UserOrgPermInfo)info.clone();
                    newUOP.setOrg(sysCU.castToFullOrgUnitInfo());
                    info.setCtrlUnit(sysCU);
                    newUOP.setPermItem(beenDepPerm);
                    newUOP.setRuleStructure(null);
                    newUOP.setRuleExpr(null);
                    uops.add(newUOP);
                    addUOPKeys.add(key);
                }
                continue;
            }
            size1 = beenDepPerms.size();
            for (j = 0; j < size1; ++j) {
                beenDepPerm = beenDepPerms.get(j);
                if (!beenDepPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation()) || existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addUOPKeys.contains(key)) continue;
                newUOP = (UserOrgPermInfo)info.clone();
                newUOP.setPermItem(beenDepPerm);
                newUOP.setRuleStructure(null);
                newUOP.setRuleExpr(null);
                uops.add(newUOP);
                addUOPKeys.add(key);
            }
        }
        UserOrgPermInfo userOrgPermInfo = null;
        int size2 = uops.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            userOrgPermInfo = uops.get(i2);
            if (existUOPKeys.contains(PermissionCommonUtil.getKey(userOrgPermInfo))) continue;
            result.add(userOrgPermInfo);
        }
        return result;
    }

    private UserOrgPermCollection getAllDelUOPs(Context context, UserOrgPermCollection delUOPs, Set existUOPKeys, Set addUOPKeys) throws BOSException, EASBizException {
        UserOrgPermCollection result = (UserOrgPermCollection)((Object)delUOPs.clone());
        Set currentDelUOPs = this.createUOPSet(result);
        int size = delUOPs.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = delUOPs.get(i);
            PermItemCollection beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
            if (beenDepPerms == null) continue;
            int size1 = beenDepPerms.size();
            for (int j = 0; j < size1; ++j) {
                String key;
                PermItemInfo beenDepPerm = beenDepPerms.get(j);
                if (!info.getPermItem().getOrgRelation().equals((Object)beenDepPerms.get(j).getOrgRelation()) || !existUOPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) && !addUOPKeys.contains(key) || currentDelUOPs.contains(key)) continue;
                result.removeObject(info.getId());
            }
        }
        return result;
    }

    private void addUOPBatch(PreparedStatement statement, UserOrgPermCollection uops) throws SQLException {
        BOSObjectType objectType = this.getBOSType();
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = uops.get(i);
            statement.setString(1, BOSUuid.create((BOSObjectType)objectType).toString());
            statement.setString(2, info.getOwner().getId().toString());
            statement.setString(3, info.getOrg().getId().toString());
            statement.setString(4, info.getPermItem().getId().toString());
            statement.setInt(5, info.getPermType().getValue());
            statement.setString(6, info.getRuleStructure());
            statement.setString(7, info.getRuleExpr());
            statement.setString(8, info.getCtrlUnit().getId().toString());
            statement.addBatch();
        }
    }

    private void delUOPBatch(PreparedStatement statement, UserOrgPermCollection uops) throws SQLException {
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = uops.get(i);
            statement.setString(1, info.getId().toString());
            statement.addBatch();
        }
    }

    private void updateUOPBatch(PreparedStatement statement, UserOrgPermCollection uops) throws SQLException {
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = uops.get(i);
            statement.setString(1, info.getRuleStructure());
            statement.setString(2, info.getRuleExpr());
            statement.setString(3, info.getId().toString());
            statement.addBatch();
        }
    }

    private Set createUOPSet(UserOrgPermCollection uops) {
        HashSet<String> set = new HashSet<String>(1000);
        UserOrgPermInfo userOrgPermInfo = null;
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            userOrgPermInfo = uops.get(i);
            set.add(PermissionCommonUtil.getKey(userOrgPermInfo));
        }
        return set;
    }

    @Override
    protected UserOrgPermCollection _getSourcePerms(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        LowTimeHelper lowHelper = new LowTimeHelper();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer sql = new StringBuffer(500);
            if (Administrator.isCUAdmin(ctx, userPK)) {
                String orgRelationFilter = FilterHelper.getOrgRelationFilter(ctx, orgPK, "FOrgRelation");
                sql.append("SELECT FID, FName, ").append(aliasField).append(", ").append(" FLongNumber, FOrgRelation, FIsLeaf, FParentID, FObjectType, FIsApplyToF7 FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND ( FType = ").append(20).append(" OR FType = ").append(30).append(" ) ");
                sql.append(orgRelationFilter);
                sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "FObjectType", "FOperationType"));
                sql.append(" ORDER BY FLongNumber ASC");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
                    PermItemInfo info = new PermItemInfo();
                    info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                    info.setName(rowSet.getString("FName"));
                    info.setAlias(rowSet.getString(aliasField));
                    info.setLongNumber(rowSet.getString("FLongNumber"));
                    info.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                    info.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                    info.setObjectType(rowSet.getString("FObjectType"));
                    info.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                    String parentID = rowSet.getString("FParentID");
                    if (parentID != null) {
                        PermItemInfo parent = new PermItemInfo();
                        parent.setId(BOSUuid.read((String)parentID));
                        info.setParent(parent);
                    }
                    userOrgPermInfo.setPermItem(info);
                    userOrgPerms.add(userOrgPermInfo);
                }
            } else {
                Object[] params = new Object[]{userPK.toString()};
                sql.append(" SELECT UserOrgPerm.FID, UserOrgPerm.FPermItemID, ").append(" PermItem.FName, ").append("PermItem.").append(aliasField).append(", ").append(" PermItem.FOrgRelation, PermItem.FIsLeaf, PermItem.FParentID,PermItem.FObjectType, PermItem.FIsApplyToF7 ").append(" FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FPermType = ").append(30).append(" AND ( ").append(" UserOrgPerm.FOrgID = '").append(orgPK.toString()).append("' ").append(" OR UserOrgPerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' )  ");
                sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                while (rowSet.next()) {
                    UserOrgPermInfo info = new UserOrgPermInfo();
                    PermItemInfo permItemInfo = new PermItemInfo();
                    permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                    permItemInfo.setName(rowSet.getString("FName"));
                    permItemInfo.setAlias(rowSet.getString(aliasField));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                    permItemInfo.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                    permItemInfo.setObjectType(rowSet.getString("FObjectType"));
                    permItemInfo.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                    String parentID = rowSet.getString("FParentID");
                    if (parentID != null) {
                        PermItemInfo parent = new PermItemInfo();
                        parent.setId(BOSUuid.read((String)parentID));
                        permItemInfo.setParent(parent);
                    }
                    info.setPermItem(permItemInfo);
                    userOrgPerms.add(info);
                }
                UserRolePermHelper helper = new UserRolePermHelper();
                UserOrgPermCollection rolePerm = helper.getUserRoleAuthorizationPerm(ctx, userPK, orgPK);
                userOrgPerms = helper.interPermItemCol(userOrgPerms, rolePerm);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (this.isUnionOrg(ctx, orgPK)) {
            lowHelper.printTime2Last("..... isUnionOrg:");
            return userOrgPerms;
        }
        UserOrgPermCollection retCol = this.filterCslrptPermItem(userOrgPerms);
        lowHelper.printTime2Last("..... isNotUnionOrg:");
        return retCol;
    }

    @Override
    protected UserOrgPermCollection _getTargetPerms(Context ctx, IObjectPK sourceUserPK, IObjectPK targetUserPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (sourceUserPK != null && targetUserPK != null && orgPK != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        try {
            StringBuffer sql = new StringBuffer(800);
            String orgID = orgPK.toString();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            Object[] params = new Object[]{targetUserPK.toString(), orgID};
            sql.append(" SELECT UserOrgPerm.FID, UserOrgPerm.FPermItemID, UserOrgPerm.FPermType, ").append(" UserOrgPerm.FOrgID, UserOrgPerm.FOwner, ").append(" UserOrgPerm.FRuleStructure, UserOrgPerm.FRuleExpr, PermItem.FName, ").append(" PermItem.").append(aliasField).append(", ").append(" PermItem.FOrgRelation, PermItem.FIsLeaf, ").append(" PermItem.FParentID, PermItem.FObjectType, PermItem.FIsApplyToF7 ").append(" FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND ( UserOrgPerm.FOrgID = ? ");
            sql.append(" OR UserOrgPerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
            sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
            StringBuffer authorizedFilter = new StringBuffer(400);
            if (!Administrator.isCUAdmin(ctx, sourceUserPK)) {
                authorizedFilter.append(" SELECT UserOrgPerm.FPermItemID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner = '").append(sourceUserPK.toString()).append("' ").append(" AND UserOrgPerm.FPermType = ").append(30).append(" AND ( UserOrgPerm.FOrgID = '").append(orgID).append("' ").append(" OR UserOrgPerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("') ");
                authorizedFilter.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
                authorizedFilter.append(" UNION ALL ").append(" SELECT DISTINCT rolePerm.FPermItemID FROM T_PM_RolePerm rolePerm ").append(" WHERE rolePerm.FPermType = ").append(30).append(" AND EXISTS (").append(" SELECT userRoleOrg.FRoleID FROM T_PM_UserRoleOrg userRoleOrg ").append(" WHERE userRoleOrg.FUserID = '").append(sourceUserPK.toString()).append("'").append(" AND userRoleOrg.FOrgID = '").append(orgPK.toString()).append("' ").append(" AND userRoleOrg.FRoleID = rolePerm.FRoleID ").append(" ) ");
            }
            if (!StringUtils.isEmpty((String)authorizedFilter.toString())) {
                sql.append(" AND UserOrgPerm.FPermItemID IN ( ").append(authorizedFilter).append(" ) ");
            }
            sql.append(" ORDER BY PermItem.FLongNumber ASC");
            HashSet<String> targetUOPSet = new HashSet<String>();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                if (targetUOPSet.contains(rowSet.getString("FPermItemID"))) continue;
                targetUOPSet.add(rowSet.getString("FPermItemID"));
                UserOrgPermInfo info = new UserOrgPermInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                permItemInfo.setName(rowSet.getString("FName"));
                permItemInfo.setAlias(rowSet.getString(aliasField));
                permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                permItemInfo.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                permItemInfo.setObjectType(rowSet.getString("FObjectType"));
                permItemInfo.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    permItemInfo.setParent(parent);
                }
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FOrgID")));
                info.setOrg(fullOrgUnitInfo);
                UserInfo owner = new UserInfo();
                owner.setId(BOSUuid.read((String)rowSet.getString("FOwner")));
                info.setOwner(owner);
                info.setPermItem(permItemInfo);
                info.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                info.setRuleStructure(rowSet.getString("FRuleStructure"));
                info.setRuleExpr(rowSet.getString("FRuleExpr"));
                userOrgPerms.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL, e);
        }
        if (this.isUnionOrg(ctx, orgPK)) {
            if (logger.isDebugEnabled()) {
                endTime = lowTimer.msValue();
                logger.debug((Object)("_getTargetPerms  " + (endTime - beginTime)));
            }
            return userOrgPerms;
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("_getTargetPerms  " + (endTime - beginTime)));
        }
        return this.filterCslrptPermItem(userOrgPerms);
    }

    private boolean isUnionOrg(Context ctx, IObjectPK orgPK) throws EASBizException, BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isUnion"));
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK, sic);
        return fullOrgUnitInfo.isIsUnion();
    }

    private UserOrgPermCollection filterCslrptPermItem(UserOrgPermCollection uops) {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (uops != null) {
            int size = uops.size();
            for (int i = 0; i < size; ++i) {
                PermItemInfo permItemInfo = uops.get(i).getPermItem();
                if (ConfigurationLoader.getInstance().getConfigurationInfo().getCslrptPermItemNames().contains(permItemInfo.getName())) continue;
                result.add(uops.get(i));
            }
        }
        return result;
    }

    @Override
    protected Set _getBizObjectTypes(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (userPK != null && orgPK != null);
        HashSet<String> result = new HashSet<String>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT PermItem.FObjectType FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE FOwner = ? ").append(" AND ( FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ").append(" OR FOrgID = ? ) ").append(" AND PermItem.FObjectType IS NOT NULL ");
        Object[] params = new Object[]{userPK.toString(), orgPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String objectType = rowSet.getString("FObjectType");
                if (StringUtils.isEmpty((String)objectType)) continue;
                result.add(objectType);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserOrgPermException(UserOrgPermException.GET_USERORGPERM_FAIL, e);
        }
        return result;
    }

    private UserOrgPermCollection addDepPerm(Context context, UserOrgPermCollection perms) throws EASBizException, BOSException {
        int i;
        UserOrgPermCollection ret = new UserOrgPermCollection();
        HashSet<String> alreadyAddedPerm = new HashSet<String>();
        int size = perms.size();
        for (i = 0; i < size; ++i) {
            String key = this.getUniqueKey(perms.get(i));
            alreadyAddedPerm.add(key);
        }
        for (i = 0; i < perms.size(); ++i) {
            UserOrgPermInfo info = perms.get(i);
            ret.add(info);
            PermItemCollection depPerms = new PermItemCollection();
            depPerms = info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
            if (depPerms == null) continue;
            for (int j = 0; j < depPerms.size(); ++j) {
                UserOrgPermInfo depUserOrgPermInfo = new UserOrgPermInfo();
                depUserOrgPermInfo.setOrg(info.getOrg());
                depUserOrgPermInfo.setOwner(info.getOwner());
                depUserOrgPermInfo.setPermType(info.getPermType());
                depUserOrgPermInfo.setCtrlUnit(info.getCtrlUnit());
                depUserOrgPermInfo.setPermItem(depPerms.get(j));
                String key = this.getUniqueKey(depUserOrgPermInfo);
                if (alreadyAddedPerm.contains(key)) continue;
                alreadyAddedPerm.add(key);
                ret.add(depUserOrgPermInfo);
            }
        }
        return ret;
    }

    private String getUniqueKey(UserOrgPermInfo info) {
        return new StringBuffer().append(info.getOwner().getId()).append("-").append(info.getOrg().getId()).append("-").append(info.getPermItem().getId()).append("-").append((Object)info.getPermType()).toString();
    }

    protected UserOrgPermCollection _saveUserOrgPermsBatch_old(Context ctx, IObjectPK userPK, IObjectPK cu, FullOrgUnitCollection orgCol, UserOrgPermCollection perms) throws BOSException, EASBizException {
        List orgIdList = ToolUtils.orgCol2List(orgCol);
        boolean isNeedAddSysCu = ToolUtils.addSysOrgId(orgIdList);
        if (isNeedAddSysCu) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            if (orgCol != null && !orgCol.isEmpty()) {
                orgCol.add(fullOrgUnitInfo);
            }
        }
        UserOrgPermCollection permsWithDep = this.addDepPerm(ctx, perms);
        this._deleteUserOrgPermsBatch(ctx, userPK, cu, orgIdList, permsWithDep);
        String insertSql = "insert into t_pm_userorgperm(fid, fowner,forgid,fpermitemid,fpermType,fctrlUnitID) values(?,?,?,?,?,?)";
        Connection conn = this.getConnection(ctx);
        PreparedStatement state = null;
        try {
            state = conn.prepareStatement(insertSql);
            boolean mayRun = this.addInsertData(state, userPK, cu, orgCol, permsWithDep);
            if (mayRun && this.count > 0) {
                state.executeBatch();
                this.cleanPermissionCache(userPK);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)state, (Connection)conn);
        }
        this.handleCallBack(ctx, userPK);
        return permsWithDep;
    }

    @Override
    protected UserOrgPermCollection _saveUserOrgPermsBatch(Context ctx, IObjectPK userPK, IObjectPK cu, FullOrgUnitCollection orgCol, UserOrgPermCollection perms) throws BOSException, EASBizException {
        List orgIdList = ToolUtils.orgCol2List(orgCol);
        boolean isNeedAddSysCu = ToolUtils.addSysOrgId(orgIdList);
        if (isNeedAddSysCu) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            if (orgCol != null && !orgCol.isEmpty()) {
                orgCol.add(fullOrgUnitInfo);
            }
        }
        UserOrgPermCollection permsWithDep = this.addDepPerm(ctx, perms);
        UserOrgPermCollection userOrgPermCol = this.getUserOrgPermCol(ctx, userPK, cu, orgCol, permsWithDep);
        this.saveInDTempTable(ctx, userOrgPermCol, cu.toString(), userPK);
        this.cleanPermissionCache(userPK);
        this.handleCallBack(ctx, userPK);
        return permsWithDep;
    }

    private UserOrgPermInfo getUserOrgPermInfo(UserOrgPermInfo info, String userId, String orgId) {
        UserOrgPermInfo ret = new UserOrgPermInfo();
        ret.setPermItem(info.getPermItem());
        ret.setPermType(info.getPermType());
        FullOrgUnitInfo sysOrgInfo = new FullOrgUnitInfo();
        sysOrgInfo.setId(BOSUuid.read((String)orgId));
        ret.setOrg(sysOrgInfo);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)userId));
        ret.setOwner(user);
        return ret;
    }

    private UserOrgPermCollection getUserOrgPermCol(Context ctx, IObjectPK userPK, IObjectPK cu, FullOrgUnitCollection orgCol, UserOrgPermCollection userOrgPermCol) {
        if (userPK == null || orgCol == null || orgCol.isEmpty() || cu == null || userOrgPermCol == null) {
            return new UserOrgPermCollection();
        }
        String ctrlStr = cu.toString();
        UserOrgPermCollection ret = new UserOrgPermCollection();
        Map<OrgType, UserOrgPermCollection> orgTypeOUPMap = this.getOrgTypeUOPMap(userOrgPermCol);
        Iterator<OrgType> orgTypeItr = orgTypeOUPMap.keySet().iterator();
        String sysCuId = "11111111-1111-1111-1111-111111111111CCE7AED4";
        ConfigurationLoader loader = ConfigurationLoader.getInstance();
        ConfigurationInfo configInfo = loader.getConfigurationInfo();
        while (orgTypeItr.hasNext()) {
            UserOrgPermInfo userOrgPerm;
            int j;
            int size2;
            FullOrgUnitInfo orgInfo;
            int size1;
            int i;
            OrgType orgType = orgTypeItr.next();
            UserOrgPermCollection uopCol = orgTypeOUPMap.get(orgType);
            if (orgType.getValue() == -1) {
                int size = uopCol.size();
                for (i = 0; i < size; ++i) {
                    UserOrgPermInfo userOrgPerm2 = uopCol.get(i);
                    ret.add(this.getUserOrgPermInfo(userOrgPerm2, userPK.toString(), sysCuId));
                }
                continue;
            }
            if (orgType.getValue() == 1) {
                size1 = orgCol.size();
                for (i = 0; i < size1; ++i) {
                    orgInfo = orgCol.get(i);
                    if (!orgInfo.isIsUnion()) continue;
                    size2 = uopCol.size();
                    for (j = 0; j < size2; ++j) {
                        userOrgPerm = uopCol.get(j);
                        if (!configInfo.getCslrptPermItemNames().contains(userOrgPerm.getPermItem().getNumber())) continue;
                        ret.add(this.getUserOrgPermInfo(userOrgPerm, userPK.toString(), orgInfo.getId().toString()));
                    }
                }
            }
            size1 = orgCol.size();
            for (i = 0; i < size1; ++i) {
                orgInfo = orgCol.get(i);
                if (!OrgCommonUtils.isOrgType((OrgUnitInfo)orgInfo, (OrgType)orgType)) continue;
                size2 = uopCol.size();
                for (j = 0; j < size2; ++j) {
                    userOrgPerm = uopCol.get(j);
                    ret.add(this.getUserOrgPermInfo(userOrgPerm, userPK.toString(), orgInfo.getId().toString()));
                }
            }
        }
        return ret;
    }

    private Map<OrgType, UserOrgPermCollection> getOrgTypeUOPMap(UserOrgPermCollection userOrgPermCol) {
        HashMap<OrgType, UserOrgPermCollection> ret = new HashMap<OrgType, UserOrgPermCollection>();
        int size = userOrgPermCol.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo uop = userOrgPermCol.get(i);
            OrgType orgType = uop.getPermItem().getOrgRelation();
            UserOrgPermCollection value = (UserOrgPermCollection)((Object)ret.get(orgType));
            value = value != null ? (UserOrgPermCollection)((Object)ret.get(orgType)) : new UserOrgPermCollection();
            value.add(uop);
            ret.put(orgType, value);
        }
        return ret;
    }

    private void addUserOrgPermTmpBatch(Context ctx, UserOrgPermCollection uopCol, String tmpTableName) throws BOSException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement state = null;
        try {
            int i;
            String insertSql = "insert into " + tmpTableName + "( fowner,forgid,fpermitemid,fpermType) values(?,?,?,?)";
            state = conn.prepareStatement(insertSql);
            ArrayList<Future<String>> list = new ArrayList<Future<String>>();
            ExecutorService exec = Executors.newFixedThreadPool(10);
            int size = uopCol.size();
            for (i = 0; i < size; ++i) {
                UserOrgPermInfo info = uopCol.get(i);
                state.setString(1, info.getOwner().getId().toString());
                state.setString(2, info.getOrg().getId().toString());
                state.setString(3, info.getPermItem().getId().toString());
                state.setInt(4, info.getPermType().getValue());
                state.addBatch();
                if (i % 2000 != 0) continue;
                ExecuteCall t = new ExecuteCall();
                t.setState(state);
                Future<String> future = exec.submit(t);
                list.add(future);
            }
            state.executeBatch();
            size = list.size();
            for (i = 0; i < size; ++i) {
                ((Future)list.get(i)).get();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)conn);
    }

    private boolean addInsertData(PreparedStatement state, IObjectPK userPK, IObjectPK cu, FullOrgUnitCollection orgCol, UserOrgPermCollection perms) throws NumberFormatException, SQLException {
        if (userPK == null || orgCol == null || orgCol.isEmpty() || cu == null) {
            return false;
        }
        Map permSortInfoMap = ToolUtils.sortByPermType(perms);
        if (permSortInfoMap == null || permSortInfoMap.isEmpty()) {
            return false;
        }
        HashSet<String> saveNoOrgPermSet = new HashSet<String>();
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo orgInfo = orgCol.get(i);
            String orgIdStr = orgInfo.getId().toString();
            Set permTypeValueSet = permSortInfoMap.keySet();
            for (String permTypeValue : permTypeValueSet) {
                List permIdList = (List)permSortInfoMap.get(permTypeValue);
                if (permIdList == null || permIdList.isEmpty()) continue;
                int permIdSize = permIdList.size();
                for (int permIdIndex = 0; permIdIndex < permIdSize; ++permIdIndex) {
                    PermItemInfo permItem = (PermItemInfo)permIdList.get(permIdIndex);
                    String permIdStr = permItem.getId().toString();
                    if (!PermissionOrgTypeUtils.checkMatchOrg2PermItem(permItem, (OrgUnitInfo)orgInfo)) continue;
                    String ctrlStr = cu.toString();
                    if (-1 == permItem.getOrgRelation().getValue()) {
                        ctrlStr = "11111111-1111-1111-1111-111111111111CCE7AED4";
                        String setKey = userPK.toString() + ctrlStr + permIdStr + permTypeValue;
                        if (saveNoOrgPermSet.contains(setKey)) continue;
                        this.addUserOrgPermBatch(state, userPK.toString(), ctrlStr, ctrlStr, permIdStr, new Integer(permTypeValue));
                        saveNoOrgPermSet.add(setKey);
                        continue;
                    }
                    this.addUserOrgPermBatch(state, userPK.toString(), ctrlStr, orgIdStr, permIdStr, new Integer(permTypeValue));
                }
            }
        }
        return true;
    }

    private void addUserOrgPermBatch(final PreparedStatement state, String userStr, String cuStr, String orgIdStr, String permIdStr, int permTypeInt) throws SQLException {
        state.setString(1, BOSUuid.create((BOSObjectType)this.getBOSType()).toString());
        state.setString(2, userStr);
        state.setString(3, orgIdStr);
        state.setString(4, permIdStr);
        state.setInt(5, permTypeInt);
        state.setString(6, cuStr);
        state.addBatch();
        ++this.count;
        if (this.count >= 2000) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        state.executeBatch();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }.start();
            logger.error((Object)"....... exebatch one!");
            this.count = 0;
        }
    }

    @Override
    protected void _deleteUserOrgPermsBatch(Context ctx, IObjectPK userPK, IObjectPK cu, List orgIdAry, UserOrgPermCollection perms) throws BOSException, EASBizException {
        if (userPK == null || orgIdAry == null || orgIdAry.isEmpty() || cu == null) {
            return;
        }
        Map permSortInfoMap = ToolUtils.sortByPermType(perms);
        if (permSortInfoMap == null || permSortInfoMap.isEmpty()) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        Statement statement = null;
        boolean isNeedSysCU = ToolUtils.addSysOrgId(orgIdAry);
        String orgStr = ToolUtils.aryToStr(orgIdAry, true);
        Set permTypeValueSet = permSortInfoMap.keySet();
        Iterator it = permTypeValueSet.iterator();
        try {
            statement = conn.createStatement();
            while (it.hasNext()) {
                int fromIndex;
                String permTypeKeyStr = it.next().toString();
                List permInfoTotalList = (List)permSortInfoMap.get(permTypeKeyStr);
                int toIndex = fromIndex = 0;
                boolean count = false;
                while (permInfoTotalList.size() > toIndex) {
                    toIndex = permInfoTotalList.size() > toIndex + 100 ? fromIndex + 100 : permInfoTotalList.size();
                    List permInfoList = permInfoTotalList.subList(fromIndex, toIndex);
                    List permIdList = ToolUtils.transCol2ListByPeroperty(permInfoList, new IObjectCol2List(){

                        @Override
                        public String getList(Object obj) {
                            PermItemInfo permItemInfo = (PermItemInfo)obj;
                            if (permItemInfo != null && permItemInfo.getId() != null) {
                                return permItemInfo.getId().toString();
                            }
                            return null;
                        }
                    });
                    if (permIdList != null && !permIdList.isEmpty()) {
                        String permIdStr = ToolUtils.aryToStr(permIdList, true);
                        String delSql = "delete from t_pm_userorgperm where fowner = '" + userPK.toString() + "' and forgid in (" + orgStr + ")  and ( fpermitemid in (" + permIdStr + ") and fpermtype = " + permTypeKeyStr + ")";
                        statement.addBatch(delSql);
                    }
                    fromIndex = toIndex;
                }
            }
            statement.executeBatch();
            this.cleanPermissionCache(userPK);
            this.handleCallBack(ctx, userPK);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserOrgPermInfo userOrgPermInfo = this.getUserOrgPermInfo(ctx, pk);
        StringBuffer sb = new StringBuffer("");
        if (userOrgPermInfo != null) {
            if (userOrgPermInfo.getOwner() != null) {
                sb.append(userOrgPermInfo.getOwner().getNumber());
            }
            if (userOrgPermInfo.getOrg() != null) {
                sb.append("  ").append(userOrgPermInfo.getOrg().getNumber());
            }
        }
        return sb.toString();
    }

    @Override
    protected void _saveSimplePerm(Context ctx, UserOrgPermInfo userOrgPermInfo) throws BOSException {
        StringBuffer insertSql = new StringBuffer("insert into t_pm_userorgperm(fid,fowner,forgid,fpermitemid,fpermType,fruleStructure,fruleexpr,fctrlunitid) values(?,?,?,?,?,?,?,?)");
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(insertSql.toString());
            ps.setString(1, userOrgPermInfo.getId().toString());
            ps.setString(2, userOrgPermInfo.getOwner().getId().toString());
            ps.setString(3, userOrgPermInfo.getOrg().getId().toString());
            ps.setString(4, userOrgPermInfo.getPermItem().getId().toString());
            ps.setInt(5, userOrgPermInfo.getPermType().getValue());
            ps.setString(6, userOrgPermInfo.getRuleStructure());
            ps.setString(7, userOrgPermInfo.getRuleExpr());
            ps.setString(8, userOrgPermInfo.getCtrlUnit().getId().toString());
            ps.execute();
            this.handleCallBack(ctx, (IObjectPK)new ObjectUuidPK(userOrgPermInfo.getOwner().getId()));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("sql error! sql is:" + insertSql.toString(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
    }

    @Override
    protected void _deleteSimplePerm(Context ctx, String userId, String orgId, String permItemId) throws BOSException, EASBizException {
        String delSql = "delete from  t_pm_userorgperm where fowner = ? and forgid = ? and fpermItemid = ?";
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(delSql);
            ps.setString(1, userId);
            ps.setString(2, orgId);
            ps.setString(3, permItemId);
            ps.execute();
            this.handleCallBack(ctx, (IObjectPK)new ObjectStringPK(userId));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("sql error! sql is:" + delSql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
    }

    @Override
    protected UserOrgPermCollection _getPermInfo(Context ctx, String permItemId, String orgId, String userId, PermType permType) throws BOSException, EASBizException {
        String oql = "select * " + this.getWhereStr(permItemId, orgId, userId, permType);
        return this.getUserOrgPermCollection(ctx, oql);
    }

    private String getWhereStr(String permItemId, String orgId, String userId, PermType permTypeEnum) {
        String retStr = "";
        if (StringUtils.isEmpty((String)permItemId) && StringUtils.isEmpty((String)orgId) && StringUtils.isEmpty((String)userId) && permTypeEnum == null) {
            return "";
        }
        retStr = " where ";
        String whereStr = "";
        if (!StringUtils.isEmpty((String)permItemId)) {
            whereStr = " permItem.id = '" + permItemId + "'";
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            whereStr = whereStr + " and org.id = '" + orgId + "'";
        }
        if (!StringUtils.isEmpty((String)userId)) {
            whereStr = whereStr + " and owner.id = '" + userId + "'";
        }
        if (permTypeEnum != null) {
            whereStr = whereStr + " and permType = " + permTypeEnum.getValue();
        }
        if ((whereStr = whereStr.trim()).startsWith("and")) {
            whereStr = whereStr.substring(4, whereStr.length());
        }
        return retStr + whereStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _copyPermission(Context ctx, String userID, String srcOrgID, List targetOrgIDList) throws BOSException, EASBizException {
        boolean getLock = PermMutexExLockManger.tryLock(ctx, PermMutexExLockType.PermCopy);
        if (!getLock) {
            throw new UserOrgPermException(UserOrgPermException.PERMISSIONCOPYINGEXPECTION);
        }
        try {
            FullOrgUnitInfo srcOrgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(srcOrgID));
            if (srcOrgInfo == null) {
                return;
            }
            if (targetOrgIDList == null || targetOrgIDList.size() == 0) {
                return;
            }
            if (StringUtils.isEmpty((String)userID)) {
                return;
            }
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userID));
            boolean isEnablePermAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
            Iterator it = targetOrgIDList.iterator();
            while (it.hasNext()) {
                boolean isUnLocked = PermMutexExLockManger.isUnLockedOfcache(ctx, PermMutexExLockType.PermCopy, 10000L);
                if (isUnLocked) {
                    logger.error((Object)"\u6743\u9650\u590d\u5236\u4efb\u52a1\u4e2d\u65ad");
                    throw new UserOrgPermException(UserOrgPermException.PERMISSIONCOPINGINTERUPT);
                }
                String targetOrgID = (String)it.next();
                FullOrgUnitInfo targetOrgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetOrgID));
                this.copyperm(ctx, userInfo, srcOrgID, isEnablePermAuthen, targetOrgInfo);
                this.copyRole(ctx, userInfo, srcOrgID, isEnablePermAuthen, targetOrgInfo);
            }
            PermissionChangeHelper helper = new PermissionChangeHelper();
            helper.setUserPK((IObjectPK)new ObjectStringPK(userID));
            helper.exceChange(ctx);
        }
        finally {
            PermMutexExLockManger.releaseLock(ctx, PermMutexExLockType.PermCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRole(Context ctx, UserInfo userInfo, String srcOrgID, boolean isEnablePermAuthen, FullOrgUnitInfo targetOrg) throws BOSException, EASBizException {
        PreparedStatement statement = null;
        Connection connection = null;
        connection = this.getConnection(ctx);
        boolean isBizAdmin = userInfo.isBizAdmin();
        try {
            if (isBizAdmin) {
                this.copyRole(ctx, connection, statement, userInfo, srcOrgID, isEnablePermAuthen, targetOrg, "T_PM_GRANTUSERROLEORG");
            }
            this.copyRole(ctx, connection, statement, userInfo, srcOrgID, isEnablePermAuthen, targetOrg, "T_PM_USERROLEORG");
        }
        catch (SQLException e) {
            logger.error((Object)"copy user role error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)connection);
        }
    }

    private void copyRole(Context ctx, Connection connection, PreparedStatement statement, UserInfo userInfo, String srcOrgID, boolean isEnablePermAuthen, FullOrgUnitInfo targetOrg, String userRoleOrgTable) throws BOSException, SQLException, EASBizException {
        String userId = userInfo.getId().toString();
        String targetOrgID = targetOrg.getId().toString();
        String roleQuerySql = "SELECT T1.FRoleID FRoleID FROM " + userRoleOrgTable + " T1 WHERE T1.FUserID = '" + userId + "' AND T1.FOrgID = '" + srcOrgID + "' AND NOT EXISTS ( SELECT T2.FRoleID FROM " + userRoleOrgTable + " T2 WHERE T1.FRoleID = T2.FRoleID AND T2.FUserID = '" + userId + "' AND T2.FOrgID = '" + targetOrgID + "')";
        String insertRoleSql = "INSERT INTO " + userRoleOrgTable + " (FUserID, FOrgID, FRoleID) VALUES ( '" + userId + "', '" + targetOrgID + "', ? )";
        String notNeedAuthenRoleSql = "";
        String needAuthenRoleSql = "";
        if (isEnablePermAuthen) {
            notNeedAuthenRoleSql = roleQuerySql + " AND NOT EXISTS (SELECT 1 FROM  T_PM_RolePerm T3 WHERE T3.froleid = T1.froleid and T3.FPermitemid IN (SELECT FPermitemid FROM T_PM_PermAuthentor WHERE FAuthentorId IN (SELECT FID FROM T_PM_USER WHERE FType=60 AND FID IN (SELECT FUSERID FROM T_PM_ORGRANGE WHERE FTYPE=10 AND FORGID='" + targetOrg.getCU().getId().toString() + "'))))";
            needAuthenRoleSql = roleQuerySql + " AND EXISTS (SELECT 1 FROM  T_PM_RolePerm T3 WHERE T3.froleid = T1.froleid and T3.FPermitemid IN (SELECT FPermitemid FROM T_PM_PermAuthentor WHERE FAuthentorId IN (SELECT FID FROM T_PM_USER WHERE FType=60 AND FID IN (SELECT FUSERID FROM T_PM_ORGRANGE WHERE FTYPE=10 AND FORGID='" + targetOrg.getCU().getId().toString() + "'))))";
            this.dealRoleWhenEnablePermAuthen(ctx, connection, statement, targetOrg, userInfo, needAuthenRoleSql, userRoleOrgTable);
        }
        this.dealRoleWhenNotEnablePermAuthen(ctx, connection, statement, targetOrg, userInfo, isEnablePermAuthen ? notNeedAuthenRoleSql : roleQuerySql, insertRoleSql);
    }

    private void dealRoleWhenNotEnablePermAuthen(Context ctx, Connection connection, PreparedStatement statement, FullOrgUnitInfo targetOrg, UserInfo userInfo, String notNeedAuthenRoleSql, String insertRoleSql) throws SQLException, BOSException {
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)notNeedAuthenRoleSql);
        statement = connection.prepareStatement(insertRoleSql);
        while (rowset.next()) {
            statement.setString(1, rowset.getString("FRoleID"));
            statement.addBatch();
        }
        statement.executeBatch();
    }

    private void dealRoleWhenEnablePermAuthen(Context ctx, Connection connection, PreparedStatement statement, FullOrgUnitInfo targetOrg, UserInfo userInfo, String needAuthenRoleSql, String userRoleOrgTable) throws BOSException, SQLException, EASBizException {
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)needAuthenRoleSql);
        HashSet<String> assignRoleSet = new HashSet<String>();
        while (rowset.next()) {
            assignRoleSet.add(rowset.getString("FRoleId"));
        }
        if (assignRoleSet == null || assignRoleSet.isEmpty()) {
            return;
        }
        this.dealRoleWhenNeedAuthen(ctx, connection, statement, assignRoleSet, targetOrg, userInfo, userRoleOrgTable);
    }

    private void dealRoleWhenNeedAuthen(Context ctx, Connection connection, PreparedStatement statement, Set<String> assignRoleSet, FullOrgUnitInfo targetOrg, UserInfo userInfo, String userRoleOrgTable) throws SQLException, EASBizException, BOSException {
        if (assignRoleSet == null || assignRoleSet.isEmpty()) {
            return;
        }
        String operateType = this.getOperateType(userRoleOrgTable);
        String changeTable = userRoleOrgTable + "change";
        String insertRoleSql = "INSERT INTO " + changeTable + " (FID,FASSIGNTYPE,FUserID, FRoleID,FOrgID,FAUTHENSTATUS,FPERMCHANGEID ) VALUES(?,?,?,?,?,?,?)";
        statement = connection.prepareStatement(insertRoleSql);
        for (String assignRoleId : assignRoleSet) {
            Set<String> authentorSet = this.getAuthentorByRole(ctx, assignRoleId, targetOrg.getCU().getId().toString());
            if (authentorSet == null || authentorSet.isEmpty()) continue;
            String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), operateType, userInfo.getNumber(), userInfo.getName(), "user");
            if (operateType == "20") {
                statement.setString(1, BOSUuid.create((String)"013DCF9F").toString());
            } else {
                statement.setString(1, BOSUuid.create((String)"A83B45CB").toString());
            }
            statement.setString(2, "10");
            statement.setString(3, userInfo.getId().toString());
            statement.setString(4, assignRoleId);
            statement.setString(5, targetOrg.getId().toString());
            statement.setString(6, "10");
            statement.setString(7, permChangeId);
            statement.addBatch();
            this.insertAuthenRecord(ctx, targetOrg.getCU().getId().toString(), authentorSet, permChangeId);
        }
        statement.executeBatch();
    }

    private Set<String> getAuthentorByRole(Context ctx, String needAuthenRoleId, String ctrlUnitId) throws BOSException, SQLException {
        HashSet<String> authentorSet = new HashSet<String>();
        String sql = "select fauthentorid from T_PM_PermAuthentor atr where atr.fpermitemid in (select FpermItemId from t_pm_roleperm where froleid ='" + needAuthenRoleId + "') and atr.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')) group by fauthentorid";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            authentorSet.add(rowSet.getString("fauthentorid"));
        }
        return authentorSet;
    }

    private String getOperateType(String tableName) {
        if (tableName.equalsIgnoreCase("T_PM_UserRoleOrg")) {
            return "20";
        }
        return "70";
    }

    private void copyperm(Context ctx, UserInfo userInfo, String srcOrgID, boolean isEnablePermAuthen, FullOrgUnitInfo targetOrg) throws EASBizException, BOSException {
        PreparedStatement statement = null;
        Connection connection = null;
        String targetOrgID = targetOrg.getId().toString();
        String orgRelationFilter = FilterHelper.getOrgRelationFilter(ctx, (IObjectPK)new ObjectUuidPK(targetOrgID), "T2.FOrgRelation");
        connection = this.getConnection(ctx);
        try {
            if (isEnablePermAuthen) {
                this.dealPermWhenEnablePermAuthen(ctx, connection, statement, srcOrgID, targetOrg, userInfo, orgRelationFilter);
            }
            this.dealPermWhenNotEnablePermAuthen(ctx, connection, statement, srcOrgID, targetOrg, userInfo, orgRelationFilter, isEnablePermAuthen);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)connection);
        }
    }

    private void dealPermWhenNotEnablePermAuthen(Context ctx, Connection connection, PreparedStatement statement, String sourceOrgId, FullOrgUnitInfo targetOrg, UserInfo userInfo, String orgRelationFilter, boolean isEnablePermAuthen) throws BOSException, SQLException {
        String userId = userInfo.getId().toString();
        String targetOrgID = targetOrg.getId().toString();
        StringBuffer permQuerySql = new StringBuffer();
        permQuerySql.append("SELECT newbosid('896DC075'),'" + userId + "','" + targetOrgID + "',T1.FPermItemID FPermItemID,T1.FPermType FPermType,T1.FRuleStructure FRuleStructure,T1.FRuleExpr RuleExpr,T1.FCtrlUnitID FCtrlUnitID ").append("FROM T_PM_UserOrgPerm T1 LEFT JOIN T_PM_PermItem T2 ON T1.FPermItemID = T2.FID WHERE T1.FOwner = '" + userId + "' AND T1.FOrgID = '" + sourceOrgId + "' ").append(orgRelationFilter + "AND NOT EXISTS ( SELECT T3.FID FROM T_PM_UserOrgPerm T3 WHERE T1.FPermitemID = T3.FPermitemID AND T3.FOwner = '" + userId + "' ").append("AND T3.FOrgID = '" + targetOrgID + "')");
        if (isEnablePermAuthen) {
            permQuerySql.append(" AND (T1.FPermType=20 OR T1.FPermType<>20 AND NOT EXISTS(select T4.FPermItemID from T_PM_PermAuthentor T4 WHERE T1.FPermItemID = T4.FPermItemID AND T4.FAuthentorId IN (SELECT FID FROM T_PM_USER ").append("WHERE FType=60 AND FID IN (SELECT FUSERID FROM T_PM_ORGRANGE WHERE FTYPE=10 AND FORGID='" + targetOrg.getCU().getId().toString() + "'))))");
        }
        String insertPermSql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr,FCtrlUnitID )";
        DbUtil.execute((Context)ctx, (String)(insertPermSql + permQuerySql.toString()));
    }

    private void dealPermWhenEnablePermAuthen(Context ctx, Connection connection, PreparedStatement statement, String srcOrgID, FullOrgUnitInfo targetOrg, UserInfo userInfo, String orgRelationFilter) throws BOSException, EASBizException, SQLException {
        String userId = userInfo.getId().toString();
        String targetOrgID = targetOrg.getId().toString();
        StringBuffer permQuerySql = new StringBuffer();
        permQuerySql.append("SELECT T1.FPermItemID FPermItemID,T1.FPermType FPermType,T1.FRuleStructure FRuleStructure,T1.FRuleExpr RuleExpr,T1.FCtrlUnitID FCtrlUnitID ").append("FROM T_PM_UserOrgPerm T1 LEFT JOIN T_PM_PermItem T2 ON T1.FPermItemID = T2.FID WHERE T1.FOwner = '" + userId + "' AND T1.FOrgID = '" + srcOrgID + "' ").append(orgRelationFilter + "AND NOT EXISTS ( SELECT T3.FID FROM T_PM_UserOrgPerm T3 WHERE T1.FPermitemID = T3.FPermitemID AND T3.FOwner = '" + userId + "' ").append("AND T3.FOrgID = '" + targetOrgID + "')");
        permQuerySql.append(" AND EXISTS(select T4.FPermItemID from T_PM_PermAuthentor T4 WHERE T1.FPermItemID = T4.FPermItemID AND T4.FAuthentorId IN (SELECT FID FROM T_PM_USER ").append("WHERE FType=60 AND FID IN (SELECT FUSERID FROM T_PM_ORGRANGE WHERE FTYPE=10 AND FORGID='" + targetOrg.getCU().getId().toString() + "')))");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)permQuerySql.toString());
        HashMap<String, UserOrgPermInfo> grantUserOrgPermMap = new HashMap<String, UserOrgPermInfo>();
        HashMap<String, UserOrgPermInfo> normalUserOrgPermMap = new HashMap<String, UserOrgPermInfo>();
        CtrlUnitInfo ctrlUnitInfo = null;
        while (rowset.next()) {
            UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
            userOrgPermInfo.setRuleExpr(rowset.getString("RuleExpr"));
            userOrgPermInfo.setRuleStructure(rowset.getString("FRuleStructure"));
            if (ctrlUnitInfo == null) {
                ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(rowset.getString("FCtrlUnitID")));
            }
            userOrgPermInfo.setCtrlUnit(ctrlUnitInfo);
            int permType = rowset.getInt("FPermType");
            if (permType == 10) {
                normalUserOrgPermMap.put(rowset.getString("FPermItemID"), userOrgPermInfo);
                continue;
            }
            if (permType != 30) continue;
            grantUserOrgPermMap.put(rowset.getString("FPermItemID"), userOrgPermInfo);
        }
        if (normalUserOrgPermMap != null && !normalUserOrgPermMap.isEmpty()) {
            this.dealPermWhenNeedAuthen(ctx, connection, statement, normalUserOrgPermMap, targetOrg, userInfo, 10);
        }
        if (grantUserOrgPermMap != null && !grantUserOrgPermMap.isEmpty()) {
            this.dealPermWhenNeedAuthen(ctx, connection, statement, grantUserOrgPermMap, targetOrg, userInfo, 30);
        }
    }

    private void dealPermWhenNeedAuthen(Context ctx, Connection connection, PreparedStatement statement, HashMap<String, UserOrgPermInfo> userOrgPermMap, FullOrgUnitInfo targetOrg, UserInfo userInfo, int permType) throws BOSException, SQLException, EASBizException {
        if (userOrgPermMap == null || userOrgPermMap.isEmpty()) {
            return;
        }
        BOSObjectType bosObjectType = new BOSObjectType("AB724BE5");
        String permChangeId = BOSUuid.create((BOSObjectType)bosObjectType).toString();
        String strSql = "INSERT INTO t_pm_permChangeRecord(FID,FAssignerID,FOperType,FAssignedObjectNumber,FAssignedObjectName,FChangeTime,FASSIGNEDOBJECTTYPE) VALUES(?,?,?,?,?,NOW(),?)";
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])new Object[]{permChangeId, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), permType == 10 ? "10" : "80", userInfo.getNumber(), userInfo.getName(), "\u7528\u6237"});
        Set<String> getAuthentorSet = this.getAuthentorByPerms(ctx, targetOrg.getCU().getId().toString(), userOrgPermMap.keySet());
        this.insertAuthenRecord(ctx, targetOrg.getCU().getId().toString(), getAuthentorSet, permChangeId);
        String insertPermChangeSql = "INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid, FOrgID, FPermItemID, FASSIGNTYPE,FPermType, FRuleStructure,FRuleExpr, FCtrlUnitID) values (?,?,?,?,?,?,?,?,?,?,?)";
        statement = connection.prepareStatement(insertPermChangeSql);
        for (Map.Entry<String, UserOrgPermInfo> entry : userOrgPermMap.entrySet()) {
            statement.setString(1, BOSUuid.create((BOSObjectType)new BOSObjectType("5592D485")).toString());
            statement.setString(2, BOSUuid.create((BOSObjectType)new BOSObjectType("896DC075")).toString());
            statement.setString(3, permChangeId);
            statement.setString(4, userInfo.getId().toString());
            statement.setString(5, targetOrg.getId().toString());
            statement.setString(6, entry.getKey());
            statement.setString(7, "10");
            statement.setInt(8, permType);
            UserOrgPermInfo userOrgPermInfo = entry.getValue();
            statement.setString(9, userOrgPermInfo.getRuleStructure());
            statement.setString(10, userOrgPermInfo.getRuleExpr());
            statement.setString(11, userOrgPermInfo.getCtrlUnit().getId().toString());
            statement.addBatch();
        }
        statement.executeBatch();
    }

    private void insertAuthenRecord(Context ctx, String ctrlUnitId, Set<String> authentorSet, String permChangeId) throws BOSException, SQLException, EASBizException {
        if (authentorSet.size() == 0) {
            return;
        }
        for (String authentorId : authentorSet) {
            String sql = "INSERT INTO T_PM_AuthenRecord(FID,FPermChangeID,FAuthenStatus,FAuthentorID,FCU) VALUES(newbosid('B0E636B6'),'" + permChangeId + "','" + "10" + "','" + authentorId + "','" + ctrlUnitId + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentorId);
        }
    }

    private Set<String> getAuthentorByPerms(Context ctx, String ctrlUnitId, Set<String> perms) throws BOSException, SQLException {
        HashSet<String> authentorSet = new HashSet<String>();
        String sql = "select fauthentorid from T_PM_PermAuthentor atr where atr.fpermitemid in (" + ToolUtils.aryToStr(perms) + ") and atr.fauthentorid in (select fid from t_pm_user where ftype=60 and fid in (select fuserid from t_pm_orgrange where ftype = 10 and forgid = '" + ctrlUnitId + "')) group by fauthentorid";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            authentorSet.add(rowSet.getString("fauthentorid"));
        }
        return authentorSet;
    }

    @Override
    protected PermItemCollection _getAuthorizePerms(Context ctx, IObjectPK userPK, List orgList) throws BOSException, EASBizException {
        if (userPK == null || orgList == null || orgList.isEmpty()) {
            return new PermItemCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList), CompareType.INNER);
        filter.getFilterItems().add(item);
        view.setFilter(filter);
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        Set orgTypeSet = PermissionOrgTypeUtils.getSelectOrgType(orgCol);
        StringBuffer oql = new StringBuffer(" select * where id in (");
        StringBuffer fromSql = new StringBuffer();
        fromSql.append(" Select Distinct FPermItemID From T_PM_UserOrgPerm ").append(" Where FOwner = '" + userPK.toString() + "'").append(" And FOrgID In ( ").append(ToolUtils.aryToStr(orgList)).append(" )").append(" And FPermType = 30 Group By FPermItemID Having Count(FOrgID)>=" + orgList.size() + " ").append(" Union ").append(" Select Distinct T1.FPermItemID From T_PM_RolePerm T1 ,T_PM_UserRoleOrg T2 ").append(" Where T2.FRoleID = T1.FRoleID And ").append(" T2.FUserID = '" + userPK.toString() + "'  And ").append(" T2.FOrgID In ( ").append(ToolUtils.aryToStr(orgList)).append(" )").append(" And T1.FPermType = 30 Group By T1.FPermItemID Having count(distinct T2.FOrgID)>=" + orgList.size() + " ");
        oql.append(fromSql).append(" ) and orgRelation in (" + ToolUtils.aryToStr(orgTypeSet) + ") order by longnumber asc");
        return PermItemFactory.getLocalInstance(ctx).getPermItemCollection(oql.toString());
    }

    @Override
    protected UserOrgPermCollection _getAccreditedPerms(Context ctx, IObjectPK userPK, IObjectPK orgPK, Collection permPKCol) throws BOSException {
        assert (userPK != null && orgPK != null);
        UserOrgPermCollection uops = new UserOrgPermCollection();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT fid,FPermItemID, FPermType FROM T_PM_UserOrgPerm WHERE FOwner = ? AND FOrgID = ? and FPermItemID in (").append(ToolUtils.aryToStr(permPKCol)).append(") ");
        Object[] params = new Object[]{userPK.toString(), orgPK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])params);
        UserOrgPermInfo userOrgPermInfo = null;
        try {
            while (rowSet.next()) {
                userOrgPermInfo = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                userOrgPermInfo.setPermItem(permItemInfo);
                userOrgPermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                userOrgPermInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
                uops.add(userOrgPermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer noneSql = new StringBuffer();
        noneSql.append("select a.fid,a.FPermItemID,a.FPermType from T_PM_UserOrgPerm a join T_PM_PermItem b on a.fpermitemid=b.fid ").append(" where a.FOwner=? and a.forgid='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' and a.fpermitemid in (").append(ToolUtils.aryToStr(permPKCol)).append(")").append(" and b.forgrelation=-1");
        Object[] noneParams = new Object[]{userPK.toString()};
        IRowSet noneRowSet = DbUtil.executeQuery((Context)ctx, (String)noneSql.toString(), (Object[])noneParams);
        try {
            while (noneRowSet.next()) {
                userOrgPermInfo = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)noneRowSet.getString("FPermItemID")));
                userOrgPermInfo.setPermItem(permItemInfo);
                userOrgPermInfo.setPermType(PermType.getEnum(noneRowSet.getInt("FPermType")));
                userOrgPermInfo.setId(BOSUuid.read((String)noneRowSet.getString("fid")));
                uops.add(userOrgPermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return uops;
    }

    private void saveInDTempTable(Context ctx, UserOrgPermCollection uopCol, String cuPK, IObjectPK targetUserPK) throws BOSException, EASBizException {
        TableManager manager = null;
        String tableName = null;
        try {
            manager = TableManager.getTableManager((Context)ctx);
            if (manager != null) {
                tableName = manager.getTableName("permissionBatch");
                String createSql = "create table " + tableName + " (FOwner varchar(44),FOrgId varchar(44),FPermItemId varchar(44),FPermType int)";
                manager.createTable(createSql);
            }
            this.addUserOrgPermTmpBatch(ctx, uopCol, tableName);
            this.insertIntoUOP(ctx, tableName, cuPK, targetUserPK);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (manager != null && tableName != null) {
                manager.releaseTable(tableName);
            }
        }
    }

    private void insertIntoUOP(Context ctx, String tmpTableName, String cuPK, IObjectPK targetUserPK) throws BOSException, EASBizException {
        boolean isEnabledAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        String permChangeId = null;
        String sourceUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        UserInfo targetUserInfo = UserFactory.getLocalInstance(ctx).getUserInfo(targetUserPK);
        if (isEnabledAuthen) {
            permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(sourceUserId, "10", targetUserInfo.getNumber(), targetUserInfo.getName(), "user");
            this.insertAuthenRecord(ctx, permChangeId, tmpTableName);
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid,");
            sql.append(" FOrgID,FPermItemID,FPermType,FASSIGNTYPE,FAuthenStatus,FCtrlUnitID) ");
            sql.append(" select newbosid('5592D485'),newbosid('896DC075'),'" + permChangeId + "',");
            sql.append(" tmptable.FOwner,tmptable.FOrgId,tmptable.FPermItemId,tmptable.FPermType,");
            sql.append("'10','10','" + cuPK + "'");
            sql.append(" from " + tmpTableName + " tmptable inner join T_PM_PermAuthentor pa ");
            sql.append(" on tmptable.FPermItemId = pa.FPermitemID");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("insert into t_pm_userOrgPerm(fid,fowner,forgid,fpermitemid,FPermType,FCtrlUnitID) ");
            sql.append(" select newBOSId('896DC075'),a.fowner,a.forgid,a.fpermitemid,a.fpermtype,'");
            sql.append(cuPK).append("' from ");
            sql.append(tmpTableName).append("  a left join t_pm_userorgperm b on ");
            sql.append(" a.fowner=b.fowner and a.forgid=b.forgid and a.fpermitemid=b.fpermitemid and a.fpermtype=b.fpermtype ");
            sql.append(" where b.fid is null and a.FPermItemId not in (select FPermitemID from T_PM_PermAuthentor)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else {
            StringBuffer sql = new StringBuffer().append("insert into t_pm_userOrgPerm(fid,fowner,forgid,fpermitemid,FPermType,FCtrlUnitID) ").append(" select newBOSId('896DC075'),a.fowner,a.forgid,a.fpermitemid,a.fpermtype,'").append(cuPK).append("' from ").append(tmpTableName).append(" a left join t_pm_userorgperm b on ").append(" a.fowner=b.fowner and a.forgid=b.forgid and a.fpermitemid=b.fpermitemid and a.fpermtype=b.fpermtype ").append(" where b.fid is null");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void insertAuthenRecord(Context ctx, String permChangeId, String tmpTableName) throws BOSException {
    }

    class ExecuteCall
    implements Callable<String> {
        PreparedStatement state = null;

        ExecuteCall() {
        }

        public void setState(PreparedStatement state) {
            this.state = state;
        }

        @Override
        public String call() {
            try {
                this.state.executeBatch();
                return "true";
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                return "false";
            }
        }
    }
}

