/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public final class PermItemCacheImpl {
    private static Logger logger = Logger.getLogger(PermItemCacheImpl.class);
    private static final String CACHE_PERM_ITEM = "permission.permItem";
    private static final String CACHE_DEPEND_ITEM = "permission.dependItem";
    private static final String CACHE_BEEN_DEPEND_ITEM = "permission.beenDependItem";
    private static Object dependMonitor = new Object();
    private static Map dependItemMap = new HashMap();
    private static Map beenDependItemMap = new HashMap();
    private static Object beenDependMonitor = new Object();
    private static final String aliasFieldL1 = "FAlias_L1";
    private static final String aliasFieldL2 = "FAlias_L2";
    private static final String aliasFieldL3 = "FAlias_L3";

    private PermItemCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        new CustomCacheService(CACHE_PERM_ITEM).removeAll();
        Object object = dependMonitor;
        synchronized (object) {
            new CustomCacheService(CACHE_DEPEND_ITEM).removeAll();
            if (dependItemMap.size() > 0) {
                dependItemMap.clear();
            }
        }
        object = beenDependMonitor;
        synchronized (object) {
            new CustomCacheService(CACHE_BEEN_DEPEND_ITEM).removeAll();
            if (beenDependItemMap.size() > 0) {
                beenDependItemMap.clear();
            }
        }
    }

    public static PermItemInfo getPermItem(Context ctx, String permItemName) throws EASBizException, BOSException {
        CustomCacheService cacheService = new CustomCacheService(CACHE_PERM_ITEM);
        PermItemInfo result = (PermItemInfo)cacheService.get(permItemName);
        if (result == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("SELECT FID, FName, FAlias_L1, FAlias_L2, FAlias_L3,");
            buffer.append(" FLongNumber, FObjectType, FType, FOrgRelation, ").append(" FOperationType, FIsApplyToF7 FROM T_PM_PermItem WHERE FName = ? AND FIsLeaf = 1");
            try {
                Object[] params = new Object[]{permItemName};
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
                if (rowSet.next()) {
                    PermItemInfo permItemInfo = new PermItemInfo();
                    String ID = rowSet.getString("FID");
                    String name = rowSet.getString("FName");
                    permItemInfo.setId(BOSUuid.read((String)ID));
                    permItemInfo.setName(name);
                    permItemInfo.setAlias(rowSet.getString(aliasFieldL1), BOSLocaleUtil.EAS_LOCALES[0]);
                    permItemInfo.setAlias(rowSet.getString(aliasFieldL2), BOSLocaleUtil.EAS_LOCALES[1]);
                    permItemInfo.setAlias(rowSet.getString(aliasFieldL3), BOSLocaleUtil.EAS_LOCALES[2]);
                    permItemInfo.setLongNumber(rowSet.getString("FLongNumber"));
                    permItemInfo.setObjectType(rowSet.getString("FObjectType"));
                    permItemInfo.setType(PermItemType.getEnum(rowSet.getInt("FType")));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                    permItemInfo.setOperationType(OperationType.getEnum(rowSet.getString("FOperationType")));
                    permItemInfo.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                    result = permItemInfo;
                    cacheService.put(permItemName, (Object)result);
                } else {
                    logger.info((Object)"permitem is not found,pls synchonize permitem");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new EASBizException(PermissionException.GET_INFO_FAIL, (Throwable)e);
            }
        }
        if (result == null) {
            if ("bs_permission_user_view".equals(permItemName)) {
                result = new PermItemInfo();
                result.setName(permItemName);
                result.setOrgRelation(OrgType.NONE);
            } else {
                IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
                PermissionItemInfo permissionItemInfo = iPermItem.getPermissionItemInfo(permItemName);
                if (permissionItemInfo != null) {
                    String alias = permissionItemInfo.getAlias();
                    String display = alias + "(" + permItemName + ")";
                    Object[] objects = new Object[]{display};
                    throw new PermItemException(PermItemException.ITEM_NOT_FOUND, objects);
                }
                Object[] objects = new Object[]{permItemName};
                throw new PermItemException(PermItemException.ITEM_NOT_FOUND, objects);
            }
        }
        result.setAlias(result.getAlias(ctx.getLocale()));
        return result;
    }

    public static PermItemCollection getDepPermItems(Context ctx, IObjectPK permItemPK) throws EASBizException, BOSException {
        String IDKey = permItemPK.toString();
        PermItemCollection dep = (PermItemCollection)((Object)dependItemMap.get(IDKey));
        if (dep == null && dependItemMap.size() == 0) {
            PermItemCacheImpl.initDependItemMap(ctx);
            dep = (PermItemCollection)((Object)dependItemMap.get(IDKey));
        }
        if (dep != null) {
            PermItemCollection indirect = new PermItemCollection();
            PermItemCacheImpl.addAllDepPermItems(dep, indirect);
            for (int i = 0; i < indirect.size(); ++i) {
                if (dep.contains(indirect.get(i))) continue;
                dep.add(indirect.get(i));
            }
        }
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermItemCollection getBeenDepPermItems(Context ctx, IObjectPK permItemPK) throws EASBizException, BOSException {
        String IDKey = permItemPK.toString();
        PermItemCollection dep = (PermItemCollection)((Object)beenDependItemMap.get(IDKey));
        if (dep != null) {
            return dep;
        }
        if (beenDependItemMap.size() > 0) {
            return null;
        }
        Object object = beenDependMonitor;
        synchronized (object) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" SELECT PermDependency.FID, PermDependency.FDependencyID, PermItem.FOrgRelation, PermItem.FType,PermItem.FParentID,PermItem.FIsLeaf,").append(aliasFieldL1).append(",").append(aliasFieldL2).append(",").append(aliasFieldL3).append(" FROM T_PM_PermDependency PermDependency ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = PermDependency.FID ORDER BY PermDependency.FDependencyID ");
            HashMap<String, PermItemCollection> allBeenDependedPemItems = new HashMap<String, PermItemCollection>(200);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                while (rowSet.next()) {
                    PermItemCollection permItems;
                    PermItemInfo permItemInfo = new PermItemInfo();
                    String ID = rowSet.getString("FID");
                    String dependencyID = rowSet.getString("FDependencyID");
                    int orgRelateion = rowSet.getInt("FOrgRelation");
                    String parentID = rowSet.getString("FParentID");
                    boolean isLeaf = rowSet.getBoolean("FIsLeaf");
                    PermItemType permItemType = PermItemType.getEnum(rowSet.getInt("FType"));
                    String aliasL1 = rowSet.getString(aliasFieldL1);
                    String aliasL2 = rowSet.getString(aliasFieldL2);
                    String aliasL3 = rowSet.getString(aliasFieldL3);
                    if (permItemType.equals((Object)PermItemType.SYSTEM_ADMIN_FUNCTION) || permItemType.equals((Object)PermItemType.BIZ_ADMIN_FUNCTION)) continue;
                    permItemInfo.setId(BOSUuid.read((String)ID));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)orgRelateion));
                    permItemInfo.setType(permItemType);
                    permItemInfo.setAlias(aliasL1, Locale.ENGLISH);
                    permItemInfo.setAlias(aliasL2, Locale.SIMPLIFIED_CHINESE);
                    permItemInfo.setAlias(aliasL3, Locale.TRADITIONAL_CHINESE);
                    permItemInfo.setIsLeaf(isLeaf);
                    if (!StringUtils.isEmpty((String)parentID)) {
                        PermItemInfo parent = new PermItemInfo();
                        parent.setId(BOSUuid.read((String)parentID));
                        permItemInfo.setParent(parent);
                    }
                    if (allBeenDependedPemItems.containsKey(dependencyID)) {
                        permItems = (PermItemCollection)((Object)allBeenDependedPemItems.get(dependencyID));
                        permItems.add(permItemInfo);
                        continue;
                    }
                    permItems = new PermItemCollection();
                    permItems.add(permItemInfo);
                    allBeenDependedPemItems.put(dependencyID, permItems);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new EASBizException(PermissionException.GET_INFO_FAIL, (Throwable)e);
            }
            for (Map.Entry entry : allBeenDependedPemItems.entrySet()) {
                String key = (String)entry.getKey();
                beenDependItemMap.put(key, entry.getValue());
            }
            return (PermItemCollection)((Object)allBeenDependedPemItems.get(IDKey));
        }
    }

    private static void addAllDepPermItems(PermItemCollection dep, PermItemCollection indirect) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = null;
        PermItemCollection directDep = null;
        for (int i = 0; i < dep.size(); ++i) {
            permItemInfo = dep.get(i);
            if (!permItemInfo.isIsUserDefined() || (directDep = (PermItemCollection)((Object)dependItemMap.get(permItemInfo.getId().toString()))) == null || directDep.size() <= 0) continue;
            indirect.addCollection(directDep);
            PermItemCacheImpl.addAllDepPermItems(directDep, indirect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDependItemMap(Context ctx) throws EASBizException, BOSException {
        Object object = dependMonitor;
        synchronized (object) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" SELECT PermDependency.FID, PermDependency.FDependencyID, PermItem.FOrgRelation, PermItem.FType,PermItem.FParentID,PermItem.FIsLeaf,").append(aliasFieldL1).append(",").append(aliasFieldL2).append(",").append(aliasFieldL3).append(",PermItem.fisUserDefined").append(" FROM T_PM_PermDependency PermDependency ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = PermDependency.FDependencyID ORDER BY  PermDependency.FID ");
            HashMap<String, PermItemCollection> allDependencyPemItems = new HashMap<String, PermItemCollection>(200);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                while (rowSet.next()) {
                    PermItemCollection permItems;
                    PermItemInfo permItemInfo = new PermItemInfo();
                    String ID = rowSet.getString("FID");
                    String dependencyID = rowSet.getString("FDependencyID");
                    int orgRelateion = rowSet.getInt("FOrgRelation");
                    String parentID = rowSet.getString("FParentID");
                    boolean isLeaf = rowSet.getBoolean("FIsLeaf");
                    String aliasL1 = rowSet.getString(aliasFieldL1);
                    String aliasL2 = rowSet.getString(aliasFieldL2);
                    String aliasL3 = rowSet.getString(aliasFieldL3);
                    PermItemType permItemType = PermItemType.getEnum(rowSet.getInt("FType"));
                    if (permItemType.equals((Object)PermItemType.SYSTEM_ADMIN_FUNCTION) || permItemType.equals((Object)PermItemType.BIZ_ADMIN_FUNCTION)) continue;
                    permItemInfo.setId(BOSUuid.read((String)dependencyID));
                    permItemInfo.setOrgRelation(OrgType.getEnum((int)orgRelateion));
                    permItemInfo.setType(permItemType);
                    permItemInfo.setAlias(aliasL1, Locale.ENGLISH);
                    permItemInfo.setAlias(aliasL2, Locale.SIMPLIFIED_CHINESE);
                    permItemInfo.setAlias(aliasL3, Locale.TRADITIONAL_CHINESE);
                    permItemInfo.setIsLeaf(isLeaf);
                    permItemInfo.setIsUserDefined(rowSet.getInt("fisUserDefined") == 1);
                    if (!StringUtils.isEmpty((String)parentID)) {
                        PermItemInfo parent = new PermItemInfo();
                        parent.setId(BOSUuid.read((String)parentID));
                        permItemInfo.setParent(parent);
                    }
                    if (allDependencyPemItems.containsKey(ID)) {
                        permItems = (PermItemCollection)((Object)allDependencyPemItems.get(ID));
                        permItems.add(permItemInfo);
                        continue;
                    }
                    permItems = new PermItemCollection();
                    permItems.add(permItemInfo);
                    allDependencyPemItems.put(ID, permItems);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new EASBizException(PermissionException.GET_INFO_FAIL, (Throwable)e);
            }
            for (Map.Entry entry : allDependencyPemItems.entrySet()) {
                String key = (String)entry.getKey();
                dependItemMap.put(key, entry.getValue());
            }
        }
    }
}

