/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.PermClearStrategyCollection;
import com.kingdee.eas.base.permission.PermClearStrategyFactory;
import com.kingdee.eas.base.permission.PermClearStrategyInfo;
import com.kingdee.eas.base.permission.StrategyTypeEnum;
import com.kingdee.eas.base.permission.app.clear.common.IPreCondition;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.strategy.PermClearStrategyBean;
import com.kingdee.eas.base.permission.app.clear.strategy.idleuser.IdelUserHelper;
import com.kingdee.eas.base.permission.app.clear.strategy.invaliddata.InvaliddataHelper;
import com.kingdee.eas.base.permission.app.clear.strategy.permrank.PermRankStrategyHelper;
import com.kingdee.eas.base.permission.app.clear.strategy.permrank.RankPreCondition;
import com.kingdee.eas.base.permission.app.clear.strategy.permrepeat.PermRepeatStrategyHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PermClearStrategyManager {
    public static List<PermClearStrategyBean> getPermClearStrategyDisplay(Context ctx) throws BOSException {
        return PermClearStrategyManager.getPermClearStrategys(ctx, null);
    }

    public static List<PermClearStrategyBean> getPermClearStrategys(Context ctx, List<String> strategyIds) throws BOSException {
        String oql = "select * ";
        if (strategyIds != null && !strategyIds.isEmpty()) {
            oql = oql + "where id in(" + ToolUtils.aryToStr(strategyIds) + ")";
        }
        PermClearStrategyCollection permClearStrategyCollection = PermClearStrategyFactory.getLocalInstance(ctx).getPermClearStrategyCollection(oql);
        return PermClearStrategyManager.convertStrategyBeans(permClearStrategyCollection);
    }

    public static boolean updatePreCondition(Context ctx, String strategyId, Map<String, Object> preCondtionParams) throws EASBizException, BOSException {
        PermClearStrategyInfo permClearStrategyInfo = PermClearStrategyFactory.getLocalInstance(ctx).getPermClearStrategyInfo((IObjectPK)new ObjectStringPK(strategyId));
        StrategyTypeEnum strategyTypeEnum = StrategyTypeEnum.getEnum(permClearStrategyInfo.getNumber());
        if (strategyTypeEnum == StrategyTypeEnum.PermRank) {
            PermRankStrategyHelper.updateClearStrategyPreCodtion(ctx, strategyId, preCondtionParams);
        }
        if (strategyTypeEnum == StrategyTypeEnum.PermRpeat) {
            PermRepeatStrategyHelper.updateClearStrategyPreCodtion(ctx, strategyId, preCondtionParams);
        }
        if (strategyTypeEnum == StrategyTypeEnum.IdleUser) {
            IdelUserHelper.updateClearStrategyPreCodtion(ctx, strategyId, preCondtionParams);
        }
        if (strategyTypeEnum == StrategyTypeEnum.InvalidData) {
            InvaliddataHelper.updateClearStrategyPreCodtion(ctx, strategyId, preCondtionParams);
        }
        return true;
    }

    public static List<PermClearStrategyBean> convertStrategyBeans(PermClearStrategyCollection colls) {
        ArrayList<PermClearStrategyBean> beans = new ArrayList<PermClearStrategyBean>();
        for (int i = 0; i < colls.size(); ++i) {
            PermClearStrategyInfo permClearStrategyInfo = colls.get(i);
            beans.add(PermClearStrategyManager.convertStrategyBean(permClearStrategyInfo));
        }
        return beans;
    }

    public static PermClearStrategyBean convertStrategyBean(PermClearStrategyInfo permClearStrategyInfo) {
        PermClearStrategyBean permClearStrategyBean = new PermClearStrategyBean();
        permClearStrategyBean.setId(permClearStrategyInfo.getId().toString());
        permClearStrategyBean.setNumber(permClearStrategyInfo.getNumber());
        permClearStrategyBean.setName(permClearStrategyInfo.getName());
        permClearStrategyBean.setType(permClearStrategyInfo.getType());
        permClearStrategyBean.setDescrption(permClearStrategyInfo.getDescription());
        permClearStrategyBean.setUpdateTime(PermClearUtils.getDateStr(permClearStrategyInfo.getLastUpdateTime()));
        IPreCondition preCondition = IPreCondition.unSerializeByType(permClearStrategyInfo.getNumber(), permClearStrategyInfo.getPreconditions());
        permClearStrategyBean.setPreCondition(preCondition);
        permClearStrategyBean.setPreConditionDisplay(preCondition.createDisplayContent());
        return permClearStrategyBean;
    }

    public static void main(String[] args) {
        PermClearStrategyBean permClearStrategyQueryBean = new PermClearStrategyBean();
        RankPreCondition rankPreCondition = new RankPreCondition();
        rankPreCondition.setAll(true);
        permClearStrategyQueryBean.setPreCondition(rankPreCondition);
        System.out.println(new Gson().toJson((Object)permClearStrategyQueryBean));
    }
}

