/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.IScan;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractScan
implements IScan {
    protected static Logger logger = Logger.getLogger((String)AbstractScan.class.getName());
    protected String scanStartTime = null;
    protected String scanUpdateTime = null;
    protected String scanEndTime = null;
    protected ScanStatusEnum scanStatus;
    protected boolean isScanFinished = false;
    protected String errorMsg = null;

    @Override
    public void scan(Context ctx) {
        this.scanStatus = ScanStatusEnum.SCANING;
        this.scanStartTime = PermClearUtils.getDateStr(new Date());
        try {
            this.execScaning(ctx);
            this.scanStatus = ScanStatusEnum.FINISHED;
        }
        catch (Exception e) {
            this.scanStatus = ScanStatusEnum.FAIL;
            this.errorMsg = e.getMessage();
            logger.error((Object)e);
        }
        this.scanEndTime = PermClearUtils.getDateStr(new Date());
        this.isScanFinished = true;
        this.refreshScan();
    }

    public abstract void execScaning(Context var1) throws BOSException, SQLException;

    @Override
    public boolean refreshScan() {
        this.scanUpdateTime = PermClearUtils.getDateStr(new Date());
        return this.isScanFinished;
    }

    public boolean isScanFinished() {
        return this.isScanFinished;
    }

    public void setScanFinished(boolean isScanFinished) {
        this.isScanFinished = isScanFinished;
    }

    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    public void setScanStatus(ScanStatusEnum scanStatus) {
        this.scanStatus = scanStatus;
    }

    public String getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(String scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public String getScanEndTime() {
        return this.scanEndTime;
    }

    public void setScanEndTime(String scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public String getScanUpdateTime() {
        return this.scanUpdateTime;
    }

    public void setScanUpdateTime(String scanUpdateTime) {
        this.scanUpdateTime = scanUpdateTime;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

