/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.idleuser;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.eas.base.permission.app.clear.strategy.idleuser.IdelUserPreCondtion;
import com.kingdee.eas.base.permission.app.clear.strategy.permrank.RankPreCondition;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IdleUserScan
extends AbstractScan
implements IPermClearStrategyScan {
    private static Logger logger = Logger.getLogger((String)RankPreCondition.class.getName());
    String scanSql = "SELECT FID,FNUMBER,FNAME_L2 ,FCREATETIME,FLASTUPDATETIME,FLASTLOGINTIME,NOW() AS CURTIME FROM T_PM_USER";
    private int dataCounts = 0;
    private int scanCounts = 0;
    ScanContent scanContent = new ScanContent();

    public void initFromCondtion(IdelUserPreCondtion idelUserPreCondtion) {
        this.scanContent.maxIdelDays = idelUserPreCondtion.getMaxIdelDays();
    }

    @Override
    public void unSerialize(String content) {
        if (!StringUtils.isEmpty((String)content)) {
            IdleUserScan scan = (IdleUserScan)new Gson().fromJson(content, IdleUserScan.class);
            this.scanContent = scan.scanContent;
        }
    }

    @Override
    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(this.scanSql);
            rs = statement.executeQuery();
            while (rs.next()) {
                ++this.dataCounts;
                Date createTime = rs.getDate("FCREATETIME");
                if (createTime == null) continue;
                Date lastUpdateTime = rs.getDate("FLASTUPDATETIME");
                Date lastLoginTime = rs.getDate("FLASTLOGINTIME");
                Date curTime = rs.getDate("CURTIME");
                long idelDays = 0L;
                int type = 0;
                if (lastLoginTime == null) {
                    type = 0;
                    idelDays = (curTime.getTime() - createTime.getTime()) / 86400000L;
                } else {
                    type = 1;
                    idelDays = (curTime.getTime() - lastLoginTime.getTime()) / 86400000L;
                }
                if (idelDays <= (long)this.scanContent.maxIdelDays) continue;
                this.scanContent.addIdelUser(rs.getString("FID"), rs.getString("FNUMBER"), rs.getString("FNAME_L2"), rs.getString("FLASTLOGINTIME"), idelDays, type);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                ++this.scanCounts;
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        ++this.scanCounts;
    }

    @Override
    public boolean refreshScan() {
        return this.isScanFinished;
    }

    @Override
    public int getCounts() {
        return 1;
    }

    @Override
    public int getScanCounts() {
        return this.scanCounts;
    }

    @Override
    public int getScanUsersCounts() {
        return this.scanContent.idelUsers.size();
    }

    @Override
    public int getScanPermCounts() {
        return 0;
    }

    @Override
    public int getScanDataCounts() {
        return this.dataCounts;
    }

    @Override
    public int getScanRoleCounts() {
        return 0;
    }

    @Override
    public int getScanOrgCounts() {
        return 0;
    }

    @Override
    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    public ScanContent getScanContent() {
        return this.scanContent;
    }

    static class ScanContent {
        List<ScanUser> idelUsers = new ArrayList<ScanUser>();
        int maxIdelDays = 3650;

        ScanContent() {
        }

        public void addIdelUser(String userId, String userNumber, String userName, String lastLoginTime, long idelDays, int type) {
            ScanUser scanUser = new ScanUser();
            scanUser.userId = userId;
            scanUser.userNumber = userNumber;
            scanUser.userName = userName;
            scanUser.lastLoginTime = lastLoginTime;
            scanUser.idelDays = idelDays;
            scanUser.type = type;
            this.idelUsers.add(scanUser);
        }

        static class ScanUser {
            String userId;
            String userNumber;
            String userName;
            String lastLoginTime;
            long idelDays = 0L;
            int type = 0;

            ScanUser() {
            }
        }
    }
}

