/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.invaliddata.scanunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearScanUnit;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class UserOrgPermScanUnit
extends AbstractScan
implements IPermClearScanUnit {
    private static String userOrgPermScanSql = "SELECT URO.FID,URO.FOWNER,URO.FORGID AS FID FROM T_PM_USERORGPERM URO WHERE NOT EXISTS (SELECT 1 FROM T_PM_USER UU WHERE UU.FID = URO.FOWNER) OR  NOT EXISTS (SELECT 1 FROM T_ORG_BASEUNIT ORG WHERE ORG.FID  = URO.FORGID)";
    private static String clearSql = "DELETE FROM T_PM_USERORGPERM where FID = ?";
    private String number = "UserOrgPerm";
    private int dataCounts = 0;
    private int permCounts = 0;
    private int orgCounts = 0;
    private int roleCounts = 0;
    private int userCounts = 0;
    private boolean isClear = false;

    public UserOrgPermScanUnit(boolean isClear) {
        this.isClear = isClear;
    }

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> userIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(userOrgPermScanSql);
            rs = statement.executeQuery();
            while (rs.next()) {
                ++this.dataCounts;
                ++this.permCounts;
                userIds.add(rs.getString("FOWNER"));
                orgIds.add(rs.getString("FORGID"));
                this.userCounts = userIds.size();
                this.orgCounts = orgIds.size();
                if (!this.isClear) continue;
                this.clean(ctx, rs.getString("FID"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    public void clean(Context ctx, String id) throws BOSException {
        DbUtil.execute((Context)ctx, (String)clearSql, (Object[])new Object[]{id});
    }

    @Override
    public int getScanDataCounts() {
        return this.dataCounts;
    }

    @Override
    public int getScanUsersCounts() {
        return this.userCounts;
    }

    @Override
    public int getScanRoleCounts() {
        return this.roleCounts;
    }

    @Override
    public int getScanPermCounts() {
        return this.permCounts;
    }

    @Override
    public int getScanOrgCounts() {
        return this.dataCounts;
    }
}

