/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.permrepeat;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearScanUnit;
import com.kingdee.eas.base.permission.app.clear.scan.permrepeat.PermRepeatScan;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PermRepeatScanUnit
extends AbstractScan
implements IPermClearScanUnit {
    private static Logger logger = Logger.getLogger((String)PermRepeatScanUnit.class.getName());
    private static String scanSql = "SELECT orp.fid,\r\n       orp.FPERMITEMID,\r\n       uro.FORGID,\r\n       uro.FROLEID,\r\n       orp.FRULEEXPR      as fFRULEEXPR1,\r\n       orp.FRULESTRUCTURE as FRULESTRUCTURE1,\r\n       rp.FRULEEXPR       as fFRULEEXPR2,\r\n       rp.FRULESTRUCTURE  as FRULESTRUCTURE2\r\n  FROM T_PM_Userorgperm orp\r\n inner join T_PM_userroleorg uro\r\n    on orp.FOWNER = uro.fuserid\r\n   and (orp.FORGID = uro.FORGID or\r\n       orp.FORGID = '11111111-1111-1111-1111-111111111111CCE7AED4')\r\n INNER JOIN T_PM_ROLEPERM rp\r\n    on uro.FROLEID = rp.FROLEID\r\n   and orp.FPERMITEMID = rp.FPERMITEMID\r\n where orp.fowner = ?";
    protected String userId;
    protected String userNumber;
    protected String userName;
    private int permCounts = 0;
    private int orgCounts = 0;
    private int roleCounts = 0;
    private int dataCounts = 0;

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> roleIds = new HashSet<String>();
        HashSet<String> userorgpermIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(scanSql);
            statement.setString(1, this.userId);
            rs = statement.executeQuery();
            while (rs.next()) {
                String FRULESTRUCTURE2;
                String fFRULEEXPR1 = rs.getString("fFRULEEXPR1") == null ? "" : rs.getString("fFRULEEXPR1").trim();
                String fFRULEEXPR2 = rs.getString("fFRULEEXPR2") == null ? "" : rs.getString("fFRULEEXPR2").trim();
                String FRULESTRUCTURE1 = rs.getString("FRULESTRUCTURE1") == null ? "" : rs.getString("FRULESTRUCTURE1").trim();
                String string = FRULESTRUCTURE2 = rs.getString("FRULESTRUCTURE2") == null ? "" : rs.getString("FRULESTRUCTURE2").trim();
                if (fFRULEEXPR1.equals(fFRULEEXPR2) && FRULESTRUCTURE1.equals(FRULESTRUCTURE2)) {
                    String orgId = rs.getString("FORGID");
                    String roleId = rs.getString("FRoleId");
                    String fid = rs.getString("fid");
                    orgIds.add(orgId);
                    roleIds.add(roleId);
                    userorgpermIds.add(fid);
                    this.permCounts = userorgpermIds.size();
                    this.orgCounts = orgIds.size();
                    this.roleCounts = roleIds.size();
                }
                ++this.dataCounts;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    @Override
    public ScanStatusEnum getScanStatus() {
        return this.scanStatus;
    }

    @Override
    public int getScanDataCounts() {
        return this.dataCounts;
    }

    @Override
    public int getScanUsersCounts() {
        return this.isScanFinished ? 1 : 0;
    }

    @Override
    public int getScanRoleCounts() {
        return this.roleCounts;
    }

    @Override
    public int getScanPermCounts() {
        return this.permCounts;
    }

    @Override
    public int getScanOrgCounts() {
        return this.orgCounts;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static void main(String[] args) {
        String scan = new Gson().toJson((Object)new PermRepeatScanUnit());
        System.out.println(scan);
        PermRepeatScan permRankScan = (PermRepeatScan)new Gson().fromJson(scan, PermRepeatScan.class);
        scan = new Gson().toJson((Object)new PermRepeatScanUnit());
        System.out.println(scan);
    }
}

