/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.task;

import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

public class PermClearQuartzManager {
    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
    private static String JOB_GROUP_NAME = "PERM_CLEAR_JOBGROUP_NAME";
    private static String TRIGGER_GROUP_NAME = "PERM_CLEAR_TRIGGERGROUP_NAME";

    public static void addJob(String jobName, JobDataMap jobDataMap, Class cls, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetailImpl jobDetail = new JobDetailImpl(jobName, JOB_GROUP_NAME, cls);
            jobDetail.setJobDataMap(jobDataMap);
            CronTriggerImpl trigger = new CronTriggerImpl(jobName, TRIGGER_GROUP_NAME);
            trigger.setCronExpression(time);
            sched.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJob(String jobName, Class cls, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetailImpl jobDetail = new JobDetailImpl(jobName, JOB_GROUP_NAME, cls);
            CronTriggerImpl trigger = new CronTriggerImpl(jobName, TRIGGER_GROUP_NAME);
            trigger.setCronExpression(time);
            sched.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobDetailImpl jobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
            CronTriggerImpl trigger = new CronTriggerImpl(triggerName, triggerGroupName);
            trigger.setCronExpression(time);
            sched.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(String jobName, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            CronTrigger trigger = (CronTrigger)sched.getTrigger(new TriggerKey(jobName, TRIGGER_GROUP_NAME));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                JobDetail jobDetail = sched.getJobDetail(new JobKey(jobName, JOB_GROUP_NAME));
                Class objJobClass = jobDetail.getJobClass();
                PermClearQuartzManager.removeJob(jobName);
                PermClearQuartzManager.addJob(jobName, objJobClass, time);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(String triggerName, String triggerGroupName, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            CronTrigger trigger = (CronTrigger)sched.getTrigger(new TriggerKey(triggerName, triggerGroupName));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                CronTriggerImpl ct = (CronTriggerImpl)trigger;
                ct.setCronExpression(time);
                sched.resumeTrigger(new TriggerKey(triggerName, triggerGroupName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.pauseTrigger(new TriggerKey(jobName, TRIGGER_GROUP_NAME));
            sched.unscheduleJob(new TriggerKey(jobName, TRIGGER_GROUP_NAME));
            sched.deleteJob(new JobKey(jobName, JOB_GROUP_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.pauseTrigger(new TriggerKey(triggerName, triggerGroupName));
            sched.unscheduleJob(new TriggerKey(triggerName, triggerGroupName));
            sched.deleteJob(new JobKey(jobName, jobGroupName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutdownJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

