/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.config;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public final class ConfigurationLoader {
    private static ConfigurationLoader instance = null;
    public static final String[] FILES = new String[]{"BOS_PermissionConfiguration.xml", "EAS_PermissionConfiguration.xml"};
    private ConfigurationInfo configurationInfo = new ConfigurationInfo();
    private static final Logger logger = Logger.getLogger(ConfigurationLoader.class);

    public static ConfigurationLoader getInstance() {
        if (instance == null) {
            instance = new ConfigurationLoader();
        }
        return instance;
    }

    public ConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }

    public static File[] getConfiguationFile() {
        File[] files = new File[FILES.length];
        for (int i = 0; i < FILES.length; ++i) {
            String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append(FILES[i]).toString();
            files[i] = new File(path);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationLoader() {
        InputStream inputStream = null;
        try {
            File[] files = ConfigurationLoader.getConfiguationFile();
            for (int i = 0; i < files.length; ++i) {
                try {
                    inputStream = new FileInputStream(files[i]);
                    Element document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
                    this.loadConfigurationInfo(document);
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            String error = "read file failed:";
            logger.error((Object)(error + e));
            throw new IllegalArgumentException(error + e);
        }
        catch (JDOMException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException("read file failed:" + (Object)((Object)e));
        }
        finally {
            try {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    inputStream = null;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    inputStream = null;
                }
            }
            catch (Throwable throwable) {
                inputStream = null;
                throw throwable;
            }
        }
    }

    private void loadConfigurationInfo(Element root) {
        List childrens = root.getChildren();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)childrens.get(i);
            String elementName = element.getName();
            if ("special-data-permissions".equalsIgnoreCase(elementName)) {
                this.loadSpecialEntityTypes(element);
                continue;
            }
            if ("s1basedatas".equalsIgnoreCase(elementName)) {
                this.loadS1BaseDataTypes(element);
                continue;
            }
            if ("cslrpt-permitems".equalsIgnoreCase(elementName)) {
                this.loadCslrptPermItemNames(element);
                continue;
            }
            if (!"discrete-permissions".equalsIgnoreCase(elementName)) continue;
            this.loadDiscreteInfo(element);
        }
    }

    private void loadSpecialEntityTypes(Element element) {
        List entities = element.getChildren();
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            Element entity = (Element)entities.get(i);
            String entityType = entity.getChild("type").getText();
            this.configurationInfo.getSpecialEntityTypes().add(entityType);
            if (entity.getChild("position-field") == null) continue;
            String positionField = entity.getChild("position-field").getText();
            this.configurationInfo.getSpecialPositionField().put(entityType, positionField);
        }
    }

    private void loadS1BaseDataTypes(Element element) {
        List entities = element.getChildren();
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            Element entity = (Element)entities.get(i);
            String entityType = entity.getChild("type").getText();
            this.configurationInfo.getS1BaseDataTypes().add(entityType);
        }
    }

    private void loadCslrptPermItemNames(Element element) {
        List permItems = element.getChildren();
        int size = permItems.size();
        for (int i = 0; i < size; ++i) {
            Element permItem = (Element)permItems.get(i);
            String permItemName = permItem.getChild("name").getText();
            this.configurationInfo.getCslrptPermItemNames().add(permItemName);
        }
    }

    private void loadDiscreteInfo(Element element) {
        List discretePermissions = element.getChildren();
        int size = discretePermissions.size();
        for (int i = 0; i < size; ++i) {
            Element discretePermission = (Element)discretePermissions.get(i);
            String entityType = discretePermission.getChild("type").getText();
            String tableName = discretePermission.getChild("table-name").getText();
            this.configurationInfo.getDiscretEntityTables().put(entityType, tableName);
            Element elementPermItems = discretePermission.getChild("permitems");
            List permItems = elementPermItems.getChildren();
            LinkedHashSet<String> setPermItems = new LinkedHashSet<String>();
            int size1 = permItems.size();
            for (int j = 0; j < size1; ++j) {
                Element elementPermItem = (Element)permItems.get(j);
                String permItemName = elementPermItem.getChild("name").getText();
                setPermItems.add(permItemName);
            }
            this.configurationInfo.getDiscretEntityPermItems().put(entityType, setPermItems);
        }
    }
}

