/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.config;

import com.kingdee.eas.base.permission.PermissionResUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SslUIConfiguration {
    private static Logger logger = Logger.getLogger(SslUIConfiguration.class);
    private Properties configuration = null;
    private static SslUIConfiguration instance = null;

    private SslUIConfiguration() {
    }

    public static SslUIConfiguration getInstance() {
        if (instance == null) {
            instance = new SslUIConfiguration();
        }
        return instance;
    }

    public Properties getSSLConfig() {
        if (this.configuration != null) {
            return this.configuration;
        }
        FileInputStream fin = null;
        try {
            File configFile = this.getConfigFile();
            fin = new FileInputStream(configFile);
            this.configuration = new Properties();
            this.configuration.load(fin);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("ssl" + PermissionResUtil.getResource("res_2") + e));
            this.storeConfigFile();
        }
        catch (IOException e) {
            logger.error((Object)("ssl" + PermissionResUtil.getResource("res_3") + e));
            this.storeConfigFile();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.configuration;
    }

    private File getConfigFile() throws IOException {
        String ctrlFilePath = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("SSLConfig.properties").toString();
        File configFile = new File(ctrlFilePath);
        logger.debug((Object)("ssl" + PermissionResUtil.getResource("res_4") + configFile.toString()));
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeConfigFile() {
        FileOutputStream fout = null;
        try {
            File clientCtrlFile = this.getConfigFile();
            fout = new FileOutputStream(clientCtrlFile);
            Properties props = new Properties();
            StringBuffer strInfo = new StringBuffer("ssl configuration sample information:");
            strInfo.append("#someEditUI need ssl config :\n").append("#com.kingdee.eas.framework.client.someEditUI = true\n").append("#someEditUI need not ssl config :\n").append("#com.kingdee.eas.framework.client.someEditUI = false\n");
            props.store(fout, strInfo.toString());
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("ssl" + PermissionResUtil.getResource("res_2") + e));
        }
        catch (IOException e) {
            logger.error((Object)("ssl" + PermissionResUtil.getResource("res_3") + e));
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getProperty(String paramName) {
        String property;
        if (this.configuration == null) {
            this.getSSLConfig();
        }
        if ((property = this.configuration.getProperty(paramName)) != null) {
            property = property.trim();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ssl" + PermissionResUtil.getResource("res_5") + paramName + " : " + property));
        }
        return property;
    }

    public boolean isSSLNeeded(String uiclass) {
        return "true".equalsIgnoreCase(this.getProperty(uiclass));
    }
}

