/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.daq.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.permission.app.daq.util.DAQDateUtil;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DataAcquisitionUtil {
    public static Context buildContext(String dataCenter, String l) {
        if (dataCenter == null) {
            return null;
        }
        Context context = new Context();
        Context userCtx = new Context();
        Locale locale = null;
        locale = StringUtils.isEmpty((String)l) ? new Locale("l2") : new Locale(l);
        userCtx.setLocale(locale);
        DataCenterManager dc = new DataCenterManager(userCtx);
        List<DCInfo> dcList = DataAcquisitionUtil.getDCList();
        for (DCInfo di : dcList) {
            if (!dataCenter.equals(di.getNumber())) continue;
            context.setAIS(dataCenter);
            String clientHostIP = "127.0.0.1";
            context.setClientHostIP(clientHostIP);
            context.setClientHostName(clientHostIP);
            context.setLocale(locale);
            context.setUserName("administrator");
        }
        return context;
    }

    public static Timestamp getTime(Date date) {
        if (date == null) {
            date = new Date();
        }
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        if (d.get(11) == 0) {
            d.add(5, -1);
            d.set(10, 23);
            d.set(12, 59);
            d.set(13, 0);
            d.set(14, 0);
        } else {
            d.set(12, 0);
            d.set(13, 0);
            d.set(14, 0);
        }
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static int getSizeByType(int type, Date start, Date end) throws ParseException {
        if (type == 0) {
            return 24;
        }
        if (type == 1) {
            return DAQDateUtil.getDate(start, end);
        }
        if (type == 2) {
            return DAQDateUtil.getWEEK(start, end);
        }
        if (type == 3) {
            return DAQDateUtil.getMonth(start, end);
        }
        return 0;
    }

    public static int dataDistribution(int type, Date nowTime, Date beginTime) throws ParseException {
        if (type == 0) {
            return DAQDateUtil.getHour(nowTime) - 1;
        }
        if (type == 1) {
            return DAQDateUtil.getDate(beginTime, nowTime) - 1;
        }
        if (type == 2) {
            return DAQDateUtil.getWEEK(beginTime, nowTime) - 1;
        }
        if (type == 3) {
            return DAQDateUtil.getMonth(beginTime, nowTime) - 1;
        }
        return 0;
    }

    public static String aryToStr(List idList, boolean isPs) {
        if (idList == null || idList.isEmpty()) {
            return "''";
        }
        StringBuilder receivers = new StringBuilder();
        if (isPs) {
            for (int i = 0; i < idList.size(); ++i) {
                receivers.append("?,");
            }
        } else {
            for (int i = 0; i < idList.size(); ++i) {
                receivers.append("'").append(idList.get(i).toString()).append("',");
            }
        }
        receivers.deleteCharAt(receivers.length() - 1);
        return receivers.toString();
    }

    public static Date initTime(Date time, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(11, hour);
        calendar.set(12, 1);
        return calendar.getTime();
    }

    public static Date initBeginTime(Date beginTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(beginTime);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 1);
        return calendar.getTime();
    }

    public static Date initEndTime(Date beginTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(beginTime);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    private static List<DCInfo> getDCList() {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcList;
    }
}

