/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.datatrans;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserDataTransferInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.helper.OrgRangeAppHelper;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DataTransferHelper {
    private static Logger logger = Logger.getLogger(DataTransferHelper.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String rangeBosType = new OrgRangeInfo().getBOSType().toString();
    private static final String sqlSentence4CopyOrgRange = "insert into t_pm_orgrange(FID,FUserID,FOrgID,FType) values(newbosid('" + rangeBosType + "'),?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyUserData(UserDataTransferInfo info, Context ctx) throws BOSException, EASBizException {
        IObjectPK logPK;
        StringBuffer retPompStr;
        block22: {
            boolean check = true;
            LowTimeHelper lowHelper = new LowTimeHelper();
            retPompStr = new StringBuffer("");
            UserInfo sourceUserInfo = info.getSourceUserInfo();
            StringBuffer detial = new StringBuffer();
            boolean isCpPerm = info.isCpPerm();
            boolean isCpAdminOrgRange = info.isCpAdminOrgRange();
            boolean isCpBizOrgRange = info.isCpBizOrgRange();
            boolean isCpCuOrgRange = info.isCpCuOrgRange() && UserType.SYSTEM.equals((Object)sourceUserInfo.getType());
            boolean isBizAdmin = info.isCpCuOrgRange() && sourceUserInfo.isBizAdmin();
            String param = ParamManager.getParamValue((Context)ctx, null, (String)"canCopyUserPerm");
            if (isCpPerm) {
                int maxPermNum = 0;
                if (!StringUtils.isEmpty((String)param)) {
                    maxPermNum = Integer.parseInt(param);
                }
                if (maxPermNum != 0) {
                    String sql = "select count(1) countNum from T_PM_UserOrgPerm where FOWNER = ?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sourceUserInfo.getId().toString()});
                    int count = 0;
                    try {
                        if (rs.next()) {
                            count = rs.getInt("countNum");
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    if (count > maxPermNum) {
                        throw new PermissionServiceException(EASCommonResource.getString((String)RESOURCE, (String)"srcUserPerm", (Locale)ctx.getLocale()) + maxPermNum + EASCommonResource.getString((String)RESOURCE, (String)"canNotCopy", (Locale)ctx.getLocale()));
                    }
                }
                detial.append(EASCommonResource.getString((String)RESOURCE, (String)"copyAssignedPerm", (Locale)ctx.getLocale()));
            }
            if (isCpAdminOrgRange) {
                detial.append(EASCommonResource.getString((String)RESOURCE, (String)"copyAdminRange", (Locale)ctx.getLocale()));
            }
            if (isCpBizOrgRange) {
                detial.append(EASCommonResource.getString((String)RESOURCE, (String)"copyBizRange", (Locale)ctx.getLocale()));
            }
            if (isCpCuOrgRange || isBizAdmin) {
                detial.append(EASCommonResource.getString((String)RESOURCE, (String)"copyCUOrGoveRange", (Locale)ctx.getLocale()));
            }
            IUser userinterface = DataTransferHelper.getUserInteface(ctx);
            sourceUserInfo = userinterface.getUserInfo((IObjectPK)new ObjectUuidPK(sourceUserInfo.getId().toString()), DataTransferHelper.getUserSelectorCollection());
            lowHelper.printTime2Last("sourceUserInfo");
            UserInfo tgtUserInfo = null;
            if (info.isAddUser()) {
                tgtUserInfo = new UserInfo();
                DataTransferHelper.copyUserBasicInfo(sourceUserInfo, tgtUserInfo, info, ctx);
            } else {
                tgtUserInfo = info.getTgtUserInfo();
            }
            detial.append(EASCommonResource.getString((String)RESOURCE, (String)"srcUser", (Locale)ctx.getLocale()) + "\uff1a" + sourceUserInfo.getNumber() + "(" + sourceUserInfo.getName() + ")");
            detial.append("  " + EASCommonResource.getString((String)RESOURCE, (String)"targetUser", (Locale)ctx.getLocale()) + "\uff1a" + tgtUserInfo.getNumber() + "(" + tgtUserInfo.getName() + ")");
            logPK = LogUtil.beginLog((Context)ctx, (String)EASCommonResource.getString((String)RESOURCE, (String)"permCopy", (Locale)ctx.getLocale()), (BOSObjectType)BOSObjectType.create((String)"14E71B8E"), (IObjectPK)new ObjectUuidPK(sourceUserInfo.getId()), (String)detial.toString());
            lowHelper.printTime2Last("copyUserBasicInfo");
            boolean mutexResult = false;
            IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                mutexResult = mutexServiceControl.requestObjIDForUpdate("copyUserData" + tgtUserInfo.getId().toString());
                if (mutexResult) {
                    if (info.isCpAdminOrgRange()) {
                        DataTransferHelper.copyUserAdminOrgRange(sourceUserInfo, tgtUserInfo, ctx, retPompStr);
                        lowHelper.printTime2Last("copyUserAdminOrgRange");
                    }
                    if (info.isCpBizOrgRange()) {
                        DataTransferHelper.copyUserBizOrgRange(sourceUserInfo, tgtUserInfo, ctx, retPompStr);
                        lowHelper.printTime2Last("copyUserBizOrgRange");
                    }
                    if (info.isCpCuOrgRange() && UserType.SYSTEM.equals((Object)sourceUserInfo.getType())) {
                        DataTransferHelper.copyUserBizOrgRange(sourceUserInfo, tgtUserInfo, ctx, retPompStr);
                        lowHelper.printTime2Last("copyUserCUOrgRange");
                    }
                    if (info.isCpCuOrgRange() && sourceUserInfo.isBizAdmin()) {
                        DataTransferHelper.copyUserCUOrgRange(sourceUserInfo, tgtUserInfo, ctx, retPompStr);
                        lowHelper.printTime2Last("copyUserCUOrgRange");
                    }
                    if (info.isCpPerm()) {
                        DataTransferHelper.copyUserPerm(sourceUserInfo, tgtUserInfo, info, ctx, retPompStr);
                        DataTransferHelper.handleCallBack(ctx, (IObjectPK)new ObjectUuidPK(tgtUserInfo.getId()));
                        lowHelper.printTime2Last("copyUserPerm");
                    }
                    break block22;
                }
                throw new PermissionServiceException(EASCommonResource.getString((String)RESOURCE, (String)"targetUserCoping", (Locale)ctx.getLocale()));
            }
            finally {
                if (mutexResult) {
                    mutexServiceControl.releaseObjIDForUpdate("copyUserData" + tgtUserInfo.getId().toString());
                }
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return retPompStr.toString();
    }

    private static IUser getUserInteface(Context ctx) throws BOSException {
        return UserFactory.getLocalInstance(ctx);
    }

    private static SelectorItemCollection getUserSelectorCollection() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("type"));
        coll.add(new SelectorItemInfo("security"));
        coll.add(new SelectorItemInfo("bizAdmin"));
        coll.add(new SelectorItemInfo("defLocale"));
        coll.add(new SelectorItemInfo("defOrgUnit"));
        return coll;
    }

    public static UserInfo copyUserBasicInfo(UserInfo sourceUserInfo, UserInfo tgtUserInfo, UserDataTransferInfo info, Context ctx) throws BOSException, EASBizException {
        tgtUserInfo.setNumber(info.getAddUserAccount());
        UserType type = sourceUserInfo.getType();
        tgtUserInfo.setType(type);
        if (UserType.SYSTEM.equals((Object)type) || UserType.OTHER.equals((Object)type)) {
            HashMap userNames = info.getUserStrNameHash();
            for (Object key : userNames.keySet()) {
                tgtUserInfo.setName((String)userNames.get(key), (Locale)key);
            }
        } else {
            IObjectValue objectValue = (IObjectValue)info.getUserRealName();
            if (UserType.PERSON.equals((Object)type)) {
                tgtUserInfo.setPerson((PersonInfo)objectValue);
            } else if (UserType.CUSTOMER.equals((Object)type)) {
                tgtUserInfo.setCustomerID(objectValue.get("id").toString());
            } else if (UserType.SUPPLIER.equals((Object)type)) {
                tgtUserInfo.setSupplierID(objectValue.get("id").toString());
            } else {
                tgtUserInfo.setReferId(objectValue.get("id").toString());
            }
            DataTransferHelper.copyMultiLanName(ctx, objectValue, (IObjectValue)tgtUserInfo);
        }
        if (PermissionCommonUtil.isAuthenAddnewUserEnabled(ctx)) {
            tgtUserInfo.setIsRegister(false);
        } else {
            tgtUserInfo.setIsRegister(true);
        }
        tgtUserInfo.setCell(info.getCell());
        tgtUserInfo.setEmail(info.getEmail());
        tgtUserInfo.setPassword(info.getUserPsd());
        tgtUserInfo.setSecurity(sourceUserInfo.getSecurity());
        tgtUserInfo.setBizAdmin(sourceUserInfo.isBizAdmin());
        tgtUserInfo.setDefLocale(sourceUserInfo.getDefLocale());
        tgtUserInfo.setDefaultLocale(sourceUserInfo.getDefaultLocale());
        tgtUserInfo.setDefOrgUnit(sourceUserInfo.getDefOrgUnit());
        tgtUserInfo.setChangedPW(false);
        tgtUserInfo.setCU(sourceUserInfo.getCU());
        tgtUserInfo.setEffectiveDate(new Timestamp(new Date().getTime()));
        tgtUserInfo.setPWEffectiveDate(new Date());
        tgtUserInfo.setInvalidationDate(new Timestamp(DataTransferHelper.getDefaultInvalidDate().getTimeInMillis()));
        tgtUserInfo.setIsDelete(false);
        tgtUserInfo.setIsForbidden(false);
        tgtUserInfo.setIsLocked(false);
        IUser userinterface = DataTransferHelper.getUserInteface(ctx);
        IObjectPK itgtPK = userinterface.addnew((CoreBaseInfo)tgtUserInfo);
        if (UserType.PERSON.equals((Object)type)) {
            IOrgRangeIncludeSubOrg iOrgRangeIncSubOrg = OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx);
            ArrayList<String> userIdList = new ArrayList<String>();
            userIdList.add(itgtPK.toString());
            iOrgRangeIncSubOrg.updateAdminOrgRange(userIdList);
        }
        return tgtUserInfo;
    }

    public static void copyMultiLanName(Context ctx, IObjectValue source, IObjectValue target) {
        Locale[] allLocales = MultiLangHelper.getDefinedLocales(ctx);
        String key = "name";
        for (int i = 0; i < allLocales.length; ++i) {
            Locale l = allLocales[i];
            target.put(key, source.get(key, l), l);
        }
    }

    private static Calendar getDefaultInvalidDate() {
        Calendar pwInvaildDate = Calendar.getInstance();
        pwInvaildDate.set(2099, 11, 31, 0, 0, 0);
        return pwInvaildDate;
    }

    public static void copyUserAdminOrgRange(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, StringBuffer retPompStr) throws BOSException, EASBizException {
        DataTransferHelper.deleteExistOrgRange(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.ADMIN_ORG_TYPE);
        DataTransferHelper.executeSql(ctx, sqlSentence4CopyOrgRange, DataTransferHelper.getCopyOrgRangeSql(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.ADMIN_ORG_TYPE, retPompStr));
        DataTransferHelper.copyOrgRangeIncludeSubOrg(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.ADMIN_ORG_TYPE);
    }

    public static void copyUserCUOrgRange(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, StringBuffer retPompStr) throws BOSException, EASBizException {
        DataTransferHelper.deleteExistOrgRange(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.MANAGE_ORG_TYPE);
        DataTransferHelper.executeSql(ctx, sqlSentence4CopyOrgRange, DataTransferHelper.getCopyOrgRangeSql(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.MANAGE_ORG_TYPE, retPompStr));
        DataTransferHelper.copyOrgRangeIncludeSubOrg(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.MANAGE_ORG_TYPE);
    }

    public static void copyUserBizOrgRange(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, StringBuffer retPompStr) throws BOSException, EASBizException {
        DataTransferHelper.deleteExistOrgRange(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.BIZ_ORG_TYPE);
        DataTransferHelper.executeSql(ctx, sqlSentence4CopyOrgRange, DataTransferHelper.getCopyOrgRangeSql(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.BIZ_ORG_TYPE, retPompStr));
        DataTransferHelper.copyOrgRangeIncludeSubOrg(sourceUserInfo, tgtUserInfo, ctx, OrgRangeType.BIZ_ORG_TYPE);
    }

    private static void executeSql(Context ctx, String sql, List params) throws BOSException {
        if (sql == null || sql.length() == 0 || params == null) {
            logger.info((Object)"sql is null ,return ");
            return;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql);
            int argi = 0;
            for (int sqli = 0; sqli < params.size(); ++sqli) {
                Object[] args = (Object[])params.get(sqli);
                if (sqli != 0 && argi != args.length) {
                    logger.error((Object)"params amount does not match during executing SQL batch in Class");
                }
                for (argi = 0; argi < args.length; ++argi) {
                    statement.setObject(argi + 1, args[argi]);
                }
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private static void copyOrgRangeIncludeSubOrg(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sourceId = sourceUserInfo.getId().toString();
        ObjectUuidPK currentUserPK = new ObjectUuidPK(currentUserInfo.getId());
        ObjectUuidPK tgtUserPK = new ObjectUuidPK(tgtUserInfo.getId());
        String managedCUIDs = PermissionRangeHelper.getManagedCuIdSQL(ctx, (IObjectPK)currentUserPK);
        StringBuffer sql = new StringBuffer();
        String bosType = new OrgRangeIncludeSubOrgInfo().getBOSType().toString();
        sql.append("insert into t_pm_orgrangeincludesuborg(fid,forgid,fuserid,ftype,fisincludesuborg) ").append(" select newbosid('").append(bosType).append("'),forgid,'").append(tgtUserPK.toString()).append("',ftype,fisincludesuborg from t_pm_orgrangeincludesuborg ").append(" where fuserID='").append(sourceId).append("'  and ftype= ").append(orgRangeType.getValue()).append(" and forgID not in ( select distinct(osb.forgid) from t_pm_orgrangeincludesuborg osb where osb.fuserid='").append(tgtUserPK.toString()).append("' and osb.ftype=").append(orgRangeType.getValue()).append(")");
        if (!Administrator.isSuperAdmin((IObjectPK)currentUserPK)) {
            sql.append(" and forgid in (select fid from t_org_baseunit where FControlUnitID in (").append(managedCUIDs).append(")) ");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
        Collection orgLongNumberCol = OrgRangeAppHelper.getIncludeSubOrgLongNumList(ctx, (IObjectPK)tgtUserPK, orgRangeType);
        OrgRangeAppHelper.deleteSubOrgFromOrgRangeIncludeSub(ctx, (IObjectPK)tgtUserPK, orgRangeType, orgLongNumberCol);
    }

    private static void deleteExistOrgRange(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, OrgRangeType orType) throws EASBizException, BOSException {
        Integer type = new Integer(orType.getValue());
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK currentUserPK = new ObjectUuidPK(currentUserInfo.getId());
        String sourceId = sourceUserInfo.getId().toString();
        String tgtId = tgtUserInfo.getId().toString();
        String managedCUIDs = PermissionRangeHelper.getManagedCuIdSQL(ctx, (IObjectPK)currentUserPK);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_PM_OrgRange where FUserID = '").append(tgtId).append("' and FType=").append(type).append(" and FOrgID in (select  distinct FOrgID from T_PM_OrgRange where  FUserID = '").append(sourceId).append("' and FType = ").append(type).append(") ");
        if (!Administrator.isSuperAdmin((IObjectPK)currentUserPK)) {
            sql.append(" and FOrgID in (select fid from t_org_baseunit where FControlUnitID in (").append(managedCUIDs).append(")) ");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static List getCopyOrgRangeSql(UserInfo sourceUserInfo, UserInfo tgtUserInfo, Context ctx, OrgRangeType orgRangeType, StringBuffer retPompStr) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sourceId = sourceUserInfo.getId().toString();
        ObjectUuidPK currentUserPK = new ObjectUuidPK(currentUserInfo.getId());
        String managedCUIDs = PermissionRangeHelper.getManagedCuIdSQL(ctx, (IObjectPK)currentUserPK);
        StringBuffer sql = new StringBuffer();
        sql.append("select  distinct FOrgID,FType,BASEUNIT.fnumber fnumber from T_PM_OrgRange ORGRANGE");
        sql.append(" left join T_ORG_BASEUNIT BASEUNIT ON ORGRANGE.FOrgID = BASEUNIT.FID ");
        sql.append(" where ORGRANGE.FUserID = '").append(sourceId).append("' and FType = ").append(orgRangeType.getValue()).append(" ");
        if (!Administrator.isSuperAdmin((IObjectPK)currentUserPK)) {
            sql.append(" and FOrgID in (select fid from t_org_baseunit where FControlUnitID in (").append(managedCUIDs).append(")) ");
        }
        if (20 == orgRangeType.getValue()) {
            retPompStr.append("\n" + PermissionResUtil.getResource(ctx, "res_6"));
        } else if (10 == orgRangeType.getValue()) {
            retPompStr.append("\n" + PermissionResUtil.getResource(ctx, "res_7"));
        } else if (30 == orgRangeType.getValue()) {
            retPompStr.append("\n" + PermissionResUtil.getResource(ctx, "res_8"));
        }
        ArrayList<Object[]> sqlList = new ArrayList<Object[]>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                sqlList.add(DataTransferHelper.getCopyOrgRangeSql(tgtUserInfo, rowSet.getString("FOrgID"), OrgRangeType.getEnum(rowSet.getInt("FType"))));
                retPompStr.append(rowSet.getString("fnumber")).append(",");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"copy org range error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return sqlList;
    }

    private static String[] transAry2StrAry(List strList) {
        if (strList.isEmpty()) {
            return null;
        }
        String[] retSql = new String[strList.size()];
        for (int i = 0; i < strList.size(); ++i) {
            retSql[i] = (String)strList.get(i);
        }
        return retSql;
    }

    private static String getCopyOrgRangeSql(Context ctx, UserInfo sourceUserInfo, UserInfo tgtUserInfo, String orgId, OrgRangeType orType, String tableName, BOSObjectType bosType) {
        Integer type = new Integer(orType.getValue());
        String tgtId = tgtUserInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_pm_orgrange (FID,FUserID,FOrgID,FType) select  newbosid('" + bosType.toString() + "'),'").append(tgtId).append("','").append(orgId).append("',").append(type);
        return sql.toString();
    }

    private static Object[] getCopyOrgRangeSql(UserInfo tgtUserInfo, String orgId, OrgRangeType orType) {
        Integer type = new Integer(orType.getValue());
        String tgtId = tgtUserInfo.getId().toString();
        return new Object[]{tgtId, orgId, type};
    }

    public static void copyUserPerm(UserInfo sourceUserInfo, UserInfo tgtUserInfo, UserDataTransferInfo info, Context ctx, StringBuffer retPompStr) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String tgtUserId = tgtUserInfo.getId().toString();
        String sourceUserId = sourceUserInfo.getId().toString();
        LowTimeHelper lowHelper = new LowTimeHelper();
        boolean isEnablePermAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        DataTransferHelper.copyUserPerm(ctx, sourceUserId, tgtUserInfo, 10, currentUserInfo.isBizAdmin(), retPompStr, isEnablePermAuthen);
        lowHelper.printTime2Last("copyUserPerm");
        DataTransferHelper.copyRolePerm(ctx, sourceUserId, tgtUserInfo, 10, currentUserInfo.isBizAdmin(), retPompStr, isEnablePermAuthen);
        lowHelper.printTime2Last("copyRolePerm");
        GroupLicenseUseInfoUtil.rebuildUserLicenseGroupInfo(ctx, tgtUserInfo.getId().toString());
    }

    private static void copyUserPerm(Context ctx, String sourceUserId, UserInfo tgtUserInfo, int type, boolean isBizAdmin, StringBuffer retPompStr, boolean isEnablePermAuthen) throws BOSException, EASBizException {
        LowTimeHelper lowHelper = new LowTimeHelper();
        String tgtUserId = tgtUserInfo.getId().toString();
        ArrayList<String[]> list = new ArrayList<String[]>();
        String permChangeId = null;
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String currentUserId = currentUserInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FOrgID as FOrgID,BASEUNIT.fnumber as fnumber from T_PM_OrgRange range ");
        sql.append(" left join T_ORG_BASEUNIT BASEUNIT ON range.FOrgID = BASEUNIT.FID ");
        sql.append("where FUserID ='").append(sourceUserId).append("' and FOrgID in (select distinct FOrgID from T_PM_OrgRange range where FUserID ='").append(tgtUserId).append("' and ftype = ").append(type).append(")");
        if (isBizAdmin) {
            sql.append("and FOrgID in (select distinct FOrgID from T_PM_OrgRange range where FUserID ='").append(currentUserId).append("' and ftype = ").append(type).append(")");
        }
        retPompStr.append("\n" + PermissionResUtil.getResource(ctx, "res_9"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                list.add(new String[]{rs.getString("FOrgID"), rs.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (isEnablePermAuthen) {
            BOSObjectType bosObjectType = new BOSObjectType("AB724BE5");
            permChangeId = BOSUuid.create((BOSObjectType)bosObjectType).toString();
            String strSql = "INSERT INTO t_pm_permChangeRecord(FID,FAssignerID,FOperType,FAssignedObjectNumber,FAssignedObjectName,FChangeTime,FASSIGNEDOBJECTTYPE) VALUES(?,?,?,?,?,NOW(),?)";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])new Object[]{permChangeId, currentUserId, "10", tgtUserInfo.getNumber(), tgtUserInfo.getName(), "\u7528\u6237"});
            strSql = "select top 1 fpermitemid from t_pm_userorgperm where exists(select 1 from  T_PM_PermAuthentor where t_pm_userorgperm.fpermitemid=T_PM_PermAuthentor.fpermitemid) and fowner=?";
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])new Object[]{sourceUserId});
            try {
                if (row.next()) {
                    strSql = "INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus,FCU)  values('00000000-0000-0000-0000-00000000000113B7DE7F',newbosid('8F704622'),'" + permChangeId + "','" + "10" + "','" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "')";
                    DbUtil.execute((Context)ctx, (String)strSql.toString());
                } else {
                    isEnablePermAuthen = false;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        lowHelper.printTime2Last("query which org");
        Connection conn = DataTransferHelper.getConnection(ctx);
        sql.setLength(0);
        Statement st = null;
        try {
            st = conn.createStatement();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String orgId = ((String[])list.get(i))[0];
                sql.setLength(0);
                sql.append("INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr,FCtrlUnitID)  ").append("select  newbosid('896DC075'),'").append(tgtUserId).append("','").append(orgId).append("',").append("FPermItemID, FPermType, FRuleStructure, FRuleExpr,FCtrlUnitID from T_PM_UserOrgPerm  ").append(" where  FOwner='").append(sourceUserId).append("' and FOrgID='").append(orgId).append("' and (select count(FID) from T_PM_UserOrgPerm up2 where FOwner='").append(tgtUserId).append("' and FOrgID='").append(orgId).append("' and T_PM_UserOrgPerm.FPermItemID=up2.FPermItemID and T_PM_UserOrgPerm.FPermType=up2.FPermType )<=0");
                if (isBizAdmin) {
                    sql.append(" and (select count(FID) from T_PM_UserOrgPerm up3 where FOwner='").append(currentUserId).append("' and FPermType=").append(30).append(" and FOrgID='").append(orgId).append("' and T_PM_UserOrgPerm.FPermItemID=up3.FPermItemID ) >0 ");
                }
                if (isEnablePermAuthen) {
                    sql.append(" and not exists (select 1 from T_PM_PermAuthentor where T_PM_UserOrgPerm.fpermitemid = T_PM_PermAuthentor.fpermitemid)");
                }
                st.addBatch(sql.toString());
                if (!isEnablePermAuthen) continue;
                String strSql = "INSERT INTO T_PM_UserOrgPermChange (FID,FUserOrgPerm,FPermChangeID,FOwnerid, FOrgID, FPermItemID, FASSIGNTYPE,FPermType, FRuleStructure,FRuleExpr, FCtrlUnitID) SELECT newbosid('5592D485'),newbosid('896DC075'),'" + permChangeId + "','" + tgtUserId + "','" + orgId + "',FpermitemId,'" + "10" + "',FpermType,FRuleStructure,FRuleExpr,FCtrlUnitID from T_PM_UserOrgPerm where exists (select 1 from T_PM_PermAuthentor pa  where pa.fpermitemid =  T_PM_UserOrgPerm.FpermitemId) and forgid='" + orgId + "' and fowner='" + sourceUserId + "'";
                DbUtil.execute((Context)ctx, (String)strSql);
            }
            int[] counts = st.executeBatch();
            retPompStr.append(DataTransferHelper.getCopyOrgNumbers(counts, list));
            if (DataTransferHelper.sum(counts) == 0) {
                if (isEnablePermAuthen) {
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"noIntersectionButNeedAuthen", (Locale)ctx.getLocale()));
                } else {
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"no_intersection", (Locale)ctx.getLocale()));
                }
            }
            lowHelper.printTime2Last("insert new org");
            StringBuffer existSql = new StringBuffer();
            if (isBizAdmin) {
                Statement st1 = conn.createStatement();
                existSql.append("select 1 from T_PM_UserOrgPerm where FOwner='").append(sourceUserId).append("' and FOrgId || FPermItemID not in ( select FOrgId || FPermItemID from T_PM_UserOrgPerm where FOwner='").append(currentUserId).append("' and fpermtype=").append(30).append(")");
                ResultSet set = st1.executeQuery(existSql.toString());
                while (set.next()) {
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"source_target_different", (Locale)ctx.getLocale()));
                }
            }
            String noOrgPermSql = "INSERT INTO T_PM_UserOrgPerm (FID, FOwner, FOrgID, FPermItemID, FPermType, FRuleStructure, FRuleExpr,FCtrlUnitID) SELECT newbosid('896DC075'), '" + tgtUserId + "',FOrgId,FPermItemID, FPermType, FRuleStructure, FRuleExpr,FCtrlUnitID  FROM t_pm_userorgperm where FOWNER = '" + sourceUserId + "'  and FORGID = '11111111-1111-1111-1111-111111111111CCE7AED4'  and FPERMITEMID not in (select FPERMITEMID from t_pm_userorgperm where FOWNER = '" + tgtUserId + "' and FORGID = '11111111-1111-1111-1111-111111111111CCE7AED4' )";
            DbUtil.execute((Context)ctx, (String)noOrgPermSql);
        }
        catch (SQLException e) {
            logger.error((Object)"copy user perm error", (Throwable)e);
            throw new UserException(UserException.COPY_USER, e);
        }
        finally {
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
    }

    private static String getCopyOrgNumbers(int[] counts, List list) {
        StringBuffer ret = new StringBuffer();
        if (counts.length == list.size()) {
            int length = counts.length;
            for (int i = 0; i < length; ++i) {
                if (counts[i] <= 0) continue;
                ret.append(((String[])list.get(i))[1]).append(",");
            }
        }
        return ret.toString();
    }

    private static int sum(int[] intArray) {
        if (intArray == null || intArray.length == 0) {
            return 0;
        }
        int ret = 0;
        int length = intArray.length;
        for (int i = 0; i < length; ++i) {
            ret += intArray[i];
        }
        return ret;
    }

    private static void copyRolePerm(Context ctx, String sourceUserId, UserInfo tgtUserInfo, int type, boolean isBizAdmin, StringBuffer retPompStr, boolean isEnablePermAuthen) throws BOSException, EASBizException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String tgtUserId = tgtUserInfo.getId().toString();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String currentUserId = currentUserInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FOrgID as FOrgID,BASEUNIT.fnumber as fnumber from T_PM_UserRoleOrg role ");
        sql.append(" left join T_ORG_BASEUNIT BASEUNIT ON role.FOrgID = BASEUNIT.FID ");
        sql.append("where FUserID ='").append(sourceUserId).append("' and FOrgID in (select distinct FOrgID from T_PM_OrgRange range where FUserID ='").append(tgtUserId).append("' and ftype = ").append(type).append(")");
        if (isBizAdmin) {
            sql.append(" and FOrgID in (select distinct FOrgID from T_PM_OrgRange range where FUserID ='").append(currentUserId).append("' and ftype = ").append(type).append(")");
        }
        retPompStr.append("\n\n" + PermissionResUtil.getResource(ctx, "res_10"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                list.add(new String[]{rs.getString("FOrgID"), rs.getString("FNumber")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (isEnablePermAuthen) {
            String strSql = "select top 1 fuserid from T_PM_UserRoleOrg where exists(select 1 from  T_PM_RolePerm where T_PM_UserRoleOrg.froleid = T_PM_RolePerm.froleid and fpermitemid in (select fpermitemid from T_PM_PermAuthentor)) and fuserid=?";
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])new Object[]{sourceUserId});
            try {
                if (row.next()) {
                    DataTransferHelper.copyRoleNeedAuthen(ctx, list, sourceUserId, tgtUserInfo);
                } else {
                    isEnablePermAuthen = false;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        sql.setLength(0);
        Connection conn = null;
        Statement st = null;
        try {
            conn = DataTransferHelper.getConnection(ctx);
            st = conn.createStatement();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String orgId = ((String[])list.get(i))[0];
                sql.setLength(0);
                sql.append("INSERT INTO T_PM_UserRoleOrg (FUserID, FOrgID, FRoleID) ").append(" select '").append(tgtUserId).append("','").append(orgId).append("',FRoleID from T_PM_UserRoleOrg  ").append(" where FUserID = '").append(sourceUserId).append("' and FOrgID = '").append(orgId).append("' and  (select count(*) from T_PM_UserRoleOrg uro2 where ").append("FUserID='").append(tgtUserId).append("' and FOrgID='").append(orgId).append("' and uro2.FRoleID=T_PM_UserRoleOrg.FRoleID)<=0");
                if (isBizAdmin) {
                    sql.append(" and (select count(*) from T_PM_GrantUserRoleOrg uro3 where FUserID='").append(currentUserId).append("' and FOrgID='").append(orgId).append("' and T_PM_UserRoleOrg.FRoleID=uro3.FRoleID)>0");
                }
                if (isEnablePermAuthen) {
                    sql.append(" and not exists (select 1 from  T_PM_RolePerm where T_PM_UserRoleOrg.froleid = T_PM_RolePerm.froleid and fpermitemid in (select fpermitemid from T_PM_PermAuthentor)) ");
                }
                st.addBatch(sql.toString());
            }
            int[] counts = st.executeBatch();
            retPompStr.append(DataTransferHelper.getCopyOrgNumbers(counts, list));
            if (DataTransferHelper.sum(counts) == 0) {
                if (isEnablePermAuthen) {
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"noIntersectionButNeedAuthen", (Locale)ctx.getLocale()));
                } else {
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"no_intersection", (Locale)ctx.getLocale()));
                }
            }
            if (isBizAdmin) {
                StringBuffer existSql = new StringBuffer();
                Statement st1 = conn.createStatement();
                existSql.append("select count(*) c from T_PM_UserRoleOrg where FUserID='").append(sourceUserId).append("' and FOrgId || FRoleID not in ( select FOrgId || FRoleID from T_PM_GrantUserRoleOrg where FUserID='").append(currentUserId).append("'").append(")");
                ResultSet set = st1.executeQuery(existSql.toString());
                while (set.next()) {
                    int count = set.getInt(1);
                    if (count <= 0) continue;
                    retPompStr.append("\n").append(EASCommonResource.getString((String)RESOURCE, (String)"source_target_different", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"copy user role error", (Throwable)e);
                throw new UserException(UserException.COPY_USER, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private static void copyRoleNeedAuthen(Context ctx, List list, String sourceUserId, UserInfo tgtUserInfo) throws BOSException, UserException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String currentUserId = currentUserInfo.getId().toString();
        String tgtUserId = tgtUserInfo.getId().toString();
        String permChangeId = null;
        Connection conn = null;
        Statement st = null;
        try {
            conn = DataTransferHelper.getConnection(ctx);
            st = conn.createStatement();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer strSql = new StringBuffer();
                String orgId = ((String[])list.get(i))[0];
                strSql.append(" select FRoleID from T_PM_UserRoleOrg  ").append(" where FUserID = '").append(sourceUserId).append("' and FOrgID = '").append(orgId).append("' and  (select count(*) from T_PM_UserRoleOrg uro2 where ").append("FUserID='").append(tgtUserId).append("' and FOrgID='").append(orgId).append("' and uro2.FRoleID=T_PM_UserRoleOrg.FRoleID)<=0");
                ResultSet set = st.executeQuery(strSql.toString());
                while (set.next()) {
                    BOSObjectType bosObjectType = new BOSObjectType("AB724BE5");
                    permChangeId = BOSUuid.create((BOSObjectType)bosObjectType).toString();
                    String inPermChange = "INSERT INTO t_pm_permChangeRecord(FID,FAssignerID,FOperType,FAssignedObjectNumber,FAssignedObjectName,FChangeTime,FASSIGNEDOBJECTTYPE)  VALUES(?,?,?,?,?,NOW(),?)";
                    DbUtil.execute((Context)ctx, (String)inPermChange, (Object[])new Object[]{permChangeId, currentUserId, "20", tgtUserInfo.getNumber(), tgtUserInfo.getName(), "\u7528\u6237"});
                    String inAuthenRecord = "INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus,FCU)  values('00000000-0000-0000-0000-00000000000113B7DE7F',newbosid('8F704622'),'" + permChangeId + "','" + "10" + "','" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "')";
                    DbUtil.execute((Context)ctx, (String)inAuthenRecord.toString());
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("INSERT INTO T_PM_UserRoleOrgChange (FID,FASSIGNTYPE,FUserID, FRoleID,");
                    buffer.append(" FOrgID,FAUTHENSTATUS,FPERMCHANGEID )");
                    buffer.append(" SELECT  newbosid('013DCF9F'),'10','" + tgtUserId + "','" + set.getString("froleid") + "','" + orgId + "',");
                    buffer.append(" '10','" + permChangeId + "' ");
                    DbUtil.execute((Context)ctx, (String)buffer.toString());
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"copy user role error", (Throwable)e);
                throw new UserException(UserException.COPY_USER, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private static void handleCallBack(Context ctx, IObjectPK targetUserPK) throws EASBizException, BOSException {
        PermissionChangeHelper helper = new PermissionChangeHelper();
        helper.setUserPK(targetUserPK);
        helper.exceChange(ctx);
    }
}

