/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OrgRangeAppHelper {
    private static final Logger logger = Logger.getLogger(OrgRangeAppHelper.class);

    public static void deleteSubOrgFromOrgRangeIncludeSub(Context ctx, OrgRangeIncludeSubOrgInfo orgRangeIncludeSubOrgInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(orgRangeIncludeSubOrgInfo.getUser().getId());
        OrgRangeType type = orgRangeIncludeSubOrgInfo.getType();
        ArrayList<String> longNumberList = new ArrayList<String>();
        longNumberList.add(orgRangeIncludeSubOrgInfo.getOrg().getLongNumber());
        OrgRangeAppHelper.deleteSubOrgFromOrgRangeIncludeSub(ctx, (IObjectPK)userPK, type, longNumberList);
    }

    public static void deleteSubOrgFromOrgRangeIncludeSub(Context ctx, IObjectPK userPK, OrgRangeType type, Collection longNumberCol) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (longNumberCol == null || longNumberCol.size() < 1) {
            return;
        }
        sql.append("delete from t_pm_orgrangeincludesuborg where fuserid='").append(userPK.toString()).append("' and FType = ").append(type.getValue()).append(" and forgid in (select fid from t_org_admin where ");
        Iterator itr = longNumberCol.iterator();
        while (itr.hasNext()) {
            sql.append(" FLongNumber like '").append(itr.next() + "!%' ");
            if (!itr.hasNext()) continue;
            sql.append(" or ");
        }
        sql.append(")");
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            SQLUtils.execute((Connection)con, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.error((Object)"deleteSubOrgFromOrgRangeIncludeSub error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    public static Collection getIncludeSubOrgLongNumList(Context ctx, IObjectPK userPK, OrgRangeType type) throws BOSException, EASBizException {
        String sql = "select b.flongnumber from t_pm_orgrangeincludesuborg a join t_org_admin b on a.forgid=b.fid where a.fuserid='" + userPK.toString() + "' and a.fisincludesuborg=1 and a.ftype=" + type.getValue();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> longNumSet = new HashSet<String>();
        try {
            while (rs.next()) {
                String longNumber = rs.getString("flongnumber");
                longNumSet.add(longNumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getIncludeSubOrgLongNumList:" + e));
            throw new BOSException((Throwable)e);
        }
        return longNumSet;
    }

    public static void deleteDuplicateOrgRange(Context ctx) throws BOSException, EASBizException {
        ObjectUuidPK currentUserPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        OrgRangeAppHelper.deleteDuplicateOrgRange(ctx, (IObjectPK)currentUserPK);
    }

    public static void deleteDuplicateOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        if (OrgRangeAppHelper.hasDuplicateOrgRange(ctx, userPK, false)) {
            String orgRangeFromSql = " from t_pm_orgrange where fuserid = '" + userPK + "' and fid not in (select max(fid) from t_pm_orgrange group by fuserid,forgid,ftype) and fid not in (select fuserorgrangeid from t_pm_specialdirectorperm)";
            OrgRangeAppHelper.deleteOrgRangeAndLog(ctx, false, orgRangeFromSql);
            String orgRangeDeleteInDirectorFromSql = "  from t_pm_orgrange where fuserid='" + userPK + "' and fid not in (select min(fid) from t_pm_orgrange group by fuserid,forgid,ftype)";
            OrgRangeAppHelper.deleteOrgRangeAndLog(ctx, false, orgRangeDeleteInDirectorFromSql);
        }
        if (OrgRangeAppHelper.hasDuplicateOrgRange(ctx, userPK, true)) {
            String orgRangeNotIncludeSubOrgFromSql = " from t_pm_orgrangeincludesuborg where fuserid='" + userPK + "' and fid not in (select max(fid) from t_pm_orgrangeincludesuborg group by fuserid,forgid,ftype) and fisincludesuborg=0";
            OrgRangeAppHelper.deleteOrgRangeAndLog(ctx, true, orgRangeNotIncludeSubOrgFromSql);
            String orgRangeIncludeSubOrgFromSql = " from t_pm_orgrangeincludesuborg where fuserid='" + userPK + "' and fid not in (select min(fid) from t_pm_orgrangeincludesuborg group by fuserid,forgid,ftype)";
            OrgRangeAppHelper.deleteOrgRangeAndLog(ctx, true, orgRangeIncludeSubOrgFromSql);
        }
    }

    private static void deleteOrgRangeAndLog(Context ctx, boolean isIncludeSub, String fromSql) throws BOSException, EASBizException {
        ArrayList<String> idCol = new ArrayList<String>();
        BOSObjectType bosType = new OrgRangeInfo().getBOSType();
        if (isIncludeSub) {
            bosType = new OrgRangeIncludeSubOrgInfo().getBOSType();
        }
        LowTimeHelper timer = new LowTimeHelper();
        String sql = "select fid,fuserid,forgid,ftype " + fromSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer deleteDetail = new StringBuffer();
        deleteDetail.append("fuserid-forgid-ftype:");
        try {
            while (rs.next()) {
                String userid = rs.getString("fuserid");
                String orgid = rs.getString("forgid");
                int type = rs.getInt("ftype");
                String id = rs.getString("fid");
                idCol.add(id);
                deleteDetail.append(userid).append("-").append(orgid).append("-").append(String.valueOf(type)).append(",");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getDeletedOrgRangeAndLog", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (idCol.size() > 0) {
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"getDeletedOrgRangeAndLog", (BOSObjectType)bosType, null, (String)deleteDetail.toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        timer.printTime2Last("<<<<<<<<<<<<<<<getDeletedOrgRangeAndLog");
        OrgRangeAppHelper.deleteOrgRange(ctx, isIncludeSub, idCol);
    }

    private static boolean hasDuplicateOrgRange(Context ctx, IObjectPK userPK, boolean isIncludeSub) throws BOSException, EASBizException {
        String table = "t_pm_orgrange";
        if (isIncludeSub) {
            table = "t_pm_orgrangeincludesuborg";
        }
        String countSql = "select count(*) counta from " + table + " where fuserid='" + userPK.toString() + "'";
        String distinceCountSql = "select count(*) countb from (select distinct fuserid,forgid,ftype from " + table + " where fuserid='" + userPK.toString() + "') a";
        IRowSet countSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
        IRowSet distinctCountSet = DbUtil.executeQuery((Context)ctx, (String)distinceCountSql);
        int count = 0;
        int distinctCount = 0;
        try {
            while (countSet.next()) {
                count = countSet.getInt("counta");
            }
            while (distinctCountSet.next()) {
                distinctCount = distinctCountSet.getInt("countb");
            }
            if (count > distinctCount) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("hasDuplicateOrgRange:" + e));
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static void deleteOrgRange(Context ctx, boolean isIncludeSub, Collection idCol) throws BOSException, EASBizException {
        String table = "t_pm_orgrange";
        if (isIncludeSub) {
            table = "t_pm_orgrangeincludesuborg";
        }
        String deleteSql = "delete from " + table + " where fid in (" + ToolUtils.aryToStr(idCol) + ")";
        DbUtil.execute((Context)ctx, (String)deleteSql);
    }

    private static IObjectPK getCurrentUserPK(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return new ObjectUuidPK(userInfo.getId());
    }
}

