/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermChangeTypeEnum;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermitemChangeReportInfo;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.helper.SynchUserHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermChangeReportHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.helper.PermChangeReportHelper");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String PERMITEM_TABLE = "t_pm_permitem";
    private static final String USERORGPERM_TABLE = "t_pm_userorgperm";
    private static final String ROLEPERM_TABLE = "t_pm_roleperm";
    private static final String SPECIALPERM_TABLE = "T_PM_SpecialDataPermEntry";
    private static final String IDSecondAuthorize_TABLE = "T_PM_IDSecondAuthorize";
    private static final String MENU_TABLE = "t_pm_mainmenuitem";
    private static final String PCR_PERMDELETE_CONTENT = "pcr_permdelete_content";
    private static final String PCR_PERMITEMDELETE_REASON = "pcr_permdelete_reason";
    private static final String PCR_PERMTYPECHANGE_REASON = "pcr_permtypechange_reason";
    private static final String PCR_PERMORGRELATIONCHANGE_REASON = "pcr_permorgrelationchange_reason";
    private static final String PCR_RECORDSDELETE_CONTENT = "pcr_recordsdelete_content";
    private static final String PCR_RELATIVEDELETED_REASON = "pcr_relativedeleted_reason";
    private static final String PCR_SOLUTION = "pcr_solution";
    private static Map tableChangeTypeMap = null;
    Context ctx = null;
    Connection con = null;
    String metasPath = null;

    public PermChangeReportHelper(Context ctx) throws BOSException {
        try {
            this.con = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.ctx = ctx;
    }

    private Context getContext() {
        if (this.isFromApp()) {
            return this.ctx;
        }
        SynchUserHelper helper = null;
        try {
            helper = new SynchUserHelper(this.con, this.metasPath);
            Context context = helper.createVirtualConext(this.metasPath);
            return context;
        }
        finally {
            if (helper != null) {
                helper.release();
            }
        }
    }

    private boolean isFromApp() {
        return this.ctx != null;
    }

    public PermChangeReportHelper(Connection con, String metasPath) throws BOSException {
        this.con = con;
        this.metasPath = metasPath;
    }

    private static PermChangeTypeEnum getChangeTypeByTableName(String tableName) {
        if (tableChangeTypeMap == null) {
            tableChangeTypeMap = new HashMap();
            tableChangeTypeMap.put(USERORGPERM_TABLE, PermChangeTypeEnum.USERORGPERM);
            tableChangeTypeMap.put(ROLEPERM_TABLE, PermChangeTypeEnum.ROLEPERM);
            tableChangeTypeMap.put(SPECIALPERM_TABLE, PermChangeTypeEnum.SPECIALPERM);
            tableChangeTypeMap.put(IDSecondAuthorize_TABLE, PermChangeTypeEnum.IDAUTHORIZE);
            tableChangeTypeMap.put(MENU_TABLE, PermChangeTypeEnum.MENUITEM);
            Collection discreteTableCol = PermChangeReportHelper.getDiscreteTables();
            for (String table : discreteTableCol) {
                tableChangeTypeMap.put(table, PermChangeTypeEnum.DISCRETEPERM);
            }
        }
        return (PermChangeTypeEnum)((Object)tableChangeTypeMap.get(tableName));
    }

    private static Set getDeleteNumberPerms(Connection con) throws BOSException, SQLException {
        String sql = "select a.fid,a.fnumber from t_pm_permitem1 a left join t_pm_permitem b on a.fnumber=b.fnumber where b.fid is null";
        IRowSet row = SynchUserHelper.executeQuery(con, sql);
        HashSet<PermItemInfo> deletePermIds = new HashSet<PermItemInfo>();
        while (row.next()) {
            PermItemInfo info = new PermItemInfo();
            String permitemID = row.getString("fid");
            info.setId(BOSUuid.read((String)permitemID));
            info.setNumber(row.getString("fnumber"));
            deletePermIds.add(info);
        }
        return deletePermIds;
    }

    private List getOrgRelationChangedPermsLog() throws BOSException, SQLException {
        String sql = "select a.fid,a.fnumber,a.forgrelation oldOrgRelation,b.forgrelation newOrgRelation  from t_pm_permitem1 a left join t_pm_permitem b on a.fnumber=b.fnumber and a.ftype=b.ftype where a.forgrelation<> b.forgrelation";
        IRowSet row = SynchUserHelper.executeQuery(this.con, sql);
        ArrayList<PermitemChangeReportInfo> changeList = new ArrayList<PermitemChangeReportInfo>();
        while (row.next()) {
            String permitemID = row.getString("fid");
            String content = "[" + permitemID + "," + row.getString("fnumber") + "]";
            String reason = "[" + row.getInt("oldOrgRelation") + "," + row.getInt("newOrgRelation") + "]";
            PermitemChangeReportInfo info = new PermitemChangeReportInfo();
            this.setMultiLangProperty((IObjectValue)info, "content", PCR_PERMDELETE_CONTENT, new String[]{content});
            this.setMultiLangProperty((IObjectValue)info, "reason", PCR_PERMORGRELATIONCHANGE_REASON, new String[]{reason});
            this.setMultiLangProperty((IObjectValue)info, "solution", PCR_SOLUTION, null);
            info.setChangeType(PermChangeTypeEnum.PERMITEM);
            info.setChangedTable(PERMITEM_TABLE);
            info.setPermItemID(permitemID);
            changeList.add(info);
        }
        return changeList;
    }

    private void setMultiLangProperty(IObjectValue info, String property, String key, String[] params) {
        Locale[] locales = MultiLangHelper.getDefinedLocales(this.getContext());
        for (int i = 0; i < locales.length; ++i) {
            String value = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)key, (Locale)locales[i]), params);
            info.put(property, (Object)value, locales[i]);
        }
    }

    private List getTypeChangedPermsLog() throws BOSException, SQLException {
        String sql = "select a.fid,a.fnumber,a.ftype oldType,b.ftype newType from t_pm_permitem1 a left join t_pm_permitem b on a.fnumber=b.fnumber where a.ftype<>b.ftype";
        IRowSet row = SynchUserHelper.executeQuery(this.con, sql);
        ArrayList<PermitemChangeReportInfo> changeList = new ArrayList<PermitemChangeReportInfo>();
        while (row.next()) {
            String permitemID = row.getString("fid");
            PermitemChangeReportInfo info = new PermitemChangeReportInfo();
            String deletedPerms = "[" + permitemID + "," + row.getString("fnumber") + "]";
            this.setMultiLangProperty((IObjectValue)info, "content", PCR_PERMDELETE_CONTENT, new String[]{deletedPerms});
            String reason = "[" + row.getInt("oldType") + "," + row.getInt("newType") + "]";
            this.setMultiLangProperty((IObjectValue)info, "reason", PCR_PERMTYPECHANGE_REASON, new String[]{reason});
            this.setMultiLangProperty((IObjectValue)info, "solution", PCR_SOLUTION, null);
            info.setChangeType(PermChangeTypeEnum.PERMITEM);
            info.setChangedTable(PERMITEM_TABLE);
            info.setPermItemID(permitemID);
            changeList.add(info);
        }
        return changeList;
    }

    private List getDeletedNumberPermsLog() throws BOSException, SQLException {
        Set deletedPermSet = PermChangeReportHelper.getDeleteNumberPerms(this.con);
        ArrayList<PermitemChangeReportInfo> changeList = new ArrayList<PermitemChangeReportInfo>();
        for (PermItemInfo permItem : deletedPermSet) {
            StringBuffer content = new StringBuffer();
            content.append("[").append(permItem.getId()).append(",").append(permItem.getNumber()).append("],");
            PermitemChangeReportInfo info = new PermitemChangeReportInfo();
            this.setMultiLangProperty((IObjectValue)info, "content", PCR_PERMDELETE_CONTENT, new String[]{content.toString()});
            this.setMultiLangProperty((IObjectValue)info, "reason", PCR_PERMITEMDELETE_REASON, null);
            this.setMultiLangProperty((IObjectValue)info, "solution", PCR_SOLUTION, null);
            info.setChangeType(PermChangeTypeEnum.PERMITEM);
            info.setChangedTable(PERMITEM_TABLE);
            info.setPermItemID(permItem.getId().toString());
            changeList.add(info);
        }
        return changeList;
    }

    public void logChangeToReport(Set permitemIdSet) throws BOSException, SQLException {
        ArrayList allLogs = new ArrayList();
        List orgRelationChangeLogList = this.getOrgRelationChangedPermsLog();
        allLogs.addAll(orgRelationChangeLogList);
        List deletedPermChangeLogList = this.getDeletedNumberPermsLog();
        allLogs.addAll(deletedPermChangeLogList);
        String permitemIds = ToolUtils.aryToStr(permitemIdSet);
        try {
            this.saveLogs(allLogs);
        }
        catch (Exception e) {
            logger.info((Object)"Errors happens when saving permission item changed reports logs!");
        }
    }

    public static Collection getDiscreteTables() {
        return ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().values();
    }

    private static String getQuestionMarks(int n) {
        StringBuffer questionMarks = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            questionMarks.append(",?");
        }
        return questionMarks.toString();
    }

    private void saveLogs(Collection allLogs) throws BOSException, SQLException {
        Timestamp now = new Timestamp(new Date().getTime());
        String version = String.valueOf(now.getTime());
        Iterator itr = allLogs.iterator();
        PreparedStatement ps = null;
        Locale[] locales = MultiLangHelper.getDefinedLocales(this.getContext());
        try {
            int i;
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_PM_PermitemChangeReport(FID,FSynTime,FChangedTable,FChangeType,FPermItemID,FVersion,");
            for (i = 0; i < locales.length; ++i) {
                sql.append(MultiLangHelper.getFieldName("FContent", locales[i])).append(",");
            }
            for (i = 0; i < locales.length; ++i) {
                sql.append(MultiLangHelper.getFieldName("FReason", locales[i])).append(",");
            }
            for (i = 0; i < locales.length; ++i) {
                sql.append(MultiLangHelper.getFieldName("FSolution", locales[i]));
                if (i >= locales.length - 1) continue;
                sql.append(",");
            }
            sql.append(") values(?,?,?,?,?,?").append(PermChangeReportHelper.getQuestionMarks(3 * locales.length)).append(")");
            ps = this.con.prepareStatement(sql.toString());
            BOSObjectType bosType = new PermitemChangeReportInfo().getBOSType();
            int n = 0;
            while (itr.hasNext()) {
                int i2;
                ++n;
                PermitemChangeReportInfo info = (PermitemChangeReportInfo)itr.next();
                ps.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
                ps.setTimestamp(2, now);
                ps.setString(3, info.getChangedTable());
                ps.setInt(4, info.getChangeType().getValue());
                ps.setString(5, info.getPermItemID());
                ps.setString(6, version);
                for (i2 = 0; i2 < locales.length; ++i2) {
                    ps.setString(7 + i2, info.getContent(locales[i2]));
                }
                for (i2 = 0; i2 < locales.length; ++i2) {
                    ps.setString(7 + locales.length + i2, info.getReason(locales[i2]));
                }
                for (i2 = 0; i2 < locales.length; ++i2) {
                    ps.setString(7 + 2 * locales.length + i2, info.getSolution(locales[i2]));
                }
                ps.addBatch();
                if (n % 2000 != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private List getDeleteRelationTableLog(String tableName, String[] logFields, String permitemField, String sqlStr) throws BOSException, SQLException {
        Map permValueMap = PermChangeReportHelper.getDeletePermRelationMap(this.con, logFields, permitemField, sqlStr);
        Iterator itr = permValueMap.keySet().iterator();
        ArrayList<PermitemChangeReportInfo> changeList = new ArrayList<PermitemChangeReportInfo>();
        while (itr.hasNext()) {
            String permitemId = (String)itr.next();
            List deletedValueList = (List)permValueMap.get(permitemId);
            StringBuffer content = new StringBuffer();
            content.append("[");
            content.append(ToolUtils.aryToStr(logFields, false));
            content.append("]:\n");
            for (Map valueMap : deletedValueList) {
                content.append("[");
                for (int i = 0; i < logFields.length; ++i) {
                    content.append(valueMap.get(logFields[i])).append(",");
                }
                content.append("];\n");
            }
            PermitemChangeReportInfo changeInfo = new PermitemChangeReportInfo();
            this.setMultiLangProperty((IObjectValue)changeInfo, "content", PCR_RECORDSDELETE_CONTENT, new String[]{content.toString()});
            this.setMultiLangProperty((IObjectValue)changeInfo, "reason", PCR_RELATIVEDELETED_REASON, new String[]{permitemId});
            this.setMultiLangProperty((IObjectValue)changeInfo, "solution", PCR_SOLUTION, null);
            changeInfo.setChangedTable(tableName);
            changeInfo.setChangeType(PermChangeReportHelper.getChangeTypeByTableName(tableName));
            changeInfo.setPermItemID(permitemId);
            changeList.add(changeInfo);
        }
        return changeList;
    }

    private static Map getDeletePermRelationMap(Connection con, String[] logFields, String permitemField, String sqlStr) throws BOSException, SQLException {
        IRowSet rs = SynchUserHelper.executeQuery(con, sqlStr);
        HashMap permValueMap = new HashMap();
        while (rs.next()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            String permitemId = rs.getString(permitemField);
            for (int i = 0; i < logFields.length; ++i) {
                valueMap.put(logFields[i], rs.getObject(logFields[i]));
            }
            List rolePermMapList = null;
            rolePermMapList = permValueMap.containsKey(permitemId) ? (List)permValueMap.get(permitemId) : new ArrayList();
            rolePermMapList.add(valueMap);
            permValueMap.put(permitemId, rolePermMapList);
        }
        return permValueMap;
    }
}

