/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class ServerInstancesHelper {
    private static Logger log = Logger.getLogger(ServerInstancesHelper.class);
    public static final String SUBSYSTEM_CONFIG_PATH = System.getProperty("eas.deploy");
    private static final String SERVER_ROOT_PROP = "bos.root";
    private static final String DEFAULT_SERVER_CONFIG = "bosconfig.xml";
    private static final String CONFIG_KEY_SERVERURL = "serviceURL";
    private static final String CONFIGITEM = "systemStatusCtrolCache";
    private static StringBuffer primaryServerLocation = new StringBuffer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrimaryServerLocation() {
        StringBuffer stringBuffer = primaryServerLocation;
        synchronized (stringBuffer) {
            if (primaryServerLocation != null && primaryServerLocation.toString().length() != 0) {
                return primaryServerLocation.toString();
            }
            String singleConfigDir = null;
            String serverInstanceRoot = SUBSYSTEM_CONFIG_PATH.substring(0, SUBSYSTEM_CONFIG_PATH.lastIndexOf(47));
            File rootPath = new File(serverInstanceRoot = serverInstanceRoot.substring(0, serverInstanceRoot.lastIndexOf(47)));
            if (rootPath != null && rootPath.isDirectory()) {
                File[] allFiles = rootPath.listFiles();
                for (int i = 0; i < allFiles.length; ++i) {
                    if (allFiles[i] != null && allFiles[i].isDirectory()) {
                        singleConfigDir = allFiles[i].getPath() + File.separator + "config";
                        String singleconfigFile = singleConfigDir + File.separator + DEFAULT_SERVER_CONFIG;
                        File file = ServerInstancesHelper.getFile(singleconfigFile);
                        XMLConfiguration xmlConfig = ServerInstancesHelper.load(file);
                        if (xmlConfig == null) continue;
                        List configItems = xmlConfig.getConfigItemList("ORMServiceLocation");
                        for (int j = 0; configItems != null && j < configItems.size(); ++j) {
                            if (configItems.get(j) == null) {
                                singleConfigDir = null;
                                break;
                            }
                            String url = ((ConfigurationItem)configItems.get(j)).getProperty(CONFIG_KEY_SERVERURL);
                            if (StringUtils.isEmpty((String)url)) continue;
                            singleConfigDir = null;
                            break;
                        }
                    }
                    if (singleConfigDir != null) break;
                }
            }
            primaryServerLocation.append(singleConfigDir).append(File.separator).append("easconfig");
            return primaryServerLocation.toString();
        }
    }

    public static File getServerRoot() {
        String root = System.getProperty(SERVER_ROOT_PROP);
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        return new File(root);
    }

    private static XMLConfiguration load(File file) {
        XMLConfiguration xmlConfig = null;
        if (file != null && file.exists()) {
            xmlConfig = XMLConfiguration.getInstance((File)file);
        }
        return xmlConfig;
    }

    private static File getFile(String name) {
        File file;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (!(file = new File(name)).isAbsolute()) {
            file = new File(ServerInstancesHelper.getServerRoot(), name);
        }
        return file;
    }
}

