/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.GroupLicenseUseInfo;
import com.kingdee.eas.base.permission.app.SyncUserResultInfo;
import com.kingdee.eas.base.permission.app.util.PermThreadPool;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseManager;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper1;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.kbc.CloudLicenseUtil;
import com.kingdee.eas.common.EASBizException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class GroupLicenseUseInfoUtil {
    private static Logger logger = Logger.getLogger(GroupLicenseUseInfoUtil.class);

    public static boolean isRegister() {
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (loc.isLocal()) {
            try {
                return LicenseSrvAgent.getLocalInstance().isRegister();
            }
            catch (Throwable e) {
                return false;
            }
        }
        try {
            return LicenseSrvAgentFactory.getRemoteInstance((String)loc.getServiceURL()).isRegister();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isRegister(Context ctx) {
        boolean flag = false;
        try {
            String controlPolicy = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getControlPolicy();
            if (ControlPolicy.isByRegistUsers((String)controlPolicy)) {
                flag = true;
            }
        }
        catch (LicenseException e) {
            flag = GroupLicenseUseInfoUtil.isRegister();
            logger.error((Object)e.getMessage());
        }
        return flag;
    }

    public static boolean assignUserGroup(Context ctx, List<String> userIds, String groupNumber) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).assignUsersGroup(ctx, userIds, groupNumber);
    }

    public static boolean changeRolePermitem(Context ctx, RoleInfo role, RolePermCollection addPerms, RolePermCollection delPerms) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        final Context ctx1 = ctx;
        final RoleInfo role1 = role;
        final RolePermCollection addRolePerms = addPerms;
        final RolePermCollection delRolePerms = delPerms;
        Future<Boolean> future = PermThreadPool.getExecutorService().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return LicenseUseManager.getInstance(ctx1).changeRolePermitem(ctx1, role1, addRolePerms, delRolePerms);
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean disAssignUserGroup(Context ctx, List<String> userIds, String groupNumber) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).disAssignUsersGroup(ctx, userIds, groupNumber);
    }

    public static boolean removeUsersLicenseGroupInfo(Context ctx, List<String> licneseGroupIds) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).removeUsersLicenseGroupInfo(ctx, licneseGroupIds);
    }

    public static boolean assignPermitem(Context ctx, String useId, List<String> permitemIds) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).assignPermitem(ctx, useId, permitemIds);
    }

    public static boolean assignRoles(Context ctx, String useId, List<String> roles) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).assignRoles(ctx, useId, roles);
    }

    public static boolean assignUsersRoles(Context ctx, List<IObjectPK> userIds, List<String> roles) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).assignUsersRoles(ctx, userIds, roles);
    }

    public static boolean disAssignPermitems(Context ctx, String useId, List<String> permitemIds) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return true;
        }
        return LicenseUseManager.getInstance(ctx).disAssignPermitems(ctx, useId, permitemIds);
    }

    public static void changeUserInfo(Context ctx, UserInfo newUserInfo, UserInfo oldUserInfo) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).changeUserInfo(ctx, newUserInfo, oldUserInfo);
    }

    public static void addUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).addUser(ctx, userInfo);
    }

    public static void deleteUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).deleteUser(ctx, userInfo);
    }

    public static void deleteUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).deleteUsers(ctx, usersId);
    }

    public static void forbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).forbidUsers(ctx, usersId);
    }

    public static void forbidUsers(Context ctx, List<String> usersId, boolean flag) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        if (flag) {
            LicenseUseManager.getInstance(ctx).forbidUsers(ctx, usersId);
        } else {
            LicenseUseManager.getInstance(ctx).unForbidUsers(ctx, usersId);
        }
    }

    public static void callBackUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).callBackUsers(ctx, usersId);
    }

    public static void unForbidUsers(Context ctx, List<String> usersId) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).unForbidUsers(ctx, usersId);
    }

    public static List<CloudUserInfo> getAssembleCloudUserInfo(Context ctx) throws BOSException, EASBizException {
        CloudLicenseUtil.refreshUserSyncStatus(ctx);
        return LicenseUseManager.getInstance(ctx).getAssembleCloudUserInfo(ctx, true, false);
    }

    public static List<CloudUserInfo> getAssembleCloudUserInfoNotIncludeGroups(Context ctx) throws BOSException, EASBizException {
        CloudLicenseUtil.refreshUserSyncStatus(ctx);
        return LicenseUseManager.getInstance(ctx).getAssembleCloudUserInfo(ctx, false, false);
    }

    public static List<CloudUserInfo> getAssembleCloudUserInfoAll(Context ctx) throws BOSException, EASBizException {
        CloudLicenseUtil.refreshUserSyncStatus(ctx);
        return LicenseUseManager.getInstance(ctx).getAssembleCloudUserInfo(ctx, true, true);
    }

    public static List<CloudUserInfo> getAssembleCloudUserInfoIncludeAll(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getAssembleCloudUserInfoIncludeAll(ctx);
    }

    public static void synCloudUser2ERP(Context ctx, List<UserInfo> userList) throws BOSException, EASBizException {
        UserLicenseGroupHelper1.getInstance(ctx).synCloudUser2ERP(ctx, userList);
    }

    public static String synResultUpdate2ERP(Context ctx, Map<String, UserInfo> synUserMap) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).synResultUpdate2ERP(ctx, synUserMap);
    }

    public static String synResultUpdateToERP(Context ctx, Map<String, SyncUserResultInfo> synUserResults) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).synResultUpdateToERP(ctx, synUserResults);
    }

    public static String synResultUpdateToERP2(Context ctx, List<CloudUserInfo> assembleCloudUserInfo) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).synResultUpdateToERP2(ctx, assembleCloudUserInfo);
    }

    public static String synResultUpdateToERP3(Context ctx, List<CloudUserInfo> assembleCloudUserInfo) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).synResultUpdateToERP3(ctx, assembleCloudUserInfo);
    }

    public static Map<String, CloudRegistUserInfo> getRegistUseFromLicense(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getRegistUserMapFromLicense(ctx);
    }

    public static List<CloudUserInfo> getCloudUserInfoFromLicense(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getCloudUserInfoFromLicense(ctx);
    }

    public static Map initUserLicenseGroup(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).initUserLicenseGroup(ctx);
    }

    public static Map resetAllUserSyncState(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).resetAllUserSyncState(ctx);
    }

    public static List<String> getUserGroupListByUserorgperm(Context ctx, String userId) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserGroupListByUserorgperm(ctx, userId);
    }

    public static List<String> getUserGroupListByRole(Context ctx, String roleId) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserGroupListByRole(ctx, roleId);
    }

    public static List<String> getUserGroupsByRole(Context ctx, String roleId) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserGroupsByRole(ctx, roleId);
    }

    public static List<String> getUserGroupListByRoles(Context ctx, List<String> roleIds) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserGroupListByRoles(ctx, roleIds);
    }

    public static List<String> getUserGroupListByUserroleorg(Context ctx, String userId) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserGroupListByUserroleorg(ctx, userId);
    }

    public static List<String> getUserLicenseGroupByUser(Context ctx, String userId) throws BOSException, EASBizException {
        return UserLicenseGroupHelper1.getInstance(ctx).getUserLicenseGroupByUser(ctx, userId);
    }

    public static List<String> getUserGroupStr(Context ctx, String useId) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getUserGroupStr(ctx, useId);
    }

    public static List<String> getUserGroupName(Context ctx, String useId) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getUserGroupName(ctx, useId);
    }

    public static Map getUserGroupDiffInfo(Context ctx, String useId) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getUserGroupDiffInfo(ctx, useId);
    }

    public static Map<String, GroupLicenseUseInfo> getLicenseUseInfoMap(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getLicenseUseInfoMap();
    }

    public static List<String> getOSLicenseModule(Context ctx) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getLicenseModule();
    }

    public static boolean hasGroupPerm(Context ctx, List userGroupLicenses) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).hasGroupPerm(ctx, userGroupLicenses);
    }

    public static void rebuildUserLicenseGroupInfo(Context ctx, String userId) throws BOSException, EASBizException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        UserLicenseGroupHelper1.getInstance(ctx).rebuildUserLicenseGroupInfo(ctx, userId);
    }

    public static List getGroupUsers(Context ctx, String groupNumber) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).getGroupUsers(ctx, groupNumber);
    }

    public static boolean activeUserGroups(Context ctx, Map userData, String groupNumber, int count) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).activeUserGroups(userData, groupNumber, count);
    }

    public static boolean removeUser(Context ctx, String[] seleteUserLicenseIds, Map userData, String groupNumber, int activeCount) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).removeUser(seleteUserLicenseIds, userData, groupNumber, activeCount);
    }

    public static boolean unActiveUserGroups(Context ctx, List userIds, String groupNumber) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).unActiveUserGroups(userIds, groupNumber);
    }

    public static boolean unActiveUserGroups(Context ctx, Map userData, String groupNumber, int count) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).unActiveUserGroups(userData, groupNumber, count);
    }

    public static String importUserGroups(Context ctx, Map<String, Map<String, Boolean>> userGroupMap, Map<String, List<String>> groupRetainMap) throws BOSException, EASBizException {
        return LicenseUseManager.getInstance(ctx).importUserGroups(ctx, userGroupMap, groupRetainMap);
    }

    public static void syncUserGroups(Context ctx, IObjectPK userPk) throws EASBizException, BOSException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).synUserGroups(ctx, userPk);
    }

    public static void batchSyncUserGroups(Context ctx, List<IObjectPK> userPks) throws EASBizException, BOSException {
        if (!GroupLicenseUseInfoUtil.isRegister(ctx)) {
            return;
        }
        LicenseUseManager.getInstance(ctx).batchSynUserGroups(ctx, userPks);
    }
}

