/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupCollection;
import com.kingdee.eas.base.permission.UserLicenseGroupFactory;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.app.util.interior.ILicenseUseSrv;
import com.kingdee.eas.base.permission.app.util.interior.IUserLicenseGroupActiveHelper;
import com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvFactory;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UserLicenseGroupActiveHelper
implements IUserLicenseGroupActiveHelper {
    private String activeSQL = "";
    private String updateUserSQL = "";
    private String updateDiffSQL = "";
    private List userIds = null;
    private String groupNumber = "";
    private boolean isAssign = true;
    private boolean isActive = false;
    private Context context;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserLicenseGroupActiveHelper");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserLicenseGroupHelper userLicGroupHelper = null;

    @Override
    public boolean exec() throws BOSException, EASBizException {
        return this.isAssign;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addActiveData(Context ctx, List userIds, String groupNumber, boolean isActive) {
        this.userIds = userIds;
        this.groupNumber = groupNumber;
        this.isActive = isActive;
        this.context = ctx;
        HashMap userGroupMap = new HashMap();
        HashMap<String, Boolean> groupMap = new HashMap<String, Boolean>();
        if (this.userLicGroupHelper == null) {
            this.userLicGroupHelper = new UserLicenseGroupHelper(ctx);
        }
        UserLicenseGroupCollection userGroups = null;
        try {
            userGroups = UserLicenseGroupFactory.getLocalInstance(ctx).getUserLicenseGroupCollection("where groupnumber = '" + groupNumber + "' and user in (" + ToolUtils.aryToStr((List)userIds) + ")");
            if (isActive) {
                if (!this.checkAssignUsersGroup(ctx, groupNumber, userGroups.size())) {
                    this.isAssign = false;
                    return;
                }
                this.isAssign = true;
            } else {
                this.isAssign = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        groupMap.put(groupNumber, isActive);
        int size = userGroups.size();
        for (int i = 0; i < size; ++i) {
            UserLicenseGroupInfo licGroupInfo = userGroups.get(i);
            UserLicenseGroupInfoEx userlicGroupEx = new UserLicenseGroupInfoEx(licGroupInfo);
            userlicGroupEx.setIsActive(isActive);
            userlicGroupEx.setSynUser(SynStateEnum.SYN_NO);
            this.userLicGroupHelper.addUpdUserLicenseGroupInfo(userlicGroupEx);
            userGroupMap.put(licGroupInfo.getUser().getNumber(), groupMap);
        }
        try {
            this.userLicGroupHelper.exec();
            return;
        }
        catch (EASBizException e) {
            logger.error((Object)("==================================EASBizException=======================" + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.error((Object)("==================================BOSException==========================" + (Object)((Object)e)));
        }
    }

    private void unSynUser(List userIds) throws BOSException {
        String updateUserSql = "update T_PM_USER SET FIsSynToCloud = 0 where FID IN(" + com.kingdee.eas.base.permission.util.ToolUtils.aryToStr(userIds) + ")";
        DbUtil.execute((Context)this.context, (String)updateUserSql);
    }

    private void updUserLicGroupDiff(Context ctx, String userId, List<String> userGroupStr) throws BOSException {
        int num = UserLicenseGroupTool.updateUserLicGroupDiff(ctx, userId, userGroupStr);
        if (num <= 0) {
            UserLicenseGroupTool.insUserLicGroupDiff(ctx, this.getUserInfo(ctx, userId), userGroupStr);
        }
    }

    private UserInfo getUserInfo(Context ctx, String userId) {
        try {
            return UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private boolean checkAssignUsersGroup(Context ctx, String groupNumber, int nums) throws BOSException, EASBizException {
        int remainNum;
        if (ctx == null) {
            ctx = ContextUtils.getContextFromSession();
        }
        return (remainNum = this.getLicenseUseSev(ctx).getGroupRemainNum(ctx, groupNumber)) >= nums;
    }

    private ILicenseUseSrv getLicenseUseSev(Context ctx) throws BOSException {
        return LicenseUseSrvFactory.getLocalInstance(ctx);
    }

    @Override
    public void addActiveData(Context context, Map userData, String groupNumber, int count, boolean isActive) {
        if (userData.size() == 0) {
            this.isAssign = true;
            return;
        }
        if (isActive) {
            try {
                if (!this.checkAssignUsersGroup(context, groupNumber, count)) {
                    this.isAssign = false;
                    return;
                }
                this.isAssign = true;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        } else {
            this.isAssign = true;
        }
        Set entrySet = userData.entrySet();
        Iterator userDataItr = entrySet.iterator();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(userData.size(), userData.size(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10));
        ArrayList<activeThread> tasks = new ArrayList<activeThread>(userData.size());
        List futures = null;
        while (userDataItr.hasNext()) {
            Map.Entry userDataEntry = userDataItr.next();
            tasks.add(new activeThread(context, (String)userDataEntry.getKey(), (JSONArray)userDataEntry.getValue(), groupNumber, isActive));
        }
        try {
            futures = executorService.invokeAll(tasks);
            for (int i = 0; i < futures.size(); ++i) {
                if (((Boolean)futures.get(i).get()).booleanValue()) continue;
                this.isAssign = false;
            }
            if (isActive && !LicenseUseSrvFactory.getLocalInstance(context).assignUsersGroup(context, groupNumber, count)) {
                this.isAssign = false;
            } else if (!isActive && !LicenseUseSrvFactory.getLocalInstance(context).disAssignUsersGroup(context, groupNumber, count)) {
                this.isAssign = false;
            }
        }
        catch (InterruptedException e) {
            this.isAssign = false;
            logger.error((Object)"addActiveData.InterruptedException", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.isAssign = false;
            logger.error((Object)"addActiveData.ExecutionException", (Throwable)e);
        }
        catch (BOSException e) {
            this.isAssign = false;
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            this.isAssign = false;
            logger.error((Object)e);
        }
    }

    @Override
    public void addAllActiveData(Context ctx, Map userData, String groupNumber, boolean isActive) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx, Connection conn, JSONArray userIds, String groupNumer, boolean isActive) {
        String activeSQL = "update t_pm_userlicensegroup set fisactive = " + (isActive ? 1 : 0) + " where fgroupnumber ='" + groupNumer + "' and fuserid in(" + com.kingdee.eas.base.permission.util.ToolUtils.aryToStr((List)userIds) + ")";
        String synSQL = "update t_pm_user set fissyntocloud = 0 where fid in(" + com.kingdee.eas.base.permission.util.ToolUtils.aryToStr((List)userIds) + ")";
        String logSQL = "insert into t_pm_userlog(fid,fuserid,fcontent_l1,fcontent_l2,fcontent_l3,fchangedate,fchangeuserid) values(?,?,?,?,?,?,?)";
        PreparedStatement active_ps = null;
        PreparedStatement syn_ps = null;
        PreparedStatement log_ps = null;
        try {
            int i;
            active_ps = conn.prepareStatement(activeSQL);
            syn_ps = conn.prepareStatement(synSQL);
            log_ps = conn.prepareStatement(logSQL);
            for (i = 0; i < userIds.size(); ++i) {
                log_ps.setString(1, BOSUuid.create((String)"A20E4845").toString());
                log_ps.setString(2, userIds.getString(i));
                log_ps.setString(3, this.activeLicenseGroupContent(groupNumer, isActive, "l1").toString());
                log_ps.setString(4, this.activeLicenseGroupContent(groupNumer, isActive, "l2").toString());
                log_ps.setString(5, this.activeLicenseGroupContent(groupNumer, isActive, "l3").toString());
                log_ps.setTimestamp(6, this.getTime());
                log_ps.setString(7, ctx.getCaller().toString());
                log_ps.addBatch();
            }
            active_ps.executeUpdate();
            syn_ps.executeUpdate();
            log_ps.executeBatch();
            i = 1;
            return i != 0;
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupActiveHelper.execute.SQLException", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (active_ps != null) {
                    active_ps.close();
                }
                if (syn_ps != null) {
                    syn_ps.close();
                }
                if (log_ps != null) {
                    log_ps.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"UserLicenseGroupActiveHelper.close.execute.SQLException", (Throwable)e);
            }
        }
    }

    @Override
    public boolean removeUserLicenseGroup(Context context, String[] userids, Map userData, String groupNumber, int activeCount) {
        Set entrySet = userData.entrySet();
        Iterator userDataItr = entrySet.iterator();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(userData.size(), userData.size(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10));
        ArrayList<RemoveThread> tasks = new ArrayList<RemoveThread>(userData.size());
        List futures = null;
        while (userDataItr.hasNext()) {
            Map.Entry userDataEntry = userDataItr.next();
            tasks.add(new RemoveThread(context, userids, (String)userDataEntry.getKey(), (JSONArray)userDataEntry.getValue(), groupNumber, activeCount));
        }
        try {
            futures = executorService.invokeAll(tasks);
            for (int i = 0; i < futures.size(); ++i) {
                if (((Boolean)futures.get(i).get()).booleanValue()) continue;
                return false;
            }
            if (!LicenseUseSrvFactory.getLocalInstance(context).disAssignUsersGroup(context, groupNumber, activeCount)) {
                return false;
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"addActiveData.InterruptedException", (Throwable)e);
            return false;
        }
        catch (ExecutionException e) {
            logger.error((Object)"addActiveData.ExecutionException", (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRemove(Context ctx, String[] userIds, Connection conn, JSONArray ugIds, String groupNumber, int activeCount) {
        String removeSQL = "delete from t_pm_userlicensegroup where fid in(" + com.kingdee.eas.base.permission.util.ToolUtils.aryToStr((List)ugIds) + ")";
        String synSQL = "update t_pm_user set fissyntocloud = 0 where fid in(" + com.kingdee.eas.base.permission.util.ToolUtils.aryToStr(userIds) + ")";
        String logSQL = "insert into t_pm_userlog(fid,fuserid,fcontent_l1,fcontent_l2,fcontent_l3,fchangedate,fchangeuserid) values(?,?,?,?,?,?,?)";
        PreparedStatement remove_ps = null;
        PreparedStatement syn_ps = null;
        PreparedStatement log_ps = null;
        try {
            int i;
            remove_ps = conn.prepareStatement(removeSQL);
            syn_ps = conn.prepareStatement(synSQL);
            log_ps = conn.prepareStatement(logSQL);
            for (i = 0; i < userIds.length; ++i) {
                log_ps.setString(1, BOSUuid.create((String)"A20E4845").toString());
                log_ps.setString(2, userIds[i]);
                log_ps.setString(3, this.removeLicenseGroupContent(groupNumber, "l1").toString());
                log_ps.setString(4, this.removeLicenseGroupContent(groupNumber, "l2").toString());
                log_ps.setString(5, this.removeLicenseGroupContent(groupNumber, "l3").toString());
                log_ps.setTimestamp(6, this.getTime());
                log_ps.setString(7, ctx.getCaller().toString());
                log_ps.addBatch();
            }
            remove_ps.executeUpdate();
            syn_ps.executeUpdate();
            log_ps.executeBatch();
            i = 1;
            return i != 0;
        }
        catch (SQLException e) {
            logger.error((Object)"UserLicenseGroupActiveHelper.execute.SQLException", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (remove_ps != null) {
                    remove_ps.close();
                }
                if (syn_ps != null) {
                    syn_ps.close();
                }
                if (log_ps != null) {
                    log_ps.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"UserLicenseGroupActiveHelper.close.execute.SQLException", (Throwable)e);
            }
        }
    }

    private StringBuffer activeLicenseGroupContent(String groupStr, boolean isActive, String locale) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer changeContent = new StringBuffer();
        if (isActive) {
            if ("l1".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append("Active group\"").append(groupStr).append("\"").append(lineSep);
            }
            if ("l2".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append(EASResource.getString((String)RESOURCE, (String)"AVTIVATE_GROUP") + "\"").append(groupStr).append("\"").append(lineSep);
            }
            if ("l3".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append(EASResource.getString((String)RESOURCE, (String)"AVTIVATE_GROUP") + "\"").append(groupStr).append("\"").append(lineSep);
            }
        } else {
            if ("l1".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append("Release group\"").append(groupStr).append("\"").append(lineSep);
            }
            if ("l2".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append(EASResource.getString((String)RESOURCE, (String)"CANCEL_GROUP") + "\"").append(groupStr).append("\"").append(lineSep);
            }
            if ("l3".equals(locale)) {
                changeContent.setLength(0);
                changeContent.append(EASResource.getString((String)RESOURCE, (String)"CANCEL_GROUP") + "\"").append(groupStr).append("\"").append(lineSep);
            }
        }
        return changeContent;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public StringBuffer removeLicenseGroupContent(String gorupNumber, String locale) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer changeContent = new StringBuffer();
        if ("l1".equals(locale)) {
            changeContent.append("Remove group\"").append(gorupNumber).append("\"").append(lineSep);
        }
        if ("l2".equals(locale)) {
            changeContent.append(EASResource.getString((String)RESOURCE, (String)"DELETE_GROUP") + "\"").append(gorupNumber).append("\"").append(lineSep);
        }
        if ("l3".equals(locale)) {
            changeContent.append(EASResource.getString((String)RESOURCE, (String)"DELETE_GROUP") + "\"").append(gorupNumber).append("\"").append(lineSep);
        }
        return changeContent;
    }

    @Override
    public void addAllActiveData(Context ctx, List userIds, String groupNumber, boolean isActive) throws BOSException {
    }

    class RemoveThread
    implements Callable<Boolean> {
        String dbAis;
        JSONArray ugIds;
        int activeCount;
        String[] seleteUserLicenseIds;
        String groupNumber;
        Context ctx;

        public RemoveThread(Context ctx, String[] seleteUserLicenseIds, String dbAis, JSONArray ugIds, String groupNumber, int activeCount) {
            this.dbAis = dbAis;
            this.ugIds = ugIds;
            this.activeCount = activeCount;
            this.seleteUserLicenseIds = seleteUserLicenseIds;
            this.groupNumber = groupNumber;
            this.ctx = ctx;
        }

        @Override
        public Boolean call() throws Exception {
            Connection conn = DbConnector.getConnection((String)this.dbAis);
            return UserLicenseGroupActiveHelper.this.executeRemove(this.ctx, this.seleteUserLicenseIds, conn, this.ugIds, this.groupNumber, this.activeCount);
        }
    }

    class activeThread
    implements Callable<Boolean> {
        String dbAis;
        JSONArray userIds;
        String groupNumber;
        Context ctx;
        boolean isActive;

        public activeThread(Context ctx, String dbAis, JSONArray userIds, String groupNumber, boolean isActive) {
            this.dbAis = dbAis;
            this.userIds = userIds;
            this.groupNumber = groupNumber;
            this.isActive = isActive;
            this.ctx = ctx;
        }

        @Override
        public Boolean call() throws Exception {
            Connection conn = DbConnector.getConnection((String)this.dbAis);
            return UserLicenseGroupActiveHelper.this.execute(this.ctx, conn, this.userIds, this.groupNumber, this.isActive);
        }
    }
}

