/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior.bean;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLicenseGroupInfo;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class UserLicenseGroupsInfo {
    private static Logger logger = Logger.getLogger((String)UserLicenseGroupsInfo.class.getName());
    protected String fuserId;
    protected UserInfo user;
    protected List<UserLicenseGroupInfoEx> lsLicGroups;
    protected Set<String> groupsNumberSet;
    protected final ReentrantLock lock = new ReentrantLock();

    public UserLicenseGroupsInfo(Context ctx, String fuserId) {
        this.fuserId = fuserId;
        try {
            IUser iuser = UserFactory.getLocalInstance(ctx);
            iuser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
            this.user = iuser.getUserInfo((IObjectPK)new ObjectUuidPK(fuserId));
            this.groupsNumberSet = new HashSet<String>();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.user = new UserInfo(fuserId);
        }
    }

    public UserLicenseGroupsInfo(UserInfo user) {
        this.user = user;
        this.fuserId = user.getId().toString();
        this.groupsNumberSet = new HashSet<String>();
    }

    public UserLicenseGroupsInfo(String fuserId) {
        this(null, fuserId);
    }

    public UserInfo getUser() {
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.user = user;
    }

    public String getFuserId() {
        return this.fuserId;
    }

    public void setFuserId(String fuserId) {
        this.fuserId = fuserId;
    }

    public List<UserLicenseGroupInfoEx> getLsLicGroups() {
        return this.lsLicGroups;
    }

    public void setLsLicGroups(List<UserLicenseGroupInfoEx> lsLicGroups) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.lsLicGroups = lsLicGroups;
        }
        finally {
            lock.unlock();
        }
    }

    public void addLicGroups(UserLicenseGroupInfo groupInfo) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.addLicGroups(new UserLicenseGroupInfoEx(groupInfo));
        }
        finally {
            lock.unlock();
        }
    }

    public void addLicGroups(UserLicenseGroupInfoEx groupInfo) {
        if (groupInfo == null) {
            return;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.groupsNumberSet == null) {
                this.groupsNumberSet = new HashSet<String>();
            }
            if (this.groupsNumberSet.contains(groupInfo.getGroupNumber())) {
                return;
            }
            if (this.lsLicGroups == null) {
                this.lsLicGroups = new ArrayList<UserLicenseGroupInfoEx>();
            }
            groupInfo.setUser(this.user);
            this.lsLicGroups.add(groupInfo);
            this.groupsNumberSet.add(groupInfo.getGroupNumber());
        }
        finally {
            lock.unlock();
        }
    }

    public void removeLicGroups(UserLicenseGroupInfoEx groupInfo) {
        if (groupInfo == null) {
            return;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.groupsNumberSet.remove(groupInfo.getGroupNumber());
            this.lsLicGroups.remove(groupInfo);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLicGroups(String groupNumber) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (groupNumber == null || this.lsLicGroups == null || this.groupsNumberSet == null || !this.groupsNumberSet.contains(groupNumber)) {
                return;
            }
            int size = this.lsLicGroups.size();
            for (int i = 0; i < size; ++i) {
                if (!groupNumber.equalsIgnoreCase(this.lsLicGroups.get(i).getGroupNumber())) continue;
                this.removeLicGroups(this.lsLicGroups.get(i));
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserLicenseGroupInfoEx getLicGroup(String groupNumber) {
        if (groupNumber == null || this.lsLicGroups == null || this.groupsNumberSet == null || !this.groupsNumberSet.contains(groupNumber)) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int size = this.lsLicGroups.size();
            for (int i = 0; i < size; ++i) {
                if (!groupNumber.equalsIgnoreCase(this.lsLicGroups.get(i).getGroupNumber())) continue;
                UserLicenseGroupInfoEx userLicenseGroupInfoEx = this.lsLicGroups.get(i);
                return userLicenseGroupInfoEx;
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public Set<String> getGroupsNumberSet() {
        return this.groupsNumberSet;
    }

    public void setGroupsNumberSet(Set<String> groupsNumberSet) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.groupsNumberSet = groupsNumberSet;
        }
        finally {
            lock.unlock();
        }
    }
}

