/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.DBUserBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Deprecated
public class LicenseDBExecHelper {
    private Context ctx;
    private Map operateMap;
    private Map<OPT, String> sqlMap;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.db.LicenseDBExecHelper");

    public LicenseDBExecHelper(Context ctx) {
        this.ctx = ctx;
        this.operateMap = new HashMap();
        this.sqlMap = new HashMap<OPT, String>();
    }

    public void addUpdateValues(Map userGroupMap) {
        this.operateMap.put(OPT.UPDATE_OPT, userGroupMap);
    }

    public void addInsertValues(Map userGroupMap) {
        this.operateMap.put(OPT.INSERT_OPT, userGroupMap);
    }

    public void addDeleteValues(Map userGroupMap) {
        this.operateMap.put(OPT.DELETE_PT, userGroupMap);
    }

    public void addDeleteUserValues(DBUserBean dbUserBean) {
        this.operateMap.put(OPT.DELETEDUSER_OPT, dbUserBean);
    }

    public void addforbidUserValues(DBUserBean dbUserBean) {
        this.operateMap.put(OPT.FORBIDDENUSER_OPT, dbUserBean);
    }

    private void initSQLMap() {
        StringBuilder updateSQL = new StringBuilder("update t_pm_userlicensegroup up set fisactive = ? where fgroupnumber = ? and exists(select 1 from t_pm_user u where up.fuserid = u.fid and u.fnumber = ?)");
        StringBuilder updateUserSQL = new StringBuilder("update t_pm_user set fisSyntocloud = 0  where fnumber in ");
        StringBuilder uadateUserDeletedStateSQL = new StringBuilder("update t_pm_user set fisdelete =?,fisSyntocloud = 0  where fnumber in ");
        StringBuilder uadateUserForbiddenStateSQL = new StringBuilder("update t_pm_user  set FFORBIDDEN =? ,FISSYNTOCLOUD = 0  where fnumber in ");
        StringBuilder insertSQL = new StringBuilder("insert into T_pm_userlicensegroup(FuserId,FGroupNumber,FSynUser,fid,FIsActive,fname_l1,fname_l2,fname_l3) select FID,?,?,newbosid('94716EDD'),?,?,?,? from t_pm_user u where not exists (select 1 from T_pm_userlicensegroup up where u.fid = up.fuserid and up.fgroupNumber = ? and u.fnumber =?)");
        StringBuilder deleteSQL = new StringBuilder("DELETE FROM T_PM_USERLICENSEGROUP up Where fgroupnumber =? and exists(select 1 from t_pm_user u where up.fuserid = u.fid and u.fnumber in ");
        String userNumberParam = "";
        if (this.operateMap.get((Object)OPT.UPDATE_OPT) != null) {
            userNumberParam = ToolUtils.aryToStr(((Map)this.operateMap.get((Object)OPT.UPDATE_OPT)).keySet(), true);
            updateUserSQL.append(" (" + userNumberParam + ")");
            this.sqlMap.put(OPT.UPDATE_OPT, updateSQL.toString());
            this.sqlMap.put(OPT.UPDATE_STATE_OPT, updateUserSQL.toString());
        }
        if (this.operateMap.get((Object)OPT.INSERT_OPT) != null) {
            userNumberParam = ToolUtils.aryToStr(((Map)this.operateMap.get((Object)OPT.INSERT_OPT)).keySet(), true);
            updateUserSQL.append(" (" + userNumberParam + ")");
            this.sqlMap.put(OPT.INSERT_OPT, insertSQL.toString());
            this.sqlMap.put(OPT.UPDATE_STATE_OPT, updateUserSQL.toString());
        }
        if (this.operateMap.get((Object)OPT.DELETE_PT) != null) {
            userNumberParam = ToolUtils.aryToStr(((Map)this.operateMap.get((Object)OPT.DELETE_PT)).keySet(), true);
            deleteSQL.append(" (" + userNumberParam + "))");
            updateUserSQL.append(" (" + userNumberParam + ")");
            this.sqlMap.put(OPT.DELETE_PT, deleteSQL.toString());
            this.sqlMap.put(OPT.UPDATE_STATE_OPT, updateUserSQL.toString());
        }
        if (this.operateMap.get((Object)OPT.DELETEDUSER_OPT) != null) {
            userNumberParam = ToolUtils.aryToStr(((DBUserBean)this.operateMap.get((Object)OPT.DELETEDUSER_OPT)).getUserNumbers(), true);
            uadateUserDeletedStateSQL.append(" (" + userNumberParam + ")");
            this.sqlMap.put(OPT.DELETEDUSER_OPT, uadateUserDeletedStateSQL.toString());
        }
        if (this.operateMap.get((Object)OPT.FORBIDDENUSER_OPT) != null) {
            userNumberParam = ToolUtils.aryToStr(((DBUserBean)this.operateMap.get((Object)OPT.FORBIDDENUSER_OPT)).getUserNumbers(), true);
            uadateUserForbiddenStateSQL.append(" (" + userNumberParam + ")");
            this.sqlMap.put(OPT.FORBIDDENUSER_OPT, uadateUserForbiddenStateSQL.toString());
        }
    }

    public String execBySystemDBs() {
        if (this.operateMap.isEmpty()) {
            return "";
        }
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)"======================get dclist error:", (Throwable)e1);
        }
        if (dcList == null || dcList.size() < 0) {
            return "";
        }
        String currDataSourceAIS = this.ctx.getAIS();
        int dbSize = dcList.size();
        Iterator it = dcList.iterator();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(dbSize, dbSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10));
        ArrayList<DBOptThread> tasks = new ArrayList<DBOptThread>(dbSize);
        List futures = null;
        StringBuilder result = new StringBuilder("{");
        this.initSQLMap();
        HashSet<String> dbSet = new HashSet<String>(dbSize);
        while (it.hasNext()) {
            String dataSourceAIS = ((DCInfo)it.next()).getNumber();
            if (currDataSourceAIS.equals(dataSourceAIS)) continue;
            tasks.add(new DBOptThread(dataSourceAIS));
            dbSet.add(dataSourceAIS);
        }
        try {
            futures = executorService.invokeAll(tasks);
            executorService.shutdown();
            Iterator itAis = dbSet.iterator();
            int i = 0;
            boolean isDbSuccess = false;
            while (itAis.hasNext()) {
                isDbSuccess = (Boolean)futures.get(i).get();
                result.append((String)itAis.next()).append(":").append(isDbSuccess).append(";");
                ++i;
            }
            result.append("}");
            logger.error((Object)("dbs:executeresult:" + result.toString()));
        }
        catch (InterruptedException e) {
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>DBS:InterruptedException" + e));
        }
        catch (ExecutionException e) {
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>DBS:ExecutionException" + e));
        }
        return result.toString();
    }

    private boolean exec(Connection conn) {
        boolean isSuccess = false;
        if (this.operateMap.get((Object)OPT.UPDATE_OPT) != null && this.operateMap.get((Object)OPT.DELETEDUSER_OPT) == null && this.operateMap.get((Object)OPT.FORBIDDENUSER_OPT) == null) {
            isSuccess = this.updateFunc(conn);
        }
        if (this.operateMap.get((Object)OPT.INSERT_OPT) != null) {
            isSuccess = this.insertFunc(conn);
        }
        if (this.operateMap.get((Object)OPT.DELETE_PT) != null) {
            isSuccess = this.deleteFunc(conn);
        }
        if (this.operateMap.get((Object)OPT.DELETEDUSER_OPT) != null && this.operateMap.get((Object)OPT.UPDATE_OPT) != null) {
            isSuccess = this.setUserFunc(conn);
        }
        if (this.operateMap.get((Object)OPT.FORBIDDENUSER_OPT) != null && this.operateMap.get((Object)OPT.UPDATE_OPT) != null) {
            isSuccess = this.setUserFunc(conn);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean updateFunc(Connection conn) {
        Map userGroupMap = (Map)this.operateMap.get((Object)OPT.UPDATE_OPT);
        int count = 0;
        Statement ps = null;
        Statement userPs = null;
        boolean optState = false;
        try {
            ps = conn.prepareStatement(this.sqlMap.get((Object)OPT.UPDATE_OPT));
            userPs = conn.prepareStatement(this.sqlMap.get((Object)OPT.UPDATE_STATE_OPT));
            Set userGroupMapESet = userGroupMap.entrySet();
            if (userGroupMapESet != null) {
                for (Map.Entry entry : userGroupMapESet) {
                    if (entry == null) continue;
                    for (Map.Entry mapEntry : ((Map)entry.getValue()).entrySet()) {
                        ps.setBoolean(1, (Boolean)mapEntry.getValue());
                        ps.setString(2, (String)mapEntry.getKey());
                        ps.setString(3, (String)entry.getKey());
                        ps.addBatch();
                        if (count++ % 1000 == 0) {
                            ps.executeBatch();
                            ps.clearBatch();
                            optState = true;
                            continue;
                        }
                        optState = false;
                    }
                    if (optState) continue;
                    ps.executeBatch();
                }
            }
            userPs.execute();
            Boolean userGroupItr = true;
            return userGroupItr;
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)("============================DBS:updateFunc error" + e));
            }
            logger.error((Object)"");
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (userPs != null) {
                    userPs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                logger.error((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertFunc(Connection conn) {
        Map userGroupMap = (Map)this.operateMap.get((Object)OPT.INSERT_OPT);
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(this.ctx);
        Statement ps = null;
        Statement userPs = null;
        boolean optState = false;
        int count = 0;
        try {
            ps = conn.prepareStatement(this.sqlMap.get((Object)OPT.INSERT_OPT));
            userPs = conn.prepareStatement(this.sqlMap.get((Object)OPT.UPDATE_STATE_OPT));
            Set userGroupMapESet = userGroupMap.entrySet();
            if (userGroupMapESet != null) {
                for (Map.Entry userGroupEntry : userGroupMapESet) {
                    if (userGroupEntry == null) continue;
                    for (Map.Entry mapEntry : ((Map)userGroupEntry.getValue()).entrySet()) {
                        ps.setString(1, (String)mapEntry.getKey());
                        ps.setInt(2, 0);
                        ps.setBoolean(3, (Boolean)mapEntry.getValue());
                        ps.setString(4, moduleAliasMap.get(mapEntry.getKey()));
                        ps.setString(5, moduleAliasMap.get(mapEntry.getKey()));
                        ps.setString(6, moduleAliasMap.get(mapEntry.getKey()));
                        ps.setString(7, (String)mapEntry.getKey());
                        ps.setString(8, (String)userGroupEntry.getKey());
                        ps.addBatch();
                        if (count++ % 1000 == 0) {
                            ps.executeBatch();
                            ps.clearBatch();
                            optState = true;
                            continue;
                        }
                        optState = false;
                    }
                    if (optState) continue;
                    ps.executeBatch();
                }
            }
            userPs.execute();
            boolean userGroupItr = true;
            return userGroupItr;
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)"");
            }
            logger.error((Object)("============================DBS:insert error" + e));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (userPs != null) {
                    userPs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteFunc(Connection conn) {
        Map userGroupMap = (Map)this.operateMap.get((Object)OPT.DELETE_PT);
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(this.ctx);
        int count = 0;
        Statement ps = null;
        Statement userPs = null;
        boolean optState = false;
        try {
            ps = conn.prepareStatement(this.sqlMap.get((Object)OPT.DELETE_PT));
            userPs = conn.prepareStatement(this.sqlMap.get((Object)OPT.UPDATE_STATE_OPT));
            Set userGroupMapESet = userGroupMap.entrySet();
            if (userGroupMapESet != null) {
                for (Map.Entry userGroupEntry : userGroupMapESet) {
                    if (userGroupEntry == null) continue;
                    for (Map.Entry mapEntry : ((Map)userGroupEntry.getValue()).entrySet()) {
                        ps.setString(1, (String)mapEntry.getKey());
                        ps.addBatch();
                        if (count++ % 1000 == 0) {
                            ps.executeBatch();
                            ps.clearBatch();
                            optState = true;
                            continue;
                        }
                        optState = false;
                    }
                    if (optState) continue;
                    ps.executeBatch();
                }
            }
            userPs.execute();
            boolean userGroupItr = true;
            return userGroupItr;
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)"");
            }
            logger.error((Object)("============================DBS:delete error" + e));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (userPs != null) {
                    userPs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUserFunc(Connection conn) {
        DBUserBean dbDeleteUserBean = (DBUserBean)this.operateMap.get((Object)OPT.DELETEDUSER_OPT);
        DBUserBean dbForbiddenUserBean = (DBUserBean)this.operateMap.get((Object)OPT.FORBIDDENUSER_OPT);
        PreparedStatement ps = null;
        try {
            if (dbDeleteUserBean != null) {
                ps = conn.prepareStatement(this.sqlMap.get((Object)OPT.DELETEDUSER_OPT));
                ps.setBoolean(1, dbDeleteUserBean.getState());
            } else if (dbForbiddenUserBean != null) {
                ps = conn.prepareStatement(this.sqlMap.get((Object)OPT.FORBIDDENUSER_OPT));
                ps.setBoolean(1, dbForbiddenUserBean.getState());
            }
            if (ps.executeUpdate() > 0) {
                this.updateFunc(conn);
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)("============================DBS:setUserFunc ERROR" + e1));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (!conn.isClosed()) {
                    ps.close();
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"");
            }
        }
        return true;
    }

    class DBOptThread
    implements Callable<Boolean> {
        String dataSourceAIS;

        public DBOptThread(String dataSourceAIS) {
            this.dataSourceAIS = dataSourceAIS;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                Connection conn = DbConnector.getConnection((String)this.dataSourceAIS);
                return LicenseDBExecHelper.this.exec(conn);
            }
            catch (BOSException e) {
                return false;
            }
        }
    }

    private static enum OPT {
        UPDATE_OPT,
        INSERT_OPT,
        DELETE_PT,
        UPDATE_STATE_OPT,
        DELETEDUSER_OPT,
        FORBIDDENUSER_OPT;

    }
}

