/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.INumberSign;
import com.kingdee.eas.base.permission.INumberSignUserMap;
import com.kingdee.eas.base.permission.NumberSignCollection;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignFactory;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.NumberSignUserMapCollection;
import com.kingdee.eas.base.permission.NumberSignUserMapFactory;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.numbersign.imp.BatchSignHelper;
import com.kingdee.eas.base.permission.numbersign.imp.GoldGridSignHelper;
import com.kingdee.eas.base.permission.numbersign.imp.SignParamHelper;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectDataInfo;
import com.kingdee.eas.base.permission.util.LogUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class NumberImageSignService {
    private static final Logger logger = CoreUIObject.getLogger(NumberImageSignService.class);
    private Map paramMap = null;

    private INumberSign getNumberSignBizInterface(Context ctx) throws NumberSignException {
        INumberSign iNumberSign = null;
        try {
            iNumberSign = ctx == null ? NumberSignFactory.getRemoteInstance() : NumberSignFactory.getLocalInstance(ctx);
            return iNumberSign;
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public void batchSign(Context ctx, Component owner, IObjectPK userId, List batchSignList) throws NumberSignException {
        if (batchSignList == null || batchSignList.isEmpty()) {
            logger.error((Object)"batchSignList is null");
            throw new IllegalArgumentException("batchSignList is null");
        }
        try {
            GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
            if (this.isStartCert(ctx)) {
                String certStr = helper.getCertStr();
                this.checkCurUserRight(null, certStr);
            }
            BatchSignHelper batchSign = new BatchSignHelper();
            NumberSignCollection numberSignCol = batchSign.batchSign(ctx, userId, batchSignList);
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            iNumberSign.addnew(numberSignCol);
            logger.info((Object)"signInfo id after save over:");
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public NumberSignInfo sign(Context ctx, Component owner, IObjectValue iVo, IObjectPK userId, NumberSignInfo numberSignInfo) throws NumberSignException {
        try {
            GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
            if (this.isStartCert(ctx)) {
                String certStr = helper.getCertStr();
                this.checkCurUserRight(null, certStr);
            }
            NumberSignInfo signInfo = helper.getDefault(userId, numberSignInfo);
            signInfo.setId(BOSUuid.create((BOSObjectType)signInfo.getBOSType()));
            logger.info((Object)("signInfo id is:" + signInfo.getId()));
            signInfo.setSignInfo(helper.sign(iVo, signInfo.getId().toString()));
            signInfo.setBoId(iVo.get(iVo.getPKField()).toString());
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            IObjectPK signInfoId = iNumberSign.addnew(signInfo);
            signInfo.setId(BOSUuid.read((String)signInfoId.toString()));
            logger.info((Object)("signInfo id after save is:" + signInfo.getId()));
            return signInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (Exception e) {
            logger.error((Object)"permission error!", (Throwable)e);
            if ("goldgrid_server_error".equals(e.getMessage())) {
                throw new NumberSignException(NumberSignException.GOLDGRID_SERVER_ERROR);
            }
            throw new NumberSignException(NumberSignException.SIGN_FAIL);
        }
    }

    public NumberSignInfo saveSignInfo(Context ctx, Component owner, BOSUuid signInfoId, BOSUuid bizObjPK, String signImageInfoStr, IObjectPK userId, NumberSignInfo inputSignInfo, String certStr) throws NumberSignException {
        this.checkCurUserRight(ctx, certStr);
        GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
        NumberSignInfo signInfo = helper.getDefault(userId, inputSignInfo);
        signInfo.setId(signInfoId);
        logger.info((Object)("signInfo id is:" + signInfo.getId()));
        BASE64Decoder base = new BASE64Decoder();
        try {
            signInfo.setSignInfo(base.decodeBuffer(signImageInfoStr));
        }
        catch (Exception e) {
            logger.error((Object)"permission error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.SIGN_FAIL);
        }
        signInfo.setBoId(bizObjPK.toString());
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            IObjectPK newSignInfoId = iNumberSign.addnew(signInfo);
            signInfo.setId(BOSUuid.read((String)newSignInfoId.toString()));
            logger.info((Object)("signInfo id after save is:" + signInfo.getId()));
            return signInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public void saveBatchSignInfo(Context ctx, String signInfoIdStr, String bizObjInfoStr, String signImageInfoStr, IObjectPK userId, String certStr) throws NumberSignException {
        this.checkCurUserRight(ctx, certStr);
        GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
        String[] signIdAry = signInfoIdStr.split(";");
        String[] bizObjInfoAry = bizObjInfoStr.split(";");
        String[] signImageInfoStrAry = signImageInfoStr.split(";");
        if (signIdAry == null || signIdAry.length == 0) {
            throw new IllegalArgumentException(" not found signInfoIdStr!");
        }
        NumberSignCollection numberSignCol = new NumberSignCollection();
        for (int i = 0; i < signIdAry.length; ++i) {
            NumberSignInfo signInfo = helper.getDefault(userId, null);
            signInfo.setId(BOSUuid.read((String)signIdAry[i]));
            logger.info((Object)("signInfo id is:" + signInfo.getId()));
            BASE64Decoder base = new BASE64Decoder();
            try {
                signInfo.setSignInfo(base.decodeBuffer(signImageInfoStrAry[i]));
            }
            catch (Exception e) {
                logger.error((Object)"permission error!", (Throwable)e);
                throw new NumberSignException(NumberSignException.SIGN_FAIL);
            }
            signInfo.setBoId(bizObjInfoAry[i]);
            numberSignCol.add(signInfo);
        }
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            iNumberSign.addnew(numberSignCol);
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public Image getImageFromSignInfo(byte[] imageInfo) throws NumberSignException {
        try {
            return ImageIO.read(new ByteArrayInputStream(imageInfo));
        }
        catch (IOException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.PIC_SWITCH_ERROR);
        }
    }

    public Image findSignInfoNoVerify(IObjectPK boId, IObjectPK userId) throws NumberSignException {
        return this.findSignInfoNoVerify(null, boId, userId);
    }

    public Image findSignInfoNoVerify(Context ctx, IObjectPK boId, IObjectPK userId) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            String oqlStr = "where userId.id ='" + userId + "' and boid = '" + boId.toString() + "'  order by lastupdatetime desc ";
            NumberSignCollection numberCol = iNumberSign.getNumberSignCollection(oqlStr);
            if (numberCol != null && !numberCol.isEmpty()) {
                NumberSignInfo numberSignInfo = numberCol.get(0);
                return this.getImageFromSignInfo(numberSignInfo.getSignInfo());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
        }
        return null;
    }

    public NumberSignCollection findSignInfoNoVerify(Context ctx, String oql) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            NumberSignCollection numberCol = iNumberSign.getNumberSignCollection(oql);
            return numberCol;
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public NumberSignCollection findSignInfoNoVerify(IObjectPK boId) throws NumberSignException {
        Context ctx = null;
        return this.findSignInfoNoVerify(ctx, boId);
    }

    public NumberSignCollection findSignInfoNoVerify(Context ctx, IObjectPK boId) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            String oqlStr = "select *, userId.id, userId.name, userId.number  where boid = '" + boId.toString() + "'  order by lastupdatetime desc ";
            return iNumberSign.getNumberSignCollection(oqlStr);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            return null;
        }
    }

    public boolean verifySign(IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        boolean res = this.verifySign(null, signInfoId, iVo);
        return res;
    }

    public boolean verifySign(Context ctx, IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        try {
            GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
            return helper.verifySign(iVo, signInfoId.toString());
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
        catch (Exception e) {
            if ("goldgrid_server_error".equals(e.getMessage())) {
                throw new NumberSignException(NumberSignException.GOLDGRID_SERVER_ERROR);
            }
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
    }

    public Image findSignInfoVerify(IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        return this.findSignInfoVerify(null, signInfoId, iVo);
    }

    public byte[] findByteSignInfoVerify(IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        return this.findByteSignInfoVerify(null, signInfoId, iVo);
    }

    public Image findSignInfoVerify(Context ctx, IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        return this.getImageFromSignInfo(this.findByteSignInfoVerify(ctx, signInfoId, iVo));
    }

    public byte[] findByteSignInfoVerify(Context ctx, IObjectPK signInfoId, IObjectValue iVo) throws NumberSignException {
        try {
            GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
            if (this.verifySign(signInfoId, iVo)) {
                INumberSign iNumberSign = NumberSignFactory.getRemoteInstance();
                NumberSignInfo signInfo = iNumberSign.getNumberSignInfo(signInfoId);
                if (signInfo == null || signInfo.getSignInfo() == null) {
                    throw new NumberSignException(NumberSignException.NOT_FOUND);
                }
                return signInfo.getSignInfo();
            }
            return helper.getDefaultVerifyErrorImage();
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
    }

    public Map findImageBySignInfoIdNoVerify(List signInfoIdStrList) throws NumberSignException {
        return this.findImageBySignInfoIdNoVerify(null, signInfoIdStrList);
    }

    public Map findImageBySignInfoIdNoVerify(Context ctx, List signInfoIdStrList) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            String oqlStr = "where id in(" + ToolUtils.aryToStr(signInfoIdStrList, true) + ")";
            NumberSignCollection numberCol = iNumberSign.getNumberSignCollection(oqlStr);
            HashMap<String, Image> retMap = new HashMap<String, Image>();
            for (int i = 0; i < numberCol.size(); ++i) {
                NumberSignInfo numberSignInfo = numberCol.get(i);
                retMap.put(numberSignInfo.getId().toString(), this.getImageFromSignInfo(numberSignInfo.getSignInfo()));
            }
            return retMap;
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public Map findSignInfoBySignInfoIdNoVerify(Context ctx, List signInfoIdStrList) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            String oqlStr = "where id in(" + ToolUtils.aryToStr(signInfoIdStrList, true) + ")";
            NumberSignCollection numberCol = iNumberSign.getNumberSignCollection(oqlStr);
            HashMap<String, NumberSignInfo> retMap = new HashMap<String, NumberSignInfo>();
            for (int i = 0; i < numberCol.size(); ++i) {
                NumberSignInfo numberSignInfo = numberCol.get(i);
                retMap.put(numberSignInfo.getId().toString(), numberSignInfo);
            }
            return retMap;
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public Image getSignInfoImageByWorkFlowInfo(NumberSignCollection numberCol, String assignmentId, String procInstId, String actInstId) throws NumberSignException {
        if (numberCol == null || numberCol.isEmpty() || assignmentId == null && procInstId == null && actInstId == null) {
            return null;
        }
        for (int i = 0; i < numberCol.size(); ++i) {
            NumberSignInfo numberSignInfo = numberCol.get(i);
            if (assignmentId != null && !assignmentId.equals(numberSignInfo.getTaskId()) || procInstId != null && !procInstId.equals(numberSignInfo.getFlowInstanceId()) || actInstId != null && !actInstId.equals(numberSignInfo.getActiveInstanceId())) continue;
            return this.getImageFromSignInfo(numberSignInfo.getSignInfo());
        }
        return null;
    }

    public NumberSignInfo getSignInfoByWorkFlowInfo(Context ctx, String boId, String assignmentId, String procInstId, String actInstId) throws NumberSignException {
        if (StringUtils.isEmpty((String)boId) && StringUtils.isEmpty((String)assignmentId) && StringUtils.isEmpty((String)procInstId) && StringUtils.isEmpty((String)actInstId)) {
            return null;
        }
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            Object image = null;
            StringBuffer oqlStr = new StringBuffer("where ");
            if (!StringUtils.isEmpty((String)boId)) {
                oqlStr.append(" boId = '");
                oqlStr.append(boId);
                oqlStr.append("' and");
            }
            if (!StringUtils.isEmpty((String)assignmentId)) {
                oqlStr.append(" taskId = '");
                oqlStr.append(assignmentId);
                oqlStr.append("' and ");
            }
            if (!StringUtils.isEmpty((String)procInstId)) {
                oqlStr.append(" flowInstanceId = '");
                oqlStr.append(procInstId);
                oqlStr.append("' and ");
            }
            if (!StringUtils.isEmpty((String)actInstId)) {
                oqlStr.append(" activeInstanceId = '");
                oqlStr.append(actInstId);
                oqlStr.append("' and ");
            }
            oqlStr.delete(oqlStr.lastIndexOf("and"), oqlStr.length());
            return iNumberSign.getNumberSignInfo(oqlStr.toString());
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.VERIFY_ERROR);
        }
    }

    public void delete(Context ctx, String oql) throws NumberSignException {
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            iNumberSign.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public void deleteSignInfo(IObjectPK signInfoId, IObjectPK boId) throws NumberSignException {
        this.deleteSignInfo(null, signInfoId, boId);
    }

    public void deleteSignInfo(Context ctx, IObjectPK signInfoId, IObjectPK boId) throws NumberSignException {
        if (signInfoId == null && boId == null) {
            throw new IllegalArgumentException("signInfoId and boId both is null");
        }
        try {
            INumberSign iNumberSign = this.getNumberSignBizInterface(ctx);
            String oqlStr = "";
            if (signInfoId != null) {
                oqlStr = oqlStr + "id = '" + signInfoId + "'";
            }
            if (boId != null) {
                oqlStr = oqlStr + " and  boid = '" + boId + "'";
            }
            if (oqlStr.startsWith(" and")) {
                oqlStr = oqlStr.substring(4);
            }
            oqlStr = " where " + oqlStr;
            logger.info((Object)(" oql is:" + oqlStr));
            iNumberSign.delete(oqlStr);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
    }

    public boolean isStartNumberSign(Context ctx) throws NumberSignException {
        Map resMap = this.getNumberSignParam(ctx);
        return "true".equalsIgnoreCase((String)resMap.get("NUMBER_SIGN_ENABLE"));
    }

    public boolean isStartNumberSign(Context ctx, String bosType) throws NumberSignException {
        if (StringUtils.isEmpty((String)bosType)) {
            logger.info((Object)"bosTpe is null");
            return false;
        }
        Map resMap = this.getNumberSignParam(ctx);
        if (!"true".equalsIgnoreCase((String)resMap.get("NUMBER_SIGN_ENABLE"))) {
            logger.info((Object)"NUMBER_SIGN_ENABLE is set false");
            return false;
        }
        String bosTypeStr = (String)resMap.get("NUMBER_SIGN_BILL_BOSTYPE");
        if (StringUtils.isEmpty((String)bosTypeStr)) {
            logger.info((Object)"NUMBER_SIGN_BILL_BOSTYPE is not set in permparam.property!");
            return false;
        }
        if (bosTypeStr.indexOf(bosType) == -1) {
            logger.info((Object)LogUtil.filterLogForging(" bosTypeStr not include this bostype , all surpport bosType is :" + bosTypeStr + " this bostype is:" + bosType));
            return false;
        }
        return true;
    }

    private Map getNumberSignParam(Context ctx) throws NumberSignException {
        if (this.paramMap != null) {
            return this.paramMap;
        }
        SignParamHelper helper = new SignParamHelper(ctx);
        return helper.getNumberSignParam();
    }

    public boolean isStartNumberSign(Context ctx, IObjectPK userPK) throws NumberSignException {
        if (!this.isStartNumberSign(ctx)) {
            return false;
        }
        INumberSignUserMap iNumberSignUser = null;
        try {
            iNumberSignUser = ctx == null ? NumberSignUserMapFactory.getRemoteInstance() : NumberSignUserMapFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.OPERATOR_FAIL);
        }
        String oql = "where user.id = ('" + userPK + "') and status ='1'";
        NumberSignUserMapCollection numberSignUserCol = null;
        try {
            numberSignUserCol = iNumberSignUser.getNumberSignUserMapCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
        }
        return numberSignUserCol != null && !numberSignUserCol.isEmpty();
    }

    public String getBatchProtectInfo(Context ctx, List batchSignList) throws NumberSignException {
        BatchSignHelper helper = new BatchSignHelper();
        SignProtectDataInfo proData = helper.getProtectData(ctx, batchSignList);
        return proData.getBatchSignXmlInfo();
    }

    public String getProtectInfo(Context ctx, IObjectValue iVo) throws BOSException, EASBizException {
        GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
        return helper.getProtectInfo(iVo);
    }

    private X509Certificate conver(String certStr) throws NumberSignException {
        if (StringUtils.isEmpty((String)certStr)) {
            throw new NumberSignException(NumberSignException.USER_NOT_RIGHT);
        }
        try {
            BASE64Decoder base = new BASE64Decoder();
            ByteArrayInputStream input = null;
            byte[] arr = base.decodeBuffer(certStr);
            input = new ByteArrayInputStream(arr);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(input);
        }
        catch (Exception e) {
            logger.error((Object)"read cert error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.USER_NOT_RIGHT);
        }
    }

    public boolean isStartCert(Context ctx) throws NumberSignException {
        Map usbkeyMap = this.getNumberSignParam(ctx);
        String checkUsbkey = (String)usbkeyMap.get("NUMBER_SIGN_ENALBE_CHECKUSBKEY");
        if (StringUtils.isEmpty((String)checkUsbkey) || !checkUsbkey.equalsIgnoreCase("true")) {
            logger.info((Object)"check usbkey is not right! NUMBER_SIGN_ENALBE_CHECKUSBKEY set false");
            return false;
        }
        return true;
    }

    public void checkCurUserRight(Context ctx, String certObj) throws NumberSignException {
        if (!this.isStartCert(ctx)) {
            return;
        }
        logger.info((Object)(" cert obj is:" + certObj));
        if (certObj == null) {
            logger.info((Object)"certObj is null");
            throw new NumberSignException(NumberSignException.USER_NOT_RIGHT);
        }
        X509Certificate gaX509Cert = this.conver(certObj);
        String tempDN = gaX509Cert.getSubjectDN().toString();
        String[] strDN = tempDN.split(",");
        String strIdCard = "";
        for (int i = 0; i < strDN.length; ++i) {
            if (strDN[i].toUpperCase().indexOf("CN=") < 0) continue;
            String strXm = strDN[i];
            String[] strXM = strXm.split("=");
            strIdCard = strXM[1].substring(strXM[1].indexOf(" ") + 1);
            strIdCard = strIdCard.trim();
            break;
        }
        logger.info((Object)("cur user card number is:" + strIdCard));
        if (strIdCard.length() == 15) {
            strIdCard = this.getNewId(strIdCard);
        }
        String sysUserNumber = null;
        sysUserNumber = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getNumber() : ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
        logger.info((Object)(" sysUserNumber is:" + sysUserNumber));
        if (!strIdCard.equals(sysUserNumber)) {
            logger.error((Object)(" strIdCard and sysUserNumber is not right! usbkey number is:" + strIdCard + " sysUserNumber :" + sysUserNumber));
            throw new NumberSignException(NumberSignException.USER_NOT_RIGHT);
        }
        logger.info((Object)("\n\n\n" + new Date() + " " + PermissionResUtil.getResource("res_125") + strIdCard));
    }

    public String getNewId(String id) {
        int[] W = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        String[] A = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        int s = 0;
        String newid = id;
        newid = newid.substring(0, 6) + "19" + newid.substring(6, id.length());
        for (int i = 0; i < newid.length(); ++i) {
            int j = Integer.parseInt(newid.substring(i, i + 1)) * W[i];
            s += j;
        }
        newid = newid + A[s %= 11];
        return newid;
    }
}

