/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.NumberSignCollection;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.numbersign.BatchSignInfo;
import com.kingdee.eas.base.permission.numbersign.imp.BatchSignTest;
import com.kingdee.eas.base.permission.numbersign.imp.GoldGridSignHelper;
import com.kingdee.eas.base.permission.numbersign.imp.SignParamHelper;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectData;
import com.kingdee.eas.base.permission.numbersign.imp.SignProtectDataInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchSignHelper {
    private static final Logger logger = CoreUIObject.getLogger(BatchSignHelper.class);

    public NumberSignCollection batchSign(Context ctx, IObjectPK userId, List batchSignList) throws NumberSignException {
        SignParamHelper testhelper = new SignParamHelper(ctx);
        if (!testhelper.isTrue4Param("NUMBER_SIGN_ENALBE_BATCH")) {
            logger.warn((Object)"......... batch param not set , use test program!!!!!!!!!");
            BatchSignTest batchTest = new BatchSignTest();
            return batchTest.batchSign(ctx, userId, batchSignList);
        }
        for (int i = 0; i < batchSignList.size(); ++i) {
            BatchSignInfo batchSignInfo = (BatchSignInfo)batchSignList.get(i);
            if (batchSignInfo.getIVo() == null) {
                throw new IllegalArgumentException("batchSignInfo.getIVo() is null!");
            }
            GoldGridSignHelper helper = new GoldGridSignHelper(ctx);
            batchSignInfo.setNumberSignInfo(helper.getDefault(userId, batchSignInfo.getNumberSignInfo()));
            NumberSignInfo signInfo = batchSignInfo.getNumberSignInfo();
            signInfo.setId(BOSUuid.create((BOSObjectType)signInfo.getBOSType()));
            signInfo.setBoId(batchSignInfo.getIVo().get(batchSignInfo.getIVo().getPKField()).toString());
        }
        SignProtectDataInfo protectData = this.getProtectData(ctx, batchSignList);
        logger.info((Object)(" protectStr is:" + protectData.getBatchSignXmlInfo()));
        Map signInfoMap = new HashMap();
        try {
            GoldGridSignHelper gridHelper = new GoldGridSignHelper(ctx);
            signInfoMap = gridHelper.batchSign(protectData, batchSignList);
        }
        catch (Exception e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.SIGN_FAIL);
        }
        if (signInfoMap == null || signInfoMap.isEmpty()) {
            logger.error((Object)"not get any batch sign info ,cancel this sign!");
            throw new NumberSignException(NumberSignException.BATCHSIGN_ERROR);
        }
        NumberSignCollection numberSignCol = new NumberSignCollection();
        for (int i = 0; i < batchSignList.size(); ++i) {
            BatchSignInfo batchSignInfo = (BatchSignInfo)batchSignList.get(i);
            NumberSignInfo signInfo = batchSignInfo.getNumberSignInfo();
            if (signInfoMap.containsKey(signInfo.getId().toString())) {
                signInfo.setSignInfo((byte[])signInfoMap.get(signInfo.getId().toString()));
            }
            numberSignCol.add(signInfo);
        }
        return numberSignCol;
    }

    public SignProtectDataInfo getProtectData(Context ctx, List batchSignList) throws NumberSignException {
        try {
            SignProtectDataInfo signProtectDataInfo = new SignProtectDataInfo();
            SignProtectData signData = new SignProtectData();
            StringBuffer sb = new StringBuffer("<?xml version='1.0' encoding='GB2312' standalone='yes'?>");
            sb.append("<Signatures>");
            for (int i = 0; i < batchSignList.size(); ++i) {
                BatchSignInfo batchSignInfo = (BatchSignInfo)batchSignList.get(i);
                String docId = batchSignInfo.getNumberSignInfo().getId().toString();
                IObjectValue iVo = batchSignInfo.getIVo();
                sb.append("<Signature DocumentId='" + batchSignInfo.getNumberSignInfo().getId().toString() + "'>");
                sb.append(signData.getProtectInfoNoHeader(ctx, iVo));
                sb.append("</Signature>");
                signProtectDataInfo.addSignProtectData(docId, signData.getProtectInfo(ctx, iVo));
            }
            sb.append("</Signatures>");
            signProtectDataInfo.setBatchSignXmlInfo(sb.toString());
            return signProtectDataInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.SIGN_FAIL);
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            throw new NumberSignException(NumberSignException.SIGN_FAIL);
        }
    }
}

