/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.INumberSign;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignFactory;
import com.kingdee.eas.base.permission.numbersign.NeedSignFieldInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

public class SignProtectData {
    private static final Logger logger = CoreUIObject.getLogger(SignProtectData.class);

    public List getFieldList(Context ctx, IObjectValue iVo) throws BOSException, EASBizException {
        INumberSign iNumberSign = null;
        iNumberSign = ctx == null ? NumberSignFactory.getRemoteInstance() : NumberSignFactory.getLocalInstance(ctx);
        return iNumberSign.getNeedSignFiledInfoByBosType(iVo);
    }

    public String getProtectInfo(Context ctx, IObjectValue iVo) throws BOSException, EASBizException {
        List fieldList = this.getFieldList(ctx, iVo);
        if (fieldList == null || fieldList.isEmpty()) {
            logger.error((Object)("NumberSign.getNeedSignFiledInfoByBosType(iVo) is null! " + iVo + "\n botype is:" + iVo.getBOSType()));
            throw new NumberSignException(NumberSignException.DONT_DEFINE_SIGN_DATA);
        }
        StringBuffer FIELDXML = new StringBuffer("<?xml version='1.0' encoding='GB2312' standalone='yes'?>");
        FIELDXML.append("<Signature>");
        for (int i = 0; i < fieldList.size(); ++i) {
            NeedSignFieldInfo fieldInfo = (NeedSignFieldInfo)fieldList.get(i);
            FIELDXML.append(this.getOneFiled(fieldInfo));
        }
        FIELDXML.append("</Signature>");
        return FIELDXML.toString();
    }

    public String getProtectInfoNoHeader(Context ctx, IObjectValue iVo) throws BOSException, EASBizException {
        List fieldList = this.getFieldList(ctx, iVo);
        if (fieldList == null || fieldList.isEmpty()) {
            logger.error((Object)("NumberSign.getNeedSignFiledInfoByBosType(iVo) is null! " + iVo + "\n botype is:" + iVo.getBOSType()));
            throw new NumberSignException(NumberSignException.DONT_DEFINE_SIGN_DATA);
        }
        StringBuffer FIELDXML = new StringBuffer("");
        for (int i = 0; i < fieldList.size(); ++i) {
            NeedSignFieldInfo fieldInfo = (NeedSignFieldInfo)fieldList.get(i);
            FIELDXML.append(this.getOneFiled(fieldInfo));
        }
        return FIELDXML.toString();
    }

    private String getOneFiled(NeedSignFieldInfo fieldInfo) {
        StringBuffer res = new StringBuffer("");
        res = res.append("<Field>").append("<Field Index='Caption'>").append(this.convert(fieldInfo.getAlias())).append("</Field>").append("<Field Index='ID'>").append(this.convert(fieldInfo.getName())).append("</Field>").append("<Field Index='VALUE'>").append(this.convert(fieldInfo.getValue())).append("</Field>").append("<Field Index='ProtectItem'>TRUE</Field>").append("</Field>");
        return res.toString();
    }

    private String convert(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "NULL";
        }
        if (str.indexOf(".00") != -1) {
            return StringUtils.replace((String)str, (String)".00", (String)"");
        }
        try {
            BigDecimal big = new BigDecimal(str);
            big = big.setScale(4, 2);
            return big.toString();
        }
        catch (Exception e) {
            logger.info((Object)("str is not number , return str :" + str));
            return str;
        }
    }
}

