/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.cloud;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class LicenseUpdaterService {
    private Context ctx = null;
    private boolean isServer = true;
    private static Logger logger = Logger.getLogger(LicenseUpdaterService.class);

    private LicenseUpdaterService() {
    }

    public static LicenseUpdaterService newRemoteInstance() {
        LicenseUpdaterService service = new LicenseUpdaterService();
        service.isServer = false;
        return service;
    }

    public static LicenseUpdaterService newLocalInstance(Context ctx) {
        LicenseUpdaterService service = new LicenseUpdaterService();
        service.isServer = true;
        service.ctx = ctx;
        return service;
    }

    private ICloudRegistSrv getCloudRegistSrv() throws LicenseException {
        ICloudRegistSrv iCloudRegistSrv = null;
        iCloudRegistSrv = this.isServer ? CloudRegistSrvAgentFactory.getLocalInstance((Context)this.ctx) : CloudRegistSrvAgentFactory.getRemoteInstance();
        return iCloudRegistSrv;
    }

    private ILicenseSrv getLicenseSrv() throws LicenseException {
        Object iLicenseSrv = null;
        iLicenseSrv = this.isServer ? LicenseSrvFactory.getInstance() : LicenseSrvAgentFactory.getRemoteInstance();
        return iLicenseSrv;
    }

    public void updateLicense() throws LicenseException {
        String downLicPath = null;
        String fileId = null;
        try {
            downLicPath = this.downloadLicenseFile();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new LicenseException("downLoad license fail\uff01", (Throwable)e);
        }
        try {
            fileId = this.uploadLicenseFile(downLicPath);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new LicenseException("upload license fail\uff01", (Throwable)e);
        }
        try {
            String result = this.getCloudRegistSrv().getRebelLicenseStatus(fileId);
            JSONObject rtjson = JSONObject.parseObject((String)result);
            boolean success = rtjson.getBoolean("success");
            if (!success) {
                throw new LicenseException("license resolve fail! , reason:" + rtjson.getString("msg"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new LicenseException("license resolve fail\uff01", (Throwable)e);
        }
    }

    public String downloadLicenseFile() throws BOSException {
        try {
            ILicenseSrv agent = this.getLicenseSrv();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String prod_inst_code = baseInfo.getProductInstanceID();
            File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
            System.out.println("path=" + file.getPath());
            if (2 == baseInfo.getLicenseType()) {
                EasCloud.downloadLicenseKBC((String)prod_inst_code, (String)file.getPath());
            } else {
                EasCloud.downloadLicense((String)prod_inst_code, (String)file.getPath());
            }
            System.out.println("******download over***");
            return file.getPath();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public String uploadLicenseFile(String licenseFilePath) throws BOSException {
        String fileId = String.valueOf(System.currentTimeMillis());
        InputStream input = null;
        try {
            String fileName = licenseFilePath;
            String extName = ".zip";
            if (!StringUtils.isEmpty((String)fileName)) {
                if ((fileName = fileName.toLowerCase()).lastIndexOf(".dat") != -1) {
                    extName = fileName.substring(fileName.lastIndexOf(".dat"));
                } else if (fileName.lastIndexOf(".lic") != -1) {
                    extName = fileName.substring(fileName.lastIndexOf(".lic"));
                }
            }
            input = new BufferedInputStream(new FileInputStream(licenseFilePath));
            int position = 0;
            int readSize = 0x500000;
            int totalSize = input.available();
            readSize = readSize < totalSize ? readSize : totalSize;
            ICloudRegistSrv irs = this.getCloudRegistSrv();
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                irs.uploadCloudLicenseFile(fileId, bf, extName);
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
        }
        return fileId;
    }

    public static void main(String[] args) {
        LicenseUpdaterService.newRemoteInstance();
    }
}

