/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyControl;
import com.kingdee.eas.base.permission.service.helper.UsbKeyControlImpl;
import com.kingdee.eas.base.permission.service.helper.UsbKeyCtxHelper;
import com.kingdee.eas.base.permission.service.helper.ekey.EUsbKeyBaseOperatorImpl;
import com.kingdee.eas.base.permission.service.helper.usbkeyimpl.UsbKeyOperatorImpl;
import com.kingdee.eas.base.permission.service.helper.usbkeyimpl.UsbKeyTest;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UsbKeyProxy {
    private static Logger logger = Logger.getLogger(UsbKeyProxy.class);
    IUsbKeyControl iUsbKey = null;

    public void write(String content) throws UsbKeyException {
        this.init();
        this.iUsbKey.write(content);
    }

    public String read(int length) throws UsbKeyException {
        this.init();
        return this.iUsbKey.read(length);
    }

    private void init() throws UsbKeyException {
        if (!UsbKeyCtxHelper.isNeedUsbKeyPerm()) {
            this.iUsbKey = UsbKeyTest.getInstance();
            return;
        }
        String usbKeyTest = UsbKeyCtxHelper.getUsbkeyImp();
        if (!StringUtils.isEmpty((String)usbKeyTest) && usbKeyTest.equalsIgnoreCase("TEST")) {
            this.iUsbKey = UsbKeyTest.getInstance();
        } else if (!StringUtils.isEmpty((String)usbKeyTest) && usbKeyTest.equalsIgnoreCase("EKEY")) {
            UsbKeyControlImpl iUsbKeyContolExt = new UsbKeyControlImpl();
            iUsbKeyContolExt.setFileNo(9);
            iUsbKeyContolExt.setUsbKeyBaseOperator(new EUsbKeyBaseOperatorImpl());
            this.iUsbKey = iUsbKeyContolExt;
        } else if (!StringUtils.isEmpty((String)usbKeyTest)) {
            IUsbKeyBaseOperator operImp = UsbKeyCtxHelper.getUserCustermUsbKeyImpl(usbKeyTest);
            UsbKeyControlImpl iUsbKeyContolExt = new UsbKeyControlImpl();
            iUsbKeyContolExt.setFileNo(9);
            iUsbKeyContolExt.setUsbKeyBaseOperator(operImp);
            this.iUsbKey = iUsbKeyContolExt;
        } else {
            this.iUsbKey = new UsbKeyOperatorImpl();
        }
    }
}

