/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.util.cloud.ShrCloud;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class PagingExecuteHandler {
    private Context ctx = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.util.cloud.PagingExecuteHandler");

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public final String exec(List<CloudUserInfo> pagingData) throws EASBizException, BOSException {
        String sync_id = System.currentTimeMillis() + String.format("%03d", new AtomicLong().incrementAndGet());
        int is_finish = 1;
        StringBuilder result = new StringBuilder();
        String res = "";
        boolean isExistsSuccess = false;
        result.append(" [ProductInstanceID] : " + ShrCloud.getProductInstanceID(this.ctx)).append("\n");
        result.append(" [exec operate is] : " + this.getClass().getName()).append("\n");
        result.append(" [exec start time] : " + this.formatDate(new Date())).append("\n");
        result.append(" [operate data is] : " + pagingData.size()).append("\n");
        logger.error((Object)("PagingExcuteHandler.exec:pagingData size = " + pagingData.size()));
        if (100 < pagingData.size()) {
            int pageNumber = 100;
            int totalCount = pagingData.size();
            int totalPage = totalCount / pageNumber;
            if (totalCount % pageNumber > 0) {
                ++totalPage;
            }
            for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                int fromIndex = pageNo * pageNumber;
                int toIndex = (pageNo + 1) * pageNumber;
                if (toIndex > totalCount) {
                    toIndex = totalCount;
                }
                logger.error((Object)"PagingExcuteHandler.exec:pagingData.subList");
                List<CloudUserInfo> pageData = pagingData.subList(fromIndex, toIndex);
                long startTime = System.currentTimeMillis();
                if (toIndex == totalCount) {
                    is_finish = 2;
                }
                String execResult = this.execSync(this.ctx, result, pageNo, pageData, startTime, sync_id, is_finish);
                long endTime = System.currentTimeMillis();
                if (execResult.toLowerCase().contains("access denied")) {
                    result.append(" [execute result error ] : Access denied \n");
                    result.append(" [exec end time] :" + this.formatDate(new Date()));
                    SynShrUserToCloudUtils.writeSyncLog(this.ctx, result.toString());
                    return res.toString();
                }
                if (String.valueOf(0).equals(SynShrUserToCloudUtils.getReturnErrcode(execResult))) {
                    isExistsSuccess = true;
                }
                res = execResult;
                result.append(" [execute page  : " + pageNo + " ]");
                result.append(" [execute result errorcode ] : " + SynShrUserToCloudUtils.getReturnErrcode(execResult)).append("\n");
                result.append(" [execute result des ] : " + SynShrUserToCloudUtils.getReturnDes(execResult)).append("\n");
            }
        } else {
            long startTime = System.currentTimeMillis();
            logger.error((Object)"PagingExcuteHandler.exec:retryExecSync");
            is_finish = 2;
            String nonce = this.execSync(this.ctx, result, 1, pagingData, startTime, sync_id, is_finish);
            if (nonce.toLowerCase().contains("access denied")) {
                result.append(" [execute result error ] : Access denied \n");
            } else {
                if (String.valueOf(0).equals(SynShrUserToCloudUtils.getReturnErrcode(nonce))) {
                    isExistsSuccess = true;
                }
                res = nonce;
                result.append(" [execute result errorcode ] : " + SynShrUserToCloudUtils.getReturnErrcode(nonce)).append("\n");
                result.append(" [execute result des ] : " + SynShrUserToCloudUtils.getReturnDes(nonce)).append("\n");
            }
        }
        result.append(" [exec end time] :" + this.formatDate(new Date()));
        return res;
    }

    public static void main(String[] args) {
        String cc = System.currentTimeMillis() + String.format("%03d", new AtomicLong().incrementAndGet());
        System.out.println(cc);
        System.out.println(new AtomicLong().incrementAndGet());
    }

    public String execSync(Context ctx, StringBuilder result, int pageNo, List<CloudUserInfo> pageData, long startTime, String sync_id, int is_finish) throws EASBizException, BOSException {
        logger.error((Object)"PagingExcuteHandler.retryExecSync:doPaging");
        String execResult = this.doPaging(pageData, sync_id, is_finish);
        logger.error((Object)("PagingExcuteHandler.retryExecSync:execResult=" + execResult));
        SynShrUserToCloudUtils.waitSyncResultToCache(ctx, execResult);
        return execResult;
    }

    abstract String doPaging(List<CloudUserInfo> var1, String var2, int var3) throws EASBizException;

    private String formatDate(Date date) {
        return SynShrUserToCloudUtils.formatDateToString(date, "yyyy-MM-dd HH:mm:ss");
    }

    private String assmbleLogFileNamePrefix(List<CloudUserInfo> pagingData) {
        CloudUserInfo userInfo;
        String defaultLogFileName = "pageData";
        if (pagingData != null && pagingData.size() > 0 && 0 == (userInfo = pagingData.get(0)).getStatus()) {
            defaultLogFileName = "disableUserPageData";
        }
        return defaultLogFileName;
    }
}

