/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.permission.IPermUIGroupMapping;
import com.kingdee.eas.base.permission.ISynShrUserToCloudFacade;
import com.kingdee.eas.base.permission.IUserFacade;
import com.kingdee.eas.base.permission.PermUIGroupMappingCollection;
import com.kingdee.eas.base.permission.PermUIGroupMappingFactory;
import com.kingdee.eas.base.permission.SynShrUserToCloudFacadeFactory;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.util.cloud.SynShrUserToCloudUtils;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncDetailResultInfo;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserSyncResultInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public final class SynShrUserToCloudHelper {
    private static final Logger logger = Logger.getLogger(SynShrUserToCloudHelper.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public static String syncShrUserToCloud(Context ctx) throws EASBizException, BOSException {
        SynShrUserToCloudUtils.clearSyncResultCacheKey();
        StringBuffer syncStr = new StringBuffer();
        List<CloudUserInfo> syncDisableUserData = SynShrUserToCloudHelper.removeDuplicates(SynShrUserToCloudHelper.assembleCloudDisableUserInfoByPage(ctx));
        String syncDisableUserStr = SynShrUserToCloudUtils.syncShrUserToCloud(ctx, syncDisableUserData);
        syncStr.append(syncDisableUserStr);
        List<CloudUserInfo> syncEnableUserData = SynShrUserToCloudHelper.removeDuplicates(SynShrUserToCloudHelper.assembleCloudEnableUserInfoByPage(ctx));
        String syncEnableUserStr = SynShrUserToCloudUtils.syncShrUserToCloud(ctx, syncEnableUserData);
        syncStr.append(syncEnableUserStr);
        SynShrUserToCloudUtils.writeCloudParamLog(ctx);
        return syncStr.toString();
    }

    public static List<CloudUserInfo> removeDuplicates(List<CloudUserInfo> syncEnableUserData) {
        ArrayList<CloudUserInfo> targetData = new ArrayList<CloudUserInfo>();
        CloudUserInfo cloudUser = null;
        HashMap<String, CloudUserInfo> m = new HashMap<String, CloudUserInfo>();
        int size = syncEnableUserData.size();
        for (int i = 0; i < size; ++i) {
            cloudUser = syncEnableUserData.get(i);
            String erp_account = cloudUser.getErp_account();
            if (m.get(erp_account) != null) continue;
            m.put(erp_account, cloudUser);
            targetData.add(cloudUser);
        }
        return targetData;
    }

    public static String syncShrUserToCloudForClient() throws EASBizException, BOSException {
        return SynShrUserToCloudFacadeFactory.getRemoteInstance().syncShrUserToCloudPaging();
    }

    public static String syncShrUserToCloudInBackground(Context ctx) throws EASBizException, BOSException {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append(" [start time]\uff1a ").append(SynShrUserToCloudUtils.formatDateToString(new java.util.Date(), "yyyy-MM-dd HH:mm:ss")).append("\n");
        String syncUserStr = SynShrUserToCloudHelper.syncShrUserToCloud(ctx);
        logBuffer.append(" [syncUserStr]\uff1a ").append(syncUserStr).append("\n");
        String licenseFilePath = SynShrUserToCloudUtils.downloadLicense(ctx);
        logBuffer.append(" [licenseFilePath]\uff1a ").append(licenseFilePath).append("\n");
        String fileId = String.valueOf(System.currentTimeMillis());
        logBuffer.append(" [fileId]\uff1a ").append(fileId).append("\n");
        boolean uploadSuccess = SynShrUserToCloudUtils.uploadLicenseFile(fileId, licenseFilePath);
        logBuffer.append(" [uploadSuccess]\uff1a ").append(uploadSuccess).append("\n");
        boolean isSuccess = SynShrUserToCloudHelper.checkUploadIsSuccess(ctx, fileId);
        logBuffer.append(" [parse License isSuccess]\uff1a ").append(isSuccess).append("\n");
        if (isSuccess) {
            int num = SynShrUserToCloudHelper.importUserFromCloud(ctx);
            logBuffer.append(" [importUserFromCloud number]\uff1a ").append(num).append("\n");
        }
        boolean isRemove = SynShrUserToCloudUtils.removeTempFile(licenseFilePath);
        logBuffer.append(" [removeTempFile is ]\uff1a ").append(licenseFilePath).append("\n");
        logBuffer.append(" [removeTempFile state ]\uff1a ").append(isRemove);
        logBuffer.append(" [end time]\uff1a ").append(SynShrUserToCloudUtils.formatDateToString(new java.util.Date(), "yyyy-MM-dd HH:mm:ss")).append("\n");
        SynShrUserToCloudUtils.writeSyncResultLog(ctx, logBuffer.toString());
        return logBuffer.toString();
    }

    public static CloudUserSyncDetailResultInfo getSyncResultInfo(Context ctx, String key) {
        String json = SynShrUserToCloudUtils.getSynResult(ctx, key);
        return (CloudUserSyncDetailResultInfo)JSONObject.parseObject((String)json, CloudUserSyncDetailResultInfo.class);
    }

    public static List<JSONObject> getSyncResultList(Context ctx) {
        ConcurrentHashMap<String, Object> cache = SynShrUserToCloudUtils.getSimpleCache();
        Set cacheKeySet = cache.keySet();
        ArrayList<JSONObject> resultTotal = new ArrayList<JSONObject>();
        for (String key : cacheKeySet) {
            resultTotal.addAll(SynShrUserToCloudHelper.assembleSyncResultData(ctx, key));
        }
        return resultTotal;
    }

    public static List<JSONObject> assembleSyncResultData(Context ctx, String key) {
        CloudUserSyncDetailResultInfo res = SynShrUserToCloudHelper.getSyncResultInfo(ctx, key);
        List<CloudUserSyncResultInfo> resultlist = res.getData();
        String json = JSONObject.toJSONString(resultlist);
        List _data = JSONObject.parseArray((String)json, JSONObject.class);
        ArrayList<JSONObject> avliableData = new ArrayList<JSONObject>();
        JSONObject o = null;
        if (_data != null) {
            int size = _data.size();
            for (int i = 0; i < size; ++i) {
                o = (JSONObject)_data.get(i);
                o.put("gender", (Object)SynShrUserToCloudHelper.convetGenderValueToAlias(o));
                o.put("status", (Object)SynShrUserToCloudHelper.convetStatusValueToAlias(o));
                o.put("is_delete", (Object)SynShrUserToCloudHelper.convetIsDeleteValueToAlias(o));
                avliableData.add(o);
            }
        }
        return avliableData;
    }

    private static String convetGenderValueToAlias(JSONObject obj) {
        int gender = Integer.parseInt(String.valueOf(obj.get((Object)"gender")));
        String alias = "";
        if (0 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"male");
        } else if (1 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"female");
        } else if (2 == gender) {
            alias = EASResource.getString((String)RESOURCE, (String)"secret");
        }
        return alias;
    }

    private static String convetStatusValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"status")));
        String alias = "";
        if (0 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"DISABLE");
        } else if (1 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"ENABLE");
        }
        return alias;
    }

    private static String convetIsDeleteValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"is_delete")));
        String alias = "";
        if (0 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"no");
        } else if (1 == status) {
            alias = EASResource.getString((String)RESOURCE, (String)"yes");
        }
        return alias;
    }

    public static boolean checkUploadIsSuccess(Context ctx, String fileId) {
        String result = SynShrUserToCloudUtils.getCloudRegistSrv(ctx).getRebelLicenseStatus(fileId);
        JSONObject o = JSONObject.parseObject((String)result);
        return o.getBoolean("success");
    }

    public static String updateCloudUserStatus(Context ctx) throws EASBizException, BOSException {
        List<CloudUserInfo> syncData = SynShrUserToCloudHelper.assembleCloudUserInfo(ctx);
        return SynShrUserToCloudUtils.updateCloudUserStatus(ctx, syncData);
    }

    public static PermUIGroupMappingCollection getPermUIGroupMapping(Context ctx) throws BOSException {
        IPermUIGroupMapping iPermUIGroupMapping = null;
        iPermUIGroupMapping = null == ctx ? PermUIGroupMappingFactory.getRemoteInstance() : PermUIGroupMappingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("permItem.id"));
        return iPermUIGroupMapping.getPermUIGroupMappingCollection(view);
    }

    public static List<CloudUserInfo> assembleCloudUserInfoByPage(Context ctx) throws BOSException {
        ISynShrUserToCloudFacade istc = SynShrUserToCloudHelper.getSynShrUserToCloudFacade(ctx);
        try {
            return istc.assembleCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CloudUserInfo> assembleCloudDisableUserInfoByPage(Context ctx) throws BOSException {
        ISynShrUserToCloudFacade istc = SynShrUserToCloudHelper.getSynShrUserToCloudFacade(ctx);
        try {
            return istc.assembleDisableCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CloudUserInfo> assembleCloudEnableUserInfoByPage(Context ctx) throws BOSException {
        ISynShrUserToCloudFacade istc = SynShrUserToCloudHelper.getSynShrUserToCloudFacade(ctx);
        try {
            return istc.assembleEnableCloudUserInfo();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String assembleCloudUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynShrUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynShrUserToCloudHelper.getUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    public static String assembleCloudDisableUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynShrUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynShrUserToCloudHelper.getDisableUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    public static String assembleCloudEnableUserInfoByPageSql(Context ctx) {
        Timestamp lastUpdateTime = SynShrUserToCloudHelper.getSynLastUpdateTime(ctx);
        String sql = SynShrUserToCloudHelper.getEnabledUserPermissionInfoSql(ctx, lastUpdateTime);
        return sql;
    }

    public static List<CloudUserInfo> doAssembleCloudUserInfoByPage(Context ctx, String sql) throws BOSException {
        ISynShrUserToCloudFacade istc = SynShrUserToCloudHelper.getSynShrUserToCloudFacade(ctx);
        ArrayList<CloudUserInfo> cloudUserInfos = new ArrayList<CloudUserInfo>();
        List<CloudUserInfo> pageCloudUsers = null;
        int pageNumber = 5000;
        int totalCount = SynShrUserToCloudUtils.getTotalCount(ctx, sql);
        int totalPage = totalCount / pageNumber;
        if (totalCount % pageNumber > 0) {
            ++totalPage;
        }
        int top = 0;
        for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
            int fromIndex = pageNo * pageNumber;
            int toIndex = (pageNo + 1) * pageNumber;
            if (toIndex > totalCount) {
                toIndex = totalCount;
            }
            top = fromIndex + toIndex;
            String pagingSql = SynShrUserToCloudUtils.assemblePagingSql(top, sql);
            String lastSql = "";
            try {
                lastSql = istc.getPagingSqlNoOptmize(pagingSql, fromIndex, toIndex);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            IRowSet rowset = SynShrUserToCloudUtils.executeQuery(ctx, lastSql);
            pageCloudUsers = SynShrUserToCloudHelper.doAssembleCloudUserByRowSet(ctx, rowset);
            if (null == pageCloudUsers) continue;
            cloudUserInfos.addAll(pageCloudUsers);
        }
        return cloudUserInfos;
    }

    public static List<CloudUserInfo> assembleCloudUserInfo(Context ctx) throws BOSException {
        ArrayList<CloudUserInfo> list = new ArrayList();
        if (ctx == null) {
            try {
                list = SynShrUserToCloudFacadeFactory.getRemoteInstance().assembleCloudUserInfo();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        } else {
            try {
                list = SynShrUserToCloudFacadeFactory.getLocalInstance(ctx).assembleCloudUserInfo();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ISynShrUserToCloudFacade getSynShrUserToCloudFacade(Context ctx) {
        ISynShrUserToCloudFacade interfacce = null;
        if (ctx == null) {
            try {
                interfacce = SynShrUserToCloudFacadeFactory.getRemoteInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                interfacce = SynShrUserToCloudFacadeFactory.getLocalInstance(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return interfacce;
    }

    public static List<CloudUserInfo> doAssembleCloudUserByRowSet(Context ctx, IRowSet rowSet) throws BOSException {
        ArrayList<CloudUserInfo> syncData = new ArrayList<CloudUserInfo>();
        JSONArray localcloudUsers = SynShrUserToCloudUtils.getCloudRegistUserInfoFromLicense(ctx);
        HashMap<String, CloudUserInfo> userMap = new HashMap<String, CloudUserInfo>();
        try {
            while (rowSet.next()) {
                String userId = rowSet.getString("userId");
                String group = rowSet.getString("groupName");
                if (null == userMap.get(userId)) {
                    CloudUserInfo cloudUserInfo = SynShrUserToCloudHelper.assembleCloudUserInfo(rowSet, localcloudUsers);
                    userMap.put(userId, cloudUserInfo);
                    syncData.add(cloudUserInfo);
                    continue;
                }
                if (StringUtils.isEmpty((String)group)) continue;
                CloudUserInfo source = (CloudUserInfo)userMap.get(userId);
                String sourceGroup = source.getProd_group();
                source.setProd_group(SynShrUserToCloudHelper.margetGroup(sourceGroup, group));
                userMap.put(userId, source);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return syncData;
    }

    private static String margetGroup(String sourceGroup, String newGroup) {
        if (StringUtils.isEmpty((String)newGroup)) {
            return sourceGroup;
        }
        StringBuffer group = new StringBuffer();
        if (!StringUtils.isEmpty((String)sourceGroup)) {
            if (!sourceGroup.toString().contains(newGroup)) {
                group.append(sourceGroup);
                group.append(";");
                group.append(newGroup);
            } else {
                group.append(sourceGroup);
            }
        } else {
            group.append(newGroup);
        }
        return group.toString();
    }

    private static CloudUserInfo assembleCloudUserInfo(IRowSet rowSet, JSONArray localcloudUsers) throws SQLException {
        CloudUserInfo cloudUserInfo = new CloudUserInfo();
        Date birthday = rowSet.getDate("birthday");
        String uname = rowSet.getString("uname");
        String uNumber = rowSet.getString("unumber");
        String pNumber = rowSet.getString("pnumber");
        String email = rowSet.getString("email");
        String cell = rowSet.getString("cell");
        String position = rowSet.getString("posName");
        int gender = rowSet.getInt("gender");
        String dept = rowSet.getString("dept");
        String idno = rowSet.getString("fidcardno");
        int status = rowSet.getInt("FForbidden");
        int isDelete = rowSet.getInt("FIsDelete");
        String group = rowSet.getString("groupName");
        Map<String, String> localFileUserMap = SynShrUserToCloudUtils.findCloudUserFromLocalLicenseFile(localcloudUsers, uNumber);
        String _uid = localFileUserMap.get("cloudUuId");
        cloudUserInfo.setBirthday(SynShrUserToCloudHelper.paraseDateToString(birthday));
        cloudUserInfo.setDepartment(dept);
        cloudUserInfo.setEmail(email);
        cloudUserInfo.setErp_account(uNumber);
        int cloud_gender = 0;
        cloud_gender = 1 == gender ? 0 : (2 == gender ? 1 : 2);
        cloudUserInfo.setGender(cloud_gender);
        cloudUserInfo.setIdno(idno);
        cloudUserInfo.setMid(pNumber);
        cloudUserInfo.setName(uname);
        cloudUserInfo.setPhone(cell);
        cloudUserInfo.setPosition(position);
        cloudUserInfo.setProd_group(group);
        cloudUserInfo.setStatus(status == 1 ? 0 : 1);
        cloudUserInfo.setIs_delete(isDelete);
        if (!StringUtils.isEmpty((String)_uid)) {
            int uid = Integer.parseInt(_uid);
            cloudUserInfo.setUid(uid);
        }
        return cloudUserInfo;
    }

    private static String paraseDateToString(java.util.Date birthday) {
        return SynShrUserToCloudUtils.formatDateToString(birthday, "yyyy-MM-dd");
    }

    public static String getUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleAllRolePermSql(ctx, lastUpdateTime);
        String userRolePerm = SynShrUserToCloudHelper.assembleAllUserPermSql(ctx, lastUpdateTime);
        sql.append(SynShrUserToCloudHelper.wrapSql(userPerm));
        sql.append(" union ");
        sql.append(SynShrUserToCloudHelper.wrapSql(userRolePerm));
        return sql.toString();
    }

    public static String assembleAllRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynShrUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String assembleAllUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        return sql.toString();
    }

    public static String getEnabledUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleEnabledUserRolePermSql(ctx, lastUpdateTime);
        String userRolePerm = SynShrUserToCloudHelper.assembleEnabledUserPermSql(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(" union ");
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String getDisableUserPermissionInfoSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleDisableUserPermSql(ctx, lastUpdateTime);
        String userRolePerm = SynShrUserToCloudHelper.assembleDisableUserRolePermSql(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(" union ");
        sql.append(userRolePerm);
        return sql.toString();
    }

    public static String assembleEnabledUserRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynShrUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        sql.append(SynShrUserToCloudHelper.assembleUserStatusFilter(0));
        sql.append(SynShrUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynShrUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleEnabledUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(SynShrUserToCloudHelper.assembleUserStatusFilter(0));
        sql.append(SynShrUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynShrUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleDisableUserRolePermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userRolePerm = SynShrUserToCloudHelper.assembleUserRolePerm(ctx, lastUpdateTime);
        sql.append(userRolePerm);
        sql.append(SynShrUserToCloudHelper.assembleUserStatusFilter(1));
        sql.append(SynShrUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynShrUserToCloudHelper.wrapSql(sql.toString());
    }

    public static String assembleDisableUserPermSql(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        String userPerm = SynShrUserToCloudHelper.assembleUserPerm(ctx, lastUpdateTime);
        sql.append(userPerm);
        sql.append(SynShrUserToCloudHelper.assembleUserStatusFilter(1));
        sql.append(SynShrUserToCloudHelper.assembleUserDefaultOrderByLastUpdateTime());
        return SynShrUserToCloudHelper.wrapSql(sql.toString());
    }

    private static String assembleUserStatusFilter(int status) {
        return " and u.FForbidden = " + status;
    }

    private static String assembleUserDefaultOrderByLastUpdateTime() {
        return " order by u.FLASTUPDATETIME asc ";
    }

    private static String wrapSql(String sourceSql) {
        return "select temp.* from (" + sourceSql + ")temp ";
    }

    private static void addFilter(StringBuffer sql, Timestamp lastUpdateTime) {
        if (null != lastUpdateTime) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = format.format(lastUpdateTime);
            sql.append(" and u.FLASTUPDATETIME >={ts'").append(dateStr).append("'}");
            logger.error((Object)MessageFormat.format(" lastUpdateTime is {0}", lastUpdateTime.toLocaleString()));
        } else {
            logger.error((Object)" lastUpdateTime is null");
        }
    }

    private static String assembleUserPerm(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        if (SynShrUserToCloudUtils.isSQLServerDB(ctx)) {
            sql.append(" select top 100 percent ");
        } else {
            sql.append(" select  ");
        }
        sql.append("  u.fid as userId, u.fname_l2 as uname,u.fnumber as unumber,u.FLASTUPDATETIME ");
        sql.append(" ,u.FForbidden,u.FIsDelete ");
        sql.append(" ,u.FCell cell,u.FEMail email,person.fgender gender,person.FIDCARDNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2 as dept ");
        sql.append(" ,pos.fname_l2 as posName ");
        sql.append(" ,pgm.fgroup as groupName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" left join t_pm_userorgperm up on up.fowner = u.fid ");
        sql.append(" left join T_PM_PermItem pi on pi.fid = up.fpermitemid ");
        sql.append(" left join T_PM_PermUIGroupMapping pgm on pgm.FPERMITEMID= pi.fid ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        SynShrUserToCloudHelper.addFilter(sql, lastUpdateTime);
        return sql.toString();
    }

    private static String assembleUserRolePerm(Context ctx, Timestamp lastUpdateTime) {
        StringBuffer sql = new StringBuffer();
        if (SynShrUserToCloudUtils.isSQLServerDB(ctx)) {
            sql.append(" select top 100 percent ");
        } else {
            sql.append(" select  ");
        }
        sql.append("  u.fid as userId, u.fname_l2 as uname,u.fnumber as unumber,u.FLASTUPDATETIME ");
        sql.append(" ,u.FForbidden,u.FIsDelete ");
        sql.append(" ,u.FCell cell,u.FEMail email,person.fgender gender,person.FIDCARDNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2 as dept ");
        sql.append(" ,pos.fname_l2 as posName ");
        sql.append(" ,pgm.fgroup as groupName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" left join t_pm_userroleorg uroleorg on uroleorg.fuserId = u.fid ");
        sql.append(" left join t_pm_role urole on urole.fid = uroleorg.FRoleID ");
        sql.append(" left join t_pm_roleperm rp on rp.FRoleID = urole.fid ");
        sql.append(" left join T_PM_PermItem pi on pi.fid = rp.fpermitemid ");
        sql.append(" left join T_PM_PermUIGroupMapping pgm on pgm.FPERMITEMID= pi.fid ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        SynShrUserToCloudHelper.addFilter(sql, lastUpdateTime);
        return sql.toString();
    }

    public static IRowSet getPersonInfo(Set<String> personNumbers) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select  ");
        sql.append("  u.fid as userId, u.fname_l2  uname,u.fnumber unumber ");
        sql.append(" ,u.FForbidden,u.FIsDelete ,u.FCell cell,u.FEMail email ");
        sql.append(" ,person.fgender gender,person.FIDCARDNO idCardNO,person.fnumber pnumber");
        sql.append(" ,person.FBirthday birthday");
        sql.append(" ,admin.fname_l2  dept ");
        sql.append(" ,pos.fname_l2  posName ");
        sql.append(" from t_pm_user  u ");
        sql.append(" inner join t_bd_person person on person.fid = u.fpersonid ");
        sql.append(" inner join T_ORG_PositionMember pm on pm.fpersonid = person.fid ");
        sql.append(" inner join T_ORG_Position pos on pm.FPositionID = pos.fid ");
        sql.append(" inner join t_org_admin admin on admin.fid = pos.FAdminOrgUnitId ");
        sql.append(" where u.fid not in('256c221a-0106-1000-e000-10d7c0a813f413B7DE7F','00000000-0000-0000-0000-00000000000013B7DE7F') ");
        sql.append(" and pm.FIsPrimary=1 ");
        sql.append(SynShrUserToCloudHelper.addPeronNumberFilter(personNumbers));
        try {
            return SynShrUserToCloudUtils.executeQuery(null, sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String addPeronNumberFilter(Set<String> personNumbers) {
        if (personNumbers == null || personNumbers.size() == 0) {
            return " ";
        }
        return " and person.fnumber in " + SynShrUserToCloudHelper.convetSetToString(personNumbers) + "";
    }

    public static String convetSetToString(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>(set);
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getSynLastUpdateTime(Context ctx) {
        String sql = "select flastupdatetime from T_PM_SynShrUserToCloud";
        try {
            IRowSet rs = SynShrUserToCloudUtils.executeQuery(ctx, sql);
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int importUserFromCloud(Context ctx) {
        String cloudUserString;
        ICloudRegistSrv cloudRegistSrv = null;
        IUserFacade userFacade = null;
        try {
            if (null == ctx) {
                userFacade = UserFacadeFactory.getRemoteInstance();
                cloudRegistSrv = CloudRegistSrvAgentFactory.getRemoteInstance();
            } else {
                userFacade = UserFacadeFactory.getLocalInstance(ctx);
                cloudRegistSrv = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int page = 0;
        int rows = 500;
        int successCount = 0;
        while (!StringUtils.isEmpty((String)(cloudUserString = cloudRegistSrv.getCloudRegistUser(page * rows, rows)))) {
            ++page;
        }
        return successCount;
    }

    public static Map<String, Map<String, String>> convetToUserDatas(List<CloudUserInfo> data) {
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>(data.size());
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        for (CloudUserInfo u : data) {
            map = new HashMap<String, String>();
            map.put("userNumber", u.getErp_account());
            map.put("userName", u.getName());
            map.put("personNumber", u.getMid());
            map.put("deptName", u.getDepartment());
            int gender = u.getGender();
            genderAlias = 0 == gender ? EASResource.getString((String)RESOURCE, (String)"female") : (1 == gender ? EASResource.getString((String)RESOURCE, (String)"female") : EASResource.getString((String)RESOURCE, (String)"secret"));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("idCardNO", u.getIdno());
            map.put("email", u.getEmail());
            map.put("phone", u.getPhone());
            map.put("position", u.getPosition());
            group = u.getProd_group();
            String no = EASResource.getString((String)RESOURCE, (String)"no");
            if (group == null) {
                map.put("SLF", no);
                map.put("PRF", no);
                map.put("SYS", no);
            } else {
                String yes = EASResource.getString((String)RESOURCE, (String)"yes");
                if (group.indexOf("SLF") != -1) {
                    map.put("SLF", yes);
                } else {
                    map.put("SLF", no);
                }
                if (group.indexOf("PRF") != -1) {
                    map.put("PRF", yes);
                } else {
                    map.put("PRF", no);
                }
                if (group.indexOf("SYS") != -1) {
                    map.put("SYS", yes);
                } else {
                    map.put("SYS", no);
                }
            }
            users.put(u.getErp_account(), map);
        }
        return users;
    }
}

