/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.risk.ClazzType;
import com.kingdee.eas.base.risk.ExecClassRegistryFactory;
import com.kingdee.eas.base.risk.ExecClassRegistryInfo;
import com.kingdee.eas.base.risk.IExecClassRegistry;
import com.kingdee.eas.base.risk.ModelConditType;
import com.kingdee.eas.base.risk.ModelOrgFactory;
import com.kingdee.eas.base.risk.ModelOrgInfo;
import com.kingdee.eas.base.risk.ModelOtherEntryCollection;
import com.kingdee.eas.base.risk.ModelRuleType;
import com.kingdee.eas.base.risk.ModelShowFactory;
import com.kingdee.eas.base.risk.ModelShowInfo;
import com.kingdee.eas.base.risk.ModelShowStateEnum;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.app.AbstractRiskModelControllerBean;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountFactory;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountInfo;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillFactory;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillInfo;
import com.kingdee.eas.base.risk.service.common.ClazzUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RiskModelControllerBean
extends AbstractRiskModelControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskModelControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RiskModelInfo riskModelInfo = (RiskModelInfo)model;
        this.checkNumberDup(ctx, riskModelInfo);
        this.checkNameDup(ctx, riskModelInfo);
        if (riskModelInfo.getId() != null && ModelShowFactory.getLocalInstance(ctx).exists(" where riskModel.id ='" + riskModelInfo.getId().toString() + "' and status = 'enable'")) {
            throw new RiskException(RiskException.RISKMODELENABLED);
        }
        ModelConditType conditType = riskModelInfo.getConditType();
        if (conditType == ModelConditType.Rule) {
            riskModelInfo.setConditClazz(null);
            riskModelInfo.setConditSQL(null);
        } else if (conditType == ModelConditType.Clazz) {
            riskModelInfo.getModelConditEntry().clear();
            riskModelInfo.setConditSQL(null);
            String conditClazz = riskModelInfo.getConditClazz();
            ClazzUtils.checkClazz(conditClazz);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("classPath", (Object)conditClazz, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("clazzType", (Object)ClazzType.ConditClazz, CompareType.EQUALS));
            IExecClassRegistry iExecClassRegistry = ExecClassRegistryFactory.getLocalInstance(ctx);
            if (!iExecClassRegistry.exists(filterInfo)) {
                ExecClassRegistryInfo classRegistryInfo = new ExecClassRegistryInfo();
                classRegistryInfo.setClassPath(conditClazz);
                classRegistryInfo.setClazzType(ClazzType.ConditClazz);
                iExecClassRegistry.submit((CoreBaseInfo)classRegistryInfo);
            }
        } else if (conditType == ModelConditType.Sql) {
            riskModelInfo.getModelConditEntry().clear();
            riskModelInfo.setConditClazz(null);
        }
        ModelRuleType ruleType = riskModelInfo.getRuleType();
        if (ruleType == ModelRuleType.Rule) {
            riskModelInfo.setRuleClazz(null);
            riskModelInfo.setRuleSQL(null);
        } else if (ruleType == ModelRuleType.Clazz) {
            riskModelInfo.getModelRuleEntry().clear();
            riskModelInfo.getFilterEntry().clear();
            riskModelInfo.setRuleSQL(null);
            String ruleClazz = riskModelInfo.getRuleClazz();
            ClazzUtils.checkClazz(ruleClazz);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("classPath", (Object)ruleClazz, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("clazzType", (Object)ClazzType.execRuleClazz, CompareType.EQUALS));
            IExecClassRegistry iExecClassRegistry = ExecClassRegistryFactory.getLocalInstance(ctx);
            if (!iExecClassRegistry.exists(filterInfo)) {
                ExecClassRegistryInfo classRegistryInfo = new ExecClassRegistryInfo();
                classRegistryInfo.setClassPath(ruleClazz);
                classRegistryInfo.setClazzType(ClazzType.execRuleClazz);
                iExecClassRegistry.submit((CoreBaseInfo)classRegistryInfo);
            }
        } else if (ruleType == ModelRuleType.Sql) {
            riskModelInfo.getModelRuleEntry().clear();
            riskModelInfo.getFilterEntry().clear();
            riskModelInfo.setRuleClazz(null);
        }
        if (riskModelInfo.isCompareInOrder()) {
            riskModelInfo.getFilterEntry().clear();
            riskModelInfo.setRiskFactors(null);
        }
        ModelOtherEntryCollection modelOtherEntry = riskModelInfo.getModelOtherEntry();
        for (int i = 0; i < modelOtherEntry.size(); ++i) {
            if (!StringUtils.isEmpty((String)modelOtherEntry.get(i).getFieldSrcName())) continue;
            throw new RiskException(RiskException.FIELDSRCNAMENULL, new Object[]{i + 1});
        }
        this.saveModelShow(ctx, model, riskModelInfo);
        return super._save(ctx, model);
    }

    private void handleParam(Object modelOrg, List<String> orgList, Map<String, String> paramMap, Map<String, String> numberPamp) {
        JSONArray orgArr = JSON.parseArray((String)modelOrg.toString());
        for (int i = 0; i < orgArr.size(); ++i) {
            JSONObject obj = (JSONObject)orgArr.get(i);
            JSONObject nameList = (JSONObject)obj.get((Object)"name");
            String name = null;
            if (nameList != null) {
                name = (String)nameList.get((Object)"l2");
            }
            Map cU = (Map)obj.get((Object)"cU");
            String orgId = null;
            if (cU != null) {
                orgId = (String)obj.get((Object)"id");
            }
            if (orgId == null) {
                orgId = (String)obj.get((Object)"orgId");
            }
            paramMap.put(orgId, name);
            String number = (String)obj.get((Object)"number");
            numberPamp.put(orgId, number);
            orgList.add(orgId);
        }
    }

    private int addOrg(Context ctx, Map<String, String> paramMap, Map<String, String> numberPamp, String riskModelId, List<String> orgList) {
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("riskModel", (Object)riskModelId));
            ModelOrgFactory.getLocalInstance(ctx).delete(filterInfo);
            UserInfo currentUser = new UserInfo(ctx.getCaller().toString());
            CoreBaseCollection addOrgs = new CoreBaseCollection();
            RiskModelInfo riskModelInfo = new RiskModelInfo();
            riskModelInfo.setId(BOSUuid.read((String)riskModelId));
            for (int i = 0; i < orgList.size(); ++i) {
                ModelOrgInfo riskModelOrgInfo = new ModelOrgInfo();
                riskModelOrgInfo.setRiskModel(riskModelInfo);
                riskModelOrgInfo.setOrgId(orgList.get(i));
                riskModelOrgInfo.setId(BOSUuid.create((String)"C0B550AF"));
                riskModelOrgInfo.setCreator(currentUser);
                String name = null;
                if (paramMap != null) {
                    name = paramMap.get(orgList.get(i));
                    riskModelOrgInfo.setName(name);
                }
                String number = null;
                if (numberPamp != null) {
                    number = numberPamp.get(orgList.get(i));
                    riskModelOrgInfo.setNumber(number);
                }
                riskModelOrgInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                addOrgs.add((CoreBaseInfo)riskModelOrgInfo);
            }
            if (addOrgs.size() > 0) {
                IObjectPK[] pks = ModelOrgFactory.getLocalInstance(ctx).addnewBatchData(addOrgs);
                return pks.length;
            }
        }
        catch (Exception var9) {
            logger.error((Object)var9, (Throwable)var9);
        }
        return 0;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private Boolean saveModelShow(Context ctx, IObjectValue model, RiskModelInfo riskModelInfo) throws BOSException, RiskException {
        int order = 0;
        HashMap<Object, Integer> orderMap = new HashMap<Object, Integer>();
        try {
            int i;
            HashSet<String> orgDeleteIds = new HashSet<String>();
            HashSet<String> orgAddIds = new HashSet<String>();
            HashSet<String> tempIds = new HashSet<String>();
            ArrayList<String> allOrgList = new ArrayList<String>();
            ArrayList<String> allAddOrgList = new ArrayList<String>();
            String orgSql = "SELECT FORGID FROM T_RIS_ModelShow WHERE FRISKMODELID = ?";
            Object[] orgParam = new Object[]{riskModelInfo.getId().toString()};
            ArrayList<Object[]> orgDelParamsList = new ArrayList<Object[]>();
            IRowSet orgRs = DbUtil.executeQuery((Context)ctx, (String)orgSql, (Object[])orgParam);
            while (orgRs.next()) {
                String orgID = orgRs.getString(1);
                tempIds.add(orgID);
                orgDeleteIds.add(orgID);
            }
            if (((RiskModelInfo)model).getOrgEntry() != null) {
                for (int i2 = 0; i2 < ((RiskModelInfo)model).getOrgEntry().size(); ++i2) {
                    orgAddIds.add(((RiskModelInfo)model).getOrgEntry().get(i2).getOrgId());
                    orgDeleteIds.remove(((RiskModelInfo)model).getOrgEntry().get(i2).getOrgId());
                }
            }
            orgAddIds.removeAll(tempIds);
            allAddOrgList.addAll(orgAddIds);
            allOrgList.addAll(orgDeleteIds);
            String deleteOrgSql = "DELETE FROM T_RIS_ModelShow WHERE FRISKMODELID = ? AND FORGID = ? AND FSTATUS = 'disable' ";
            for (i = 0; i < allOrgList.size(); ++i) {
                orgDelParamsList.add(new Object[]{riskModelInfo.getId().toString(), allOrgList.get(i)});
            }
            if (orgDelParamsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)deleteOrgSql, orgDelParamsList);
            }
            for (i = 0; i < allAddOrgList.size(); ++i) {
                String sql = "SELECT FORDERS,FRISKMODELID,FTARGETBILLTYPEID FROM T_RIS_ModelShow modelshow LEFT  JOIN  T_RIS_RiskModel riskmodel   on modelshow.friskmodelid=riskmodel.fid where forgid= ? and riskmodel.FTARGETBILLTYPEID = ?  AND riskmodel.FCONTROLMODEL = ? order by forders desc ";
                if (null == allAddOrgList.get(i)) continue;
                Object[] params = new Object[]{allAddOrgList.get(i), riskModelInfo.getTargetBillType().getId().toString(), riskModelInfo.getControlModel() == null ? "" : riskModelInfo.getControlModel().getValue()};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (rs.next()) {
                    Integer o = rs.getInt(1);
                    if (o != null) {
                        if (rs.getObject(2).equals(riskModelInfo.getId().toString())) continue;
                        order = o + 1;
                        orderMap.put(allAddOrgList.get(i), order);
                    }
                } else {
                    order = 1;
                    orderMap.put(((String)allAddOrgList.get(i)).toString(), order);
                }
                ModelShowInfo showInfo = new ModelShowInfo();
                showInfo.setStatus(ModelShowStateEnum.DISABLE);
                showInfo.setOrders(order);
                showInfo.setRiskModel(riskModelInfo);
                showInfo.setOrgID((String)allAddOrgList.get(i));
                showInfo.setNumber(riskModelInfo.getNumber());
                showInfo.setNumber(riskModelInfo.getNumber());
                showInfo.setPKField(BOSUuid.create((BOSObjectType)showInfo.getBOSType()).toString());
                showInfo.setId(BOSUuid.create((BOSObjectType)showInfo.getBOSType()));
                Timestamp nowTime = this.getTime();
                StringBuffer sb = new StringBuffer("");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                paramsList.add(new Object[]{order, riskModelInfo.getId().toString(), riskModelInfo.getNumber(), ctx.getCaller().toString(), BOSUuid.create((BOSObjectType)showInfo.getBOSType()).toString(), allAddOrgList.get(i), nowTime, ctx.getCaller().toString(), nowTime, allAddOrgList.get(i)});
                sb.append("insert into t_ris_modelshow(FORDERS, FRISKMODELID, FNUMBER, FCREATORID,  FID, FORGID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID) ").append(" values ").append(" ( ?,?,?,?,?,?,?,?,?,?)");
                DbUtil.executeBatch((Context)ctx, (String)sb.toString(), paramsList);
            }
        }
        catch (Exception e) {
            throw new RiskException(RiskException.SAVEORDERERROR);
        }
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ModelShowFactory.getLocalInstance(ctx).delete("where riskModel = '" + pk.toString() + "'");
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        BOSUuid id;
        RiskModelInfo risk = (RiskModelInfo)super._getValue(ctx, pk, selector);
        if (risk.getRepeatBill() != null) {
            id = risk.getRepeatBill().getId();
            RepeatBillInfo repeatBillInfo = RepeatBillFactory.getLocalInstance(ctx).getRepeatBillInfo("select *,srcBill.*,targetBill.* where id ='" + id.toString() + "'");
            risk.setRepeatBill(repeatBillInfo);
        }
        if (risk.getOverAmount() != null) {
            id = risk.getOverAmount().getId();
            OverAmountInfo overAmountInfo = OverAmountFactory.getLocalInstance(ctx).getOverAmountInfo("select *,srcBill.*,targetBill.* where id = '" + id.toString() + "'");
            risk.setOverAmount(overAmountInfo);
        }
        return risk;
    }
}

