/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.RiskErrLogCollection;
import com.kingdee.eas.base.risk.RiskErrLogFactory;
import com.kingdee.eas.base.risk.RiskErrLogInfo;
import com.kingdee.eas.base.risk.RiskErrParamCollection;
import com.kingdee.eas.base.risk.RiskErrParamFactory;
import com.kingdee.eas.base.risk.RiskErrParamInfo;
import com.kingdee.eas.base.risk.RiskExecDataCollection;
import com.kingdee.eas.base.risk.RiskExecDataFactory;
import com.kingdee.eas.base.risk.RiskExecDataInfo;
import com.kingdee.eas.base.risk.RiskRecordCollection;
import com.kingdee.eas.base.risk.RiskRecordFactory;
import com.kingdee.eas.base.risk.RiskRecordInfo;
import com.kingdee.eas.base.risk.app.AbstractRiskRecordFacadeControllerBean;
import com.kingdee.eas.base.risk.tools.commTools.H;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskRecordFacadeControllerBean
extends AbstractRiskRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskRecordFacadeControllerBean");

    @Override
    protected String _getRiskSnapshot(Context ctx, String billId) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer(10000);
        String batchNumber = this.getBatchNumber(ctx, billId);
        if (StringUtils.isEmpty((CharSequence)batchNumber)) {
            return "\u67e5\u8be2\u4e0b\u8f7d\u65e5\u5fd7\u5931\u8d25\uff01";
        }
        this.appendExecRecord(ctx, batchNumber, billId, buffer);
        this.appendExecData(ctx, batchNumber, billId, buffer);
        this.appendErrLog(ctx, batchNumber, billId, buffer);
        this.appendErrParam(ctx, batchNumber, billId, buffer);
        return buffer.toString();
    }

    private void appendErrParam(Context ctx, String batchNumber, String billId, StringBuffer targetBuffer) {
        try {
            RiskErrParamCollection coll = RiskErrParamFactory.getLocalInstance(ctx).getRiskErrParamCollection("where batchNumber = '" + batchNumber + "' AND billId = '" + billId + "' ");
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (i == 0) {
                    targetBuffer.append("\n\nRiskErrParam\n[\n");
                }
                RiskErrParamInfo info = coll.get(i);
                targetBuffer.append(" {\n  bizObjId:").append(info.getBizObjId()).append(",\n  bizObjInfo:").append(this.getBizObjInfo(ctx, info.getBizObjId())).append(",\n  ").append("errPosition:").append(info.getErrPosition()).append(",\n  ").append("args:").append(info.getArgs()).append(",\n  ").append("seq:").append(info.getSeq()).append("\n }\n");
                if (i != coll.size() - 1) continue;
                targetBuffer.append("]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private String getBizObjInfo(Context ctx, String bizObjId) throws BOSException {
        if (StringUtils.isNotEmpty((CharSequence)bizObjId) && BOSUuid.isValid((String)bizObjId, (boolean)true)) {
            ObjectUuidPK uuidPK = new ObjectUuidPK(bizObjId);
            BOSObjectType objectType = uuidPK.getObjectType();
            SelectorItemCollection billSelectors = new SelectorItemCollection();
            billSelectors.add("id");
            billSelectors.add("name");
            billSelectors.add("number");
            IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(objectType, H.PK(bizObjId), billSelectors);
            Object name = value.get("name");
            Object number = value.get("number");
            String retStr = "";
            if (name != null && StringUtils.isNotEmpty((CharSequence)name.toString())) {
                retStr = retStr + name.toString();
            }
            if (number != null && StringUtils.isNotEmpty((CharSequence)number.toString())) {
                retStr = retStr + number.toString();
            }
            return retStr;
        }
        return "";
    }

    private void appendErrLog(Context ctx, String batchNumber, String billId, StringBuffer targetBuffer) {
        try {
            RiskErrLogCollection coll = RiskErrLogFactory.getLocalInstance(ctx).getRiskErrLogCollection("where batchNumber = '" + batchNumber + "' AND billId = '" + billId + "' ");
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (i == 0) {
                    targetBuffer.append("\n\nRiskErrLog\n[\n");
                }
                RiskErrLogInfo info = coll.get(i);
                targetBuffer.append(" {\n  bizObjId:").append(info.getBizObjId()).append(",\n  bizObjInfo:").append(this.getBizObjInfo(ctx, info.getBizObjId())).append(",\n  ").append("errStack:").append(info.getErrStack()).append("\n }\n");
                if (i != coll.size() - 1) continue;
                targetBuffer.append("]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void appendExecData(Context ctx, String batchNumber, String billId, StringBuffer targetBuffer) {
        try {
            RiskExecDataCollection coll = RiskExecDataFactory.getLocalInstance(ctx).getRiskExecDataCollection("where batchNumber = '" + batchNumber + "' AND billId = '" + billId + "' ");
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (i == 0) {
                    targetBuffer.append("\n\nRiskExecData\n[\n");
                }
                RiskExecDataInfo info = coll.get(i);
                targetBuffer.append(" {\n  bizObjId:").append(info.getBizObjId()).append(",\n  bizObjInfo:").append(this.getBizObjInfo(ctx, info.getBizObjId())).append(",\n  ").append("entryName:").append(info.getEntryName()).append(",\n  ").append("valueType:").append((Object)info.getValueType()).append(",\n  ").append("value:").append(info.getValue()).append("\n }\n");
                if (i != coll.size() - 1) continue;
                targetBuffer.append("]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void appendExecRecord(Context ctx, String batchNumber, String billId, StringBuffer targetBuffer) {
        try {
            RiskRecordCollection coll = RiskRecordFactory.getLocalInstance(ctx).getRiskRecordCollection("where batchNumber = '" + batchNumber + "' AND billId = '" + billId + "' ");
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (i == 0) {
                    targetBuffer.append("\n\nRiskRecord\n[\n");
                }
                RiskRecordInfo info = coll.get(i);
                targetBuffer.append(" {\n  bizObjId:").append(info.getBizObjId()).append(",\n  bizObjInfo:").append(this.getBizObjInfo(ctx, info.getBizObjId())).append(",\n  ").append("billNumber:").append(info.getBillNumber()).append(",\n  ").append("billUserId:").append(info.getBillUserId()).append(",\n  ").append("billBOSType:").append(info.getBillBOSType()).append(",\n  ").append("result:").append(info.isResult()).append(",\n  ").append("msg:").append(info.getMsg()).append("\n }\n");
                if (i != coll.size() - 1) continue;
                targetBuffer.append("]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected String getBatchNumber(Context ctx, String billId) {
        try {
            String sql = "select top 1 FBatchNumber from T_RIS_RiskInvoke where fbillId = ? order by  FOrders desc ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return "";
    }
}

