/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.common;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.risk.BaseSnapshotInfo;
import com.kingdee.eas.base.risk.DesignInvokeInfo;
import com.kingdee.eas.base.risk.ExecValueType;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskErrLogInfo;
import com.kingdee.eas.base.risk.RiskErrParamInfo;
import com.kingdee.eas.base.risk.RiskExecDataInfo;
import com.kingdee.eas.base.risk.RiskInvokeInfo;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.RiskRecordInfo;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.service.pojo.DataSnapshot;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DataSnapshotUtil {
    private static Logger logger = Logger.getLogger(DataSnapshotUtil.class);

    public static void writeDesignInvoke(Context ctx, RiskParam param) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeDesignInvoke"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            CoreBaseCollection designInvokeColl = dataSnapshot.getDesignInvokeColl();
            List<RiskDesignerInfo> designerList = param.getDesignerList();
            for (int i = 0; designerList != null && i < designerList.size(); ++i) {
                RiskDesignerInfo designerInfo = designerList.get(i);
                if (designerInfo.getId() == null) {
                    logger.error((Object)"writeDesignInvoke designer id is null");
                }
                DesignInvokeInfo info = new DesignInvokeInfo();
                DataSnapshotUtil.setBaseSnapshot(ctx, param, info, dataSnapshot.getBatchNumber(), dataSnapshot.getBillId(), designerInfo.getId().toString());
                designInvokeColl.add((CoreBaseInfo)info);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    public static void writeRiskInvoke(Context ctx, RiskParam param) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeRiskInvoke"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            RiskInvokeInfo invokeInfo = dataSnapshot.getInvokeInfo();
            DataSnapshotUtil.setBaseSnapshot(ctx, param, invokeInfo, dataSnapshot.getBatchNumber(), dataSnapshot.getBillId(), null);
            invokeInfo.setOrders(BigDecimal.valueOf(Long.parseLong(dataSnapshot.getBatchNumber())));
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    public static void writeExecRecord(Context ctx, RiskParam param, RiskModelInfo riskModelInfo) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeExecRecord"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            IObjectValue objectValue = param.getModel();
            String billUser = DataSnapshotUtil.getBillUser(ctx, objectValue);
            String billNumber = objectValue.get("number") != null ? objectValue.get("number").toString() : "";
            RiskRecordInfo riskRecordInfo = new RiskRecordInfo();
            DataSnapshotUtil.setBaseSnapshot(ctx, param, riskRecordInfo, dataSnapshot.getBatchNumber(), dataSnapshot.getBillId(), riskModelInfo.getId().toString());
            riskRecordInfo.setBillBOSType(dataSnapshot.getBillBosType());
            riskRecordInfo.setBillUserId(billUser);
            riskRecordInfo.setBillNumber(billNumber);
            riskRecordInfo.setBillMainOrgId((String)param.getParams().get("__$$billMainOrgId"));
            CoreBaseCollection coll = dataSnapshot.getRiskRecordInfoColl();
            coll.add((CoreBaseInfo)riskRecordInfo);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private static String getBillUser(Context ctx, IObjectValue objectValue) {
        IObjectValue creator = objectValue.getObjectValue("creator");
        if (creator != null) {
            return creator.get("id") == null ? "" : creator.get("id").toString();
        }
        logger.error((Object)"getBillUser creator is null");
        return null;
    }

    public static void writeErrLog(Context ctx, RiskParam param, String bizObjId, Throwable e) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeErrLog"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            CoreBaseCollection coll = dataSnapshot.getRiskErrLogInfoColl();
            RiskErrLogInfo errLogInfo = new RiskErrLogInfo();
            DataSnapshotUtil.setBaseSnapshot(ctx, param, errLogInfo, dataSnapshot.getBatchNumber(), dataSnapshot.getBillId(), bizObjId);
            StringBuilder errStack = new StringBuilder();
            errStack.append(e.getMessage()).append(";");
            StackTraceElement[] stackTrace = e.getStackTrace();
            int length = stackTrace.length >= 40 ? 40 : stackTrace.length;
            for (int i = 0; i < length; ++i) {
                StackTraceElement log = stackTrace[i];
                errStack.append("at:").append(log.toString()).append(";");
            }
            if (errStack.length() >= 4000) {
                errStack.setLength(4000);
            }
            errLogInfo.setErrStack(errStack.toString());
            coll.add((CoreBaseInfo)errLogInfo);
        }
        catch (Throwable e1) {
            logger.error((Object)e1, e1);
        }
    }

    private static void setObjectBase(Context ctx, RiskParam param, ObjectBaseInfo target) {
        IObjectPK caller = ctx.getCaller();
        if (caller != null) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)caller.toString()));
            target.setCreator(userInfo);
            target.setLastUpdateUser(userInfo);
        }
        Timestamp timestamp = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            Date parse = df.parse(param.getDataSnapshot().getBatchNumber());
            timestamp = new Timestamp(parse.getTime());
        }
        catch (ParseException e) {
            logger.error((Object)e, (Throwable)e);
            timestamp = new Timestamp(new Date().getTime());
        }
        target.setCreateTime(timestamp);
        target.setLastUpdateTime(timestamp);
        target.setId(BOSUuid.create((BOSObjectType)target.getBOSType()));
    }

    private static void setBaseSnapshot(Context ctx, RiskParam param, BaseSnapshotInfo target, String batchNumber, String billId, String bizObjId) {
        DataSnapshotUtil.setObjectBase(ctx, param, target);
        target.setBatchNumber(batchNumber);
        target.setBillId(billId);
        target.setBizObjId(bizObjId);
    }

    public static void writeErrParam(Context ctx, RiskParam param, String bizObjId, Object[] args) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeErrParam"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            CoreBaseCollection coll = dataSnapshot.getRiskErrParamInfoColl();
            String errPosition = DataSnapshotUtil.getErrPosition();
            for (int i = 0; i < args.length; ++i) {
                RiskErrParamInfo errParam = new RiskErrParamInfo();
                DataSnapshotUtil.setBaseSnapshot(ctx, param, errParam, dataSnapshot.getBatchNumber(), dataSnapshot.getBillId(), bizObjId);
                String arg = JSON.toJSONString((Object)args[i]);
                if (arg != null && arg.length() >= 4000) {
                    arg = arg.substring(0, 4000);
                }
                errParam.setArgs(arg);
                errParam.setSeq(i);
                errParam.setErrPosition(errPosition);
                coll.add((CoreBaseInfo)errParam);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private static String getErrPosition() {
        int length;
        StringBuilder errPosition = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int n = length = stackTrace.length >= 2 ? 2 : stackTrace.length;
        if (length >= 2) {
            StackTraceElement log = stackTrace[1];
            errPosition.append(log.getClassName() + "." + log.getMethodName() + ";");
        }
        return errPosition.toString();
    }

    public static void writeExecData(Context ctx, RiskParam param, String bizObjId, String entryName, ExecValueType valueType, String value) {
        try {
            if (!"true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "writeExecData"))) {
                return;
            }
            DataSnapshot dataSnapshot = param.getDataSnapshot();
            CoreBaseCollection coll = dataSnapshot.getRiskExecrDataInfoColl();
            RiskExecDataInfo dataInfo = new RiskExecDataInfo();
            DataSnapshotUtil.setBaseSnapshot(ctx, param, dataInfo, dataSnapshot.getBatchNumber(), dataInfo.getBillId(), bizObjId);
            dataInfo.setEntryName(entryName);
            dataInfo.setValueType(valueType);
            dataInfo.setValue(value);
            coll.add((CoreBaseInfo)dataInfo);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }
}

