/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.riskManage.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.RiskExecuteFacadeFactory;
import com.kingdee.eas.base.risk.cache.RiskConfigUtils;
import com.kingdee.eas.base.risk.cache.RiskSysParam;
import com.kingdee.eas.base.risk.service.pojo.BatchRiskResult;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.pojo.RiskResult;
import com.kingdee.eas.base.risk.service.riskManage.RiskService;
import com.kingdee.eas.base.risk.service.riskManage.RiskServiceEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RiskServiceImpl
extends RiskServiceEvent
implements RiskService {
    private static Logger logger = Logger.getLogger(RiskServiceImpl.class);

    protected List getRobotRiskDesigner(Context ctx, BOSObjectType metaBosType, String method, Object[] args) {
        try {
            List designers = RiskExecuteFacadeFactory.getLocalInstance(ctx).getDesignersByMethod(metaBosType, method, args);
            if (designers == null || designers.size() == 0) {
                logger.error((Object)("getRobotRiskDesigner designers is null or size=0;[metaBosType:" + metaBosType.toString() + ",method:" + method + "]"));
            }
            return designers;
        }
        catch (Throwable e) {
            logger.error((Object)("getRisk exception;[metaBosType:" + metaBosType + ",method:" + method + "]"));
            logger.error((Object)e, e);
            return null;
        }
    }

    @Override
    public RiskResult getRisk(Context ctx, BOSObjectType metaBosType, String method, Object[] args, String targetBillId) {
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"risk_enable is false");
            return this.defaultResult(ctx, targetBillId);
        }
        if (!RiskConfigUtils.existROBOT(ctx, metaBosType, method)) {
            logger.error((Object)("getModelRisk--existFunction[metaBosType:" + metaBosType.toString() + ",method:" + method + "]"));
            return this.defaultResult(ctx, targetBillId);
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(targetBillId);
        List riskDesigner = this.getRobotRiskDesigner(ctx, metaBosType, method, args);
        if (riskDesigner == null || riskDesigner.size() == 0) {
            logger.error((Object)("getRisk designers is null or size=0;[metaBosType:" + metaBosType.toString() + ",method:" + method + ",targetBillId:" + targetBillId + "] return defalut value[allExecSuccess true]"));
            return this.defaultResult(ctx, targetBillId);
        }
        RiskParam riskParam = this.initRiskParam(ctx, RiskParam.builder(), targetBillId, ControlMode.robot, riskDesigner);
        return this.doRiskBus(ctx, riskParam);
    }

    @Override
    public BatchRiskResult getRiskBatch(Context ctx, BOSObjectType metaBosType, String method, Object[] args, List<String> targetBillIds) {
        if (!RiskSysParam.risk_enable(ctx)) {
            logger.error((Object)"risk_enable is false");
            return this.defaultResultBatch(ctx, targetBillIds);
        }
        if (!RiskConfigUtils.existROBOT(ctx, metaBosType, method)) {
            return this.defaultResultBatch(ctx, targetBillIds);
        }
        List riskDesigner = this.getRobotRiskDesigner(ctx, metaBosType, method, args);
        return this.getRiskBatch(ctx, targetBillIds, riskDesigner, ControlMode.robot);
    }
}

