/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.report.IReportManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;

public class ReportMananger
extends AbstractBOSObject
implements IReportManager {
    public ReportMananger() {
    }

    public ReportMananger(Context ctx) {
        super(ctx);
    }

    @Override
    public HashMap getQeuryReportByID(String reportID) throws BOSException, SQLException {
        HashMap<String, IRowSet> map = new HashMap<String, IRowSet>();
        IRowSet rs = this.getQueryInfo(reportID);
        if (rs.next()) {
            map.put("report", rs);
        }
        if ((rs = this.getQueryInfoFields(reportID)).next()) {
            map.put("reportheader", rs);
        }
        return map;
    }

    @Override
    public HashMap GetReportByID(String reportID) throws BOSException, SQLException {
        HashMap<String, IRowSet> map = new HashMap<String, IRowSet>();
        Locale locale = this.getContext().getLocale();
        String strSQL = "SELECT FID as FReportID,FReportClassName,FName_" + locale + " as FName,FReportSRVClassName ,FDetailReportID ,FWebFilterClassName,FUserDefine,FIsCellSelect  ,FPluginClassName,FEditUIName,FKeyFieldName,FFilterPanelName,FIsVirtualMode  ,FViewPermission,FPRINTPERMISSION,freporttype FROM T_BAS_Report Where FID=? ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
        if (rs.next()) {
            map.put("report", rs);
            strSQL = "SELECT T_BAS_REPORTHEADER.FID,FParentFieldName,FReportID,FCaption_" + locale + " as FCaption,FFieldName,FDecimalField,FDecimal, FColType,FWidth,FAlign,FLevel,FIndex,FMergeable,FFormatString,fishiberarchy,fleaffield   FROM T_BAS_REPORTHEADER  LEFT JOIN T_BAS_RptDataType ON T_BAS_RptDataType.FParentID=T_BAS_REPORTHEADER.FID  WHERE  FReportID = ?  Order By FLevel,FIndex,FParentFieldName ";
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportID});
            map.put("reportheader", (IRowSet)(rs.next() ? rs : null));
        }
        return map;
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public IRowSet getReportFields(int type, String reportid) throws BOSException, SQLException {
        IRowSet rs = null;
        switch (type) {
            case 1: {
                rs = this.getFixReportFields(reportid);
                break;
            }
            case 3: {
                rs = this.getQueryInfoFields(reportid);
                break;
            }
        }
        return rs;
    }

    private IRowSet getFixReportFields(String reportid) throws BOSException {
        String ssql = "";
        IRowSet rs = null;
        Locale locale = this.getContext().getLocale();
        if (reportid.trim().length() > 0) {
            ssql = " where FReportID='" + reportid + "'";
        }
        if ((ssql = "select Fid,FCaption_" + locale + " as FCaption,FFieldName,case  when fcolType=1 then 'String' else 'Number' end as FFieldType  from t_bas_reportheader " + ssql).trim().length() > 0) {
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)ssql);
        }
        return rs;
    }

    private IRowSet getQueryInfoFields(String reportid) throws SQLException, BOSException {
        DynamicRowSet drs = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)new MetaDataPK(reportid));
        drs = new DynamicRowSet(4);
        ColInfo ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "Fid";
        drs.setColInfo(1, ciId);
        ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "FCaption";
        drs.setColInfo(2, ciId);
        ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "FFieldName";
        drs.setColInfo(3, ciId);
        ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "FFieldType";
        drs.setColInfo(4, ciId);
        Locale locale = this.getContext().getLocale();
        if (queryInfo.getSelector() != null) {
            for (int i = 0; i < queryInfo.getSelector().size(); ++i) {
                QueryFieldInfo unit = queryInfo.getSelector().get(i);
                drs.moveToInsertRow();
                if (unit.getDisplayName(locale) != null) {
                    drs.updateString(drs.findColumn("FCaption"), unit.getDisplayName(locale).toString());
                } else {
                    drs.updateString(drs.findColumn("FCaption"), "");
                }
                try {
                    if (unit.getReturnType() != null) {
                        drs.updateString(drs.findColumn("FFieldType"), unit.getReturnType().toString());
                    } else {
                        drs.updateString(drs.findColumn("FFieldType"), "");
                    }
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw e;
                }
                if (unit.getName() != null) {
                    drs.updateString(drs.findColumn("FFieldName"), unit.getName().toString());
                } else {
                    drs.updateString(drs.findColumn("FFieldName"), "");
                }
                if (unit.getPKField() != null) {
                    drs.updateString(drs.findColumn("Fid"), unit.getPKField().toString());
                } else {
                    drs.updateString(drs.findColumn("Fid"), "");
                }
                drs.insertRow();
            }
        }
        drs.beforeFirst();
        return drs;
    }

    @Override
    public IRowSet getReportList(int type, String systemID) throws BOSException, SQLException {
        IRowSet rs = null;
        switch (type) {
            case 1: {
                rs = this.getFixReportInfo(systemID);
                break;
            }
            case 3: {
                rs = this.getQueryInfo(systemID);
                break;
            }
        }
        return rs;
    }

    private IRowSet getFixReportInfo(String systemID) throws BOSException {
        String ssql = "";
        IRowSet rs = null;
        Locale locale = this.getContext().getLocale();
        if (systemID.trim().length() > 0) {
            ssql = " where FSYSTEMID='" + systemID + "'";
        }
        if ((ssql = "select fid,fname_" + locale + " as fname from T_BAS_Report " + ssql).trim().length() > 0) {
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)ssql);
        }
        return rs;
    }

    private IRowSet getQueryInfo(String systemID) throws SQLException {
        DynamicRowSet drs = null;
        drs = new DynamicRowSet(2);
        ColInfo ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "fid";
        drs.setColInfo(1, ciId);
        ciId = new ColInfo();
        ciId.colType = 12;
        ciId.columnName = "fname";
        drs.setColInfo(2, ciId);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        BusinessObjectBriefView view = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_base_query"));
        BOSObjectType[] bostype = new BOSObjectType[]{MetaDataTypeList.JOINQUERY, MetaDataTypeList.UNIONQUERY};
        IBriefViewTreeNode root = view.getViewRootByType(bostype);
        this.convertToKingdeeTreeNode(root, systemID, drs);
        drs.beforeFirst();
        return drs;
    }

    private void convertToKingdeeTreeNode(IBriefViewTreeNode root, String systemID, DynamicRowSet drs) throws SQLException {
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode ibf = (IBriefViewTreeNode)enu.nextElement();
            MetaDataBriefInfo info = ibf.getMetaDataObjectBriefInfo();
            if (info == null || !info.getFullName().equals(systemID)) {
                this.convertToKingdeeTreeNode(ibf, systemID, drs);
                continue;
            }
            this.getNodeInfo(drs, ibf);
            break;
        }
    }

    private void getNodeInfo(DynamicRowSet drs, IBriefViewTreeNode ibf) throws SQLException {
        Enumeration enu = ibf.children();
        if (enu == null) {
            return;
        }
        Locale locale = null;
        locale = this.getContext().getLocale();
        if (!enu.hasMoreElements()) {
            if (ibf != null && (ibf.getMetaDataType() == MetaDataTypeList.JOINQUERY || ibf.getMetaDataType() == MetaDataTypeList.UNIONQUERY)) {
                drs.moveToInsertRow();
                drs.updateString(drs.findColumn("fid"), ibf.getFullName());
                if (ibf.getAlias(locale) != null) {
                    if (ibf.getAlias(locale).toString() != "") {
                        drs.updateString(drs.findColumn("fname"), ibf.getAlias(locale).toString());
                    } else {
                        drs.updateString(drs.findColumn("fname"), ibf.getName().toString());
                    }
                } else {
                    drs.updateString(drs.findColumn("fname"), ibf.getName().toString());
                }
                drs.insertRow();
            }
        } else {
            MetaDataBriefInfo info1 = null;
            while (enu.hasMoreElements()) {
                IBriefViewTreeNode ibf1 = (IBriefViewTreeNode)enu.nextElement();
                if (ibf1 == null || !ibf1.isLeaf() || (info1 = ibf1.getMetaDataObjectBriefInfo()) == null || info1.getMetaDataType() != MetaDataTypeList.JOINQUERY && info1.getMetaDataType() != MetaDataTypeList.UNIONQUERY) continue;
                drs.moveToInsertRow();
                drs.updateString(drs.findColumn("fid"), info1.getFullName());
                if (info1.getAlias(locale) != null) {
                    if (info1.getAlias(locale).toString() != "") {
                        drs.updateString(drs.findColumn("fname"), info1.getAlias(locale).toString());
                    } else {
                        drs.updateString(drs.findColumn("fname"), info1.getName().toString());
                    }
                } else {
                    drs.updateString(drs.findColumn("fname"), info1.getName().toString());
                }
                drs.insertRow();
            }
        }
    }

    @Override
    public String getReportFilterFormID(String reportId) throws BOSException, SQLException {
        String filterFormId = null;
        String strSQL = "select FID,FWebFilterClassName,FFilterPanelName from T_BAS_Report where FID=?";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSQL, (Object[])new Object[]{reportId});
        while (rs.next()) {
            filterFormId = rs.getString("FWebFilterClassName");
        }
        return filterFormId;
    }
}

