/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.demo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.HashMap;

public class TestReportDataDemo
extends ReportServerBase {
    private String getSelectSql(String name) {
        String sql = " SELECT t1.FName_l2 FParentName, t1.FID FParentID, \n        t2.FName_l2 FName, \n        t2.FID, t2.FDisplayName_l2 FDisplayName, t2.FLongNumber, \n        LENGTH(t2.FUIClassName) FOrder, t2.FUIClassName, t2.FUIClassParam, \n        t2.FShortcutCode, t1.FUIClassName FPUIClassName, \n        t1.FUIClassParam FPUIClassParam, \n         t1.FLevel FLevel \n  FROM  t_bas_sysmenuitem t1, t_bas_sysmenuitem t2 WHERE t1.FID=t2.fparent \n";
        if (name != null) {
            sql = sql + " AND t2.FName_l2 like ? \n";
        }
        sql = sql + " ORDER BY t1.FName_l2,t2.FName_l2";
        return sql;
    }

    @Override
    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        String rptName = (String)filter.getObject("name");
        ReportTitles titles = new ReportTitles();
        titles = new ReportTitles();
        if (rptName == null) {
            titles.AddTitle(0, "\u83dc\u5355\u540d\u79f0\uff1aall");
        } else {
            titles.AddTitle(0, "\u83dc\u5355\u540d\u79f0\uff1a" + rptName);
        }
        return titles;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE tmp_ReportDemo( ");
        createTable.append(" FParentName varchar(255) ");
        createTable.append(",FName   varchar(44)  ");
        createTable.append(",FID varchar(255) ");
        createTable.append(",FDisplayName varchar(255) ");
        createTable.append(",FLongNumber varchar(255) ");
        createTable.append(",FOrder NUMERIC(17,4) ");
        createTable.append(",FUIClassName varchar(255) ");
        createTable.append(",FUIClassParam varchar(255) ");
        createTable.append(",FShortcutCode varchar(255) ");
        createTable.append(",FPUIClassName varchar(255) ");
        createTable.append(",FPUIClassParam varchar(44) ");
        createTable.append(",FLevel NUMERIC(17,4) ");
        createTable.append(" ); ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    @Override
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tmpTable = this.createTmpTableSQL();
        StringBuffer sbSQL = new StringBuffer();
        String name = (String)filter.getObject("name");
        Object rs = null;
        sbSQL.append(" INSERT INTO ").append(tmpTable).append(" \t  (FParentName,FName,FID,FDisplayName,FLongNumber,\n").append("\t   FOrder,FUIClassName,FUIClassParam,FShortcutCode,\n").append("\t   FPUIClassName,FPUIClassParam,FLevel)\n").append(this.getSelectSql(name));
        if (name != null) {
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new Object[]{name});
        } else {
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        }
        return tmpTable;
    }

    @Override
    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        String sql = "SELECT * FROM " + tableName + " Order By FParentName, FName ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)start, (int)rows);
        return rs;
    }

    @Override
    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String name = (String)filter.getObject("name");
        String sql = null;
        try {
            sql = this.isHierarchyReport(reportID) ? this.getHierarchySelectSql(name) : this.getSelectSql(name);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        IRowSet rs = null;
        rs = name != null ? DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{name}) : DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        return rs;
    }

    private boolean isHierarchyReport(String reportId) throws BOSException, SQLException {
        boolean is = false;
        String sql = " SELECT FIsHiberarchy  FROM  T_Bas_ReportHeader t1 WHERE t1.FFieldName='FParentName' AND FReportID='" + reportId + "';";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (rs.next()) {
            is = rs.getBoolean("FIsHiberarchy");
        }
        return is;
    }

    private String getHierarchySelectSql(String name) {
        String sql = " SELECT t1.FName_l2 FParentName, \n        t1.FName_l2 FName, \n        t1.FID, t1.FDisplayName_l2 FDisplayName, t1.FLongNumber, \n        LENGTH(t1.FUIClassName) FOrder, t1.FUIClassName, t1.FUIClassParam, \n        t1.FShortcutCode, t1.FUIClassName FPUIClassName, \n        t1.FUIClassParam FPUIClassParam,         t1.FLevel FLevel,1 DDD \n  FROM  t_bas_sysmenuitem t1 WHERE t1.fparent is null \n";
        if (name != null) {
            sql = sql + " AND t1.FName_l2 like ? \n";
        }
        sql = sql + " ORDER BY t1.FName_l2";
        return sql;
    }

    @Override
    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        String parentId = (String)rowData.get("FID");
        String sql = " SELECT t1.FName_l2 FParentName, \n        t1.FName_l2 FName, \n        t1.FID, t1.FDisplayName_l2 FDisplayName, t1.FLongNumber, \n        LENGTH(t1.FUIClassName)  FOrder, t1.FUIClassName, t1.FUIClassParam, \n        t1.FShortcutCode, t1.FUIClassName FPUIClassName, \n        t1.FUIClassParam FPUIClassParam,         t1.FLevel FLevel,1 DDD \n  FROM  t_bas_sysmenuitem t1 WHERE t1.fparent = ? \n";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{parentId});
        return rs;
    }
}

