/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.kingdee.eas.base.security.app.BCyptBOTPSignVerifier;
import com.kingdee.eas.base.security.app.IEASBOTPSignVerifier;
import com.kingdee.eas.base.security.app.ItrusBOTPSignVerifier;
import org.apache.log4j.Logger;

public final class BOTPSignVerifierManager {
    private static Logger logger = Logger.getLogger(BOTPSignVerifierManager.class);
    private static IEASBOTPSignVerifier verifier;

    public static IEASBOTPSignVerifier getVerifierInUse(String supportVerifier) {
        if (verifier == null) {
            logger.error((Object)"first time to fetch verifiter ...");
            verifier = BOTPSignVerifierManager.getVerifierByName(supportVerifier);
            logger.error((Object)("fetch verifier success, verfier: " + verifier.getClass().getName()));
        }
        return verifier;
    }

    protected static IEASBOTPSignVerifier getVerifierByName(String supportVerifier) {
        if (supportVerifier == null || supportVerifier.length() == 0) {
            logger.error((Object)"param 'botp.sign.verifier' is empty, return default implementation.");
            return BOTPSignVerifierManager.defaultSignVerifier();
        }
        if (supportVerifier.contains(".") && supportVerifier.endsWith("Verifier")) {
            return BOTPSignVerifierManager.getByClassName(supportVerifier);
        }
        return BOTPSignVerifierManager.getByType(supportVerifier);
    }

    private static IEASBOTPSignVerifier getByType(String type) {
        logger.error((Object)("the value of param 'supportVerifier' is '" + type + "'"));
        if ("normal".equalsIgnoreCase(type)) {
            logger.error((Object)"return the implementation of BCyptBOTPSignVerifier");
            return new BCyptBOTPSignVerifier();
        }
        if ("itrus".equalsIgnoreCase(type)) {
            logger.error((Object)"return the implementation of ItrusBOTPSignVerifier");
            return new ItrusBOTPSignVerifier();
        }
        logger.error((Object)("not support the verifier '" + type + "', return default implementation."));
        return BOTPSignVerifierManager.defaultSignVerifier();
    }

    private static IEASBOTPSignVerifier getByClassName(String className) {
        try {
            Class<?> clz = Class.forName(className);
            if (IEASBOTPSignVerifier.class.isAssignableFrom(clz)) {
                return (IEASBOTPSignVerifier)clz.newInstance();
            }
            logger.error((Object)("not Standard implementation of IEASBOTPSignVerifier, class '" + clz.getName() + "' must implement the interface " + IEASBOTPSignVerifier.class.getName()));
            return BOTPSignVerifierManager.defaultSignVerifier();
        }
        catch (Exception e) {
            logger.error((Object)"initialize instance fail, please make sure the no args constructor is provided, and now return default implementation");
            return BOTPSignVerifierManager.defaultSignVerifier();
        }
    }

    private static IEASBOTPSignVerifier defaultSignVerifier() {
        return new BCyptBOTPSignVerifier();
    }
}

